/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzaba;
import com.google.android.gms.internal.zzade;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;

public class zzatu
extends zzauh {
    private String mAppId;
    private String zzacM;
    private int zzbsw;
    private String zzbqv;
    private String zzacL;
    private long zzbsx;
    private long zzbqz;
    private int zzbsy;
    private String zzVX;

    zzatu(zzaue zzaue2) {
        super(zzaue2);
    }

    @Override
    protected void zzmS() {
        Object object;
        boolean bl;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = this.getContext().getPackageName();
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzKl().zzLZ().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzatx.zzfE(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zzKl().zzLZ().zzj("Error retrieving app installer package name. appId", zzatx.zzfE(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKl().zzLZ().zze("Error retrieving package info. appId, appName", zzatx.zzfE(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzbqv = string;
        this.zzacM = string2;
        this.zzbsw = n;
        this.zzacL = string3;
        this.zzbsx = 0L;
        this.zzKn().zzLh();
        packageInfo = zzaba.zzaQ((Context)this.getContext());
        boolean bl2 = bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            this.zzbw((Status)packageInfo);
        }
        boolean bl3 = false;
        if (bl) {
            object = this.zzKn().zzLj();
            if (this.zzKn().zzLi()) {
                this.zzKl().zzMd().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                this.zzKl().zzMd().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && this.zzKn().zzwR()) {
                this.zzKl().zzMd().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl3 = true;
                this.zzKl().zzMf().log("Collection enabled");
            }
        }
        this.zzVX = "";
        this.zzbqz = 0L;
        this.zzKn().zzLh();
        try {
            object = zzaba.zzwQ();
            Object object2 = this.zzVX = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl3) {
                this.zzKl().zzMf().zze("App package, google app id", this.mAppId, this.zzVX);
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.zzKl().zzLZ().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzatx.zzfE(string4), illegalStateException);
        }
        this.zzbsy = Build.VERSION.SDK_INT >= 16 ? (zzade.zzbg((Context)this.getContext()) ? 1 : 0) : 0;
    }

    protected void zzbw(Status status) {
        if (status == null) {
            this.zzKl().zzLZ().log("GoogleService failed to initialize (no status)");
        } else {
            this.zzKl().zzLZ().zze("GoogleService failed to initialize, status", status.getStatusCode(), status.getStatusMessage());
        }
    }

    @WorkerThread
    zzatd zzfD(String string) {
        this.zzmR();
        return new zzatd(this.zzke(), this.getGmpAppId(), this.zzmZ(), this.zzLX(), this.zzKu(), this.zzKv(), this.zzKw(), string, this.zzbqb.isEnabled(), !this.zzKm().zzbts, this.zzKm().zzKq(), this.zzuW(), this.zzbqb.zzMF(), this.zzLY());
    }

    String zzke() {
        this.zzob();
        return this.mAppId;
    }

    String getGmpAppId() {
        this.zzob();
        return this.zzVX;
    }

    String zzmZ() {
        this.zzob();
        return this.zzacM;
    }

    int zzLX() {
        this.zzob();
        return this.zzbsw;
    }

    String zzKu() {
        this.zzob();
        return this.zzbqv;
    }

    long zzKv() {
        return this.zzKn().zzKv();
    }

    @WorkerThread
    long zzKw() {
        this.zzob();
        this.zzmR();
        if (this.zzbsx == 0L) {
            this.zzbsx = this.zzbqb.zzKh().zzM(this.getContext(), this.getContext().getPackageName());
        }
        return this.zzbsx;
    }

    long zzuW() {
        this.zzob();
        return 0L;
    }

    int zzLY() {
        this.zzob();
        return this.zzbsy;
    }
}

