/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaum;
import com.google.android.gms.internal.zzaus;
import com.google.android.gms.internal.zzaut;
import com.google.android.gms.measurement.AppMeasurement;

public final class zzaub {
    private final zza zzbtA;

    public zzaub(zza zza2) {
        zzac.zzw((Object)zza2);
        this.zzbtA = zza2;
    }

    public static boolean zzi(Context context, boolean bl) {
        zzac.zzw((Object)context);
        return zzaut.zza(context, bl ? "com.google.android.gms.measurement.PackageMeasurementReceiver" : "com.google.android.gms.measurement.AppMeasurementReceiver", false);
    }

    @MainThread
    public void onReceive(final Context context, Intent intent) {
        final zzaue zzaue2 = zzaue.zzbM(context);
        final zzatx zzatx2 = zzaue2.zzKl();
        if (intent == null) {
            zzatx2.zzMb().log("Receiver called with null intent");
            return;
        }
        zzaue2.zzKn().zzLh();
        String string = intent.getAction();
        zzatx2.zzMf().zzj("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzaum.zzj(context, false);
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            this.zzbtA.doStartService(context, intent2);
        } else if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzatx2.zzMf().log("Install referrer extras are null");
                return;
            }
            zzatx2.zzMd().zzj("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            final Bundle bundle = zzaue2.zzKh().zzu(uri);
            if (bundle == null) {
                zzatx2.zzMf().log("No campaign defined in install referrer broadcast");
            } else {
                final long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzatx2.zzMb().log("Install referrer is missing timestamp");
                }
                zzaue2.zzKk().zzm(new Runnable(this){

                    @Override
                    public void run() {
                        long l3 = 0L;
                        zzaus zzaus2 = zzaue2.zzKg().zzS(zzaue2.zzKb().zzke(), "_fot");
                        if (zzaus2 != null && zzaus2.mValue instanceof Long) {
                            l3 = (Long)zzaus2.mValue;
                        }
                        long l2 = l;
                        if (l3 > 0L && (l2 >= l3 || l2 <= 0L)) {
                            l2 = l3 - 1L;
                        }
                        if (l2 > 0L) {
                            bundle.putLong("click_timestamp", l2);
                        }
                        AppMeasurement.getInstance(context).logEventInternal("auto", "_cmp", bundle);
                        zzatx2.zzMf().log("Install campaign recorded");
                    }
                });
            }
        }
    }

    public static interface zza {
        public void doStartService(Context var1, Intent var2);
    }
}

