/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class zzaud
extends zzauh {
    private ExecutorService zzbtK;
    private zzd zzbtL;
    private zzd zzbtM;
    private final PriorityBlockingQueue<FutureTask<?>> zzbtN;
    private final BlockingQueue<FutureTask<?>> zzbtO;
    private final Thread.UncaughtExceptionHandler zzbtP;
    private final Thread.UncaughtExceptionHandler zzbtQ;
    private final Object zzbtR = new Object();
    private final Semaphore zzbtS = new Semaphore(2);
    private volatile boolean zzbtT;
    private static final AtomicLong zzbtU = new AtomicLong(Long.MIN_VALUE);

    zzaud(zzaue zzaue2) {
        super(zzaue2);
        this.zzbtN = new PriorityBlockingQueue();
        this.zzbtO = new LinkedBlockingQueue();
        this.zzbtP = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzbtQ = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzmS() {
    }

    @Override
    public void zzmR() {
        if (Thread.currentThread() != this.zzbtL) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzJX() {
        if (Thread.currentThread() != this.zzbtM) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public boolean zzbc() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public boolean zzMr() {
        return Thread.currentThread() == this.zzbtL;
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtL) {
            if (!this.zzbtN.isEmpty()) {
                this.zzKl().zzMb().log("Callable skipped the worker queue.");
            }
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtL) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.zzbtR;
        synchronized (object) {
            this.zzbtN.add(zzc2);
            if (this.zzbtL == null) {
                this.zzbtL = new zzd("Measurement Worker", this.zzbtN);
                this.zzbtL.setUncaughtExceptionHandler(this.zzbtP);
                this.zzbtL.start();
            } else {
                this.zzbtL.zzhA();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzbtR;
        synchronized (object) {
            this.zzbtO.add(futureTask);
            if (this.zzbtM == null) {
                this.zzbtM = new zzd("Measurement Network", this.zzbtO);
                this.zzbtM.setUncaughtExceptionHandler(this.zzbtQ);
                this.zzbtM.start();
            } else {
                this.zzbtM.zzhA();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService zzMs() {
        Object object = this.zzbtR;
        synchronized (object) {
            if (this.zzbtK == null) {
                this.zzbtK = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbtK;
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzbtV;

        public zzb(String string) {
            zzac.zzw((Object)string);
            this.zzbtV = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzaud.this.zzKl().zzLZ().zzj(this.zzbtV, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long zzbtX;
        private final boolean zzbtY;
        private final String zzbtV;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzac.zzw((Object)string);
            this.zzbtX = zzbtU.getAndIncrement();
            this.zzbtV = string;
            this.zzbtY = bl;
            if (this.zzbtX == Long.MAX_VALUE) {
                zzaud.this.zzKl().zzLZ().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzac.zzw((Object)string);
            this.zzbtX = zzbtU.getAndIncrement();
            this.zzbtV = string;
            this.zzbtY = bl;
            if (this.zzbtX == Long.MAX_VALUE) {
                zzaud.this.zzKl().zzLZ().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzaud.this.zzKl().zzLZ().zzj(this.zzbtV, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.zzbtY != zzc2.zzbtY) {
                return this.zzbtY ? -1 : 1;
            }
            if (this.zzbtX < zzc2.zzbtX) {
                return -1;
            }
            if (this.zzbtX > zzc2.zzbtX) {
                return 1;
            }
            zzaud.this.zzKl().zzMa().zzj("Two tasks share the same index. index", this.zzbtX);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object zzbtZ;
        private final BlockingQueue<FutureTask<?>> zzbua;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzac.zzw((Object)string);
            zzac.zzw(blockingQueue);
            this.zzbtZ = new Object();
            this.zzbua = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzaud.this.zzbtS.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzbua.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzbtZ;
                    synchronized (object) {
                        if (this.zzbua.peek() == null && !zzaud.this.zzbtT) {
                            try {
                                this.zzbtZ.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzaud.this.zzbtR;
                    synchronized (object) {
                        if (this.zzbua.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzaud.this.zzbtR;
                synchronized (object) {
                    zzaud.this.zzbtS.release();
                    zzaud.this.zzbtR.notifyAll();
                    if (this == zzaud.this.zzbtL) {
                        zzaud.this.zzbtL = null;
                    } else if (this == zzaud.this.zzbtM) {
                        zzaud.this.zzbtM = null;
                    } else {
                        zzaud.this.zzKl().zzLZ().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzhA() {
            Object object = this.zzbtZ;
            synchronized (object) {
                this.zzbtZ.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzaud.this.zzKl().zzMb().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

