/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzb;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzato;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzauu;
import com.google.android.gms.internal.zzauw;
import com.google.android.gms.internal.zzbyc;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public class zzaut
extends zzauh {
    private final AtomicLong zzbwk = new AtomicLong(0L);
    private int zzbwl;

    zzaut(zzaue zzaue2) {
        super(zzaue2);
    }

    @Override
    protected void zzmS() {
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            this.zzKl().zzMb().log("Utils falling back to Random for random id");
        }
        this.zzbwk.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zzNk() {
        long l = this.zzbwk.get();
        if (l == 0L) {
            AtomicLong atomicLong = this.zzbwk;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ this.zznR().currentTimeMillis()).nextLong() + (long)(++this.zzbwl);
            }
        }
        AtomicLong atomicLong = this.zzbwk;
        synchronized (atomicLong) {
            this.zzbwk.compareAndSet(-1L, 1L);
            l = this.zzbwk.getAndIncrement();
            return l;
        }
    }

    static boolean zzfT(String string) {
        zzac.zzdr((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    public Bundle zzu(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zzKl().zzMb().zzj("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    public boolean zzA(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    boolean zzac(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzKl().zzLZ().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzKl().zzLZ().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzKl().zzLZ().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzKl().zzLZ().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzad(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzKl().zzLZ().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzKl().zzLZ().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            this.zzKl().zzLZ().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzKl().zzLZ().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, Map<String, String> map, String string2) {
        if (string2 == null) {
            this.zzKl().zzLZ().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.startsWith("firebase_")) {
            this.zzKl().zzLZ().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (map != null && map.containsKey(string2)) {
            this.zzKl().zzLZ().zze("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzb(String string, int n, String string2) {
        if (string2 == null) {
            this.zzKl().zzLZ().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() > n) {
            this.zzKl().zzLZ().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public int zzfU(String string) {
        if (!this.zzac("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbqc, string)) {
            return 13;
        }
        if (!this.zzb("event", this.zzKn().zzKM(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfV(String string) {
        if (!this.zzad("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbqc, string)) {
            return 13;
        }
        if (!this.zzb("event", this.zzKn().zzKM(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfW(String string) {
        if (!this.zzac("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.zzbqh, string)) {
            return 15;
        }
        if (!this.zzb("user property", this.zzKn().zzKN(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzfX(String string) {
        if (!this.zzad("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.zzbqh, string)) {
            return 15;
        }
        if (!this.zzb("user property", this.zzKn().zzKN(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzfY(String string) {
        if (!this.zzac("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", this.zzKn().zzKO(), string)) {
            return 3;
        }
        return 0;
    }

    public int zzfZ(String string) {
        if (!this.zzad("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", this.zzKn().zzKO(), string)) {
            return 3;
        }
        return 0;
    }

    boolean zza(String string, String string2, int n, Object object) {
        int n2;
        if (object instanceof Parcelable[]) {
            n2 = ((Parcelable[])object).length;
        } else if (object instanceof ArrayList) {
            n2 = ((ArrayList)object).size();
        } else {
            return true;
        }
        if (n2 > n) {
            this.zzKl().zzMb().zzd("Parameter array is too long; discarded. Value kind, name, array length", string, string2, n2);
            return false;
        }
        return true;
    }

    boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.length() > n) {
                this.zzKl().zzMb().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            Parcelable[] parcelableArray;
            for (Parcelable parcelable : parcelableArray = (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                this.zzKl().zzMb().zze("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            for (Object e : arrayList) {
                if (e instanceof Bundle) continue;
                this.zzKl().zzMb().zze("All ArrayList elements must be of type Bundle. Value type, name", e.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean zzga(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzKl().zzLZ().log("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        if (!this.zzgb(string)) {
            this.zzKl().zzLZ().zzj("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", string);
            return false;
        }
        return true;
    }

    boolean zzgb(String string) {
        zzac.zzw((Object)string);
        String string2 = "^1:\\d+:android:[a-f0-9]+$";
        return string.matches(string2);
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string = String.valueOf(object);
            return this.zza(string, n, bl);
        }
        return null;
    }

    public String zza(String string, int n, boolean bl) {
        if (string.length() > n) {
            if (bl) {
                return String.valueOf(string.substring(0, n)).concat("...");
            }
            return null;
        }
        return string;
    }

    public int zza(String string, Object object, boolean bl) {
        if (bl && !this.zza("param", string, this.zzKn().zzKR(), object)) {
            return 17;
        }
        boolean bl2 = zzaut.zzgd(string) ? this.zza("param", string, this.zzKn().zzKQ(), object, bl) : this.zza("param", string, this.zzKn().zzKP(), object, bl);
        return bl2 ? 0 : 4;
    }

    public Object zzk(String string, Object object) {
        if ("_ev".equals(string)) {
            Object object2 = this.zza(this.zzKn().zzKQ(), object, true);
            return object2;
        }
        Object object3 = this.zza(zzaut.zzgd(string) ? this.zzKn().zzKQ() : this.zzKn().zzKP(), object, false);
        return object3;
    }

    public Bundle[] zzH(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    public Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl, boolean bl2) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            this.zzKn().zzKL();
            for (String string2 : bundle.keySet()) {
                String string3;
                int n2 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n2 = this.zzfY(string2);
                    }
                    if (n2 == 0) {
                        n2 = this.zzfZ(string2);
                    }
                }
                if (n2 != 0) {
                    if (this.zzd(bundle2, n2)) {
                        string3 = this.zza(string2, this.zzKn().zzKO(), true);
                        bundle2.putString("_ev", string3);
                        if (n2 == 3) {
                            this.zzb(bundle2, string2);
                        }
                    }
                    bundle2.remove(string2);
                    continue;
                }
                n2 = this.zza(string2, bundle.get(string2), bl2);
                if (n2 != 0 && !"_ev".equals(string2)) {
                    if (this.zzd(bundle2, n2)) {
                        string3 = this.zza(string2, this.zzKn().zzKO(), true);
                        bundle2.putString("_ev", string3);
                        this.zzb(bundle2, bundle.get(string2));
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzaut.zzfT(string2) || ++n <= 25) continue;
                string3 = new StringBuilder(48).append("Event can't contain more then ").append(25).append(" params").toString();
                this.zzKl().zzLZ().zze(string3, string, bundle);
                this.zzd(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    public boolean zzd(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        long l = bundle.getLong("_err");
        if (l == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    public void zzb(Bundle bundle, Object object) {
        zzac.zzw((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private int zzgc(String string) {
        if ("_ldl".equals(string)) {
            return this.zzKn().zzKT();
        }
        return this.zzKn().zzKS();
    }

    public int zzl(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, this.zzgc(string), object, false) : this.zza("user property", string, this.zzgc(string), object, false);
        return bl ? 0 : 7;
    }

    public Object zzm(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zzgc(string), object, true);
        }
        return this.zza(this.zzgc(string), object, false);
    }

    public void zza(zzauw.zzg zzg2, Object object) {
        zzac.zzw((Object)object);
        zzg2.zzaGV = null;
        zzg2.zzbxf = null;
        zzg2.zzbwi = null;
        if (object instanceof String) {
            zzg2.zzaGV = (String)object;
        } else if (object instanceof Long) {
            zzg2.zzbxf = (Long)object;
        } else if (object instanceof Double) {
            zzg2.zzbwi = (Double)object;
        } else {
            this.zzKl().zzLZ().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzauw.zzc zzc2, Object object) {
        zzac.zzw((Object)object);
        zzc2.zzaGV = null;
        zzc2.zzbxf = null;
        zzc2.zzbwi = null;
        if (object instanceof String) {
            zzc2.zzaGV = (String)object;
        } else if (object instanceof Long) {
            zzc2.zzbxf = (Long)object;
        } else if (object instanceof Double) {
            zzc2.zzbwi = (Double)object;
        } else {
            this.zzKl().zzLZ().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            this.zzKl().zzMc().zze("Not putting event parameter. Invalid value type. name, type", string, string3);
        }
    }

    public void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    public void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        this.zzd(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        this.zzbqb.zzKn().zzLh();
        this.zzbqb.zzKa().zze("auto", "_err", bundle);
    }

    public byte[] zzk(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzx(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzch(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    static long zzy(byte[] byArray) {
        zzac.zzw((Object)byArray);
        zzac.zzav((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    @WorkerThread
    public long zzz(byte[] byArray) {
        zzac.zzw((Object)byArray);
        this.zzmR();
        MessageDigest messageDigest = zzaut.zzch("MD5");
        if (messageDigest == null) {
            this.zzKl().zzLZ().log("Failed to get MD5");
            return 0L;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return zzaut.zzy(byArray2);
    }

    public byte[] zza(zzauw.zzd zzd2) {
        try {
            int n = zzd2.zzafB();
            byte[] byArray = new byte[n];
            zzbyc zzbyc2 = zzbyc.zzah((byte[])byArray);
            zzd2.zza(zzbyc2);
            zzbyc2.zzafo();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzh(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zznR().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, String string, boolean bl) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    public static boolean zzy(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    public boolean zzbW(String string) {
        this.zzmR();
        int n = zzadg.zzbi((Context)this.getContext()).checkCallingOrSelfPermission(string);
        if (n == 0) {
            return true;
        }
        this.zzKl().zzMe().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzgd(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzae(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && 64 * i + j < bitSet.length(); ++j) {
                if (!bitSet.get(64 * i + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length * 64) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzaut.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauw.zze zze2) {
        if (zze2 == null) {
            return;
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("bundle {\n");
        zzaut.zza(stringBuilder, n, "protocol_version", zze2.zzbxi);
        zzaut.zza(stringBuilder, n, "platform", zze2.zzbxq);
        zzaut.zza(stringBuilder, n, "gmp_version", zze2.zzbxu);
        zzaut.zza(stringBuilder, n, "uploading_gmp_version", zze2.zzbxv);
        zzaut.zza(stringBuilder, n, "config_version", zze2.zzbxH);
        zzaut.zza(stringBuilder, n, "gmp_app_id", zze2.zzbqK);
        zzaut.zza(stringBuilder, n, "app_id", zze2.zzaS);
        zzaut.zza(stringBuilder, n, "app_version", zze2.zzbhN);
        zzaut.zza(stringBuilder, n, "app_version_major", zze2.zzbxD);
        zzaut.zza(stringBuilder, n, "app_version_minor", zze2.zzbxE);
        zzaut.zza(stringBuilder, n, "app_version_release", zze2.zzbxF);
        zzaut.zza(stringBuilder, n, "firebase_instance_id", zze2.zzbqS);
        zzaut.zza(stringBuilder, n, "dev_cert_hash", zze2.zzbxz);
        zzaut.zza(stringBuilder, n, "app_store", zze2.zzbqL);
        zzaut.zza(stringBuilder, n, "upload_timestamp_millis", zze2.zzbxl);
        zzaut.zza(stringBuilder, n, "start_timestamp_millis", zze2.zzbxm);
        zzaut.zza(stringBuilder, n, "end_timestamp_millis", zze2.zzbxn);
        zzaut.zza(stringBuilder, n, "previous_bundle_start_timestamp_millis", zze2.zzbxo);
        zzaut.zza(stringBuilder, n, "previous_bundle_end_timestamp_millis", zze2.zzbxp);
        zzaut.zza(stringBuilder, n, "app_instance_id", zze2.zzbxy);
        zzaut.zza(stringBuilder, n, "resettable_device_id", zze2.zzbxw);
        zzaut.zza(stringBuilder, n, "device_id", zze2.zzbxG);
        zzaut.zza(stringBuilder, n, "limited_ad_tracking", zze2.zzbxx);
        zzaut.zza(stringBuilder, n, "os_version", zze2.zzbb);
        zzaut.zza(stringBuilder, n, "device_model", zze2.zzbxr);
        zzaut.zza(stringBuilder, n, "user_default_language", zze2.zzbxs);
        zzaut.zza(stringBuilder, n, "time_zone_offset_minutes", zze2.zzbxt);
        zzaut.zza(stringBuilder, n, "bundle_sequential_index", zze2.zzbxA);
        zzaut.zza(stringBuilder, n, "service_upload", zze2.zzbxB);
        zzaut.zza(stringBuilder, n, "health_monitor", zze2.zzbqO);
        if (zze2.zzbxI != 0L) {
            zzaut.zza(stringBuilder, n, "android_id", zze2.zzbxI);
        }
        zzaut.zza(stringBuilder, n, zze2.zzbxk);
        zzaut.zza(stringBuilder, n, zze2.zzbxC);
        zzaut.zza(stringBuilder, n, zze2.zzbxj);
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauw.zzg[] zzgArray) {
        if (zzgArray == null) {
            return;
        }
        ++n;
        for (zzauw.zzg zzg2 : zzgArray) {
            if (zzg2 == null) continue;
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("user_property {\n");
            zzaut.zza(stringBuilder, n, "set_timestamp_millis", zzg2.zzbxM);
            zzaut.zza(stringBuilder, n, "name", zzg2.name);
            zzaut.zza(stringBuilder, n, "string_value", zzg2.zzaGV);
            zzaut.zza(stringBuilder, n, "int_value", zzg2.zzbxf);
            zzaut.zza(stringBuilder, n, "double_value", zzg2.zzbwi);
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauw.zzc[] zzcArray) {
        if (zzcArray == null) {
            return;
        }
        ++n;
        for (zzauw.zzc zzc2 : zzcArray) {
            if (zzc2 == null) continue;
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzaut.zza(stringBuilder, n, "name", zzc2.name);
            zzaut.zza(stringBuilder, n, "string_value", zzc2.zzaGV);
            zzaut.zza(stringBuilder, n, "int_value", zzc2.zzbxf);
            zzaut.zza(stringBuilder, n, "double_value", zzc2.zzbwi);
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauw.zzb[] zzbArray) {
        if (zzbArray == null) {
            return;
        }
        ++n;
        for (zzauw.zzb zzb2 : zzbArray) {
            if (zzb2 == null) continue;
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzaut.zza(stringBuilder, n, "name", zzb2.name);
            zzaut.zza(stringBuilder, n, "timestamp_millis", zzb2.zzbxc);
            zzaut.zza(stringBuilder, n, "previous_timestamp_millis", zzb2.zzbxd);
            zzaut.zza(stringBuilder, n, "count", zzb2.count);
            zzaut.zza(stringBuilder, n, zzb2.zzbxb);
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauw.zza[] zzaArray) {
        if (zzaArray == null) {
            return;
        }
        ++n;
        for (zzauw.zza zza2 : zzaArray) {
            if (zza2 == null) continue;
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("audience_membership {\n");
            zzaut.zza(stringBuilder, n, "audience_id", zza2.zzbwn);
            zzaut.zza(stringBuilder, n, "new_audience", zza2.zzbwZ);
            zzaut.zza(stringBuilder, n, "current_data", zza2.zzbwX);
            zzaut.zza(stringBuilder, n, "previous_data", zza2.zzbwY);
            zzaut.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauw.zzf zzf2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzf2 == null) {
            return;
        }
        zzaut.zza(stringBuilder, ++n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbxK != null) {
            zzaut.zza(stringBuilder, n + 1);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzf2.zzbxK;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.zzbxJ != null) {
            zzaut.zza(stringBuilder, n + 1);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzf2.zzbxJ;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauu.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzbwB != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzd2.zzbwB) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzaut.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzaut.zza(stringBuilder, n, "match_as_float", zzd2.zzbwC);
        zzaut.zza(stringBuilder, n, "comparison_value", zzd2.zzbwD);
        zzaut.zza(stringBuilder, n, "min_comparison_value", zzd2.zzbwE);
        zzaut.zza(stringBuilder, n, "max_comparison_value", zzd2.zzbwF);
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauu.zzf zzf2) {
        if (zzf2 == null) {
            return;
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbwJ != null) {
            String[] stringArray = "UNKNOWN_MATCH_TYPE";
            switch (zzf2.zzbwJ) {
                case 1: {
                    stringArray = "REGEXP";
                    break;
                }
                case 2: {
                    stringArray = "BEGINS_WITH";
                    break;
                }
                case 3: {
                    stringArray = "ENDS_WITH";
                    break;
                }
                case 4: {
                    stringArray = "PARTIAL";
                    break;
                }
                case 5: {
                    stringArray = "EXACT";
                    break;
                }
                case 6: {
                    stringArray = "IN_LIST";
                }
            }
            zzaut.zza(stringBuilder, n, "match_type", stringArray);
        }
        zzaut.zza(stringBuilder, n, "expression", zzf2.zzbwK);
        zzaut.zza(stringBuilder, n, "case_sensitive", zzf2.zzbwL);
        if (zzf2.zzbwM.length > 0) {
            zzaut.zza(stringBuilder, n + 1);
            stringBuilder.append("expression_list {\n");
            for (String string2 : zzf2.zzbwM) {
                zzaut.zza(stringBuilder, n + 2);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauu.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzaut.zza(stringBuilder, n, "complement", zzc2.zzbwz);
        zzaut.zza(stringBuilder, n, "param_name", zzc2.zzbwA);
        zzaut.zza(stringBuilder, n + 1, "string_filter", zzc2.zzbwx);
        zzaut.zza(stringBuilder, n + 1, "number_filter", zzc2.zzbwy);
        zzaut.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    public static String zzb(zzauw.zzd zzd2) {
        if (zzd2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzd2.zzbxg != null) {
            for (zzauw.zze zze2 : zzd2.zzbxg) {
                if (zze2 == null) continue;
                zzaut.zza(stringBuilder, 1, zze2);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzauu.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzaut.zza(stringBuilder, 0, "filter_id", zzb2.zzbwr);
        zzaut.zza(stringBuilder, 0, "event_name", zzb2.zzbws);
        zzaut.zza(stringBuilder, 1, "event_count_filter", zzb2.zzbwv);
        stringBuilder.append("  filters {\n");
        for (zzauu.zzc zzc2 : zzb2.zzbwt) {
            zzaut.zza(stringBuilder, 2, zzc2);
        }
        zzaut.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzauu.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzaut.zza(stringBuilder, 0, "filter_id", zze2.zzbwr);
        zzaut.zza(stringBuilder, 0, "property_name", zze2.zzbwH);
        zzaut.zza(stringBuilder, 1, zze2.zzbwI);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public boolean zzge(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = this.zzKn().zzLD();
        this.zzKn().zzLh();
        return string2.equals(string);
    }

    static boolean zzgf(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    boolean zzgg(String string) {
        return "1".equals(this.zzKi().zzZ(string, "measurement.upload.blacklist_internal"));
    }

    boolean zzgh(String string) {
        return "1".equals(this.zzKi().zzZ(string, "measurement.upload.blacklist_public"));
    }

    Bundle zzN(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzk(string, bundle.get(string));
                if (object == null) {
                    this.zzKl().zzMb().zzj("Param value can't be null", string);
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    zzatq zza(String string, Bundle bundle, String string2, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = this.zzfV(string);
        if (n != 0) {
            this.zzKl().zzLZ().zzj("Invalid conditional property event name", string);
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string2);
        List list = zzf.zzx((Object)"_o");
        Bundle bundle2 = this.zza(string, bundle, list, bl2, false);
        Bundle bundle3 = bl ? this.zzN(bundle2) : bundle2;
        return new zzatq(string, new zzato(bundle3), string2, l);
    }

    @WorkerThread
    long zzM(Context context, String string) {
        this.zzmR();
        zzac.zzw((Object)context);
        zzac.zzdr((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzaut.zzch("MD5");
        if (messageDigest == null) {
            this.zzKl().zzLZ().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzN(context, string)) {
                    PackageInfo packageInfo = zzadg.zzbi((Context)context).getPackageInfo(this.getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        byte[] byArray = messageDigest.digest(packageInfo.signatures[0].toByteArray());
                        l = zzaut.zzy(byArray);
                    } else {
                        this.zzKl().zzMb().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKl().zzLZ().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    boolean zzN(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = zzadg.zzbi((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            this.zzKl().zzLZ().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzKl().zzLZ().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    boolean zzd(zzatq zzatq2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatq2));
        zzac.zzw((Object)((Object)zzatd2));
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            this.zzKn().zzLh();
            return false;
        }
        return true;
    }

    @WorkerThread
    boolean zzgi(String string) {
        zzac.zzdr((String)string);
        switch (string) {
            case "_in": 
            case "_ui": 
            case "_ug": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Parcelable> T zzb(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (zzb.zza zza2) {
            this.zzKl().zzLZ().log("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object zzI(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException exception) {
                return null;
            }
        }
        objectOutputStream.close();
        objectInputStream.close();
        return object2;
    }
}

