/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcfp;
import com.google.android.gms.internal.zzcfq;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjo;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcfo
extends zzciu {
    private final Map<String, Long> zzbou;
    private final Map<String, Integer> zzbov = new ArrayMap();
    private long zzbow;

    public zzcfo(zzchx zzchx2) {
        super(zzchx2);
        this.zzbou = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            super.zzwE().zzyv().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = super.zzkp().elapsedRealtime();
        super.zzwD().zzj(new zzcfp(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        super.zzwo();
        super.zzjB();
        zzbr.zzcF((String)string);
        if (this.zzbov.isEmpty()) {
            this.zzbow = l;
        }
        if ((n = this.zzbov.get(string)) != null) {
            this.zzbov.put(string, n + 1);
            return;
        }
        if (this.zzbov.size() >= 100) {
            super.zzwE().zzyx().log("Too many ads visible");
            return;
        }
        this.zzbov.put(string, 1);
        this.zzbou.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            super.zzwE().zzyv().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = super.zzkp().elapsedRealtime();
        super.zzwD().zzj(new zzcfq(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        super.zzwo();
        super.zzjB();
        zzbr.zzcF((String)string);
        Integer n = this.zzbov.get(string);
        if (n != null) {
            zzcjo zzcjo2 = super.zzww().zzzf();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbov.remove(string);
                Long l2 = this.zzbou.get(string);
                if (l2 == null) {
                    super.zzwE().zzyv().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzbou.remove(string);
                    this.zza(string, l3, zzcjo2);
                }
                if (this.zzbov.isEmpty()) {
                    if (this.zzbow == 0L) {
                        super.zzwE().zzyv().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzbow, zzcjo2);
                    this.zzbow = 0L;
                }
                return;
            }
            this.zzbov.put(string, n2);
            return;
        }
        super.zzwE().zzyv().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            super.zzwE().zzyB().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            super.zzwE().zzyB().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzcjl.zza(zzb2, bundle);
        super.zzws().zzd("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            super.zzwE().zzyB().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            super.zzwE().zzyB().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzcjl.zza(zzb2, bundle);
        super.zzws().zzd("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzJ(long l) {
        zzcjo zzcjo2 = super.zzww().zzzf();
        for (String string : this.zzbou.keySet()) {
            long l2 = this.zzbou.get(string);
            this.zza(string, l - l2, zzcjo2);
        }
        if (!this.zzbou.isEmpty()) {
            this.zza(l - this.zzbow, zzcjo2);
        }
        this.zzK(l);
    }

    public final void zzwm() {
        long l = super.zzkp().elapsedRealtime();
        super.zzwD().zzj(new zzcfr(this, l));
    }

    @WorkerThread
    private final void zzK(long l) {
        for (String string : this.zzbou.keySet()) {
            this.zzbou.put(string, l);
        }
        if (!this.zzbou.isEmpty()) {
            this.zzbow = l;
        }
    }

    static /* synthetic */ void zza(zzcfo zzcfo2, String string, long l) {
        zzcfo2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcfo zzcfo2, String string, long l) {
        zzcfo2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcfo zzcfo2, long l) {
        zzcfo2.zzK(l);
    }
}

