/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.ahw;
import com.google.android.gms.internal.ahx;
import com.google.android.gms.internal.ahz;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcga;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzckr;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckw;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;
import com.google.android.gms.internal.zzclc;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclj;
import com.google.android.gms.internal.zzcll;
import com.google.android.gms.internal.zzclm;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcfz
extends zzciv {
    private static final Map<String, String> zzbpr = new ArrayMap(1);
    private static final Map<String, String> zzbps;
    private static final Map<String, String> zzbpt;
    private static final Map<String, String> zzbpu;
    private static final Map<String, String> zzbpv;
    private final zzcgc zzbpw;
    private final zzckr zzbpx = new zzckr(this.zzkp());

    zzcfz(zzchx zzchx2) {
        super(zzchx2);
        String string = zzcfy.zzxB();
        this.zzbpw = new zzcgc(this, this.getContext(), string);
    }

    @Override
    protected final void zzjC() {
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzkC();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzkC();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzkC();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzwE().zzyv().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzjB();
        try {
            return this.zzbpw.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyx().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcgh zzE(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzcgh zzcgh2 = new zzcgh(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzwE().zzyv().zzj("Got multiple records for event aggregates, expected one. appId", zzcgx.zzea(string));
            }
            zzcgh zzcgh3 = zzcgh2;
            return zzcgh3;
        }
    }

    @WorkerThread
    public final void zza(zzcgh zzcgh2) {
        zzbr.zzu((Object)zzcgh2);
        this.zzjB();
        this.zzkC();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgh2.mAppId);
        contentValues.put("name", zzcgh2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcgh2.zzbpK));
        contentValues.put("current_bundle_count", Long.valueOf(zzcgh2.zzbpL));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcgh2.zzbpM));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert/update event aggregates (got -1). appId", zzcgx.zzea(zzcgh2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing event aggregates. appId", zzcgx.zzea(zzcgh2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzF(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzwE().zzyB().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zzd("Error deleting user attribute. appId", zzcgx.zzea(string), this.zzwz().zzdZ(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzckw zzckw2) {
        zzbr.zzu((Object)zzckw2);
        this.zzjB();
        this.zzkC();
        if (this.zzG(zzckw2.mAppId, zzckw2.mName) == null) {
            if (zzckx.zzep(zzckw2.mName)) {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzckw2.mAppId});
                zzcfy.zzxr();
                if (l >= 25L) {
                    return false;
                }
            } else {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzckw2.mAppId, zzckw2.mOrigin});
                zzcfy.zzxt();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzckw2.mAppId);
        contentValues.put("origin", zzckw2.mOrigin);
        contentValues.put("name", zzckw2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzckw2.zzbuG));
        zzcfz.zza(contentValues, "value", zzckw2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert/update user property (got -1). appId", zzcgx.zzea(zzckw2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing user property. appId", zzcgx.zzea(zzckw2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzckw zzG(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzckw zzckw2 = new zzckw(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzwE().zzyv().zzj("Got multiple records for user property, expected one. appId", zzcgx.zzea(string));
            }
            zzckw zzckw3 = zzckw2;
            return zzckw3;
        }
    }

    @WorkerThread
    public final List<zzckw> zzdQ(String string) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        ArrayList<zzckw> arrayList = new ArrayList<zzckw>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(zzcfy.zzxs()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzckw> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzwE().zzyv().zzj("Read invalid user property value, ignoring it. appId", zzcgx.zzea(string));
                    continue;
                }
                zzckw zzckw2 = new zzckw(string, string2, (String)object, l, object2);
                arrayList.add(zzckw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzckw> zzh(String string, String string2, String string3) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        ArrayList<zzckw> arrayList = new ArrayList<zzckw>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "set_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            zzcfy.zzxs();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzckw> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= zzcfy.zzxs()) {
                    this.zzwE().zzyv().zzj("Read more than the max allowed user properties, ignoring excess", zzcfy.zzxs());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzwE().zzyv().zzd("(2)Read invalid user property value, ignoring it", zzcgx.zzea(string), string2, string3);
                    continue;
                }
                zzckw zzckw2 = new zzckw(string, string2, (String)object, l, object2);
                arrayList.add(zzckw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcfw zzcfw2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        this.zzjB();
        this.zzkC();
        if (this.zzG(zzcfw2.packageName, zzcfw2.zzbph.name) == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcfw2.packageName});
            zzcfy.zzxu();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcfw2.packageName);
        contentValues.put("origin", zzcfw2.zzbpg);
        contentValues.put("name", zzcfw2.zzbph.name);
        zzcfz.zza(contentValues, "value", zzcfw2.zzbph.getValue());
        contentValues.put("active", Boolean.valueOf(zzcfw2.zzbpj));
        contentValues.put("trigger_event_name", zzcfw2.zzbpk);
        contentValues.put("trigger_timeout", Long.valueOf(zzcfw2.zzbpm));
        this.zzwA();
        contentValues.put("timed_out_event", zzckx.zza((Parcelable)zzcfw2.zzbpl));
        contentValues.put("creation_timestamp", Long.valueOf(zzcfw2.zzbpi));
        this.zzwA();
        contentValues.put("triggered_event", zzckx.zza((Parcelable)zzcfw2.zzbpn));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcfw2.zzbph.zzbuC));
        contentValues.put("time_to_live", Long.valueOf(zzcfw2.zzbpo));
        this.zzwA();
        contentValues.put("expired_event", zzckx.zza((Parcelable)zzcfw2.zzbpp));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert/update conditional user property (got -1)", zzcgx.zzea(zzcfw2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing conditional user property", zzcgx.zzea(zzcfw2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcfw zzH(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcgl zzcgl2 = this.zzwA().zzb(cursor.getBlob(5), zzcgl.CREATOR);
            long l2 = cursor.getLong(6);
            zzcgl zzcgl3 = this.zzwA().zzb(cursor.getBlob(7), zzcgl.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcgl zzcgl4 = this.zzwA().zzb(cursor.getBlob(10), zzcgl.CREATOR);
            zzcku zzcku2 = new zzcku(string2, l3, object, string3);
            zzcfw zzcfw2 = new zzcfw(string, string3, zzcku2, l2, bl, string4, zzcgl2, l, zzcgl3, l4, zzcgl4);
            if (cursor.moveToNext()) {
                this.zzwE().zzyv().zze("Got multiple records for conditional property, expected one", zzcgx.zzea(string), this.zzwz().zzdZ(string2));
            }
            zzcfw zzcfw3 = zzcfw2;
            return zzcfw3;
        }
    }

    @WorkerThread
    public final int zzI(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zzd("Error deleting conditional property", zzcgx.zzea(string), this.zzwz().zzdZ(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcfw> zzi(String string, String string2, String string3) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcfw> zzc(String string, String[] stringArray) {
        this.zzjB();
        this.zzkC();
        ArrayList<zzcfw> arrayList = new ArrayList<zzcfw>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            zzcfy.zzxu();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcfw> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= zzcfy.zzxu()) {
                    this.zzwE().zzyv().zzj("Read more than the max allowed conditional properties, ignoring extra", zzcfy.zzxu());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcgl zzcgl2 = this.zzwA().zzb(cursor.getBlob(7), zzcgl.CREATOR);
                long l2 = cursor.getLong(8);
                zzcgl zzcgl3 = this.zzwA().zzb(cursor.getBlob(9), zzcgl.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcgl zzcgl4 = this.zzwA().zzb(cursor.getBlob(12), zzcgl.CREATOR);
                zzcku zzcku2 = new zzcku(string3, l3, object2, string2);
                zzcfw zzcfw2 = new zzcfw((String)object, string2, zzcku2, l2, bl, string4, zzcgl2, l, zzcgl3, l4, zzcgl4);
                arrayList.add(zzcfw2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcfs zzdR(String string) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcfs zzcfs2 = new zzcfs(this.zzboi, string);
            zzcfs2.zzdH(cursor.getString(0));
            zzcfs2.zzdI(cursor.getString(1));
            zzcfs2.zzdJ(cursor.getString(2));
            zzcfs2.zzQ(cursor.getLong(3));
            zzcfs2.zzL(cursor.getLong(4));
            zzcfs2.zzM(cursor.getLong(5));
            zzcfs2.setAppVersion(cursor.getString(6));
            zzcfs2.zzdL(cursor.getString(7));
            zzcfs2.zzO(cursor.getLong(8));
            zzcfs2.zzP(cursor.getLong(9));
            zzcfs2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzcfs2.zzT(cursor.getLong(11));
            zzcfs2.zzU(cursor.getLong(12));
            zzcfs2.zzV(cursor.getLong(13));
            zzcfs2.zzW(cursor.getLong(14));
            zzcfs2.zzR(cursor.getLong(15));
            zzcfs2.zzS(cursor.getLong(16));
            zzcfs2.zzN(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcfs2.zzdK(cursor.getString(18));
            zzcfs2.zzY(cursor.getLong(19));
            zzcfs2.zzX(cursor.getLong(20));
            zzcfs2.zzdM(cursor.getString(21));
            zzcfs2.zzZ(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcfs2.zzwH();
            if (cursor.moveToNext()) {
                this.zzwE().zzyv().zzj("Got multiple records for app, expected one. appId", zzcgx.zzea(string));
            }
            zzcfs zzcfs3 = zzcfs2;
            return zzcfs3;
        }
    }

    @WorkerThread
    public final void zza(zzcfs zzcfs2) {
        zzbr.zzu((Object)zzcfs2);
        this.zzjB();
        this.zzkC();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcfs2.zzhk());
        contentValues.put("app_instance_id", zzcfs2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcfs2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcfs2.zzwI());
        contentValues.put("last_bundle_index", Long.valueOf(zzcfs2.zzwR()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcfs2.zzwK()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcfs2.zzwL()));
        contentValues.put("app_version", zzcfs2.zzjG());
        contentValues.put("app_store", zzcfs2.zzwN());
        contentValues.put("gmp_version", Long.valueOf(zzcfs2.zzwO()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcfs2.zzwP()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcfs2.zzwQ()));
        contentValues.put("day", Long.valueOf(zzcfs2.zzwV()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcfs2.zzwW()));
        contentValues.put("daily_events_count", Long.valueOf(zzcfs2.zzwX()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcfs2.zzwY()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcfs2.zzwS()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcfs2.zzwT()));
        contentValues.put("app_version_int", Long.valueOf(zzcfs2.zzwM()));
        contentValues.put("firebase_instance_id", zzcfs2.zzwJ());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcfs2.zzxa()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcfs2.zzwZ()));
        contentValues.put("health_monitor_sample", zzcfs2.zzxb());
        contentValues.put("android_id", Long.valueOf(zzcfs2.zzxd()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcfs2.zzhk()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert/update app (got -1). appId", zzcgx.zzea(zzcfs2.zzhk()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing app. appId", zzcgx.zzea(zzcfs2.zzhk()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzdS(String string) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzwG().zzb(string2, zzcgn.zzbqo);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error deleting over the limit events. appId", zzcgx.zzea(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcga zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        String[] stringArray = new String[]{string};
        zzcga zzcga2 = new zzcga();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzwE().zzyx().zzj("Not updating daily counts, app is not known. appId", zzcgx.zzea(string));
                zzcga zzcga3 = zzcga2;
                return zzcga3;
            }
            if (cursor.getLong(0) == l) {
                zzcga2.zzbpz = cursor.getLong(1);
                zzcga2.zzbpy = cursor.getLong(2);
                zzcga2.zzbpA = cursor.getLong(3);
                zzcga2.zzbpB = cursor.getLong(4);
                zzcga2.zzbpC = cursor.getLong(5);
            }
            if (bl) {
                ++zzcga2.zzbpz;
            }
            if (bl2) {
                ++zzcga2.zzbpy;
            }
            if (bl3) {
                ++zzcga2.zzbpA;
            }
            if (bl4) {
                ++zzcga2.zzbpB;
            }
            if (bl5) {
                ++zzcga2.zzbpC;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcga2.zzbpy));
            contentValues.put("daily_events_count", Long.valueOf(zzcga2.zzbpz));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcga2.zzbpA));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcga2.zzbpB));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcga2.zzbpC));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcga zzcga4 = zzcga2;
            return zzcga4;
        }
    }

    @WorkerThread
    public final byte[] zzdT(String string) {
        zzbr.zzcF((String)string);
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzwE().zzyv().zzj("Got multiple records for app config, expected one. appId", zzcgx.zzea(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcll zzcll2, boolean bl) {
        byte[] byArray;
        this.zzjB();
        this.zzkC();
        zzbr.zzu((Object)((Object)zzcll2));
        zzbr.zzcF((String)zzcll2.zzaK);
        zzbr.zzu((Object)zzcll2.zzbvM);
        this.zzyd();
        long l = this.zzkp().currentTimeMillis();
        if (zzcll2.zzbvM < l - zzcfy.zzxF() || zzcll2.zzbvM > l + zzcfy.zzxF()) {
            this.zzwE().zzyx().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcgx.zzea(zzcll2.zzaK), l, zzcll2.zzbvM);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcll2.zzMl()];
            ahx ahx2 = ahx.zzc((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcll2.zza(ahx2);
            ahx2.zzMc();
            byArray = this.zzwA().zzm(byArray2);
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Data loss. Failed to serialize bundle. appId", zzcgx.zzea(zzcll2.zzaK), iOException);
            return false;
        }
        this.zzwE().zzyB().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcll2.zzaK);
        contentValues.put("bundle_end_timestamp", zzcll2.zzbvM);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert bundle (got -1). appId", zzcgx.zzea(zzcll2.zzaK));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing bundle. appId", zzcgx.zzea(zzcll2.zzaK), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzyb() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzyc() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcll, Long>> zzl(String string, int n, int n2) {
        this.zzjB();
        this.zzkC();
        zzbr.zzaf((n > 0 ? 1 : 0) != 0);
        zzbr.zzaf((n2 > 0 ? 1 : 0) != 0);
        zzbr.zzcF((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcll, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcll, Long>> arrayList = new ArrayList<Pair<zzcll, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzwA().zzn((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzwE().zzyv().zze("Failed to unzip queued bundle. appId", zzcgx.zzea(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = ahw.zzb((byte[])byArray, (int)0, (int)byArray2.length);
                zzcll zzcll2 = new zzcll();
                try {
                    zzcll2.zza((ahw)object);
                }
                catch (IOException iOException) {
                    this.zzwE().zzyv().zze("Failed to merge queued bundle. appId", zzcgx.zzea(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcll, Long>)Pair.create((Object)((Object)zzcll2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcll, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzyd() {
        this.zzjB();
        this.zzkC();
        if (!this.zzyj()) {
            return;
        }
        long l = this.zzwF().zzbrr.get();
        long l2 = this.zzkp().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcfy.zzxG()) {
            this.zzwF().zzbrr.set(l2);
            zzcfz zzcfz2 = this;
            zzcfz2.zzjB();
            zzcfz2.zzkC();
            if (zzcfz2.zzyj()) {
                SQLiteDatabase sQLiteDatabase = zzcfz2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcfz2.zzkp().currentTimeMillis()), String.valueOf(zzcfy.zzxF())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcfz2.zzwE().zzyB().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcky[] zzckyArray) {
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)zzckyArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcfz zzcfz2 = this;
            zzcfz2.zzkC();
            zzcfz2.zzjB();
            zzbr.zzcF((String)string2);
            Object object = zzcfz2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzckyArray;
            int n2 = zzckyArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzckz zzckz2;
                int n3;
                int n4;
                zzcky zzcky2 = object2[n];
                object = zzcky2;
                string2 = string;
                zzcfz2 = this;
                zzcfz2.zzkC();
                zzcfz2.zzjB();
                zzbr.zzcF((String)string2);
                zzbr.zzu((Object)object);
                zzbr.zzu((Object)object.zzbuO);
                zzbr.zzu((Object)object.zzbuN);
                if (object.zzbuM == null) {
                    zzcfz2.zzwE().zzyx().zzj("Audience with no ID. appId", zzcgx.zzea(string2));
                    continue;
                }
                int n5 = object.zzbuM;
                ahz[] ahzArray = object.zzbuO;
                int n6 = object.zzbuO.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (ahzArray[n4].zzbuQ != null) continue;
                    zzcfz2.zzwE().zzyx().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcgx.zzea(string2), object.zzbuM);
                    continue block3;
                }
                ahzArray = object.zzbuN;
                n6 = object.zzbuN.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (ahzArray[n4].zzbuQ != null) continue;
                    zzcfz2.zzwE().zzyx().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcgx.zzea(string2), object.zzbuM);
                    continue block3;
                }
                boolean bl = true;
                ahz[] ahzArray2 = object.zzbuO;
                n4 = object.zzbuO.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzckz2 = ahzArray2[n3];
                    if (zzcfz2.zza(string2, n5, zzckz2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    ahzArray2 = object.zzbuN;
                    n4 = object.zzbuN.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzckz2 = ahzArray2[n3];
                        if (zzcfz2.zza(string2, n5, (zzclc)((Object)zzckz2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcfz zzcfz3 = zzcfz2;
                zzcfz3.zzkC();
                zzcfz3.zzjB();
                zzbr.zzcF((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcfz3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcky[] zzckyArray2 = zzckyArray;
            n = zzckyArray.length;
            for (int i = 0; i < n; ++i) {
                zzcky zzcky3 = zzckyArray2[i];
                object2.add(zzcky3.zzbuM);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzckz zzckz2) {
        byte[] byArray;
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)((Object)zzckz2));
        if (TextUtils.isEmpty((CharSequence)zzckz2.zzbuR)) {
            this.zzwE().zzyx().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcgx.zzea(string), n, String.valueOf(zzckz2.zzbuQ));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzckz2.zzMl()];
            ahx ahx2 = ahx.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzckz2.zza(ahx2);
            ahx2.zzMc();
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Configuration loss. Failed to serialize event filter. appId", zzcgx.zzea(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzckz2.zzbuQ);
        contentValues.put("event_name", zzckz2.zzbuR);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert event filter (got -1). appId", zzcgx.zzea(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing event filter. appId", zzcgx.zzea(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzclc zzclc2) {
        byte[] byArray;
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)((Object)zzclc2));
        if (TextUtils.isEmpty((CharSequence)zzclc2.zzbvg)) {
            this.zzwE().zzyx().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcgx.zzea(string), n, String.valueOf(zzclc2.zzbuQ));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzclc2.zzMl()];
            ahx ahx2 = ahx.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzclc2.zza(ahx2);
            ahx2.zzMc();
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Configuration loss. Failed to serialize property filter. appId", zzcgx.zzea(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzclc2.zzbuQ);
        contentValues.put("property_name", zzclc2.zzbvg);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert property filter (got -1). appId", zzcgx.zzea(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing property filter. appId", zzcgx.zzea(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzckz>> zzJ(String string, String string2) {
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzckz>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                ahw ahw2 = ahw.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzckz zzckz2 = new zzckz();
                try {
                    zzckz2.zza(ahw2);
                }
                catch (IOException iOException) {
                    this.zzwE().zzyv().zze("Failed to merge filter. appId", zzcgx.zzea(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzckz> arrayList = (ArrayList<zzckz>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzckz>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzckz2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzclc>> zzK(String string, String string2) {
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzclc>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                ahw ahw2 = ahw.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzclc zzclc2 = new zzclc();
                try {
                    zzclc2.zza(ahw2);
                }
                catch (IOException iOException) {
                    this.zzwE().zzyv().zze("Failed to merge filter", zzcgx.zzea(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzclc> arrayList = (ArrayList<zzclc>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzclc>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzclc2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbr.zzcF((String)string);
        this.zzkC();
        this.zzjB();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Database error querying filters. appId", zzcgx.zzea(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzwG().zzb(string2, zzcgn.zzbqE);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzclm> zzdU(String string) {
        this.zzkC();
        this.zzjB();
        zzbr.zzcF((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                ahw ahw2 = ahw.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzclm zzclm2 = new zzclm();
                try {
                    zzclm2.zza(ahw2);
                }
                catch (IOException iOException) {
                    this.zzwE().zzyv().zzd("Failed to merge filter results. appId, audienceId, error", zzcgx.zzea(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzclm2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzwE().zzyv().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzwE().zzyv().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzwE().zzyv().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzye() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzL(String string, String string2) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        this.zzjB();
        this.zzkC();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzwE().zzyv().zze("Failed to insert column (got -1). appId", zzcgx.zzea(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzwE().zzyv().zze("Failed to update column (got 0). appId", zzcgx.zzea(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zzd("Error inserting column. appId", zzcgx.zzea(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzyf() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcll zzcll2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzjB();
        this.zzkC();
        zzbr.zzu((Object)((Object)zzcll2));
        zzbr.zzcF((String)zzcll2.zzaK);
        try {
            byArray = new byte[zzcll2.zzMl()];
            object = byArray;
            ahx ahx2 = ahx.zzc((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcll2.zza(ahx2);
            ahx2.zzMc();
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Data loss. Failed to serialize event metadata. appId", zzcgx.zzea(zzcll2.zzaK), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzwA();
        zzbr.zzu((Object)byArray2);
        ((zzckx)object).zzjB();
        MessageDigest messageDigest = zzckx.zzbE("MD5");
        if (messageDigest == null) {
            ((zzckx)object).zzwE().zzyv().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzckx.zzo(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcll2.zzaK);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing raw event metadata. appId", zzcgx.zzea(zzcll2.zzaK), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzyg() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzyh() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzG(List<Long> list) {
        zzbr.zzu(list);
        this.zzjB();
        this.zzkC();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzwE().zzyv().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzdV(String string) {
        zzbr.zzcF((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzaa(long l) {
        this.zzjB();
        this.zzkC();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzwE().zzyB().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzyi() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcgg zzcgg2, long l, boolean bl) {
        Object object;
        zzclj zzclj2;
        String string2;
        this.zzjB();
        this.zzkC();
        zzbr.zzu((Object)zzcgg2);
        zzbr.zzcF((String)zzcgg2.mAppId);
        zzcli zzcli2 = new zzcli();
        new zzcli().zzbvC = zzcgg2.zzbpI;
        zzcli2.zzbvA = new zzclj[zzcgg2.zzbpJ.size()];
        int n = 0;
        for (String string2 : zzcgg2.zzbpJ) {
            zzclj2 = new zzclj();
            zzcli2.zzbvA[n++] = zzclj2;
            zzclj2.name = string2;
            Object object2 = zzcgg2.zzbpJ.get(string2);
            this.zzwA().zza(zzclj2, object2);
        }
        try {
            byte[] byArray = new byte[zzcli2.zzMl()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzclj2 = ahx.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcli2.zza((ahx)zzclj2);
            zzclj2.zzMc();
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Data loss. Failed to serialize event params/data. appId", zzcgx.zzea(zzcgg2.mAppId), iOException);
            return false;
        }
        this.zzwE().zzyB().zze("Saving event, name, data size", this.zzwz().zzdX(zzcgg2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcgg2.mAppId);
        string2.put("name", zzcgg2.mName);
        string2.put("timestamp", Long.valueOf(zzcgg2.zzayU));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzwE().zzyv().zzj("Failed to insert raw event (got -1). appId", zzcgx.zzea(zzcgg2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwE().zzyv().zze("Error storing raw event. appId", zzcgx.zzea(zzcgg2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzyj() {
        return this.getContext().getDatabasePath(zzcfy.zzxB()).exists();
    }

    @WorkerThread
    private static boolean zza(zzcgx zzcgx2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcgx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcgx zzcgx2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzcgx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcfz.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzcgx2.zzyx().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcgx zzcgx2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzcgx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcfz.zza(zzcgx2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcfz.zza(zzcgx2, sQLiteDatabase, string, string3, map);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcgx2.zzyv().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcgx zzcgx2, SQLiteDatabase sQLiteDatabase) {
        if (zzcgx2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcgx2.zzyx().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcgx2.zzyx().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcgx2.zzyx().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcgx2.zzyx().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzckr zza(zzcfz zzcfz2) {
        return zzcfz2.zzbpx;
    }

    static /* synthetic */ Map zzyk() {
        return zzbpr;
    }

    static /* synthetic */ Map access$200() {
        return zzbps;
    }

    static /* synthetic */ Map zzyl() {
        return zzbpu;
    }

    static /* synthetic */ Map zzym() {
        return zzbpt;
    }

    static /* synthetic */ Map zzyn() {
        return zzbpv;
    }

    static {
        zzbpr.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zzbps = new ArrayMap(18);
        zzbps.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbps.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbps.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbps.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbps.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbps.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbps.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbps.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbps.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbps.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbps.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbps.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbps.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbps.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbps.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbps.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzbps.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzbps.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzbps.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzbpt = new ArrayMap(1);
        zzbpt.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzbpu = new ArrayMap(1);
        zzbpu.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzbpv = new ArrayMap(1);
        zzbpv.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }
}

