/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.internal.zzbey;
import com.google.android.gms.internal.zzbik;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcgs
extends zzciv {
    private String mAppId;
    private String zzaeK;
    private int zzbqG;
    private String zzboF;
    private String zzaeJ;
    private long zzbqH;
    private long zzboJ;
    private int zzbqI;
    private String zzXD;

    zzcgs(zzchx zzchx2) {
        super(zzchx2);
    }

    @Override
    protected final void zzjC() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = super.getContext().getPackageName();
        PackageManager packageManager = super.getContext().getPackageManager();
        if (packageManager == null) {
            super.zzwE().zzyv().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcgx.zzea(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.zzwE().zzyv().zzj("Error retrieving app installer package name. appId", zzcgx.zzea(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(super.getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                super.zzwE().zzyv().zze("Error retrieving package info. appId, appName", zzcgx.zzea(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzboF = string;
        this.zzaeK = string2;
        this.zzbqG = n;
        this.zzaeJ = string3;
        this.zzbqH = 0L;
        zzcfy.zzxD();
        packageInfo = zzbey.zzaz((Context)super.getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcgs zzcgs2 = this;
            if (packageInfo2 == null) {
                super.zzwE().zzyv().log("GoogleService failed to initialize (no status)");
            } else {
                super.zzwE().zzyv().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = super.zzwG().zzdO("firebase_analytics_collection_enabled");
            if (super.zzwG().zzxE()) {
                super.zzwE().zzyz().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                super.zzwE().zzyz().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcfy.zzqz()) {
                super.zzwE().zzyz().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                super.zzwE().zzyB().log("Collection enabled");
            }
        }
        this.zzXD = "";
        this.zzboJ = 0L;
        zzcfy.zzxD();
        try {
            object = zzbey.zzqy();
            Object object2 = this.zzXD = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                super.zzwE().zzyB().zze("App package, google app id", this.mAppId, this.zzXD);
            }
        }
        catch (IllegalStateException illegalStateException) {
            super.zzwE().zzyv().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcgx.zzea(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzbqI = zzbik.zzaN((Context)super.getContext()) ? 1 : 0;
            return;
        }
        this.zzbqI = 0;
    }

    @WorkerThread
    final zzcft zzdW(String string) {
        super.zzjB();
        String string2 = this.zzhk();
        String string3 = this.getGmpAppId();
        zzcgs zzcgs2 = this;
        zzcgs2.zzkC();
        String string4 = zzcgs2.zzaeK;
        long l = this.zzyt();
        zzcgs2 = this;
        zzcgs2.zzkC();
        String string5 = zzcgs2.zzboF;
        long l2 = zzcfy.zzwO();
        zzcgs2 = this;
        zzcgs2.zzkC();
        super.zzjB();
        if (zzcgs2.zzbqH == 0L) {
            zzcgs2.zzbqH = zzcgs2.zzboi.zzwA().zzJ(super.getContext(), super.getContext().getPackageName());
        }
        long l3 = zzcgs2.zzbqH;
        boolean bl = this.zzboi.isEnabled();
        boolean bl2 = !super.zzwF().zzbrG;
        String string6 = this.zzwJ();
        this.zzkC();
        long l4 = this.zzboi.zzyW();
        zzcgs2 = this;
        zzcgs2.zzkC();
        return new zzcft(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcgs2.zzbqI);
    }

    @WorkerThread
    final String zzys() {
        byte[] byArray = new byte[16];
        super.zzwA().zzzr().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzwJ() {
        super.zzjB();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            super.zzwE().zzyx().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzhk() {
        this.zzkC();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzkC();
        return this.zzXD;
    }

    final int zzyt() {
        this.zzkC();
        return this.zzbqG;
    }
}

