/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckx;
import java.util.ArrayList;
import java.util.List;

public final class zzcgt
extends zzciv {
    private final zzcgu zzbqJ = new zzcgu(this, super.getContext(), zzcfy.zzxC());
    private boolean zzbqK;

    zzcgt(zzchx zzchx2) {
        super(zzchx2);
    }

    @Override
    protected final void zzjC() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        super.zzwo();
        super.zzjB();
        if (this.zzbqK) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        zzcfy.zzxM();
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    super.zzwE().zzyx().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            super.zzwE().zzyv().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                super.zzwE().zzyv().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzbqK = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    super.zzwE().zzyv().zzj("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzbqK = true;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block20;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        super.zzwE().zzyv().zzj("Error writing entry to local database", (Object)sQLiteException);
                        this.zzbqK = true;
                    }
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcgl zzcgl2) {
        Parcel parcel = Parcel.obtain();
        zzcgl2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            super.zzwE().zzyx().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzcku zzcku2) {
        Parcel parcel = Parcel.obtain();
        zzcku2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            super.zzwE().zzyx().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    public final boolean zzc(zzcfw zzcfw2) {
        super.zzwA();
        byte[] byArray = zzckx.zza((Parcelable)zzcfw2);
        if (byArray.length > 131072) {
            super.zzwE().zzyx().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public final List<zza> zzbo(int n) {
        super.zzjB();
        super.zzwo();
        if (this.zzbqK) {
            return null;
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        if (!super.getContext().getDatabasePath(zzcfy.zzxC()).exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    super.zzwE().zzyx().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zza zza2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zza2 = (zzcgl)((Object)zzcgl.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzc zzc2) {
                                    super.zzwE().zzyv().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zza2 == null) continue;
                                arrayList.add(zza2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zza2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zza2 = (zzcku)((Object)zzcku.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzc zzc3) {
                                    super.zzwE().zzyv().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zza2 == null) continue;
                                arrayList.add(zza2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zza2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zza2 = (zzcfw)((Object)zzcfw.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzc zzc4) {
                                    super.zzwE().zzyv().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zza2 == null) continue;
                                arrayList.add(zza2);
                                continue;
                            }
                            super.zzwE().zzyv().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            super.zzwE().zzyv().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzbqK = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    super.zzwE().zzyv().zzj("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzbqK = true;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block41;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        super.zzwE().zzyv().zzj("Error reading entries from local database", (Object)sQLiteException);
                        this.zzbqK = true;
                    }
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() {
        if (this.zzbqK) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzbqJ.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzbqK = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

