/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzchn;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzckx;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzchi
extends zzciv {
    static final Pair<String, Long> zzbrm = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzaiz;
    public final zzchm zzbrn = new zzchm(this, "health_monitor", zzcfy.zzxJ(), null);
    public final zzchl zzbro = new zzchl(this, "last_upload", 0L);
    public final zzchl zzbrp = new zzchl(this, "last_upload_attempt", 0L);
    public final zzchl zzbrq = new zzchl(this, "backoff", 0L);
    public final zzchl zzbrr = new zzchl(this, "last_delete_stale", 0L);
    public final zzchl zzbrs;
    public final zzchl zzbrt;
    public final zzchn zzbru;
    private String zzbrv;
    private boolean zzbrw;
    private long zzbrx;
    private String zzbry;
    private long zzbrz;
    private final Object zzbrA;
    public final zzchl zzbrB = new zzchl(this, "time_before_start", 10000L);
    public final zzchl zzbrC = new zzchl(this, "session_timeout", 1800000L);
    public final zzchk zzbrD = new zzchk(this, "start_new_session", true);
    public final zzchl zzbrE = new zzchl(this, "last_pause_time", 0L);
    public final zzchl zzbrF = new zzchl(this, "time_active", 0L);
    public boolean zzbrG;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzec(String string) {
        this.zzjB();
        long l = this.zzkp().elapsedRealtime();
        if (this.zzbrv != null && l < this.zzbrx) {
            return new Pair((Object)this.zzbrv, (Object)this.zzbrw);
        }
        String string2 = string;
        this.zzbrx = l + this.zzwG().zza(string2, zzcgn.zzbqa);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzbrv = info.getId();
                this.zzbrw = info.isLimitAdTrackingEnabled();
            }
            if (this.zzbrv == null) {
                this.zzbrv = "";
            }
        }
        catch (Throwable throwable) {
            this.zzwE().zzyA().zzj("Unable to get advertising id", throwable);
            this.zzbrv = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbrv, (Object)this.zzbrw);
    }

    @WorkerThread
    final String zzed(String string) {
        this.zzjB();
        String string2 = (String)this.zzec((String)string).first;
        MessageDigest messageDigest = zzckx.zzbE("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzchi(zzchx zzchx2) {
        super(zzchx2);
        this.zzbrs = new zzchl(this, "midnight_offset", 0L);
        this.zzbrt = new zzchl(this, "first_open_time", 0L);
        this.zzbru = new zzchn(this, "app_instance_id", null);
        this.zzbrA = new Object();
    }

    @Override
    protected final void zzjC() {
        this.zzaiz = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbrG = this.zzaiz.getBoolean("has_been_opened", false);
        if (!this.zzbrG) {
            SharedPreferences.Editor editor = this.zzaiz.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzyD() {
        this.zzjB();
        this.zzkC();
        return this.zzaiz;
    }

    @WorkerThread
    final void zzee(String string) {
        this.zzjB();
        SharedPreferences.Editor editor = this.zzyD().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzyE() {
        this.zzjB();
        return this.zzyD().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzef(String string) {
        Object object = this.zzbrA;
        synchronized (object) {
            this.zzbry = string;
            this.zzbrz = this.zzkp().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzyF() {
        Object object = this.zzbrA;
        synchronized (object) {
            if (Math.abs(this.zzkp().elapsedRealtime() - this.zzbrz) < 1000L) {
                return this.zzbry;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzyG() {
        this.zzjB();
        if (!this.zzyD().contains("use_service")) {
            return null;
        }
        return this.zzyD().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzak(boolean bl) {
        this.zzjB();
        this.zzwE().zzyB().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzyD().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzyH() {
        this.zzjB();
        this.zzwE().zzyB().log("Clearing collection preferences.");
        boolean bl = this.zzyD().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzal(true);
        }
        SharedPreferences.Editor editor = this.zzyD().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzjB();
        this.zzwE().zzyB().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzyD().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzal(boolean bl) {
        this.zzjB();
        return this.zzyD().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzyI() {
        this.zzjB();
        String string = this.zzyD().getString("previous_os_version", null);
        this.zzwu().zzkC();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzyD().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzchi zzchi2) {
        return zzchi2.zzaiz;
    }

    static /* synthetic */ SharedPreferences zzb(zzchi zzchi2) {
        return zzchi2.zzyD();
    }
}

