/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzchu;
import com.google.android.gms.internal.zzchv;
import com.google.android.gms.internal.zzchw;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzchs
extends zzciv {
    private ExecutorService zzbrZ;
    private zzchw zzbsa;
    private zzchw zzbsb;
    private final PriorityBlockingQueue<FutureTask<?>> zzbsc;
    private final BlockingQueue<FutureTask<?>> zzbsd;
    private final Thread.UncaughtExceptionHandler zzbse;
    private final Thread.UncaughtExceptionHandler zzbsf;
    private final Object zzbsg = new Object();
    private final Semaphore zzbsh = new Semaphore(2);
    private volatile boolean zzbsi;
    private static final AtomicLong zzbsj = new AtomicLong(Long.MIN_VALUE);

    zzchs(zzchx zzchx2) {
        super(zzchx2);
        this.zzbsc = new PriorityBlockingQueue();
        this.zzbsd = new LinkedBlockingQueue();
        this.zzbse = new zzchu(this, "Thread death: Uncaught exception on worker thread");
        this.zzbsf = new zzchu(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzjC() {
    }

    @Override
    public final void zzjB() {
        if (Thread.currentThread() != this.zzbsa) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzwp() {
        if (Thread.currentThread() != this.zzbsb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzR() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzyK() {
        return Thread.currentThread() == this.zzbsa;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzkC();
        zzbr.zzu(callable);
        zzchv zzchv2 = new zzchv(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbsa) {
            if (!this.zzbsc.isEmpty()) {
                super.zzwE().zzyx().log("Callable skipped the worker queue.");
            }
            zzchv2.run();
        } else {
            this.zza(zzchv2);
        }
        return zzchv2;
    }

    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzkC();
        zzbr.zzu(callable);
        zzchv zzchv2 = new zzchv(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbsa) {
            zzchv2.run();
        } else {
            this.zza(zzchv2);
        }
        return zzchv2;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzkC();
        zzbr.zzu((Object)runnable);
        this.zza(new zzchv(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzchv<?> zzchv2) {
        Object object = this.zzbsg;
        synchronized (object) {
            this.zzbsc.add(zzchv2);
            if (this.zzbsa == null) {
                this.zzbsa = new zzchw(this, "Measurement Worker", this.zzbsc);
                this.zzbsa.setUncaughtExceptionHandler(this.zzbse);
                this.zzbsa.start();
            } else {
                this.zzbsa.zzfE();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Runnable runnable) throws IllegalStateException {
        this.zzkC();
        zzbr.zzu((Object)runnable);
        zzchv zzchv2 = new zzchv(this, runnable, false, "Task exception on network thread");
        zzchs zzchs2 = this;
        Object object = zzchs2.zzbsg;
        synchronized (object) {
            zzchs2.zzbsd.add(zzchv2);
            if (zzchs2.zzbsb == null) {
                zzchs2.zzbsb = new zzchw(zzchs2, "Measurement Network", zzchs2.zzbsd);
                zzchs2.zzbsb.setUncaughtExceptionHandler(zzchs2.zzbsf);
                zzchs2.zzbsb.start();
            } else {
                zzchs2.zzbsb.zzfE();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzyL() {
        Object object = this.zzbsg;
        synchronized (object) {
            if (this.zzbrZ == null) {
                this.zzbrZ = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbrZ;
        }
    }

    static /* synthetic */ Semaphore zza(zzchs zzchs2) {
        return zzchs2.zzbsh;
    }

    static /* synthetic */ boolean zzb(zzchs zzchs2) {
        return zzchs2.zzbsi;
    }

    static /* synthetic */ Object zzc(zzchs zzchs2) {
        return zzchs2.zzbsg;
    }

    static /* synthetic */ zzchw zzd(zzchs zzchs2) {
        return zzchs2.zzbsa;
    }

    static /* synthetic */ zzchw zza(zzchs zzchs2, zzchw zzchw2) {
        zzchs2.zzbsa = null;
        return null;
    }

    static /* synthetic */ zzchw zze(zzchs zzchs2) {
        return zzchs2.zzbsb;
    }

    static /* synthetic */ zzchw zzb(zzchs zzchs2, zzchw zzchw2) {
        zzchs2.zzbsb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzyM() {
        return zzbsj;
    }
}

