/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.ahw;
import com.google.android.gms.internal.ahx;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcga;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcgt;
import com.google.android.gms.internal.zzcgv;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcgz;
import com.google.android.gms.internal.zzchb;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzcho;
import com.google.android.gms.internal.zzchr;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcib;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjp;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzcks;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckw;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzclf;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclj;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcll;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzchx {
    private static volatile zzchx zzbsq;
    private final Context mContext;
    private final zzcfy zzbsr;
    private final zzchi zzbss;
    private final zzcgx zzbst;
    private final zzchs zzbsu;
    private final zzckm zzbsv;
    private final zzchr zzbsw;
    private final AppMeasurement zzbsx;
    private final FirebaseAnalytics zzbsy;
    private final zzckx zzbsz;
    private final zzcgv zzbsA;
    private final zzcfz zzbsB;
    private final zzcgt zzbsC;
    private final zzchb zzbsD;
    private final zzf zzvz;
    private final zzcjl zzbsE;
    private final zzcjp zzbsF;
    private final zzcgf zzbsG;
    private final zzcix zzbsH;
    private final zzcgs zzbsI;
    private final zzchg zzbsJ;
    private final zzcks zzbsK;
    private final zzcfv zzbsL;
    private final zzcfo zzbsM;
    private final boolean zzafM;
    private boolean zzbsN;
    private Boolean zzbsO;
    private long zzbsP;
    private FileLock zzbsQ;
    private FileChannel zzbsR;
    private List<Long> zzbsS;
    private List<Runnable> zzbsT;
    private int zzbsU;
    private int zzbsV;
    private long zzbsW;
    private long zzbsX;
    private boolean zzbsY;
    private boolean zzbsZ;
    private boolean zzbta;
    private final long zzbtb;

    private zzchx(zzciw zzciw2) {
        zzcfo zzcfo2;
        String string;
        zzcgz zzcgz2;
        zzbr.zzu((Object)zzciw2);
        this.mContext = zzciw2.mContext;
        this.zzbsW = -1L;
        this.zzvz = zzj.zzrX();
        this.zzbtb = this.zzvz.currentTimeMillis();
        Object object = this;
        this.zzbsr = new zzcfy((zzchx)object);
        object = this;
        zzchi zzchi2 = new zzchi((zzchx)object);
        zzchi2.initialize();
        this.zzbss = zzchi2;
        object = this;
        zzcgx zzcgx2 = new zzcgx((zzchx)object);
        zzcgx2.initialize();
        this.zzbst = zzcgx2;
        this.zzwE().zzyz().zzj("App measurement is starting up, version", zzcfy.zzwO());
        zzcfy.zzxD();
        this.zzwE().zzyz().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzckx zzckx2 = new zzckx((zzchx)object);
        zzckx2.initialize();
        this.zzbsz = zzckx2;
        object = this;
        zzcgv zzcgv2 = new zzcgv((zzchx)object);
        zzcgv2.initialize();
        this.zzbsA = zzcgv2;
        object = this;
        zzcgf zzcgf2 = new zzcgf((zzchx)object);
        zzcgf2.initialize();
        this.zzbsG = zzcgf2;
        object = this;
        zzcgs zzcgs2 = new zzcgs((zzchx)object);
        zzcgs2.initialize();
        this.zzbsI = zzcgs2;
        zzcfy.zzxD();
        Object object2 = zzcgs2.zzhk();
        if (this.zzwA().zzez((String)object2)) {
            zzcgz2 = this.zzwE().zzyz();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcgz2 = this.zzwE().zzyz();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcgz2.log(string);
        this.zzwE().zzyA().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcfz((zzchx)object);
        ((zzciv)object2).initialize();
        this.zzbsB = object2;
        object = this;
        zzcgt zzcgt2 = new zzcgt((zzchx)object);
        zzcgt2.initialize();
        this.zzbsC = zzcgt2;
        object = this;
        zzcfv zzcfv2 = new zzcfv((zzchx)object);
        zzcfv2.initialize();
        this.zzbsL = zzcfv2;
        object = this;
        this.zzbsM = zzcfo2 = new zzcfo((zzchx)object);
        object = this;
        zzchb zzchb2 = new zzchb((zzchx)object);
        zzchb2.initialize();
        this.zzbsD = zzchb2;
        object = this;
        zzcjl zzcjl2 = new zzcjl((zzchx)object);
        zzcjl2.initialize();
        this.zzbsE = zzcjl2;
        object = this;
        zzcjp zzcjp2 = new zzcjp((zzchx)object);
        zzcjp2.initialize();
        this.zzbsF = zzcjp2;
        object = this;
        zzcix zzcix2 = new zzcix((zzchx)object);
        zzcix2.initialize();
        this.zzbsH = zzcix2;
        object = this;
        zzcks zzcks2 = new zzcks((zzchx)object);
        zzcks2.initialize();
        this.zzbsK = zzcks2;
        object = this;
        this.zzbsJ = new zzchg((zzchx)object);
        object = this;
        this.zzbsx = new AppMeasurement((zzchx)object);
        object = this;
        this.zzbsy = new FirebaseAnalytics((zzchx)object);
        object = this;
        zzckm zzckm2 = new zzckm((zzchx)object);
        zzckm2.initialize();
        this.zzbsv = zzckm2;
        object = this;
        zzchr zzchr2 = new zzchr((zzchx)object);
        zzchr2.initialize();
        this.zzbsw = zzchr2;
        object = this;
        zzchs zzchs2 = new zzchs((zzchx)object);
        zzchs2.initialize();
        this.zzbsu = zzchs2;
        if (this.zzbsU != this.zzbsV) {
            this.zzwE().zzyv().zze("Not all components initialized", this.zzbsU, this.zzbsV);
        }
        this.zzafM = true;
        zzcfy.zzxD();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzws();
            if (((zzcix)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcix)object).getContext().getApplicationContext();
                if (((zzcix)object).zzbts == null) {
                    ((zzcix)object).zzbts = new zzcjk((zzcix)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcix)object).zzbts);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcix)object).zzbts);
                ((zzcix)object).zzwE().zzyB().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzwE().zzyx().log("Application context is not an Application");
        }
        this.zzbsu.zzj(new zzchy(this));
    }

    final void zzkC() {
        if (!this.zzafM) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzyN() {
        this.zzkC();
        this.zzwD().zzjB();
        if (this.zzbsO == null || this.zzbsP == 0L || this.zzbsO != null && !this.zzbsO.booleanValue() && Math.abs(this.zzvz.elapsedRealtime() - this.zzbsP) > 1000L) {
            this.zzbsP = this.zzvz.elapsedRealtime();
            zzcfy.zzxD();
            this.zzbsO = this.zzwA().zzbv("android.permission.INTERNET") && this.zzwA().zzbv("android.permission.ACCESS_NETWORK_STATE") && (zzbim.zzaP((Context)this.mContext).zzsk() || zzcho.zzj(this.mContext, false) && zzcki.zzk(this.mContext, false));
            if (this.zzbsO.booleanValue()) {
                this.zzbsO = this.zzwA().zzew(this.zzwt().getGmpAppId());
            }
        }
        return this.zzbsO;
    }

    @WorkerThread
    protected final void start() {
        this.zzwD().zzjB();
        this.zzwy().zzyd();
        if (this.zzwF().zzbro.get() == 0L) {
            this.zzwF().zzbro.set(this.zzvz.currentTimeMillis());
        }
        if (Long.valueOf(this.zzwF().zzbrt.get()) == 0L) {
            this.zzwE().zzyB().zzj("Persisting first open", this.zzbtb);
            this.zzwF().zzbrt.set(this.zzbtb);
        }
        if (!this.zzyN()) {
            if (this.isEnabled()) {
                if (!this.zzwA().zzbv("android.permission.INTERNET")) {
                    this.zzwE().zzyv().log("App is missing INTERNET permission");
                }
                if (!this.zzwA().zzbv("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzwE().zzyv().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcfy.zzxD();
                if (!zzbim.zzaP((Context)this.mContext).zzsk()) {
                    if (!zzcho.zzj(this.mContext, false)) {
                        this.zzwE().zzyv().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcki.zzk(this.mContext, false)) {
                        this.zzwE().zzyv().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzwE().zzyv().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcfy.zzxD();
            if (!TextUtils.isEmpty((CharSequence)this.zzwt().getGmpAppId())) {
                String string = this.zzwF().zzyE();
                if (string == null) {
                    this.zzwF().zzee(this.zzwt().getGmpAppId());
                } else if (!string.equals(this.zzwt().getGmpAppId())) {
                    this.zzwE().zzyz().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzwF().zzyH();
                    this.zzbsF.disconnect();
                    this.zzbsF.zzkZ();
                    this.zzwF().zzee(this.zzwt().getGmpAppId());
                    this.zzwF().zzbrt.set(this.zzbtb);
                    this.zzwF().zzbru.zzeg(null);
                }
            }
            this.zzws().zzef(this.zzwF().zzbru.zzyJ());
            zzcfy.zzxD();
            if (!TextUtils.isEmpty((CharSequence)this.zzwt().getGmpAppId())) {
                zzcix zzcix2 = this.zzws();
                zzcix2.zzjB();
                zzcix2.zzwo();
                zzcix2.zzkC();
                if (zzcix2.zzboi.zzyN()) {
                    zzcix2.zzwv().zzzi();
                    String string = zzcix2.zzwF().zzyI();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        zzcix2.zzwu().zzkC();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcix2.zzd("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzwv().zza(new AtomicReference<String>());
            }
        }
        this.zzza();
    }

    public final zzcfy zzwG() {
        return this.zzbsr;
    }

    public final zzchi zzwF() {
        zzchx.zza((zzciu)this.zzbss);
        return this.zzbss;
    }

    public final zzcgx zzwE() {
        zzchx.zza(this.zzbst);
        return this.zzbst;
    }

    public final zzcgx zzyO() {
        if (this.zzbst != null && this.zzbst.isInitialized()) {
            return this.zzbst;
        }
        return null;
    }

    public final zzchs zzwD() {
        zzchx.zza(this.zzbsu);
        return this.zzbsu;
    }

    public final zzckm zzwC() {
        zzchx.zza(this.zzbsv);
        return this.zzbsv;
    }

    public final zzchr zzwB() {
        zzchx.zza(this.zzbsw);
        return this.zzbsw;
    }

    final zzchs zzyP() {
        return this.zzbsu;
    }

    public final zzcix zzws() {
        zzchx.zza(this.zzbsH);
        return this.zzbsH;
    }

    public final AppMeasurement zzyQ() {
        return this.zzbsx;
    }

    public final FirebaseAnalytics zzyR() {
        return this.zzbsy;
    }

    public final zzckx zzwA() {
        zzchx.zza((zzciu)this.zzbsz);
        return this.zzbsz;
    }

    public final zzcgv zzwz() {
        zzchx.zza((zzciu)this.zzbsA);
        return this.zzbsA;
    }

    public final zzcfz zzwy() {
        zzchx.zza(this.zzbsB);
        return this.zzbsB;
    }

    public final zzcgt zzwx() {
        zzchx.zza(this.zzbsC);
        return this.zzbsC;
    }

    public final zzchb zzyS() {
        zzchx.zza(this.zzbsD);
        return this.zzbsD;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzf zzkp() {
        return this.zzvz;
    }

    public final zzcjl zzww() {
        zzchx.zza(this.zzbsE);
        return this.zzbsE;
    }

    public final zzcjp zzwv() {
        zzchx.zza(this.zzbsF);
        return this.zzbsF;
    }

    public final zzcgf zzwu() {
        zzchx.zza(this.zzbsG);
        return this.zzbsG;
    }

    public final zzcgs zzwt() {
        zzchx.zza(this.zzbsI);
        return this.zzbsI;
    }

    private final zzchg zzyT() {
        if (this.zzbsJ == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbsJ;
    }

    private final zzcks zzyU() {
        zzchx.zza(this.zzbsK);
        return this.zzbsK;
    }

    public final zzcfv zzwr() {
        zzchx.zza(this.zzbsL);
        return this.zzbsL;
    }

    public final zzcfo zzwq() {
        zzchx.zza(this.zzbsM);
        return this.zzbsM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzchx zzbj(Context context) {
        zzbr.zzu((Object)context);
        zzbr.zzu((Object)context.getApplicationContext());
        if (zzbsq != null) return zzbsq;
        Class<zzchx> clazz = zzchx.class;
        synchronized (zzchx.class) {
            if (zzbsq != null) return zzbsq;
            zzciw zzciw2 = new zzciw(context);
            zzbsq = new zzchx(zzciw2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbsq;
        }
    }

    private static void zza(zzciv zzciv2) {
        if (zzciv2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzciv2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzciu zzciu2) {
        if (zzciu2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzyV() {
        this.zzwD().zzjB();
        String string = zzcfy.zzxB();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbsR = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbsQ = this.zzbsR.tryLock();
            if (this.zzbsQ != null) {
                this.zzwE().zzyB().log("Storage concurrent access okay");
                return true;
            }
            this.zzwE().zzyv().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzwE().zzyv().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzwD().zzjB();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwE().zzyv().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzwE().zzyx().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzwD().zzjB();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwE().zzyv().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzwE().zzyv().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        this.zzwD().zzjB();
        this.zzkC();
        if (this.zzbsr.zzxE()) {
            return false;
        }
        Boolean bl = this.zzbsr.zzdO("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcfy.zzqz();
        return this.zzwF().zzal(bl2);
    }

    final void zzd(zzcft zzcft2) {
        this.zzwD().zzjB();
        this.zzkC();
        zzbr.zzcF((String)zzcft2.packageName);
        this.zzf(zzcft2);
    }

    final long zzyW() {
        Long l = this.zzwF().zzbrt.get();
        if (l == 0L) {
            return this.zzbtb;
        }
        return Math.min(this.zzbtb, l);
    }

    private final long zzyX() {
        long l = this.zzvz.currentTimeMillis();
        zzchi zzchi2 = this.zzwF();
        zzchi2.zzkC();
        zzchi2.zzjB();
        long l2 = zzchi2.zzbrs.get();
        if (l2 == 0L) {
            l2 = 1 + zzchi2.zzwA().zzzr().nextInt(86400000);
            zzchi2.zzbrs.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcft zzem(String string) {
        zzcfs zzcfs2 = this.zzwy().zzdR(string);
        if (zzcfs2 == null || TextUtils.isEmpty((CharSequence)zzcfs2.zzjG())) {
            this.zzwE().zzyA().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbim.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcfs2.zzjG() != null && !zzcfs2.zzjG().equals(string2)) {
                this.zzwE().zzyx().zzj("App version does not match; dropping. appId", zzcgx.zzea(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcft(string, zzcfs2.getGmpAppId(), zzcfs2.zzjG(), zzcfs2.zzwM(), zzcfs2.zzwN(), zzcfs2.zzwO(), zzcfs2.zzwP(), null, zzcfs2.zzwQ(), false, zzcfs2.zzwJ(), zzcfs2.zzxd(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcgl zzcgl2, String string) {
        Object object;
        zzcfs zzcfs2;
        block4: {
            zzcfs2 = this.zzwy().zzdR(string);
            if (zzcfs2 == null || TextUtils.isEmpty((CharSequence)zzcfs2.zzjG())) {
                this.zzwE().zzyA().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbim.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcfs2.zzjG() != null && !zzcfs2.zzjG().equals(object)) {
                    this.zzwE().zzyx().zzj("App version does not match; dropping event. appId", zzcgx.zzea(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcgl2.name)) break block4;
                this.zzwE().zzyx().zzj("Could not find package. appId", zzcgx.zzea(string));
            }
        }
        object = new zzcft(string, zzcfs2.getGmpAppId(), zzcfs2.zzjG(), zzcfs2.zzwM(), zzcfs2.zzwN(), zzcfs2.zzwO(), zzcfs2.zzwP(), null, zzcfs2.zzwQ(), false, zzcfs2.zzwJ(), zzcfs2.zzxd(), 0L, 0);
        this.zzb(zzcgl2, (zzcft)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcgl zzcgl2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcft2));
        zzbr.zzcF((String)zzcft2.packageName);
        this.zzwD().zzjB();
        this.zzkC();
        String string = zzcft2.packageName;
        long l = zzcgl2.zzbpR;
        this.zzwA();
        if (!zzckx.zzd(zzcgl2, zzcft2)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        this.zzwy().beginTransaction();
        try {
            com.google.android.gms.common.internal.safeparcel.zza zza2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcfz zzcfz2 = this.zzwy();
            zzbr.zzcF((String)string3);
            zzcfz2.zzjB();
            zzcfz2.zzkC();
            if (l2 < 0L) {
                zzcfz2.zzwE().zzyx().zze("Invalid time querying timed out conditional properties", zzcgx.zzea(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcfz2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzwE().zzyA().zzd("User property timed out", object22.packageName, this.zzwz().zzdZ(object22.zzbph.name), object22.zzbph.getValue());
                if (object22.zzbpl != null) {
                    this.zzc(new zzcgl(object22.zzbpl, l), zzcft2);
                }
                this.zzwy().zzI(string, object22.zzbph.name);
            }
            l2 = l;
            string3 = string;
            zzcfz2 = this.zzwy();
            zzbr.zzcF((String)string3);
            zzcfz2.zzjB();
            zzcfz2.zzkC();
            if (l2 < 0L) {
                zzcfz2.zzwE().zzyx().zze("Invalid time querying expired conditional properties", zzcgx.zzea(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcfz2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcfw)((Object)object4.next());
                if (object == null) continue;
                this.zzwE().zzyA().zzd("User property expired", object.packageName, this.zzwz().zzdZ(object.zzbph.name), object.zzbph.getValue());
                this.zzwy().zzF(string, object.zzbph.name);
                if (object.zzbpp != null) {
                    object22.add(object.zzbpp);
                }
                this.zzwy().zzI(string, object.zzbph.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcgl)((Object)e);
                this.zzc(new zzcgl((zzcgl)((Object)object), l), zzcft2);
            }
            long l3 = l;
            String string4 = zzcgl2.name;
            string3 = string;
            zzcfz2 = this.zzwy();
            zzbr.zzcF((String)string3);
            zzbr.zzcF((String)string4);
            zzcfz2.zzjB();
            zzcfz2.zzkC();
            if (l3 < 0L) {
                zzcfz2.zzwE().zzyx().zzd("Invalid time querying triggered conditional properties", zzcgx.zzea(string3), zzcfz2.zzwz().zzdX(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcfz2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zza2 = (zzcfw)((Object)iterator.next());
                if (zza2 == null) continue;
                zzcku zzcku2 = zza2.zzbph;
                zzckw zzckw2 = new zzckw(zza2.packageName, zza2.zzbpg, zzcku2.name, l, zzcku2.getValue());
                if (this.zzwy().zza(zzckw2)) {
                    this.zzwE().zzyA().zzd("User property triggered", zza2.packageName, this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                } else {
                    this.zzwE().zzyv().zzd("Too many active user properties, ignoring", zzcgx.zzea(zza2.packageName), this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                }
                if (zza2.zzbpn != null) {
                    object.add(zza2.zzbpn);
                }
                zza2.zzbph = new zzcku(zzckw2);
                zza2.zzbpj = true;
                this.zzwy().zza((zzcfw)zza2);
            }
            this.zzc(zzcgl2, zzcft2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zza2 = (zzcgl)((Object)e);
                this.zzc(new zzcgl((zzcgl)zza2, l), zzcft2);
            }
            this.zzwy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcgl zzcgl2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcft2));
        zzbr.zzcF((String)zzcft2.packageName);
        long l = System.nanoTime();
        this.zzwD().zzjB();
        this.zzkC();
        String string = zzcft2.packageName;
        this.zzwA();
        if (!zzckx.zzd(zzcgl2, zzcft2)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        if (this.zzwB().zzN(string, zzcgl2.name)) {
            this.zzwE().zzyx().zze("Dropping blacklisted event. appId", zzcgx.zzea(string), this.zzwz().zzdX(zzcgl2.name));
            boolean bl = this.zzwA().zzeB(string) || this.zzwA().zzeC(string);
            if (!bl && !"_err".equals(zzcgl2.name)) {
                this.zzwA().zza(string, 11, "_ev", zzcgl2.name, 0);
            }
            if (!bl) return;
            zzcfs zzcfs2 = this.zzwy().zzdR(string);
            if (zzcfs2 == null) return;
            long l2 = Math.max(zzcfs2.zzwT(), zzcfs2.zzwS());
            if (Math.abs(this.zzvz.currentTimeMillis() - l2) <= zzcfy.zzxH()) return;
            this.zzwE().zzyA().log("Fetching config for blacklisted app");
            this.zzb(zzcfs2);
            return;
        }
        if (this.zzwE().zzz(2)) {
            this.zzwE().zzyB().zzj("Logging event", this.zzwz().zzb(zzcgl2));
        }
        this.zzwy().beginTransaction();
        try {
            zzcgh zzcgh2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcgl2.zzbpQ.zzyr();
            this.zzf(zzcft2);
            if ("_iap".equals(zzcgl2.name) || "ecommerce_purchase".equals(zzcgl2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcgl2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzwE().zzyx().zze("Data lost. Currency value is too big. appId", zzcgx.zzea(string), d);
                            this.zzwy().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzckw zzckw2 = this.zzwy().zzG(string, string6);
                    if (zzckw2 == null || !(zzckw2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzbsr.zzb(string2, zzcgn.zzbqD) - 1;
                        string2 = string;
                        zzcfz zzcfz2 = this.zzwy();
                        zzbr.zzcF((String)string2);
                        zzcfz2.zzjB();
                        zzcfz2.zzkC();
                        try {
                            zzcfz2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcfz2.zzwE().zzyv().zze("Error pruning currencies. appId", zzcgx.zzea(string2), (Object)sQLiteException);
                        }
                        zzckw2 = new zzckw(string, zzcgl2.zzbpg, string6, this.zzvz.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzckw2.mValue;
                        zzckw2 = new zzckw(string, zzcgl2.zzbpg, string6, this.zzvz.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzwy().zza(zzckw2)) {
                        this.zzwE().zzyv().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcgx.zzea(string), this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                        this.zzwA().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzckx.zzep(zzcgl2.name);
            boolean bl2 = "_err".equals(zzcgl2.name);
            zzcga zzcga2 = this.zzwy().zza(this.zzyX(), string, true, bl, false, bl2, false);
            long l5 = zzcga2.zzbpz - zzcfy.zzxp();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwE().zzyv().zze("Data loss. Too many events logged. appId, count", zzcgx.zzea(string), zzcga2.zzbpz);
                }
                this.zzwy().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcga2.zzbpy - zzcfy.zzxq()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwE().zzyv().zze("Data loss. Too many public events logged. appId, count", zzcgx.zzea(string), zzcga2.zzbpy);
                }
                this.zzwA().zza(string, 16, "_ev", zzcgl2.name, 0);
                this.zzwy().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzcft2.packageName;
                n = this.zzbsr.zzb(string2, zzcgn.zzbqk);
                l5 = zzcga2.zzbpB - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzwE().zzyv().zze("Too many error events logged. appId, count", zzcgx.zzea(string), zzcga2.zzbpB);
                    }
                    this.zzwy().setTransactionSuccessful();
                    return;
                }
            }
            this.zzwA().zza(bundle, "_o", (Object)zzcgl2.zzbpg);
            if (this.zzwA().zzez(string)) {
                this.zzwA().zza(bundle, "_dbg", 1L);
                this.zzwA().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzwy().zzdS(string)) > 0L) {
                this.zzwE().zzyx().zze("Data lost. Too many events stored on disk, deleted. appId", zzcgx.zzea(string), l3);
            }
            zzcgg zzcgg2 = new zzcgg(this, zzcgl2.zzbpg, string, zzcgl2.name, zzcgl2.zzbpR, 0L, bundle);
            zzcgh zzcgh3 = this.zzwy().zzE(string, zzcgg2.mName);
            if (zzcgh3 == null) {
                long l6 = this.zzwy().zzdV(string);
                zzcfy.zzxo();
                if (l6 >= 500L) {
                    this.zzwE().zzyv().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcgx.zzea(string), this.zzwz().zzdX(zzcgg2.mName), zzcfy.zzxo());
                    this.zzwA().zza(string, 8, null, null, 0);
                    return;
                }
                zzcgh2 = new zzcgh(string, zzcgg2.mName, 0L, 0L, zzcgg2.zzayU);
            } else {
                zzcgg2 = zzcgg2.zza(this, zzcgh3.zzbpM);
                zzcgh2 = zzcgh3.zzab(zzcgg2.zzayU);
            }
            this.zzwy().zza(zzcgh2);
            this.zza(zzcgg2, zzcft2);
            this.zzwy().setTransactionSuccessful();
            if (this.zzwE().zzz(2)) {
                this.zzwE().zzyB().zzj("Event recorded", this.zzwz().zza(zzcgg2));
            }
        }
        finally {
            this.zzwy().endTransaction();
        }
        this.zzza();
        this.zzwE().zzyB().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcfw zzcfw2) {
        zzcft zzcft2 = this.zzem(zzcfw2.packageName);
        if (zzcft2 != null) {
            this.zzb(zzcfw2, zzcft2);
        }
    }

    @WorkerThread
    final void zzb(zzcfw zzcfw2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        zzbr.zzcF((String)zzcfw2.packageName);
        zzbr.zzu((Object)zzcfw2.zzbpg);
        zzbr.zzu((Object)((Object)zzcfw2.zzbph));
        zzbr.zzcF((String)zzcfw2.zzbph.name);
        this.zzwD().zzjB();
        this.zzkC();
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        zzcfw zzcfw3 = new zzcfw(zzcfw2);
        new zzcfw(zzcfw2).zzbpj = false;
        this.zzwy().beginTransaction();
        try {
            boolean bl = false;
            zzcfw zzcfw4 = this.zzwy().zzH(zzcfw3.packageName, zzcfw3.zzbph.name);
            if (zzcfw4 != null && !zzcfw4.zzbpg.equals(zzcfw3.zzbpg)) {
                this.zzwE().zzyx().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzwz().zzdZ(zzcfw3.zzbph.name), zzcfw3.zzbpg, zzcfw4.zzbpg);
            }
            if (zzcfw4 != null && zzcfw4.zzbpj) {
                zzcfw3.zzbpg = zzcfw4.zzbpg;
                zzcfw3.zzbpi = zzcfw4.zzbpi;
                zzcfw3.zzbpm = zzcfw4.zzbpm;
                zzcfw3.zzbpk = zzcfw4.zzbpk;
                zzcfw3.zzbpn = zzcfw4.zzbpn;
                zzcfw3.zzbpj = zzcfw4.zzbpj;
                zzcfw3.zzbph = new zzcku(zzcfw3.zzbph.name, zzcfw4.zzbph.zzbuC, zzcfw3.zzbph.getValue(), zzcfw4.zzbph.zzbpg);
            } else if (TextUtils.isEmpty((CharSequence)zzcfw3.zzbpk)) {
                zzcfw3.zzbph = new zzcku(zzcfw3.zzbph.name, zzcfw3.zzbpi, zzcfw3.zzbph.getValue(), zzcfw3.zzbph.zzbpg);
                zzcfw3.zzbpj = true;
                bl = true;
            }
            if (zzcfw3.zzbpj) {
                zzcku zzcku2 = zzcfw3.zzbph;
                zzckw zzckw2 = new zzckw(zzcfw3.packageName, zzcfw3.zzbpg, zzcku2.name, zzcku2.zzbuC, zzcku2.getValue());
                if (this.zzwy().zza(zzckw2)) {
                    this.zzwE().zzyA().zzd("User property updated immediately", zzcfw3.packageName, this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                } else {
                    this.zzwE().zzyv().zzd("(2)Too many active user properties, ignoring", zzcgx.zzea(zzcfw3.packageName), this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                }
                if (bl && zzcfw3.zzbpn != null) {
                    zzcgl zzcgl2 = new zzcgl(zzcfw3.zzbpn, zzcfw3.zzbpi);
                    this.zzc(zzcgl2, zzcft2);
                }
            }
            if (this.zzwy().zza(zzcfw3)) {
                this.zzwE().zzyA().zzd("Conditional property added", zzcfw3.packageName, this.zzwz().zzdZ(zzcfw3.zzbph.name), zzcfw3.zzbph.getValue());
            } else {
                this.zzwE().zzyv().zzd("Too many conditional properties, ignoring", zzcgx.zzea(zzcfw3.packageName), this.zzwz().zzdZ(zzcfw3.zzbph.name), zzcfw3.zzbph.getValue());
            }
            this.zzwy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcfw zzcfw2) {
        zzcft zzcft2 = this.zzem(zzcfw2.packageName);
        if (zzcft2 != null) {
            this.zzc(zzcfw2, zzcft2);
        }
    }

    @WorkerThread
    final void zzc(zzcfw zzcfw2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        zzbr.zzcF((String)zzcfw2.packageName);
        zzbr.zzu((Object)((Object)zzcfw2.zzbph));
        zzbr.zzcF((String)zzcfw2.zzbph.name);
        this.zzwD().zzjB();
        this.zzkC();
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        this.zzwy().beginTransaction();
        try {
            this.zzf(zzcft2);
            zzcfw zzcfw3 = this.zzwy().zzH(zzcfw2.packageName, zzcfw2.zzbph.name);
            if (zzcfw3 != null) {
                this.zzwE().zzyA().zze("Removing conditional user property", zzcfw2.packageName, this.zzwz().zzdZ(zzcfw2.zzbph.name));
                this.zzwy().zzI(zzcfw2.packageName, zzcfw2.zzbph.name);
                if (zzcfw3.zzbpj) {
                    this.zzwy().zzF(zzcfw2.packageName, zzcfw2.zzbph.name);
                }
                if (zzcfw2.zzbpp != null) {
                    Bundle bundle = null;
                    if (zzcfw2.zzbpp.zzbpQ != null) {
                        bundle = zzcfw2.zzbpp.zzbpQ.zzyr();
                    }
                    zzcgl zzcgl2 = this.zzwA().zza(zzcfw2.zzbpp.name, bundle, zzcfw3.zzbpg, zzcfw2.zzbpp.zzbpR, true, false);
                    this.zzc(zzcgl2, zzcft2);
                }
            } else {
                this.zzwE().zzyx().zze("Conditional user property doesn't exist", zzcgx.zzea(zzcfw2.packageName), this.zzwz().zzdZ(zzcfw2.zzbph.name));
            }
            this.zzwy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcgl zzcgl2, @Size(min=1L) String string) {
        Object object;
        this.zzkC();
        this.zzwD().zzjB();
        zzchx.zzwn();
        zzbr.zzu((Object)((Object)zzcgl2));
        zzbr.zzcF((String)string);
        zzclk zzclk2 = new zzclk();
        this.zzwy().beginTransaction();
        try {
            zzcgh zzcgh2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcfs zzcfs2 = this.zzwy().zzdR(string);
            if (zzcfs2 == null) {
                this.zzwE().zzyA().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcfs2.zzwQ()) {
                this.zzwE().zzyA().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcll();
            zzclk2.zzbvF = new zzcll[]{object};
            object.zzbvH = 1;
            object.zzbvP = "android";
            object.zzaK = zzcfs2.zzhk();
            object.zzboV = zzcfs2.zzwN();
            object.zzbha = zzcfs2.zzjG();
            long l2 = zzcfs2.zzwM();
            object.zzbwc = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzbvT = zzcfs2.zzwO();
            object.zzboU = zzcfs2.getGmpAppId();
            object.zzbvY = zzcfs2.zzwP();
            if (this.isEnabled() && zzcfy.zzya() && this.zzbsr.zzdP(object.zzaK)) {
                this.zzwt();
                object.zzbwh = null;
            }
            if ((pair = this.zzwF().zzec(zzcfs2.zzhk())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzbvV = (String)pair.first;
                object.zzbvW = (Boolean)pair.second;
            }
            this.zzwu().zzkC();
            object.zzbvQ = Build.MODEL;
            this.zzwu().zzkC();
            object.zzbb = Build.VERSION.RELEASE;
            object.zzbvS = (int)this.zzwu().zzyo();
            object.zzbvR = this.zzwu().zzyp();
            object.zzbvX = zzcfs2.getAppInstanceId();
            object.zzbpc = zzcfs2.zzwJ();
            List<zzckw> list = this.zzwy().zzdQ(zzcfs2.zzhk());
            object.zzbvJ = new zzcln[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcln();
                object.zzbvJ[i] = object2;
                ((zzcln)((Object)object2)).name = list.get((int)i).mName;
                ((zzcln)((Object)object2)).zzbwl = list.get((int)i).zzbuG;
                this.zzwA().zza((zzcln)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcgl2.zzbpQ.zzyr();
            if ("_iap".equals(zzcgl2.name)) {
                bundle.putLong("_c", 1L);
                this.zzwE().zzyA().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcgl2.zzbpg);
            if (this.zzwA().zzez(object.zzaK)) {
                this.zzwA().zza(bundle, "_dbg", 1L);
                this.zzwA().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzwy().zzE(string, zzcgl2.name)) == null) {
                l = 0L;
                zzcgh2 = new zzcgh(string, zzcgl2.name, 1L, 0L, zzcgl2.zzbpR);
                this.zzwy().zza(zzcgh2);
            } else {
                l = ((zzcgh)object2).zzbpM;
                zzcgh2 = ((zzcgh)object2).zzab(zzcgl2.zzbpR).zzyq();
                this.zzwy().zza(zzcgh2);
            }
            zzcgg zzcgg2 = new zzcgg(this, zzcgl2.zzbpg, string, zzcgl2.name, zzcgl2.zzbpR, l, bundle);
            zzcli zzcli2 = new zzcli();
            object.zzbvI = new zzcli[]{zzcli2};
            zzcli2.zzbvB = zzcgg2.zzayU;
            zzcli2.name = zzcgg2.mName;
            zzcli2.zzbvC = zzcgg2.zzbpI;
            zzcli2.zzbvA = new zzclj[zzcgg2.zzbpJ.size()];
            int n = 0;
            for (String string2 : zzcgg2.zzbpJ) {
                zzclj zzclj2 = new zzclj();
                zzcli2.zzbvA[n++] = zzclj2;
                zzclj2.name = string2;
                Object object3 = zzcgg2.zzbpJ.get(string2);
                this.zzwA().zza(zzclj2, object3);
            }
            object.zzbwb = this.zza(zzcfs2.zzhk(), object.zzbvJ, object.zzbvI);
            object.zzbvL = zzcli2.zzbvB;
            object.zzbvM = zzcli2.zzbvB;
            long l3 = zzcfs2.zzwL();
            object.zzbvO = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcfs2.zzwK();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzbvN = l4 != 0L ? Long.valueOf(l4) : null;
            zzcfs2.zzwU();
            object.zzbvZ = (int)zzcfs2.zzwR();
            object.zzbvU = zzcfy.zzwO();
            object.zzbvK = this.zzvz.currentTimeMillis();
            object.zzbwa = Boolean.TRUE;
            zzcfs2.zzL(object.zzbvL);
            zzcfs2.zzM(object.zzbvM);
            this.zzwy().zza(zzcfs2);
            this.zzwy().setTransactionSuccessful();
        }
        finally {
            this.zzwy().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzclk2.zzMl()];
            object = byArray;
            byte[] byArray2 = byArray;
            ahx ahx2 = ahx.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzclk2.zza(ahx2);
            ahx2.zzMc();
            return this.zzwA().zzm((byte[])object);
        }
        catch (IOException iOException) {
            this.zzwE().zzyv().zze("Data loss. Failed to bundle and serialize. appId", zzcgx.zzea(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcgg var1_1, zzcft var2_2) {
        block10: {
            this.zzwD().zzjB();
            this.zzkC();
            zzbr.zzu((Object)var1_1);
            zzbr.zzu((Object)var2_2);
            zzbr.zzcF((String)var1_1.mAppId);
            zzbr.zzaf((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcll();
            new zzcll().zzbvH = 1;
            var3_3.zzbvP = "android";
            var3_3.zzaK = var2_2.packageName;
            var3_3.zzboV = var2_2.zzboV;
            var3_3.zzbha = var2_2.zzbha;
            var3_3.zzbwc = var2_2.zzbpb == -2147483648L ? null : Integer.valueOf((int)var2_2.zzbpb);
            var3_3.zzbvT = var2_2.zzboW;
            var3_3.zzboU = var2_2.zzboU;
            var3_3.zzbvY = var2_2.zzboX == 0L ? null : Long.valueOf(var2_2.zzboX);
            var4_4 = this.zzwF().zzec(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzbvV = (String)var4_4.first;
                var3_3.zzbvW = (Boolean)var4_4.second;
            }
            this.zzwu().zzkC();
            var3_3.zzbvQ = Build.MODEL;
            this.zzwu().zzkC();
            var3_3.zzbb = Build.VERSION.RELEASE;
            var3_3.zzbvS = (int)this.zzwu().zzyo();
            var3_3.zzbvR = this.zzwu().zzyp();
            var3_3.zzbvU = null;
            var3_3.zzbvK = null;
            var3_3.zzbvL = null;
            var3_3.zzbvM = null;
            var3_3.zzbwg = var2_2.zzbpd;
            if (this.isEnabled() && zzcfy.zzya()) {
                this.zzwt();
                var3_3.zzbwh = null;
            }
            if ((var5_5 = this.zzwy().zzdR(var2_2.packageName)) == null) {
                var5_5 = new zzcfs(this, var2_2.packageName);
                var5_5.zzdH(this.zzwt().zzys());
                var5_5.zzdK(var2_2.zzbpc);
                var5_5.zzdI(var2_2.zzboU);
                var5_5.zzdJ(this.zzwF().zzed(var2_2.packageName));
                var5_5.zzQ(0L);
                var5_5.zzL(0L);
                var5_5.zzM(0L);
                var5_5.setAppVersion(var2_2.zzbha);
                var5_5.zzN(var2_2.zzbpb);
                var5_5.zzdL(var2_2.zzboV);
                var5_5.zzO(var2_2.zzboW);
                var5_5.zzP(var2_2.zzboX);
                var5_5.setMeasurementEnabled(var2_2.zzboZ);
                var5_5.zzZ(var2_2.zzbpd);
                this.zzwy().zza(var5_5);
            }
            var3_3.zzbvX = var5_5.getAppInstanceId();
            var3_3.zzbpc = var5_5.zzwJ();
            var6_6 = this.zzwy().zzdQ(var2_2.packageName);
            var3_3.zzbvJ = new zzcln[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzbvJ[var7_7] = var8_9 = new zzcln();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzbwl = var6_6.get((int)var7_7).zzbuG;
                this.zzwA().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzwy().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzwE().zzyv().zze("Data loss. Failed to insert raw event metadata. appId", zzcgx.zzea(var3_3.zzaK), var9_10);
                return;
            }
            v0 = this.zzwy();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzbpJ == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzbpJ) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block10;
            }
            var12_14 = var10_12.zzwB().zzO(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzwy().zza(var10_12.zzyX(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzbpC < (long)var10_12.zzbsr.zzdN(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzbsX = 0L;
        }
    }

    public final String zzen(String string) {
        Future<String> future = this.zzwD().zze(new zzchz(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzwE().zzyv().zze("Failed to get app instance id. appId", zzcgx.zzea(string), exception);
            return null;
        }
    }

    static void zzwn() {
        zzcfy.zzxD();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcku zzcku2, zzcft zzcft2) {
        this.zzwD().zzjB();
        this.zzkC();
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        int n = this.zzwA().zzet(zzcku2.name);
        if (n != 0) {
            this.zzwA();
            String string = zzckx.zza(zzcku2.name, zzcfy.zzxh(), true);
            int n2 = zzcku2.name != null ? zzcku2.name.length() : 0;
            this.zzwA().zza(zzcft2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzwA().zzl(zzcku2.name, zzcku2.getValue());
        if (n != 0) {
            this.zzwA();
            String string = zzckx.zza(zzcku2.name, zzcfy.zzxh(), true);
            Object object = zzcku2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzwA().zza(zzcft2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzwA().zzm(zzcku2.name, zzcku2.getValue());
        if (object == null) {
            return;
        }
        zzckw zzckw2 = new zzckw(zzcft2.packageName, zzcku2.zzbpg, zzcku2.name, zzcku2.zzbuC, object);
        this.zzwE().zzyA().zze("Setting user property", this.zzwz().zzdZ(zzckw2.mName), object);
        this.zzwy().beginTransaction();
        try {
            this.zzf(zzcft2);
            boolean bl = this.zzwy().zza(zzckw2);
            this.zzwy().setTransactionSuccessful();
            if (bl) {
                this.zzwE().zzyA().zze("User property set", this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
            } else {
                this.zzwE().zzyv().zze("Too many unique user properties are set. Ignoring user property", this.zzwz().zzdZ(zzckw2.mName), zzckw2.mValue);
                this.zzwA().zza(zzcft2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcku zzcku2, zzcft zzcft2) {
        this.zzwD().zzjB();
        this.zzkC();
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            return;
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        this.zzwE().zzyA().zzj("Removing user property", this.zzwz().zzdZ(zzcku2.name));
        this.zzwy().beginTransaction();
        try {
            this.zzf(zzcft2);
            this.zzwy().zzF(zzcft2.packageName, zzcku2.name);
            this.zzwy().setTransactionSuccessful();
            this.zzwE().zzyA().zzj("User property removed", this.zzwz().zzdZ(zzcku2.name));
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    @WorkerThread
    public final void zzyY() {
        this.zzwD().zzjB();
        this.zzkC();
        this.zzbta = true;
        try {
            String string;
            zzcfy.zzxD();
            Boolean bl = this.zzwF().zzyG();
            if (bl == null) {
                this.zzwE().zzyx().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzwE().zzyv().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzbsX > 0L) {
                this.zzza();
                return;
            }
            Object object = this;
            ((zzchx)object).zzwD().zzjB();
            if (((zzchx)object).zzbsS != null) {
                this.zzwE().zzyB().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzyS().zzlP()) {
                this.zzwE().zzyB().log("Network not connected, ignoring upload request");
                this.zzza();
                return;
            }
            long l = this.zzvz.currentTimeMillis();
            long l2 = l - zzcfy.zzxO();
            this.zzg(null, l2);
            long l3 = this.zzwF().zzbro.get();
            if (l3 != 0L) {
                this.zzwE().zzyA().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzwy().zzyb()))) {
                if (this.zzbsW == -1L) {
                    this.zzbsW = this.zzwy().zzyi();
                }
                Object object2 = string;
                int n = this.zzbsr.zzb((String)object2, zzcgn.zzbqf);
                object2 = string;
                object = this.zzbsr;
                int n2 = Math.max(0, ((zzcfy)object).zzb((String)object2, zzcgn.zzbqg));
                List<Pair<zzcll, Long>> list = this.zzwy().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcll zzcll2 = (zzcll)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcll2.zzbvV)) continue;
                        string2 = zzcll2.zzbvV;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcll)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcll)((Object)object3)).zzbvV) || ((zzcll)((Object)object3)).zzbvV.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzclk();
                    new zzclk().zzbvF = new zzcll[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcfy.zzya() && this.zzbsr.zzdP(string);
                    for (int i = 0; i < ((zzclk)((Object)object4)).zzbvF.length; ++i) {
                        ((zzclk)((Object)object4)).zzbvF[i] = (zzcll)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzclk)((Object)object4)).zzbvF[i].zzbvU = zzcfy.zzwO();
                        ((zzclk)((Object)object4)).zzbvF[i].zzbvK = l;
                        ((zzclk)((Object)object4)).zzbvF[i].zzbwa = zzcfy.zzxD();
                        if (bl2) continue;
                        ((zzclk)((Object)object4)).zzbvF[i].zzbwh = null;
                    }
                    String string3 = null;
                    if (this.zzwE().zzz(2)) {
                        string3 = this.zzwz().zza((zzclk)((Object)object4));
                    }
                    byte[] byArray = this.zzwA().zzb((zzclk)((Object)object4));
                    String string4 = zzcfy.zzxN();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbr.zzaf((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzchx)object).zzbsS != null) {
                            ((zzchx)object).zzwE().zzyv().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzchx)object).zzbsS = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzwF().zzbrp.set(l);
                        String string5 = "?";
                        if (((zzclk)((Object)object4)).zzbvF.length > 0) {
                            string5 = ((zzclk)((Object)object4)).zzbvF[0].zzaK;
                        }
                        this.zzwE().zzyB().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzbsZ = true;
                        this.zzyS().zza(string, uRL, byArray, null, new zzcia(this));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzwE().zzyv().zze("Failed to parse upload URL. Not uploading. appId", zzcgx.zzea(string), string4);
                    }
                }
            } else {
                zzcfs zzcfs2;
                this.zzbsW = -1L;
                String string6 = this.zzwy().zzaa(l - zzcfy.zzxO());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcfs2 = this.zzwy().zzdR(string6)) != null) {
                    this.zzb(zzcfs2);
                }
            }
            return;
        }
        finally {
            this.zzbta = false;
            this.zzze();
        }
    }

    @WorkerThread
    private final void zzb(zzcfs zzcfs2) {
        this.zzwD().zzjB();
        if (TextUtils.isEmpty((CharSequence)zzcfs2.getGmpAppId())) {
            this.zzb(zzcfs2.zzhk(), 204, null, null, null);
            return;
        }
        String string = zzcfs2.getAppInstanceId();
        String string2 = zzcfs2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string2);
        builder.scheme(zzcgn.zzbqd.get()).encodedAuthority(zzcgn.zzbqe.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11010");
        String string4 = builder.build().toString();
        try {
            URL uRL = new URL(string4);
            this.zzwE().zzyB().zzj("Fetching remote configuration", zzcfs2.zzhk());
            zzclf zzclf2 = this.zzwB().zzei(zzcfs2.zzhk());
            ArrayMap arrayMap = null;
            String string5 = this.zzwB().zzej(zzcfs2.zzhk());
            if (zzclf2 != null && !TextUtils.isEmpty((CharSequence)string5)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string5);
            }
            this.zzbsY = true;
            this.zzyS().zza(zzcfs2.zzhk(), uRL, (Map<String, String>)arrayMap, new zzcib(this));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzwE().zzyv().zze("Failed to parse config URL. Not fetching. appId", zzcgx.zzea(zzcfs2.zzhk()), string4);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzwy().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzbsW;
                    long l3 = l;
                    string2 = null;
                    object = this.zzwy();
                    zzbr.zzu((Object)zza3);
                    ((zzciu)object).zzjB();
                    ((zzciv)object).zzkC();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcfz)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzciu)object).zzwE().zzyv().zzj("Raw event metadata record is missing. appId", zzcgx.zzea(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = ahw.zzb((byte[])byArray, (int)0, (int)byArray.length);
                        zzcll zzcll2 = new zzcll();
                        try {
                            zzcll2.zza((ahw)string5);
                        }
                        catch (IOException iOException) {
                            ((zzciu)object).zzwE().zzyv().zze("Data loss. Failed to merge raw event metadata. appId", zzcgx.zzea(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzciu)object).zzwE().zzyx().zzj("Get multiple raw event metadata records, expected one. appId", zzcgx.zzea(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcll2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzciu)object).zzwE().zzyx().zzj("Raw event data disappeared while in transaction. appId", zzcgx.zzea(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = ahw.zzb((byte[])byArray, (int)0, (int)byArray.length);
                            zzcli zzcli2 = new zzcli();
                            try {
                                zzcli2.zza((ahw)string5);
                            }
                            catch (IOException iOException) {
                                ((zzciu)object).zzwE().zzyv().zze("Data loss. Failed to merge raw event. appId", zzcgx.zzea(string2), iOException);
                                continue;
                            }
                            zzcli2.name = cursor.getString(1);
                            zzcli2.zzbvB = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcli2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zztK == null || ((zza)object).zztK.isEmpty()) break block69;
                boolean bl = false;
                zzcll zzcll3 = zza2.zzbtd;
                zza2.zzbtd.zzbvI = new zzcli[zza2.zztK.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zztK.size(); ++n) {
                    block71: {
                        zzclj[] zzcljArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzwB().zzN(zza2.zzbtd.zzaK, zza2.zztK.get((int)n).name)) {
                                this.zzwE().zzyx().zze("Dropping blacklisted raw event. appId", zzcgx.zzea(zza2.zzbtd.zzaK), this.zzwz().zzdX(zza2.zztK.get((int)n).name));
                                if (this.zzwA().zzeB(zza2.zzbtd.zzaK) || this.zzwA().zzeC(zza2.zzbtd.zzaK) || "_err".equals(zza2.zztK.get((int)n).name)) continue;
                                this.zzwA().zza(zza2.zzbtd.zzaK, 11, "_ev", zza2.zztK.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzwB().zzO(zza2.zzbtd.zzaK, zza2.zztK.get((int)n).name);
                            if (bl2) break block70;
                            this.zzwA();
                            if (!zzckx.zzeD(zza2.zztK.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zztK.get((int)n).zzbvA == null) {
                            zza2.zztK.get((int)n).zzbvA = new zzclj[0];
                        }
                        zzclj[] zzcljArray2 = zza2.zztK.get((int)n).zzbvA;
                        int n4 = zza2.zztK.get((int)n).zzbvA.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcljArray = zzcljArray2[n3];
                            if ("_c".equals(zzcljArray.name)) {
                                zzcljArray.zzbvE = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcljArray.name)) continue;
                            zzcljArray.zzbvE = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzwE().zzyB().zzj("Marking event as conversion", this.zzwz().zzdX(zza2.zztK.get((int)n).name));
                            zzcljArray2 = Arrays.copyOf(zza2.zztK.get((int)n).zzbvA, zza2.zztK.get((int)n).zzbvA.length + 1);
                            zzclj zzclj2 = new zzclj();
                            new zzclj().name = "_c";
                            zzclj2.zzbvE = 1L;
                            zzcljArray2[zzcljArray2.length - 1] = zzclj2;
                            zza2.zztK.get((int)n).zzbvA = zzcljArray2;
                        }
                        if (!bl5) {
                            this.zzwE().zzyB().zzj("Marking event as real-time", this.zzwz().zzdX(zza2.zztK.get((int)n).name));
                            zzcljArray2 = Arrays.copyOf(zza2.zztK.get((int)n).zzbvA, zza2.zztK.get((int)n).zzbvA.length + 1);
                            zzclj zzclj3 = new zzclj();
                            new zzclj().name = "_r";
                            zzclj3.zzbvE = 1L;
                            zzcljArray2[zzcljArray2.length - 1] = zzclj3;
                            zza2.zztK.get((int)n).zzbvA = zzcljArray2;
                        }
                        bl = true;
                        if (this.zzwy().zza((long)this.zzyX(), (String)zza2.zzbtd.zzaK, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzbpC > (long)this.zzbsr.zzdN(zza2.zzbtd.zzaK)) {
                            zzcli zzcli3 = zza2.zztK.get(n);
                            for (n3 = 0; n3 < zzcli3.zzbvA.length; ++n3) {
                                if (!"_r".equals(zzcli3.zzbvA[n3].name)) continue;
                                zzcljArray = new zzclj[zzcli3.zzbvA.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcli3.zzbvA, 0, zzcljArray, 0, n3);
                                }
                                if (n3 < zzcljArray.length) {
                                    System.arraycopy(zzcli3.zzbvA, n3 + 1, zzcljArray, n3, zzcljArray.length - n3);
                                }
                                zzcli3.zzbvA = zzcljArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzckx.zzep(zza2.zztK.get((int)n).name) && bl2 && this.zzwy().zza((long)this.zzyX(), (String)zza2.zzbtd.zzaK, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzbpA > (long)this.zzbsr.zzb(string2 = zza2.zzbtd.zzaK, zzcgn.zzbqm)) {
                            this.zzwE().zzyx().zzj("Too many conversions. Not logging as conversion. appId", zzcgx.zzea(zza2.zzbtd.zzaK));
                            zzcli zzcli4 = zza2.zztK.get(n);
                            boolean bl6 = false;
                            zzclj zzclj4 = null;
                            zzclj[] zzcljArray3 = zzcli4.zzbvA;
                            int n5 = zzcli4.zzbvA.length;
                            for (int i = 0; i < n5; ++i) {
                                zzclj zzclj5 = zzcljArray3[i];
                                if ("_c".equals(zzclj5.name)) {
                                    zzclj4 = zzclj5;
                                    continue;
                                }
                                if (!"_err".equals(zzclj5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzclj4 != null) {
                                zzcljArray3 = new zzclj[zzcli4.zzbvA.length - 1];
                                n5 = 0;
                                zzclj[] zzcljArray4 = zzcli4.zzbvA;
                                int n6 = zzcli4.zzbvA.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzclj zzclj6 = zzcljArray4[i];
                                    if (zzclj6 == zzclj4) continue;
                                    zzcljArray3[n5++] = zzclj6;
                                }
                                zzcli4.zzbvA = zzcljArray3;
                            } else if (zzclj4 != null) {
                                zzclj4.name = "_err";
                                zzclj4.zzbvE = 10L;
                            } else {
                                this.zzwE().zzyv().zzj("Did not find conversion parameter. appId", zzcgx.zzea(zza2.zzbtd.zzaK));
                            }
                        }
                    }
                    zzcll3.zzbvI[n2++] = zza2.zztK.get(n);
                }
                if (n2 < zza2.zztK.size()) {
                    zzcll3.zzbvI = Arrays.copyOf(zzcll3.zzbvI, n2);
                }
                zzcll3.zzbwb = this.zza(zza2.zzbtd.zzaK, zza2.zzbtd.zzbvJ, zzcll3.zzbvI);
                zzcll3.zzbvL = Long.MAX_VALUE;
                zzcll3.zzbvM = Long.MIN_VALUE;
                for (n = 0; n < zzcll3.zzbvI.length; ++n) {
                    zzcli zzcli5 = zzcll3.zzbvI[n];
                    if (zzcli5.zzbvB < zzcll3.zzbvL) {
                        zzcll3.zzbvL = zzcli5.zzbvB;
                    }
                    if (zzcli5.zzbvB <= zzcll3.zzbvM) continue;
                    zzcll3.zzbvM = zzcli5.zzbvB;
                }
                String string6 = zza2.zzbtd.zzaK;
                zzcfs zzcfs2 = this.zzwy().zzdR(string6);
                if (zzcfs2 == null) {
                    this.zzwE().zzyv().zzj("Bundling raw events w/o app info. appId", zzcgx.zzea(zza2.zzbtd.zzaK));
                } else if (zzcll3.zzbvI.length > 0) {
                    long l5 = zzcfs2.zzwL();
                    zzcll3.zzbvO = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcfs2.zzwK();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcll3.zzbvN = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcfs2.zzwU();
                    zzcll3.zzbvZ = (int)zzcfs2.zzwR();
                    zzcfs2.zzL(zzcll3.zzbvL);
                    zzcfs2.zzM(zzcll3.zzbvM);
                    zzcll3.zzboY = zzcfs2.zzxc();
                    this.zzwy().zza(zzcfs2);
                }
                if (zzcll3.zzbvI.length > 0) {
                    zzcfy.zzxD();
                    zzclf zzclf2 = this.zzwB().zzei(zza2.zzbtd.zzaK);
                    if (zzclf2 == null || zzclf2.zzbvp == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzbtd.zzboU)) {
                            zzcll3.zzbwf = -1L;
                        } else {
                            this.zzwE().zzyx().zzj("Did not find measurement config or missing version info. appId", zzcgx.zzea(zza2.zzbtd.zzaK));
                        }
                    } else {
                        zzcll3.zzbwf = zzclf2.zzbvp;
                    }
                    this.zzwy().zza(zzcll3, bl);
                }
                this.zzwy().zzG(zza2.zzbte);
                string2 = string6;
                object = this.zzwy();
                SQLiteDatabase sQLiteDatabase = ((zzcfz)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzciu)object).zzwE().zzyv().zze("Failed to remove unused event metadata. appId", zzcgx.zzea(string2), (Object)sQLiteException);
                }
                this.zzwy().setTransactionSuccessful();
                boolean bl7 = zzcll3.zzbvI.length > 0;
                return bl7;
            }
            this.zzwy().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    private final zzclh[] zza(String string, zzcln[] zzclnArray, zzcli[] zzcliArray) {
        zzbr.zzcF((String)string);
        return this.zzwr().zza(string, zzcliArray, zzclnArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzwD().zzjB();
        this.zzkC();
        zzbr.zzcF((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzwE().zzyB().zzj("onConfigFetched. Response size", byArray.length);
            this.zzwy().beginTransaction();
            try {
                boolean bl;
                zzcfs zzcfs2 = this.zzwy().zzdR(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcfs2 == null) {
                    this.zzwE().zzyx().zzj("App does not exist in onConfigFetched. appId", zzcgx.zzea(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzwB().zzei(string) == null && !this.zzwB().zzb(string, null, null) : !this.zzwB().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcfs2.zzR(this.zzvz.currentTimeMillis());
                    this.zzwy().zza(zzcfs2);
                    if (n == 404) {
                        this.zzwE().zzyy().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzwE().zzyB().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzyS().zzlP() && this.zzyZ()) {
                        this.zzyY();
                    } else {
                        this.zzza();
                    }
                } else {
                    zzcfs2.zzS(this.zzvz.currentTimeMillis());
                    this.zzwy().zza(zzcfs2);
                    this.zzwE().zzyB().zze("Fetching config failed. code, error", n, throwable);
                    this.zzwB().zzek(string);
                    this.zzwF().zzbrp.set(this.zzvz.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzwF().zzbrq.set(this.zzvz.currentTimeMillis());
                    }
                    this.zzza();
                }
                this.zzwy().setTransactionSuccessful();
            }
            finally {
                this.zzwy().endTransaction();
            }
            return;
        }
        finally {
            this.zzbsY = false;
            this.zzze();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzwD().zzjB();
        this.zzkC();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzbsS;
            this.zzbsS = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzwF().zzbro.set(this.zzvz.currentTimeMillis());
                    this.zzwF().zzbrp.set(0L);
                    this.zzza();
                    this.zzwE().zzyB().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzwy().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcfz zzcfz2 = this.zzwy();
                            zzcfz2.zzjB();
                            zzcfz2.zzkC();
                            SQLiteDatabase sQLiteDatabase = zzcfz2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcfz2.zzwE().zzyv().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzwy().setTransactionSuccessful();
                    }
                    finally {
                        this.zzwy().endTransaction();
                    }
                    if (this.zzyS().zzlP() && this.zzyZ()) {
                        this.zzyY();
                    } else {
                        this.zzbsW = -1L;
                        this.zzza();
                    }
                    this.zzbsX = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzwE().zzyv().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzbsX = this.zzvz.elapsedRealtime();
                    this.zzwE().zzyB().zzj("Disable upload, time", this.zzbsX);
                }
            } else {
                this.zzwE().zzyB().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzwF().zzbrp.set(this.zzvz.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzwF().zzbrq.set(this.zzvz.currentTimeMillis());
                }
                this.zzza();
            }
            return;
        }
        finally {
            this.zzbsZ = false;
            this.zzze();
        }
    }

    private final boolean zzyZ() {
        this.zzwD().zzjB();
        this.zzkC();
        return this.zzwy().zzyg() || !TextUtils.isEmpty((CharSequence)this.zzwy().zzyb());
    }

    @WorkerThread
    private final void zzza() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzwD().zzjB();
            this.zzkC();
            if (!this.zzzd()) {
                return;
            }
            if (this.zzbsX > 0L) {
                l3 = this.zzvz.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzbsX);
                if (l2 > 0L) {
                    this.zzwE().zzyB().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzyT().unregister();
                    this.zzyU().cancel();
                    return;
                }
                this.zzbsX = 0L;
            }
            if (!this.zzyN() || !this.zzyZ()) {
                this.zzwE().zzyB().log("Nothing to upload or uploading impossible");
                this.zzyT().unregister();
                this.zzyU().cancel();
                return;
            }
            zzchx zzchx2 = this;
            long l4 = zzchx2.zzvz.currentTimeMillis();
            long l5 = zzcfy.zzxW();
            boolean bl = zzchx2.zzwy().zzyh() || zzchx2.zzwy().zzyc();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzchx2.zzbsr.zzxZ())) && !".none.".equals(string) ? zzcfy.zzxS() : zzcfy.zzxR()) : zzcfy.zzxQ();
            long l7 = zzchx2.zzwF().zzbro.get();
            long l8 = zzchx2.zzwF().zzbrp.get();
            long l9 = zzchx2.zzwy().zzye();
            long l10 = zzchx2.zzwy().zzyf();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzchx2.zzwA().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcfy.zzxY(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcfy.zzxX() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzwE().zzyB().log("Next upload time is 0");
            this.zzyT().unregister();
            this.zzyU().cancel();
            return;
        }
        if (!this.zzyS().zzlP()) {
            this.zzwE().zzyB().log("No network");
            this.zzyT().zzlM();
            this.zzyU().cancel();
            return;
        }
        l2 = this.zzwF().zzbrq.get();
        long l16 = zzcfy.zzxP();
        if (!this.zzwA().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzyT().unregister();
        long l17 = l3 - this.zzvz.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcfy.zzxT();
            this.zzwF().zzbro.set(this.zzvz.currentTimeMillis());
        }
        this.zzwE().zzyB().zzj("Upload scheduled in approximately ms", l17);
        this.zzyU().zzs(l17);
    }

    public final void zzam(boolean bl) {
        this.zzza();
    }

    final void zzb(zzciv zzciv2) {
        ++this.zzbsU;
    }

    final void zzzb() {
        ++this.zzbsV;
    }

    @WorkerThread
    public final void zze(zzcft zzcft2) {
        int n;
        this.zzwD().zzjB();
        this.zzkC();
        zzbr.zzu((Object)((Object)zzcft2));
        zzbr.zzcF((String)zzcft2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            return;
        }
        zzcfs zzcfs2 = this.zzwy().zzdR(zzcft2.packageName);
        if (zzcfs2 != null && TextUtils.isEmpty((CharSequence)zzcfs2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            zzcfs2.zzR(0L);
            this.zzwy().zza(zzcfs2);
            this.zzwB().zzel(zzcft2.packageName);
        }
        if (!zzcft2.zzboZ) {
            this.zzf(zzcft2);
            return;
        }
        long l = zzcft2.zzbpe;
        if (l == 0L) {
            l = this.zzvz.currentTimeMillis();
        }
        if ((n = zzcft2.zzbpf) != 0 && n != 1) {
            this.zzwE().zzyx().zze("Incorrect app type, assuming installed app. appId, appType", zzcgx.zzea(zzcft2.packageName), n);
            n = 0;
        }
        this.zzwy().beginTransaction();
        try {
            zzcgl zzcgl2;
            Object object;
            long l2 = l;
            zzcft zzcft3 = zzcft2;
            zzchx zzchx2 = this;
            zzcfs zzcfs3 = zzchx2.zzwy().zzdR(zzcft3.packageName);
            if (zzcfs3 != null && zzcfs3.getGmpAppId() != null && !zzcfs3.getGmpAppId().equals(zzcft3.zzboU)) {
                zzchx2.zzwE().zzyx().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcgx.zzea(zzcfs3.zzhk()));
                String string = zzcfs3.zzhk();
                zzcfz zzcfz2 = zzchx2.zzwy();
                zzcfz2.zzkC();
                zzcfz2.zzjB();
                zzbr.zzcF((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcfz2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcfz2.zzwE().zzyB().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcfz2.zzwE().zzyv().zze("Error deleting application data. appId, error", zzcgx.zzea(string), (Object)sQLiteException);
                }
                zzcfs3 = null;
            }
            if (zzcfs3 != null && zzcfs3.zzjG() != null && !zzcfs3.zzjG().equals(zzcft3.zzbha)) {
                object = new Bundle();
                object.putString("_pv", zzcfs3.zzjG());
                zzcgl2 = new zzcgl("_au", new zzcgi((Bundle)object), "auto", l2);
                zzchx2.zzb(zzcgl2, zzcft3);
            }
            this.zzf(zzcft2);
            zzcgh zzcgh2 = null;
            if (n == 0) {
                zzcgh2 = this.zzwy().zzE(zzcft2.packageName, "_f");
            } else if (n == 1) {
                zzcgh2 = this.zzwy().zzE(zzcft2.packageName, "_v");
            }
            if (zzcgh2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    com.google.android.gms.common.internal.safeparcel.zza zza2;
                    zzcku zzcku2 = new zzcku("_fot", l, l3, "auto");
                    this.zzb(zzcku2, zzcft2);
                    l2 = l;
                    zzcft3 = zzcft2;
                    zzchx2 = this;
                    zzchx2.zzwD().zzjB();
                    zzchx2.zzkC();
                    zzcfs3 = new Bundle();
                    zzcfs3.putLong("_c", 1L);
                    zzcfs3.putLong("_r", 1L);
                    zzcfs3.putLong("_uwa", 0L);
                    zzcfs3.putLong("_pfo", 0L);
                    zzcfs3.putLong("_sys", 0L);
                    zzcfs3.putLong("_sysu", 0L);
                    if (zzchx2.mContext.getPackageManager() == null) {
                        zzchx2.zzwE().zzyv().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcgx.zzea(zzcft3.packageName));
                    } else {
                        zzcgl2 = null;
                        try {
                            zzcgl2 = zzbim.zzaP((Context)zzchx2.mContext).getPackageInfo(zzcft3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchx2.zzwE().zzyv().zze("Package info is null, first open report might be inaccurate. appId", zzcgx.zzea(zzcft3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcgl2 != null && ((PackageInfo)zzcgl2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcgl2).firstInstallTime != ((PackageInfo)zzcgl2).lastUpdateTime) {
                                zzcfs3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zza2 = new zzcku("_fi", l2, bl ? 1L : 0L, "auto");
                            zzchx2.zzb((zzcku)zza2, zzcft3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbim.zzaP((Context)zzchx2.mContext).getApplicationInfo(zzcft3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchx2.zzwE().zzyv().zze("Application info is null, first open report might be inaccurate. appId", zzcgx.zzea(zzcft3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcfs3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcfs3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcft3.packageName;
                    zzcfz zzcfz3 = zzchx2.zzwy();
                    zzbr.zzcF((String)string);
                    zzcfz3.zzjB();
                    zzcfz3.zzkC();
                    long l4 = zzcfz3.zzL(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcfs3.putLong("_pfo", l4);
                    }
                    zza2 = new zzcgl("_f", new zzcgi((Bundle)zzcfs3), "auto", l2);
                    zzchx2.zzb((zzcgl)zza2, zzcft3);
                } else if (n == 1) {
                    zzcku zzcku3 = new zzcku("_fvt", l, l3, "auto");
                    this.zzb(zzcku3, zzcft2);
                    l2 = l;
                    zzcft3 = zzcft2;
                    zzchx2 = this;
                    zzchx2.zzwD().zzjB();
                    zzchx2.zzkC();
                    zzcfs3 = new Bundle();
                    zzcfs3.putLong("_c", 1L);
                    zzcfs3.putLong("_r", 1L);
                    object = new zzcgl("_v", new zzcgi((Bundle)zzcfs3), "auto", l2);
                    zzchx2.zzb((zzcgl)((Object)object), zzcft3);
                }
                l2 = l;
                zzcft3 = zzcft2;
                zzchx2 = this;
                zzcfs3 = new Bundle();
                zzcfs3.putLong("_et", 1L);
                object = new zzcgl("_e", new zzcgi((Bundle)zzcfs3), "auto", l2);
                zzchx2.zzb((zzcgl)((Object)object), zzcft3);
            } else if (zzcft2.zzbpa) {
                l2 = l;
                zzcft3 = zzcft2;
                zzchx2 = this;
                zzcfs3 = new Bundle();
                object = new zzcgl("_cd", new zzcgi((Bundle)zzcfs3), "auto", l2);
                zzchx2.zzb((zzcgl)((Object)object), zzcft3);
            }
            this.zzwy().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwy().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzcft zzcft2) {
        this.zzwD().zzjB();
        this.zzkC();
        zzbr.zzu((Object)((Object)zzcft2));
        zzbr.zzcF((String)zzcft2.packageName);
        zzcfs zzcfs2 = this.zzwy().zzdR(zzcft2.packageName);
        String string = this.zzwF().zzed(zzcft2.packageName);
        boolean bl = false;
        if (zzcfs2 == null) {
            zzcfs2 = new zzcfs(this, zzcft2.packageName);
            zzcfs2.zzdH(this.zzwt().zzys());
            zzcfs2.zzdJ(string);
            bl = true;
        } else if (!string.equals(zzcfs2.zzwI())) {
            zzcfs2.zzdJ(string);
            zzcfs2.zzdH(this.zzwt().zzys());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcft2.zzboU) && !zzcft2.zzboU.equals(zzcfs2.getGmpAppId())) {
            zzcfs2.zzdI(zzcft2.zzboU);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcft2.zzbpc) && !zzcft2.zzbpc.equals(zzcfs2.zzwJ())) {
            zzcfs2.zzdK(zzcft2.zzbpc);
            bl = true;
        }
        if (zzcft2.zzboW != 0L && zzcft2.zzboW != zzcfs2.zzwO()) {
            zzcfs2.zzO(zzcft2.zzboW);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcft2.zzbha) && !zzcft2.zzbha.equals(zzcfs2.zzjG())) {
            zzcfs2.setAppVersion(zzcft2.zzbha);
            bl = true;
        }
        if (zzcft2.zzbpb != zzcfs2.zzwM()) {
            zzcfs2.zzN(zzcft2.zzbpb);
            bl = true;
        }
        if (zzcft2.zzboV != null && !zzcft2.zzboV.equals(zzcfs2.zzwN())) {
            zzcfs2.zzdL(zzcft2.zzboV);
            bl = true;
        }
        if (zzcft2.zzboX != zzcfs2.zzwP()) {
            zzcfs2.zzP(zzcft2.zzboX);
            bl = true;
        }
        if (zzcft2.zzboZ != zzcfs2.zzwQ()) {
            zzcfs2.setMeasurementEnabled(zzcft2.zzboZ);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcft2.zzboY) && !zzcft2.zzboY.equals(zzcfs2.zzxb())) {
            zzcfs2.zzdM(zzcft2.zzboY);
            bl = true;
        }
        if (zzcft2.zzbpd != zzcfs2.zzxd()) {
            zzcfs2.zzZ(zzcft2.zzbpd);
            bl = true;
        }
        if (bl) {
            this.zzwy().zza(zzcfs2);
        }
    }

    @WorkerThread
    final void zzzc() {
        this.zzwD().zzjB();
        this.zzkC();
        if (!this.zzbsN) {
            this.zzwE().zzyz().log("This instance being marked as an uploader");
            zzchx zzchx2 = this;
            zzchx2.zzwD().zzjB();
            zzchx2.zzkC();
            if (zzchx2.zzzd() && zzchx2.zzyV()) {
                int n;
                int n2 = zzchx2.zza(zzchx2.zzbsR);
                int n3 = n = zzchx2.zzwt().zzyt();
                int n4 = n2;
                zzchx zzchx3 = zzchx2;
                zzchx3.zzwD().zzjB();
                if (n4 > n3) {
                    zzchx3.zzwE().zzyv().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzchx3.zza(n3, zzchx3.zzbsR)) {
                        zzchx3.zzwE().zzyB().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzchx3.zzwE().zzyv().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzbsN = true;
            this.zzza();
        }
    }

    @WorkerThread
    private final boolean zzzd() {
        this.zzwD().zzjB();
        this.zzkC();
        return this.zzbsN;
    }

    @WorkerThread
    final void zzl(Runnable runnable) {
        this.zzwD().zzjB();
        if (this.zzbsT == null) {
            this.zzbsT = new ArrayList<Runnable>();
        }
        this.zzbsT.add(runnable);
    }

    @WorkerThread
    private final void zzze() {
        this.zzwD().zzjB();
        if (this.zzbsY || this.zzbsZ || this.zzbta) {
            this.zzwE().zzyB().zzd("Not stopping services. fetch, network, upload", this.zzbsY, this.zzbsZ, this.zzbta);
            return;
        }
        this.zzwE().zzyB().log("Stopping uploading service(s)");
        if (this.zzbsT == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzbsT.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzbsT.clear();
    }

    final class zza
    implements zzcgb {
        zzcll zzbtd;
        List<Long> zzbte;
        List<zzcli> zztK;
        private long zzbtf;
        private /* synthetic */ zzchx zzbtc;

        private zza(zzchx zzchx2) {
            this.zzbtc = zzchx2;
        }

        @Override
        public final void zzb(zzcll zzcll2) {
            zzbr.zzu((Object)((Object)zzcll2));
            this.zzbtd = zzcll2;
        }

        @Override
        public final boolean zza(long l, zzcli zzcli2) {
            zzbr.zzu((Object)((Object)zzcli2));
            if (this.zztK == null) {
                this.zztK = new ArrayList<zzcli>();
            }
            if (this.zzbte == null) {
                this.zzbte = new ArrayList<Long>();
            }
            if (this.zztK.size() > 0 && zza.zza(this.zztK.get(0)) != zza.zza(zzcli2)) {
                return false;
            }
            long l2 = this.zzbtf + (long)zzcli2.zzMl();
            if (l2 >= (long)zzcfy.zzxK()) {
                return false;
            }
            this.zzbtf = l2;
            this.zztK.add(zzcli2);
            this.zzbte.add(l);
            return this.zztK.size() < zzcfy.zzxL();
        }

        private static long zza(zzcli zzcli2) {
            return zzcli2.zzbvB / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzchx zzchx2, zzchy zzchy2) {
            this(zzchx2);
        }
    }
}

