/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgq;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcig;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcij;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzciq;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckw;
import com.google.android.gms.internal.zzckx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcic
extends zzcgq {
    private final zzchx zzboi;
    private Boolean zzbtg;
    @Nullable
    private String zzbth;

    public zzcic(zzchx zzchx2) {
        this(zzchx2, null);
    }

    private zzcic(zzchx zzchx2, @Nullable String string) {
        zzbr.zzu((Object)zzchx2);
        this.zzboi = zzchx2;
        this.zzbth = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcft zzcft2) {
        this.zzb(zzcft2, false);
        this.zzboi.zzwD().zzj(new zzcid(this, zzcft2));
    }

    @Override
    @BinderThread
    public final void zza(zzcgl zzcgl2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcgl2));
        this.zzb(zzcft2, false);
        this.zzboi.zzwD().zzj(new zzcim(this, zzcgl2, zzcft2));
    }

    @Override
    @BinderThread
    public final void zza(zzcgl zzcgl2, String string, String string2) {
        zzbr.zzu((Object)((Object)zzcgl2));
        zzbr.zzcF((String)string);
        this.zzh(string, true);
        this.zzboi.zzwD().zzj(new zzcin(this, zzcgl2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcgl zzcgl2, String string) {
        zzbr.zzcF((String)string);
        zzbr.zzu((Object)((Object)zzcgl2));
        this.zzh(string, true);
        this.zzboi.zzwE().zzyA().zzj("Log and bundle. event", this.zzboi.zzwz().zzdX(zzcgl2.name));
        long l = this.zzboi.zzkp().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzboi.zzwD().zzf(new zzcio(this, zzcgl2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzboi.zzwE().zzyv().zzj("Log and bundle returned null. appId", zzcgx.zzea(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzboi.zzkp().nanoTime() / 1000000L;
            this.zzboi.zzwE().zzyA().zzd("Log and bundle processed. event, size, time_ms", this.zzboi.zzwz().zzdX(zzcgl2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zzd("Failed to log and bundle. appId, event, error", zzcgx.zzea(string), this.zzboi.zzwz().zzdX(zzcgl2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcku zzcku2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcku2));
        this.zzb(zzcft2, false);
        if (zzcku2.getValue() == null) {
            this.zzboi.zzwD().zzj(new zzcip(this, zzcku2, zzcft2));
            return;
        }
        this.zzboi.zzwD().zzj(new zzciq(this, zzcku2, zzcft2));
    }

    @Override
    @BinderThread
    public final List<zzcku> zza(zzcft zzcft2, boolean bl) {
        this.zzb(zzcft2, false);
        Future<List<zzckw>> future = this.zzboi.zzwD().zze(new zzcir(this, zzcft2));
        try {
            List<zzckw> list = future.get();
            ArrayList<zzcku> arrayList = new ArrayList<zzcku>(list.size());
            for (zzckw zzckw2 : list) {
                if (!bl && zzckx.zzey(zzckw2.mName)) continue;
                arrayList.add(new zzcku(zzckw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zze("Failed to get user attributes. appId", zzcgx.zzea(zzcft2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcft zzcft2) {
        this.zzb(zzcft2, false);
        zzcis zzcis2 = new zzcis(this, zzcft2);
        if (this.zzboi.zzwD().zzyK()) {
            zzcis2.run();
            return;
        }
        this.zzboi.zzwD().zzj(zzcis2);
    }

    @BinderThread
    private final void zzb(zzcft zzcft2, boolean bl) {
        zzbr.zzu((Object)((Object)zzcft2));
        this.zzh(zzcft2.packageName, false);
        this.zzboi.zzwA().zzew(zzcft2.zzboU);
    }

    @BinderThread
    private final void zzh(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzboi.zzwE().zzyv().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcic zzcic2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcic2 = this;
                    if (!bl2) break block9;
                    if (zzcic2.zzbtg == null) {
                        zzcic2.zzbtg = "com.google.android.gms".equals(zzcic2.zzbth) || zzy.zzf((Context)zzcic2.zzboi.getContext(), (int)Binder.getCallingUid()) || zzp.zzax((Context)zzcic2.zzboi.getContext()).zza(zzcic2.zzboi.getContext().getPackageManager(), Binder.getCallingUid());
                    }
                    if (zzcic2.zzbtg.booleanValue()) break block10;
                }
                if (zzcic2.zzbth == null && zzo.zzb((Context)zzcic2.zzboi.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcic2.zzbth = string2;
                }
                if (!string2.equals(zzcic2.zzbth)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzboi.zzwE().zzyv().zzj("Measurement Service called with invalid calling package. appId", zzcgx.zzea(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzboi.zzwD().zzj(new zzcit(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcft zzcft2) {
        this.zzb(zzcft2, false);
        return this.zzboi.zzen(zzcft2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcfw zzcfw2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        zzbr.zzu((Object)((Object)zzcfw2.zzbph));
        this.zzb(zzcft2, false);
        zzcfw zzcfw3 = new zzcfw(zzcfw2);
        new zzcfw(zzcfw2).packageName = zzcft2.packageName;
        if (zzcfw2.zzbph.getValue() == null) {
            this.zzboi.zzwD().zzj(new zzcie(this, zzcfw3, zzcft2));
            return;
        }
        this.zzboi.zzwD().zzj(new zzcif(this, zzcfw3, zzcft2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcfw zzcfw2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        zzbr.zzu((Object)((Object)zzcfw2.zzbph));
        this.zzh(zzcfw2.packageName, true);
        zzcfw zzcfw3 = new zzcfw(zzcfw2);
        if (zzcfw2.zzbph.getValue() == null) {
            this.zzboi.zzwD().zzj(new zzcig(this, zzcfw3));
            return;
        }
        this.zzboi.zzwD().zzj(new zzcih(this, zzcfw3));
    }

    @Override
    @BinderThread
    public final List<zzcku> zza(String string, String string2, boolean bl, zzcft zzcft2) {
        this.zzb(zzcft2, false);
        Future<List<zzckw>> future = this.zzboi.zzwD().zze(new zzcii(this, zzcft2, string, string2));
        try {
            List<zzckw> list = future.get();
            ArrayList<zzcku> arrayList = new ArrayList<zzcku>(list.size());
            for (zzckw zzckw2 : list) {
                if (!bl && zzckx.zzey(zzckw2.mName)) continue;
                arrayList.add(new zzcku(zzckw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zze("Failed to get user attributes. appId", zzcgx.zzea(zzcft2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcku> zza(String string, String string2, String string3, boolean bl) {
        this.zzh(string, true);
        Future<List<zzckw>> future = this.zzboi.zzwD().zze(new zzcij(this, string, string2, string3));
        try {
            List<zzckw> list = future.get();
            ArrayList<zzcku> arrayList = new ArrayList<zzcku>(list.size());
            for (zzckw zzckw2 : list) {
                if (!bl && zzckx.zzey(zzckw2.mName)) continue;
                arrayList.add(new zzcku(zzckw2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zze("Failed to get user attributes. appId", zzcgx.zzea(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfw> zza(String string, String string2, zzcft zzcft2) {
        this.zzb(zzcft2, false);
        Future<List<zzcfw>> future = this.zzboi.zzwD().zze(new zzcik(this, zzcft2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcfw> zzk(String string, String string2, String string3) {
        this.zzh(string, true);
        Future<List<zzcfw>> future = this.zzboi.zzwD().zze(new zzcil(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboi.zzwE().zzyv().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzchx zza(zzcic zzcic2) {
        return zzcic2.zzboi;
    }
}

