/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjg;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjo;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcix
extends zzciv {
    protected zzcjk zzbts;
    private AppMeasurement.EventInterceptor zzbtt;
    private final Set<AppMeasurement.OnEventListener> zzbtu = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzbtv;
    private final AtomicReference<String> zzbtw = new AtomicReference();

    protected zzcix(zzchx zzchx2) {
        super(zzchx2);
    }

    @Override
    protected final void zzjC() {
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzkC();
        super.zzwo();
        super.zzwD().zzj(new zzciy(this, bl));
    }

    @WorkerThread
    private final void zzan(boolean bl) {
        super.zzjB();
        super.zzwo();
        this.zzkC();
        super.zzwE().zzyA().zzj("Setting app measurement enabled (FE)", bl);
        super.zzwF().setMeasurementEnabled(bl);
        super.zzwv().zzzh();
    }

    public final void setMinimumSessionDuration(long l) {
        super.zzwo();
        super.zzwD().zzj(new zzcjd(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        super.zzwo();
        super.zzwD().zzj(new zzcje(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        super.zzwo();
        boolean bl2 = this.zzbtt == null || zzckx.zzey(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzd(String string, String string2, Bundle bundle) {
        super.zzwo();
        boolean bl = this.zzbtt == null || zzckx.zzey(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        super.zzwo();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, super.zzkp().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        super.zzwD().zzj(new zzcjf(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        zzbr.zzu((Object)bundle);
        super.zzjB();
        this.zzkC();
        if (!this.zzboi.isEnabled()) {
            super.zzwE().zzyA().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzbtv) {
            this.zzbtv = true;
            zzcix zzcix2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcix zzcix3 = zzcix2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, super.getContext());
                }
                catch (Exception exception) {
                    super.zzwE().zzyx().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                super.zzwE().zzyz().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzckx.zzey(string2);
        if (bl && this.zzbtt != null && !bl5 && !bl4) {
            super.zzwE().zzyA().zze("Passing event to registered event handler (FE)", super.zzwz().zzdX(string2), super.zzwz().zzA(bundle));
            this.zzbtt.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzboi.zzyN()) {
            return;
        }
        int n = super.zzwA().zzer(string2);
        if (n != 0) {
            super.zzwA();
            String string4 = zzckx.zza(string2, zzcfy.zzxg(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzboi.zzwA().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = super.zzwA().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = super.zzwA().zzzr().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            super.zzwA();
            bundle2 = zzckx.zzC(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = super.zzwA().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        zzcfy.zzxD();
        zzcjo zzcjo2 = super.zzww().zzzf();
        if (zzcjo2 != null && !bundle3.containsKey("_sc")) {
            zzcjo2.zzbtW = true;
        }
        object2 = zzcjo2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzcjl.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? super.zzwA().zzB(bundle5) : bundle5;
            super.zzwE().zzyA().zze("Logging event (FE)", super.zzwz().zzdX(string2), super.zzwz().zzA(bundle2));
            zzcgl zzcgl2 = new zzcgl((String)object, new zzcgi(bundle2), string, l);
            super.zzwv().zzc(zzcgl2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzbtu) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        zzcfy.zzxD();
        if (super.zzww().zzzf() != null && "_ae".equals(string2)) {
            super.zzwC().zzap(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbr.zzcF((String)string);
        long l = super.zzkp().currentTimeMillis();
        int n = super.zzwA().zzet(string2);
        if (n != 0) {
            super.zzwA();
            String string3 = zzckx.zza(string2, zzcfy.zzxh(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzboi.zzwA().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = super.zzwA().zzl(string2, object);
            if (n != 0) {
                super.zzwA();
                String string4 = zzckx.zza(string2, zzcfy.zzxh(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzboi.zzwA().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = super.zzwA().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        super.zzwD().zzj(new zzcjg(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbr.zzcF((String)string);
        zzbr.zzcF((String)string2);
        super.zzjB();
        super.zzwo();
        this.zzkC();
        if (!this.zzboi.isEnabled()) {
            super.zzwE().zzyA().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzboi.zzyN()) {
            return;
        }
        super.zzwE().zzyA().zze("Setting user property (FE)", super.zzwz().zzdX(string2), object);
        zzcku zzcku2 = new zzcku(string2, l, object, string);
        super.zzwv().zzb(zzcku2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcku> zzao(boolean bl) {
        super.zzwo();
        this.zzkC();
        super.zzwE().zzyA().log("Fetching user attributes (FE)");
        if (super.zzwD().zzyK()) {
            super.zzwE().zzyv().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        super.zzwD();
        if (zzchs.zzR()) {
            super.zzwE().zzyv().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboi.zzwD().zzj(new zzcjh(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwE().zzyx().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwE().zzyx().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = super.zzwF().zzyF();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)super.zzwD().zzyL(), (Callable)new zzcji(this));
        }
        catch (Exception exception) {
            super.zzwE().zzyx().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzyF() {
        super.zzwo();
        return this.zzbtw.get();
    }

    @Nullable
    final String zzac(long l) {
        if (super.zzwD().zzyK()) {
            super.zzwE().zzyv().log("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        super.zzwD();
        if (zzchs.zzR()) {
            super.zzwE().zzyv().log("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = super.zzkp().elapsedRealtime();
        String string = this.zzad(120000L);
        long l3 = super.zzkp().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzad(120000L - l3);
        }
        return string;
    }

    final void zzef(@Nullable String string) {
        this.zzbtw.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzad(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            super.zzwD().zzj(new zzcjj(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                super.zzwE().zzyx().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        super.zzjB();
        super.zzwo();
        this.zzkC();
        if (eventInterceptor != null && eventInterceptor != this.zzbtt) {
            zzbr.zza((this.zzbtt == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzbtt = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        super.zzwo();
        this.zzkC();
        zzbr.zzu((Object)onEventListener);
        if (!this.zzbtu.add(onEventListener)) {
            super.zzwE().zzyx().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        super.zzwo();
        this.zzkC();
        zzbr.zzu((Object)onEventListener);
        if (!this.zzbtu.remove(onEventListener)) {
            super.zzwE().zzyx().log("OnEventListener had not been registered");
        }
    }

    public static int getMaxUserProperties(String string) {
        zzbr.zzcF((String)string);
        return zzcfy.zzxt();
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbr.zzu((Object)conditionalUserProperty);
        super.zzwo();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            super.zzwE().zzyx().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbr.zzu((Object)conditionalUserProperty);
        zzbr.zzcF((String)conditionalUserProperty.mAppId);
        super.zzwn();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = super.zzkp().currentTimeMillis();
        zzbr.zzu((Object)conditionalUserProperty);
        zzbr.zzcF((String)conditionalUserProperty.mName);
        zzbr.zzcF((String)conditionalUserProperty.mOrigin);
        zzbr.zzu((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (super.zzwA().zzet(string) != 0) {
            super.zzwE().zzyv().zzj("Invalid conditional user property name", super.zzwz().zzdZ(string));
            return;
        }
        if (super.zzwA().zzl(string, object) != 0) {
            super.zzwE().zzyv().zze("Invalid conditional user property value", super.zzwz().zzdZ(string), object);
            return;
        }
        Object object2 = super.zzwA().zzm(string, object);
        if (object2 == null) {
            super.zzwE().zzyv().zze("Unable to normalize conditional user property value", super.zzwz().zzdZ(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= zzcfy.zzxv() && l2 >= 1L)) {
            super.zzwE().zzyv().zze("Invalid conditional user property timeout", super.zzwz().zzdZ(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > zzcfy.zzxw() || l3 < 1L) {
            super.zzwE().zzyv().zze("Invalid conditional user property time to live", super.zzwz().zzdZ(string), l3);
            return;
        }
        super.zzwD().zzj(new zzciz(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        super.zzwo();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbr.zzcF((String)string);
        super.zzwn();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = super.zzkp().currentTimeMillis();
        zzbr.zzcF((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        super.zzwD().zzj(new zzcja(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcgl zzcgl2;
        zzcgl zzcgl3;
        zzcgl zzcgl4;
        super.zzjB();
        this.zzkC();
        zzbr.zzu((Object)conditionalUserProperty);
        zzbr.zzcF((String)conditionalUserProperty.mName);
        zzbr.zzcF((String)conditionalUserProperty.mOrigin);
        zzbr.zzu((Object)conditionalUserProperty.mValue);
        if (!this.zzboi.isEnabled()) {
            super.zzwE().zzyA().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcku zzcku2 = new zzcku(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcgl4 = super.zzwA().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcgl3 = super.zzwA().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcgl2 = super.zzwA().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfw zzcfw2 = new zzcfw(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcku2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcgl3, conditionalUserProperty.mTriggerTimeout, zzcgl4, conditionalUserProperty.mTimeToLive, zzcgl2);
        super.zzwv().zzf(zzcfw2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcgl zzcgl2;
        super.zzjB();
        this.zzkC();
        zzbr.zzu((Object)conditionalUserProperty);
        zzbr.zzcF((String)conditionalUserProperty.mName);
        if (!this.zzboi.isEnabled()) {
            super.zzwE().zzyA().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcku zzcku2 = new zzcku(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcgl2 = super.zzwA().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfw zzcfw2 = new zzcfw(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcku2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcgl2);
        super.zzwv().zzf(zzcfw2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        super.zzwo();
        return this.zzl(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbr.zzcF((String)string);
        super.zzwn();
        return this.zzl(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzl(String string, String string2, String string3) {
        if (super.zzwD().zzyK()) {
            super.zzwE().zzyv().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        super.zzwD();
        if (zzchs.zzR()) {
            super.zzwE().zzyv().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboi.zzwD().zzj(new zzcjb(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwE().zzyx().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwE().zzyx().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcfw zzcfw2 = (zzcfw)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcfw2.zzbpi;
                conditionalUserProperty.mName = zzcfw2.zzbph.name;
                conditionalUserProperty.mValue = zzcfw2.zzbph.getValue();
                conditionalUserProperty.mActive = zzcfw2.zzbpj;
                conditionalUserProperty.mTriggerEventName = zzcfw2.zzbpk;
                if (zzcfw2.zzbpl != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcfw2.zzbpl.name;
                    if (zzcfw2.zzbpl.zzbpQ != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcfw2.zzbpl.zzbpQ.zzyr();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcfw2.zzbpm;
                if (zzcfw2.zzbpn != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcfw2.zzbpn.name;
                    if (zzcfw2.zzbpn.zzbpQ != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcfw2.zzbpn.zzbpQ.zzyr();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcfw2.zzbph.zzbuC;
                conditionalUserProperty.mTimeToLive = zzcfw2.zzbpo;
                if (zzcfw2.zzbpp != null) {
                    conditionalUserProperty.mExpiredEventName = zzcfw2.zzbpp.name;
                    if (zzcfw2.zzbpp.zzbpQ != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcfw2.zzbpp.zzbpQ.zzyr();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        super.zzwo();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbr.zzcF((String)string);
        super.zzwn();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (super.zzwD().zzyK()) {
            super.zzwE().zzyv().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        super.zzwD();
        if (zzchs.zzR()) {
            super.zzwE().zzyv().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboi.zzwD().zzj(new zzcjc(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwE().zzyx().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwE().zzyx().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcku zzcku2 = (zzcku)((Object)iterator.next());
                arrayMap.put(zzcku2.name, zzcku2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcix zzcix2, boolean bl) {
        zzcix2.zzan(bl);
    }

    static /* synthetic */ void zza(zzcix zzcix2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcix2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcix zzcix2, String string, String string2, Object object, long l) {
        zzcix2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcix zzcix2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcix2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcix zzcix2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcix2.zzc(conditionalUserProperty);
    }
}

