/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzcjm;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzcjo;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcjl
extends zzciv {
    protected zzcjo zzbtI;
    private volatile AppMeasurement.zzb zzbtJ;
    private AppMeasurement.zzb zzbtK;
    private long zzbtL;
    private final Map<Activity, zzcjo> zzbtM = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzbtN = new CopyOnWriteArrayList();
    private boolean zzbtO;
    private AppMeasurement.zzb zzbtP;
    private String zzbtQ;

    public zzcjl(zzchx zzchx2) {
        super(zzchx2);
    }

    @Override
    protected final void zzjC() {
    }

    @WorkerThread
    public final zzcjo zzzf() {
        this.zzkC();
        super.zzjB();
        return this.zzbtI;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            super.zzwE().zzyx().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        super.zzwD();
        if (!zzchs.zzR()) {
            super.zzwE().zzyx().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzbtO) {
            super.zzwE().zzyx().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzbtJ == null) {
            super.zzwE().zzyx().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzbtM.get(activity) == null) {
            super.zzwE().zzyx().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcjl.zzeo(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzbtJ.zzboo.equals(string2);
        boolean bl2 = zzckx.zzR(this.zzbtJ.zzbon, string);
        if (bl && bl2) {
            super.zzwE().zzyy().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcfy.zzxj())) {
            super.zzwE().zzyx().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcfy.zzxj())) {
            super.zzwE().zzyx().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        super.zzwE().zzyB().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcjo zzcjo2 = new zzcjo(string, string2, super.zzwA().zzzq());
        this.zzbtM.put(activity, zzcjo2);
        this.zza(activity, zzcjo2, true);
    }

    public final AppMeasurement.zzb zzzg() {
        super.zzwo();
        AppMeasurement.zzb zzb2 = this.zzbtJ;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        super.zzwo();
        if (zza2 == null) {
            super.zzwE().zzyx().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzbtN.remove(zza2);
        this.zzbtN.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        super.zzwo();
        this.zzbtN.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcjo zzcjo2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzbtJ != null) {
            zzb2 = this.zzbtJ;
        } else if (this.zzbtK != null && Math.abs(super.zzkp().elapsedRealtime() - this.zzbtL) < 1000L) {
            zzb2 = this.zzbtK;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzbtO = true;
        try {
            object2 = this.zzbtN.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcjo2);
                }
                catch (Exception exception) {
                    super.zzwE().zzyv().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            super.zzwE().zzyv().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzbtO = false;
        }
        Object object3 = object2 = this.zzbtJ == null ? this.zzbtK : this.zzbtJ;
        if (bl2) {
            if (zzcjo2.zzboo == null) {
                zzcjo2.zzboo = zzcjl.zzeo(activity.getClass().getCanonicalName());
            }
            object = new zzcjo(zzcjo2);
            this.zzbtK = this.zzbtJ;
            this.zzbtL = super.zzkp().elapsedRealtime();
            this.zzbtJ = object;
            super.zzwD().zzj(new zzcjm(this, bl, (AppMeasurement.zzb)object2, (zzcjo)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcjo zzcjo2) {
        super.zzwq().zzJ(super.zzkp().elapsedRealtime());
        if (super.zzwC().zzap(zzcjo2.zzbtW)) {
            zzcjo2.zzbtW = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzbon != null) {
                bundle.putString("_sn", zzb2.zzbon);
            }
            bundle.putString("_sc", zzb2.zzboo);
            bundle.putLong("_si", zzb2.zzbop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        super.zzjB();
        zzcjl zzcjl2 = this;
        synchronized (zzcjl2) {
            if (this.zzbtQ == null || this.zzbtQ.equals(string) || zzb2 != null) {
                this.zzbtQ = string;
                this.zzbtP = zzb2;
            }
            return;
        }
    }

    private static String zzeo(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcjo zzq(@NonNull Activity activity) {
        zzbr.zzu((Object)activity);
        zzcjo zzcjo2 = this.zzbtM.get(activity);
        if (zzcjo2 == null) {
            String string = zzcjl.zzeo(activity.getClass().getCanonicalName());
            zzcjo2 = new zzcjo(null, string, super.zzwA().zzzq());
            this.zzbtM.put(activity, zzcjo2);
        }
        return zzcjo2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcjo zzcjo2 = this.zzq(activity);
        this.zza(activity, zzcjo2, false);
        super.zzwq().zzwm();
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcjo zzcjo2 = this.zzq(activity);
        this.zzbtK = this.zzbtJ;
        this.zzbtL = super.zzkp().elapsedRealtime();
        this.zzbtJ = null;
        super.zzwD().zzj(new zzcjn(this, zzcjo2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcjo zzcjo2 = this.zzbtM.get(activity);
        if (zzcjo2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcjo2.zzbop);
        bundle2.putString("name", zzcjo2.zzbon);
        bundle2.putString("referrer_name", zzcjo2.zzboo);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzbtM.remove(activity);
    }

    static /* synthetic */ void zza(zzcjl zzcjl2, zzcjo zzcjo2) {
        zzcjl2.zza(zzcjo2);
    }
}

