/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgp;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzcjq;
import com.google.android.gms.internal.zzcjr;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcjt;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzckr;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcjp
extends zzciv {
    private final zzckc zzbtX;
    private zzcgp zzbtY;
    private Boolean zzbtZ;
    private final zzcgd zzbua;
    private final zzckr zzbub;
    private final List<Runnable> zzbuc = new ArrayList<Runnable>();
    private final zzcgd zzbud;

    protected zzcjp(zzchx zzchx2) {
        super(zzchx2);
        this.zzbub = new zzckr(zzchx2.zzkp());
        this.zzbtX = new zzckc(this);
        this.zzbua = new zzcjq(this, zzchx2);
        this.zzbud = new zzcju(this, zzchx2);
    }

    @Override
    protected final void zzjC() {
    }

    @WorkerThread
    public final boolean isConnected() {
        super.zzjB();
        this.zzkC();
        return this.zzbtY != null;
    }

    @WorkerThread
    protected final void zzzh() {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjv(this));
    }

    @WorkerThread
    final void zza(zzcgp zzcgp2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        super.zzjB();
        super.zzwo();
        this.zzkC();
        zzcfy.zzxD();
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        zzcfy.zzxM();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<com.google.android.gms.common.internal.safeparcel.zza> list = super.zzwx().zzbo(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                com.google.android.gms.common.internal.safeparcel.zza zza3 = (com.google.android.gms.common.internal.safeparcel.zza)e;
                if (zza3 instanceof zzcgl) {
                    try {
                        zzcgp2.zza((zzcgl)zza3, super.zzwt().zzdW(super.zzwE().zzyC()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwE().zzyv().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcku) {
                    try {
                        zzcgp2.zza((zzcku)zza3, super.zzwt().zzdW(super.zzwE().zzyC()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwE().zzyv().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcfw) {
                    try {
                        zzcgp2.zza((zzcfw)zza3, super.zzwt().zzdW(super.zzwE().zzyC()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwE().zzyv().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                super.zzwE().zzyv().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcgl zzcgl2, String string) {
        zzbr.zzu((Object)((Object)zzcgl2));
        super.zzjB();
        this.zzkC();
        zzcfy.zzxD();
        boolean bl = super.zzwx().zza(zzcgl2);
        this.zzm(new zzcjw(this, true, bl, zzcgl2, string));
    }

    @WorkerThread
    protected final void zzf(zzcfw zzcfw2) {
        zzbr.zzu((Object)((Object)zzcfw2));
        super.zzjB();
        this.zzkC();
        zzcfy.zzxD();
        boolean bl = super.zzwx().zzc(zzcfw2);
        zzcfw zzcfw3 = new zzcfw(zzcfw2);
        this.zzm(new zzcjx(this, true, bl, zzcfw3, zzcfw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfw>> atomicReference, String string, String string2, String string3) {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjy(this, atomicReference, string, string2, string3));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcku>> atomicReference, String string, String string2, String string3, boolean bl) {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjz(this, atomicReference, string, string2, string3, bl));
    }

    @WorkerThread
    protected final void zzb(zzcku zzcku2) {
        super.zzjB();
        this.zzkC();
        zzcfy.zzxD();
        boolean bl = super.zzwx().zza(zzcku2);
        this.zzm(new zzcka(this, bl, zzcku2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcku>> atomicReference, boolean bl) {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzckb(this, atomicReference, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjr(this, atomicReference));
    }

    @WorkerThread
    protected final void zzzi() {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjs(this));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        super.zzjB();
        this.zzkC();
        this.zzm(new zzcjt(this, zzb2));
    }

    @WorkerThread
    private final void zzkO() {
        super.zzjB();
        this.zzbub.start();
        this.zzbua.zzs(zzcfy.zzxA());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzkZ() {
        zzcjp zzcjp2;
        block11: {
            boolean bl;
            block12: {
                super.zzjB();
                this.zzkC();
                if (this.isConnected()) {
                    return;
                }
                if (this.zzbtZ != null) break block11;
                this.zzbtZ = super.zzwF().zzyG();
                if (this.zzbtZ != null) break block11;
                super.zzwE().zzyB().log("State of service unknown");
                zzcjp2 = this;
                super.zzjB();
                zzcjp2.zzkC();
                zzcfy.zzxD();
                super.zzwE().zzyB().log("Checking service availability");
                switch (zze.zzoU().isGooglePlayServicesAvailable(super.getContext())) {
                    case 0: {
                        super.zzwE().zzyB().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        super.zzwE().zzyB().log("Service missing");
                        break;
                    }
                    case 18: {
                        super.zzwE().zzyx().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        super.zzwE().zzyA().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        super.zzwE().zzyx().log("Service disabled");
                        break;
                    }
                    case 9: {
                        super.zzwE().zzyx().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zzbtZ = bl;
            super.zzwF().zzak(this.zzbtZ);
        }
        if (this.zzbtZ.booleanValue()) {
            super.zzwE().zzyB().log("Using measurement service");
            this.zzbtX.zzzk();
            return;
        }
        zzcjp2 = this;
        zzcfy.zzxD();
        PackageManager packageManager = super.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(super.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            super.zzwE().zzyB().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = super.getContext();
            zzcfy.zzxD();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzbtX.zzk(intent2);
            return;
        }
        super.zzwE().zzyv().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcgp zzcgp2) {
        super.zzjB();
        zzbr.zzu((Object)zzcgp2);
        this.zzbtY = zzcgp2;
        this.zzkO();
        this.zzzj();
    }

    @WorkerThread
    public final void disconnect() {
        super.zzjB();
        this.zzkC();
        try {
            zza.zzrT();
            zzckc zzckc2 = this.zzbtX;
            Context context = super.getContext();
            context.unbindService((ServiceConnection)zzckc2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzbtY = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        super.zzjB();
        if (this.zzbtY != null) {
            this.zzbtY = null;
            super.zzwE().zzyB().zzj("Disconnected from device MeasurementService", componentName);
            zzcjp zzcjp2 = this;
            super.zzjB();
            zzcjp2.zzkZ();
        }
    }

    @WorkerThread
    private final void zzkP() {
        super.zzjB();
        if (!this.isConnected()) {
            return;
        }
        super.zzwE().zzyB().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzm(Runnable runnable) throws IllegalStateException {
        super.zzjB();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzbuc.size() >= zzcfy.zzxI()) {
            super.zzwE().zzyv().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzbuc.add(runnable);
        this.zzbud.zzs(60000L);
        this.zzkZ();
    }

    @WorkerThread
    private final void zzzj() {
        super.zzjB();
        super.zzwE().zzyB().zzj("Processing queued up service tasks", this.zzbuc.size());
        for (Runnable runnable : this.zzbuc) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                super.zzwE().zzyv().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzbuc.clear();
        this.zzbud.cancel();
    }

    static /* synthetic */ zzckc zza(zzcjp zzcjp2) {
        return zzcjp2.zzbtX;
    }

    static /* synthetic */ void zza(zzcjp zzcjp2, ComponentName componentName) {
        zzcjp2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcgp zza(zzcjp zzcjp2, zzcgp zzcgp2) {
        zzcjp2.zzbtY = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcjp zzcjp2) {
        zzcjp2.zzzj();
    }

    static /* synthetic */ void zzc(zzcjp zzcjp2) {
        zzcjp2.zzkP();
    }

    static /* synthetic */ zzcgp zzd(zzcjp zzcjp2) {
        return zzcjp2.zzbtY;
    }

    static /* synthetic */ void zze(zzcjp zzcjp2) {
        zzcjp2.zzkO();
    }
}

