/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcgp;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcjp;
import com.google.android.gms.internal.zzckd;
import com.google.android.gms.internal.zzcke;
import com.google.android.gms.internal.zzckf;
import com.google.android.gms.internal.zzckg;
import com.google.android.gms.internal.zzckh;

public final class zzckc
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzbul;
    private volatile zzcgw zzbum;
    final /* synthetic */ zzcjp zzbue;

    protected zzckc(zzcjp zzcjp2) {
        this.zzbue = zzcjp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        this.zzbue.zzjB();
        Context context = this.zzbue.getContext();
        zza zza2 = zza.zzrT();
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            if (this.zzbul) {
                this.zzbue.zzwE().zzyB().log("Connection attempt already in progress");
                return;
            }
            this.zzbul = true;
            zza2.zza(context, intent, (ServiceConnection)zzcjp.zza(this.zzbue), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbr.zzcz((String)"MeasurementServiceConnection.onServiceConnected");
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzbul = false;
                this.zzbue.zzwE().zzyv().log("Service connected with null binder");
                return;
            }
            zzcgp zzcgp2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcgp2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcgp ? (zzcgp)iInterface : new zzcgr(iBinder2));
                    this.zzbue.zzwE().zzyB().log("Bound to IMeasurementService interface");
                } else {
                    this.zzbue.zzwE().zzyv().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                this.zzbue.zzwE().zzyv().log("Service connect failed to get IMeasurementService");
            }
            if (zzcgp2 == null) {
                this.zzbul = false;
                try {
                    zza.zzrT();
                    zzckc zzckc3 = zzcjp.zza(this.zzbue);
                    iInterface = this.zzbue.getContext();
                    iInterface.unbindService((ServiceConnection)zzckc3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcgp2;
                this.zzbue.zzwD().zzj(new zzckd(this, (zzcgp)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbr.zzcz((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zzbue.zzwE().zzyA().log("Service disconnected");
        this.zzbue.zzwD().zzj(new zzcke(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzzk() {
        this.zzbue.zzjB();
        Context context = this.zzbue.getContext();
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            if (this.zzbul) {
                this.zzbue.zzwE().zzyB().log("Connection attempt already in progress");
                return;
            }
            if (this.zzbum != null) {
                this.zzbue.zzwE().zzyB().log("Already awaiting connection attempt");
                return;
            }
            this.zzbum = new zzcgw(context, Looper.getMainLooper(), this, this);
            this.zzbue.zzwE().zzyB().log("Connecting to remote service");
            this.zzbul = true;
            this.zzbum.zzqZ();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbr.zzcz((String)"MeasurementServiceConnection.onConnected");
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            try {
                zzcgp zzcgp2 = (zzcgp)this.zzbum.zzrd();
                this.zzbum = null;
                this.zzbue.zzwD().zzj(new zzckf(this, zzcgp2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzbum = null;
                this.zzbul = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbr.zzcz((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zzbue.zzwE().zzyA().log("Service connection suspended");
        this.zzbue.zzwD().zzj(new zzckg(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbr.zzcz((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcgx zzcgx2 = this.zzbue.zzboi.zzyO();
        if (zzcgx2 != null) {
            zzcgx2.zzyx().zzj("Service connection failed", connectionResult);
        }
        zzckc zzckc2 = this;
        synchronized (zzckc2) {
            this.zzbul = false;
            this.zzbum = null;
        }
        this.zzbue.zzwD().zzj(new zzckh(this));
    }

    static /* synthetic */ boolean zza(zzckc zzckc2, boolean bl) {
        zzckc2.zzbul = false;
        return false;
    }
}

