/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzckl;
import com.google.android.gms.internal.zzckx;

public final class zzcki {
    private final Context mContext;
    private final zzckl zzbuq;

    public zzcki(zzckl zzckl2) {
        this.mContext = zzckl2.getContext();
        zzbr.zzu((Object)this.mContext);
        this.zzbuq = zzckl2;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbr.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzckx.zzw(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzckx.zzw(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcgx zzcgx2 = zzchx.zzbj(this.mContext).zzwE();
        zzcfy.zzxD();
        zzcgx2.zzyB().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcgx zzcgx2 = zzchx.zzbj(this.mContext).zzwE();
        zzcfy.zzxD();
        zzcgx2.zzyB().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcgx zzcgx2 = zzchx.zzbj(this.mContext).zzwE();
        if (intent == null) {
            zzcgx2.zzyx().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcfy.zzxD();
        zzcgx2.zzyB().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzchx zzchx2 = zzchx.zzbj(this.mContext);
        zzcgx zzcgx2 = zzchx2.zzwE();
        zzchx2.zzwD().zzj(new zzckj(this, zzchx2, n, zzcgx2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzwE().zzyv().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcic(zzchx.zzbj(this.mContext));
        }
        this.zzwE().zzyx().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzwE().zzyv().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzwE().zzyB().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcgx zzcgx2 = zzchx.zzbj(this.mContext).zzwE();
        String string = jobParameters.getExtras().getString("action");
        zzcfy.zzxD();
        zzcgx2.zzyB().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzwE().zzyv().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzwE().zzyB().zzj("onRebind called. action", string);
    }

    private final zzcgx zzwE() {
        return zzchx.zzbj(this.mContext).zzwE();
    }

    static /* synthetic */ zzckl zza(zzcki zzcki2) {
        return zzcki2.zzbuq;
    }
}

