/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgd;
import com.google.android.gms.internal.zzcho;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckt;

public final class zzcks
extends zzciv {
    private final AlarmManager zzahf = (AlarmManager)super.getContext().getSystemService("alarm");
    private final zzcgd zzbuz;
    private Integer zzbuA;

    protected zzcks(zzchx zzchx2) {
        super(zzchx2);
        this.zzbuz = new zzckt(this, zzchx2);
    }

    @Override
    protected final void zzjC() {
        this.zzahf.cancel(this.zzlC());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzzo();
        }
    }

    @TargetApi(value=24)
    private final void zzzo() {
        JobScheduler jobScheduler = (JobScheduler)super.getContext().getSystemService("jobscheduler");
        super.zzwE().zzyB().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzkC();
        zzcfy.zzxD();
        if (!zzcho.zzj(super.getContext(), false)) {
            super.zzwE().zzyA().log("Receiver not registered/enabled");
        }
        zzcfy.zzxD();
        if (!zzcki.zzk(super.getContext(), false)) {
            super.zzwE().zzyA().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = super.zzkp().elapsedRealtime() + l;
        if (l < zzcfy.zzxU() && !this.zzbuz.zzbn()) {
            super.zzwE().zzyB().log("Scheduling upload with DelayedRunnable");
            this.zzbuz.zzs(l);
        }
        zzcfy.zzxD();
        if (Build.VERSION.SDK_INT >= 24) {
            super.zzwE().zzyB().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcks zzcks2 = this;
            ComponentName componentName = new ComponentName(super.getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)super.getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcks2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            super.zzwE().zzyB().zzj("Scheduling job. JobID", zzcks2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        super.zzwE().zzyB().log("Scheduling upload with AlarmManager");
        this.zzahf.setInexactRepeating(2, l2, Math.max(zzcfy.zzxV(), l), this.zzlC());
    }

    private final int getJobId() {
        if (this.zzbuA == null) {
            String string = String.valueOf(super.getContext().getPackageName());
            this.zzbuA = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzbuA;
    }

    public final void cancel() {
        this.zzkC();
        this.zzahf.cancel(this.zzlC());
        this.zzbuz.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzzo();
        }
    }

    private final PendingIntent zzlC() {
        Intent intent = new Intent();
        Context context = super.getContext();
        zzcfy.zzxD();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)super.getContext(), (int)0, (Intent)intent2, (int)0);
    }

    private final void zzzp() {
        Intent intent = new Intent();
        Context context = super.getContext();
        zzcfy.zzxD();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        super.getContext().sendBroadcast(intent2);
    }

    static /* synthetic */ void zza(zzcks zzcks2) {
        zzcks2.zzzp();
    }
}

