/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.ahx;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzclj;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public final class zzckx
extends zzciv {
    private static String[] zzbuH = new String[]{"firebase_"};
    private SecureRandom zzbuI;
    private final AtomicLong zzbuJ = new AtomicLong(0L);
    private int zzbuK;

    zzckx(zzchx zzchx2) {
        super(zzchx2);
    }

    @Override
    protected final void zzjC() {
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            super.zzwE().zzyx().log("Utils falling back to Random for random id");
        }
        this.zzbuJ.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzzq() {
        if (this.zzbuJ.get() == 0L) {
            AtomicLong atomicLong = this.zzbuJ;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ super.zzkp().currentTimeMillis()).nextLong() + (long)(++this.zzbuK);
            }
        }
        AtomicLong atomicLong = this.zzbuJ;
        synchronized (atomicLong) {
            this.zzbuJ.compareAndSet(-1L, 1L);
            return this.zzbuJ.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzzr() {
        super.zzjB();
        if (this.zzbuI == null) {
            this.zzbuI = new SecureRandom();
        }
        return this.zzbuI;
    }

    static boolean zzep(String string) {
        zzbr.zzcF((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    public final Bundle zzq(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            super.zzwE().zzyx().zzj("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    public static boolean zzl(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    private final boolean zzP(String string, String string2) {
        int n;
        if (string2 == null) {
            super.zzwE().zzyv().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            super.zzwE().zzyv().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            super.zzwE().zzyv().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            super.zzwE().zzyv().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zzQ(String string, String string2) {
        int n;
        if (string2 == null) {
            super.zzwE().zzyv().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            super.zzwE().zzyv().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            super.zzwE().zzyv().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            super.zzwE().zzyv().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    private final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        String string3;
        block6: {
            if (string2 == null) {
                super.zzwE().zzyv().zzj("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            zzbr.zzu((Object)string3);
            for (int i = 0; i < zzbuH.length; ++i) {
                if (!string3.startsWith(zzbuH[i])) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            super.zzwE().zzyv().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                String[] stringArray2 = stringArray;
                string3 = string2;
                zzbr.zzu((Object)stringArray2);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!zzckx.zzR(string3, stringArray2[i])) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                super.zzwE().zzyv().zze("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    private final boolean zzb(String string, int n, String string2) {
        if (string2 == null) {
            super.zzwE().zzyv().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            super.zzwE().zzyv().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public final int zzeq(String string) {
        if (!this.zzP("event", string)) {
            return 2;
        }
        if (!this.zza("event", AppMeasurement.Event.zzboj, string)) {
            return 13;
        }
        if (!this.zzb("event", zzcfy.zzxg(), string)) {
            return 2;
        }
        return 0;
    }

    public final int zzer(String string) {
        if (!this.zzQ("event", string)) {
            return 2;
        }
        if (!this.zza("event", AppMeasurement.Event.zzboj, string)) {
            return 13;
        }
        if (!this.zzb("event", zzcfy.zzxg(), string)) {
            return 2;
        }
        return 0;
    }

    public final int zzes(String string) {
        if (!this.zzP("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzboq, string)) {
            return 15;
        }
        if (!this.zzb("user property", zzcfy.zzxh(), string)) {
            return 6;
        }
        return 0;
    }

    public final int zzet(String string) {
        if (!this.zzQ("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", AppMeasurement.UserProperty.zzboq, string)) {
            return 15;
        }
        if (!this.zzb("user property", zzcfy.zzxh(), string)) {
            return 6;
        }
        return 0;
    }

    private final int zzeu(String string) {
        if (!this.zzP("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", zzcfy.zzxi(), string)) {
            return 3;
        }
        return 0;
    }

    private final int zzev(String string) {
        if (!this.zzQ("event param", string)) {
            return 3;
        }
        if (!this.zza("event param", null, string)) {
            return 14;
        }
        if (!this.zzb("event param", zzcfy.zzxi(), string)) {
            return 3;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                super.zzwE().zzyx().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                super.zzwE().zzyx().zze("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                super.zzwE().zzyx().zze("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean zzew(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            super.zzwE().zzyv().log("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        String string2 = string;
        zzbr.zzu((Object)string2);
        String string3 = "^1:\\d+:android:[a-f0-9]+$";
        if (!string2.matches(string3)) {
            super.zzwE().zzyv().zzj("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", string);
            return false;
        }
        return true;
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzckx.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final int zza(String var1_1, Object var2_2, boolean var3_3) {
        block6: {
            block7: {
                if (!var3_3) break block6;
                zzcfy.zzxl();
                var8_4 = var2_2;
                var7_5 = var1_1;
                var6_6 = "param";
                var5_7 = this;
                if (!(var8_4 instanceof Parcelable[])) break block7;
                var9_8 = ((Parcelable[])var8_4).length;
                ** GOTO lbl16
            }
            if (!(var8_4 instanceof ArrayList)) {
                v0 = true;
            } else {
                var9_8 = ((ArrayList)var8_4).size();
lbl16:
                // 2 sources

                if (var9_8 > 1000) {
                    super.zzwE().zzyx().zzd("Parameter array is too long; discarded. Value kind, name, array length", var6_6, var7_5, var9_8);
                    v0 = false;
                } else {
                    v0 = true;
                }
            }
            if (!v0) {
                return 17;
            }
        }
        if (var4_9 = zzckx.zzey(var1_1) != false ? this.zza("param", var1_1, zzcfy.zzxk(), var2_2, var3_3) : this.zza("param", var1_1, zzcfy.zzxj(), var2_2, var3_3)) {
            return 0;
        }
        return 4;
    }

    public final Object zzk(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzckx.zza(zzcfy.zzxk(), object, true);
        }
        return zzckx.zza(zzckx.zzey(string) ? zzcfy.zzxk() : zzcfy.zzxj(), object, false);
    }

    public static Bundle[] zzC(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    public final Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl, boolean bl2) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            zzcfy.zzxf();
            for (String string2 : bundle.keySet()) {
                String string3;
                int n2 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n2 = this.zzeu(string2);
                    }
                    if (n2 == 0) {
                        n2 = this.zzev(string2);
                    }
                }
                if (n2 != 0) {
                    if (zzckx.zzd(bundle2, n2)) {
                        string3 = zzckx.zza(string2, zzcfy.zzxi(), true);
                        bundle2.putString("_ev", string3);
                        if (n2 == 3) {
                            zzckx.zzb(bundle2, string2);
                        }
                    }
                    bundle2.remove(string2);
                    continue;
                }
                n2 = this.zza(string2, bundle.get(string2), bl2);
                if (n2 != 0 && !"_ev".equals(string2)) {
                    if (zzckx.zzd(bundle2, n2)) {
                        string3 = zzckx.zza(string2, zzcfy.zzxi(), true);
                        bundle2.putString("_ev", string3);
                        zzckx.zzb(bundle2, bundle.get(string2));
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzckx.zzep(string2) || ++n <= 25) continue;
                string3 = new StringBuilder(48).append("Event can't contain more then 25 params").toString();
                super.zzwE().zzyv().zze(string3, super.zzwz().zzdX(string), super.zzwz().zzA(bundle));
                zzckx.zzd(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    private static boolean zzd(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zzb(Bundle bundle, Object object) {
        zzbr.zzu((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzex(String string) {
        if ("_ldl".equals(string)) {
            return zzcfy.zzxn();
        }
        return zzcfy.zzxm();
    }

    public final int zzl(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzckx.zzex(string), object, false) : this.zza("user property", string, zzckx.zzex(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    public final Object zzm(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzckx.zza(zzckx.zzex(string), object, true);
        }
        return zzckx.zza(zzckx.zzex(string), object, false);
    }

    public final void zza(zzcln zzcln2, Object object) {
        zzbr.zzu((Object)object);
        zzcln2.zzaIH = null;
        zzcln2.zzbvE = null;
        zzcln2.zzbuF = null;
        if (object instanceof String) {
            zzcln2.zzaIH = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzcln2.zzbvE = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzcln2.zzbuF = (Double)object;
            return;
        }
        super.zzwE().zzyv().zzj("Ignoring invalid (type) user attribute value", object);
    }

    public final void zza(zzclj zzclj2, Object object) {
        zzbr.zzu((Object)object);
        zzclj2.zzaIH = null;
        zzclj2.zzbvE = null;
        zzclj2.zzbuF = null;
        if (object instanceof String) {
            zzclj2.zzaIH = (String)object;
            return;
        }
        if (object instanceof Long) {
            zzclj2.zzbvE = (Long)object;
            return;
        }
        if (object instanceof Double) {
            zzclj2.zzbuF = (Double)object;
            return;
        }
        super.zzwE().zzyv().zzj("Ignoring invalid (type) event param value", object);
    }

    public final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            super.zzwE().zzyy().zze("Not putting event parameter. Invalid value type. name, type", super.zzwz().zzdY(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    public final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzckx.zzd(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzcfy.zzxD();
        this.zzboi.zzws().zzd("auto", "_err", bundle);
    }

    public final byte[] zzm(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            super.zzwE().zzyv().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public final byte[] zzn(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            super.zzwE().zzyv().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzbE(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    static long zzo(byte[] byArray) {
        zzbr.zzu((Object)byArray);
        zzbr.zzae((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    public final byte[] zzb(zzclk zzclk2) {
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = new byte[zzclk2.zzMl()];
            ahx ahx2 = ahx.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzclk2.zza(ahx2);
            ahx2.zzMc();
            return byArray;
        }
        catch (IOException iOException) {
            super.zzwE().zzyv().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public final boolean zzf(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(super.zzkp().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, String string, boolean bl) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    public static boolean zzw(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    public final boolean zzbv(String string) {
        super.zzjB();
        if (zzbim.zzaP((Context)super.getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        super.zzwE().zzyA().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzey(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzR(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && (i << 6) + j < bitSet.length(); ++j) {
                if (!bitSet.get((i << 6) + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length << 6) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    public final boolean zzez(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = super.zzwG().zzxZ();
        zzcfy.zzxD();
        return string2.equals(string);
    }

    static boolean zzeA(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    final boolean zzeB(String string) {
        return "1".equals(super.zzwB().zzM(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzeC(String string) {
        return "1".equals(super.zzwB().zzM(string, "measurement.upload.blacklist_public"));
    }

    final Bundle zzB(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzk(string, bundle.get(string));
                if (object == null) {
                    super.zzwE().zzyx().zzj("Param value can't be null", super.zzwz().zzdY(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzcgl zza(String string, Bundle bundle, String string2, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (this.zzer(string) != 0) {
            super.zzwE().zzyv().zzj("Invalid conditional property event name", super.zzwz().zzdZ(string));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string2);
        List<String> list = Collections.singletonList("_o");
        Bundle bundle2 = this.zza(string, bundle, list, false, false);
        Bundle bundle3 = this.zzB(bundle2);
        return new zzcgl(string, new zzcgi(bundle3), string2, l);
    }

    @WorkerThread
    final long zzJ(Context context, String string) {
        super.zzjB();
        zzbr.zzu((Object)context);
        zzbr.zzcF((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzckx.zzbE("MD5");
        if (messageDigest == null) {
            super.zzwE().zzyv().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzK(context, string)) {
                    PackageInfo packageInfo = zzbim.zzaP((Context)context).getPackageInfo(super.getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzckx.zzo(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        super.zzwE().zzyx().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                super.zzwE().zzyv().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    private final boolean zzK(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = zzbim.zzaP((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            super.zzwE().zzyv().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            super.zzwE().zzyv().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    static boolean zzd(zzcgl zzcgl2, zzcft zzcft2) {
        zzbr.zzu((Object)((Object)zzcgl2));
        zzbr.zzu((Object)((Object)zzcft2));
        if (TextUtils.isEmpty((CharSequence)zzcft2.zzboU)) {
            zzcfy.zzxD();
            return false;
        }
        return true;
    }

    @WorkerThread
    static boolean zzeD(String string) {
        zzbr.zzcF((String)string);
        switch (string) {
            case "_in": 
            case "_ui": 
            case "_ug": {
                return true;
            }
        }
        return false;
    }

    final <T extends Parcelable> T zzb(byte[] byArray, Parcelable.Creator<T> creator) {
        if (byArray == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            Parcelable parcelable = (Parcelable)creator.createFromParcel(parcel);
            return (T)parcelable;
        }
        catch (zzc zzc2) {
            super.zzwE().zzyv().log("Failed to load parcelable from buffer");
            return null;
        }
        finally {
            parcel.recycle();
        }
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Object zzD(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            object2 = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException exception) {
                return null;
            }
        }
        objectOutputStream.close();
        objectInputStream.close();
        return object2;
    }

    @Nullable
    public static String zza(String string, String[] stringArray, String[] stringArray2) {
        zzbr.zzu((Object)stringArray);
        zzbr.zzu((Object)stringArray2);
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            if (!zzckx.zzR(string, stringArray[i])) continue;
            return stringArray2[i];
        }
        return null;
    }
}

