/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzchi;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzcgf
extends zzchi {
    private ExecutorService zzbrV;
    private zzcgj zzbrW;
    private zzcgj zzbrX;
    private final PriorityBlockingQueue<FutureTask<?>> zzbrY;
    private final BlockingQueue<FutureTask<?>> zzbrZ;
    private final Thread.UncaughtExceptionHandler zzbsa;
    private final Thread.UncaughtExceptionHandler zzbsb;
    private final Object zzbsc = new Object();
    private final Semaphore zzbsd = new Semaphore(2);
    private volatile boolean zzbse;
    private static final AtomicLong zzbsf = new AtomicLong(Long.MIN_VALUE);

    zzcgf(zzcgk zzcgk2) {
        super(zzcgk2);
        this.zzbrY = new PriorityBlockingQueue();
        this.zzbrZ = new LinkedBlockingQueue();
        this.zzbsa = new zzcgh(this, "Thread death: Uncaught exception on worker thread");
        this.zzbsb = new zzcgh(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzjD() {
    }

    @Override
    public final void zzjC() {
        if (Thread.currentThread() != this.zzbrW) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzwq() {
        if (Thread.currentThread() != this.zzbrX) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzS() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzyM() {
        return Thread.currentThread() == this.zzbrW;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu(callable);
        zzcgi zzcgi2 = new zzcgi(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbrW) {
            if (!this.zzbrY.isEmpty()) {
                super.zzwF().zzyz().log("Callable skipped the worker queue.");
            }
            zzcgi2.run();
        } else {
            this.zza(zzcgi2);
        }
        return zzcgi2;
    }

    public final <V> Future<V> zzf(Callable<V> callable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu(callable);
        zzcgi zzcgi2 = new zzcgi(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbrW) {
            zzcgi2.run();
        } else {
            this.zza(zzcgi2);
        }
        return zzcgi2;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu((Object)runnable);
        this.zza(new zzcgi(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzcgi<?> zzcgi2) {
        Object object = this.zzbsc;
        synchronized (object) {
            this.zzbrY.add(zzcgi2);
            if (this.zzbrW == null) {
                this.zzbrW = new zzcgj(this, "Measurement Worker", this.zzbrY);
                this.zzbrW.setUncaughtExceptionHandler(this.zzbsa);
                this.zzbrW.start();
            } else {
                this.zzbrW.zzfF();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Runnable runnable) throws IllegalStateException {
        this.zzkD();
        zzbo.zzu((Object)runnable);
        zzcgi zzcgi2 = new zzcgi(this, runnable, false, "Task exception on network thread");
        zzcgf zzcgf2 = this;
        Object object = zzcgf2.zzbsc;
        synchronized (object) {
            zzcgf2.zzbrZ.add(zzcgi2);
            if (zzcgf2.zzbrX == null) {
                zzcgf2.zzbrX = new zzcgj(zzcgf2, "Measurement Network", zzcgf2.zzbrZ);
                zzcgf2.zzbrX.setUncaughtExceptionHandler(zzcgf2.zzbsb);
                zzcgf2.zzbrX.start();
            } else {
                zzcgf2.zzbrX.zzfF();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzyN() {
        Object object = this.zzbsc;
        synchronized (object) {
            if (this.zzbrV == null) {
                this.zzbrV = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbrV;
        }
    }

    static /* synthetic */ Semaphore zza(zzcgf zzcgf2) {
        return zzcgf2.zzbsd;
    }

    static /* synthetic */ boolean zzb(zzcgf zzcgf2) {
        return zzcgf2.zzbse;
    }

    static /* synthetic */ Object zzc(zzcgf zzcgf2) {
        return zzcgf2.zzbsc;
    }

    static /* synthetic */ zzcgj zzd(zzcgf zzcgf2) {
        return zzcgf2.zzbrW;
    }

    static /* synthetic */ zzcgj zza(zzcgf zzcgf2, zzcgj zzcgj2) {
        zzcgf2.zzbrW = null;
        return null;
    }

    static /* synthetic */ zzcgj zze(zzcgf zzcgf2) {
        return zzcgf2.zzbrX;
    }

    static /* synthetic */ zzcgj zzb(zzcgf zzcgf2, zzcgj zzcgj2) {
        zzcgf2.zzbrX = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzyO() {
        return zzbsf;
    }
}

