/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.acx;
import com.google.android.gms.internal.acy;
import com.google.android.gms.internal.zzbgz;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzces;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfg;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfm;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgm;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgo;
import com.google.android.gms.internal.zzchh;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzcgk {
    private static volatile zzcgk zzbsm;
    private final Context mContext;
    private final zzcel zzbsn;
    private final zzcfv zzbso;
    private final zzcfk zzbsp;
    private final zzcgf zzbsq;
    private final zzciz zzbsr;
    private final zzcge zzbss;
    private final AppMeasurement zzbst;
    private final FirebaseAnalytics zzbsu;
    private final zzcjk zzbsv;
    private final zzcfi zzbsw;
    private final zzcem zzbsx;
    private final zzcfg zzbsy;
    private final zzcfo zzbsz;
    private final zze zzvy;
    private final zzchy zzbsA;
    private final zzcic zzbsB;
    private final zzces zzbsC;
    private final zzchk zzbsD;
    private final zzcff zzbsE;
    private final zzcft zzbsF;
    private final zzcjf zzbsG;
    private final zzcei zzbsH;
    private final zzceb zzbsI;
    private final boolean zzafK;
    private boolean zzbsJ;
    private Boolean zzbsK;
    private long zzbsL;
    private FileLock zzbsM;
    private FileChannel zzbsN;
    private List<Long> zzbsO;
    private List<Runnable> zzbsP;
    private int zzbsQ;
    private int zzbsR;
    private long zzbsS;
    private long zzbsT;
    private boolean zzbsU;
    private boolean zzbsV;
    private boolean zzbsW;
    private final long zzbsX;

    private zzcgk(zzchj zzchj2) {
        zzceb zzceb2;
        String string;
        zzcfm zzcfm2;
        zzbo.zzu((Object)zzchj2);
        this.mContext = zzchj2.mContext;
        this.zzbsS = -1L;
        this.zzvy = zzi.zzrY();
        this.zzbsX = this.zzvy.currentTimeMillis();
        Object object = this;
        this.zzbsn = new zzcel((zzcgk)object);
        object = this;
        zzcfv zzcfv2 = new zzcfv((zzcgk)object);
        zzcfv2.initialize();
        this.zzbso = zzcfv2;
        object = this;
        zzcfk zzcfk2 = new zzcfk((zzcgk)object);
        zzcfk2.initialize();
        this.zzbsp = zzcfk2;
        this.zzwF().zzyB().zzj("App measurement is starting up, version", zzcel.zzwP());
        zzcel.zzxE();
        this.zzwF().zzyB().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcjk zzcjk2 = new zzcjk((zzcgk)object);
        zzcjk2.initialize();
        this.zzbsv = zzcjk2;
        object = this;
        zzcfi zzcfi2 = new zzcfi((zzcgk)object);
        zzcfi2.initialize();
        this.zzbsw = zzcfi2;
        object = this;
        zzces zzces2 = new zzces((zzcgk)object);
        zzces2.initialize();
        this.zzbsC = zzces2;
        object = this;
        zzcff zzcff2 = new zzcff((zzcgk)object);
        zzcff2.initialize();
        this.zzbsE = zzcff2;
        zzcel.zzxE();
        Object object2 = zzcff2.zzhl();
        if (this.zzwB().zzey((String)object2)) {
            zzcfm2 = this.zzwF().zzyB();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcfm2 = this.zzwF().zzyB();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcfm2.log(string);
        this.zzwF().zzyC().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcem((zzcgk)object);
        ((zzchi)object2).initialize();
        this.zzbsx = object2;
        object = this;
        zzcfg zzcfg2 = new zzcfg((zzcgk)object);
        zzcfg2.initialize();
        this.zzbsy = zzcfg2;
        object = this;
        zzcei zzcei2 = new zzcei((zzcgk)object);
        zzcei2.initialize();
        this.zzbsH = zzcei2;
        object = this;
        this.zzbsI = zzceb2 = new zzceb((zzcgk)object);
        object = this;
        zzcfo zzcfo2 = new zzcfo((zzcgk)object);
        zzcfo2.initialize();
        this.zzbsz = zzcfo2;
        object = this;
        zzchy zzchy2 = new zzchy((zzcgk)object);
        zzchy2.initialize();
        this.zzbsA = zzchy2;
        object = this;
        zzcic zzcic2 = new zzcic((zzcgk)object);
        zzcic2.initialize();
        this.zzbsB = zzcic2;
        object = this;
        zzchk zzchk2 = new zzchk((zzcgk)object);
        zzchk2.initialize();
        this.zzbsD = zzchk2;
        object = this;
        zzcjf zzcjf2 = new zzcjf((zzcgk)object);
        zzcjf2.initialize();
        this.zzbsG = zzcjf2;
        object = this;
        this.zzbsF = new zzcft((zzcgk)object);
        object = this;
        this.zzbst = new AppMeasurement((zzcgk)object);
        object = this;
        this.zzbsu = new FirebaseAnalytics((zzcgk)object);
        object = this;
        zzciz zzciz2 = new zzciz((zzcgk)object);
        zzciz2.initialize();
        this.zzbsr = zzciz2;
        object = this;
        zzcge zzcge2 = new zzcge((zzcgk)object);
        zzcge2.initialize();
        this.zzbss = zzcge2;
        object = this;
        zzcgf zzcgf2 = new zzcgf((zzcgk)object);
        zzcgf2.initialize();
        this.zzbsq = zzcgf2;
        if (this.zzbsQ != this.zzbsR) {
            this.zzwF().zzyx().zze("Not all components initialized", this.zzbsQ, this.zzbsR);
        }
        this.zzafK = true;
        zzcel.zzxE();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzwt();
            if (((zzchk)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzchk)object).getContext().getApplicationContext();
                if (((zzchk)object).zzbto == null) {
                    ((zzchk)object).zzbto = new zzchx((zzchk)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzchk)object).zzbto);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzchk)object).zzbto);
                ((zzchk)object).zzwF().zzyD().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzwF().zzyz().log("Application context is not an Application");
        }
        this.zzbsq.zzj(new zzcgl(this));
    }

    final void zzkD() {
        if (!this.zzafK) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzyP() {
        this.zzkD();
        this.zzwE().zzjC();
        if (this.zzbsK == null || this.zzbsL == 0L || this.zzbsK != null && !this.zzbsK.booleanValue() && Math.abs(this.zzvy.elapsedRealtime() - this.zzbsL) > 1000L) {
            this.zzbsL = this.zzvy.elapsedRealtime();
            zzcel.zzxE();
            this.zzbsK = this.zzwB().zzbv("android.permission.INTERNET") && this.zzwB().zzbv("android.permission.ACCESS_NETWORK_STATE") && (zzbgz.zzaP((Context)this.mContext).zzsl() || zzcgb.zzj(this.mContext, false) && zzciv.zzk(this.mContext, false));
            if (this.zzbsK.booleanValue()) {
                this.zzbsK = this.zzwB().zzev(this.zzwu().getGmpAppId());
            }
        }
        return this.zzbsK;
    }

    @WorkerThread
    protected final void start() {
        this.zzwE().zzjC();
        this.zzwz().zzye();
        if (this.zzwG().zzbrk.get() == 0L) {
            this.zzwG().zzbrk.set(this.zzvy.currentTimeMillis());
        }
        if (Long.valueOf(this.zzwG().zzbrp.get()) == 0L) {
            this.zzwF().zzyD().zzj("Persisting first open", this.zzbsX);
            this.zzwG().zzbrp.set(this.zzbsX);
        }
        if (!this.zzyP()) {
            if (this.isEnabled()) {
                if (!this.zzwB().zzbv("android.permission.INTERNET")) {
                    this.zzwF().zzyx().log("App is missing INTERNET permission");
                }
                if (!this.zzwB().zzbv("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzwF().zzyx().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcel.zzxE();
                if (!zzbgz.zzaP((Context)this.mContext).zzsl()) {
                    if (!zzcgb.zzj(this.mContext, false)) {
                        this.zzwF().zzyx().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzciv.zzk(this.mContext, false)) {
                        this.zzwF().zzyx().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzwF().zzyx().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcel.zzxE();
            if (!TextUtils.isEmpty((CharSequence)this.zzwu().getGmpAppId())) {
                String string = this.zzwG().zzyG();
                if (string == null) {
                    this.zzwG().zzed(this.zzwu().getGmpAppId());
                } else if (!string.equals(this.zzwu().getGmpAppId())) {
                    this.zzwF().zzyB().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzwG().zzyJ();
                    this.zzbsB.disconnect();
                    this.zzbsB.zzla();
                    this.zzwG().zzed(this.zzwu().getGmpAppId());
                    this.zzwG().zzbrp.set(this.zzbsX);
                    this.zzwG().zzbrq.zzef(null);
                }
            }
            this.zzwt().zzee(this.zzwG().zzbrq.zzyL());
            zzcel.zzxE();
            if (!TextUtils.isEmpty((CharSequence)this.zzwu().getGmpAppId())) {
                zzchk zzchk2 = this.zzwt();
                zzchk2.zzjC();
                zzchk2.zzwp();
                zzchk2.zzkD();
                if (zzchk2.zzboe.zzyP()) {
                    zzchk2.zzww().zzzk();
                    String string = zzchk2.zzwG().zzyK();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        zzchk2.zzwv().zzkD();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzchk2.zzd("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzww().zza(new AtomicReference<String>());
            }
        }
        this.zzzc();
    }

    public final zzcel zzwH() {
        return this.zzbsn;
    }

    public final zzcfv zzwG() {
        zzcgk.zza((zzchh)this.zzbso);
        return this.zzbso;
    }

    public final zzcfk zzwF() {
        zzcgk.zza(this.zzbsp);
        return this.zzbsp;
    }

    public final zzcfk zzyQ() {
        if (this.zzbsp != null && this.zzbsp.isInitialized()) {
            return this.zzbsp;
        }
        return null;
    }

    public final zzcgf zzwE() {
        zzcgk.zza(this.zzbsq);
        return this.zzbsq;
    }

    public final zzciz zzwD() {
        zzcgk.zza(this.zzbsr);
        return this.zzbsr;
    }

    public final zzcge zzwC() {
        zzcgk.zza(this.zzbss);
        return this.zzbss;
    }

    final zzcgf zzyR() {
        return this.zzbsq;
    }

    public final zzchk zzwt() {
        zzcgk.zza(this.zzbsD);
        return this.zzbsD;
    }

    public final AppMeasurement zzyS() {
        return this.zzbst;
    }

    public final FirebaseAnalytics zzyT() {
        return this.zzbsu;
    }

    public final zzcjk zzwB() {
        zzcgk.zza((zzchh)this.zzbsv);
        return this.zzbsv;
    }

    public final zzcfi zzwA() {
        zzcgk.zza((zzchh)this.zzbsw);
        return this.zzbsw;
    }

    public final zzcem zzwz() {
        zzcgk.zza(this.zzbsx);
        return this.zzbsx;
    }

    public final zzcfg zzwy() {
        zzcgk.zza(this.zzbsy);
        return this.zzbsy;
    }

    public final zzcfo zzyU() {
        zzcgk.zza(this.zzbsz);
        return this.zzbsz;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zze zzkq() {
        return this.zzvy;
    }

    public final zzchy zzwx() {
        zzcgk.zza(this.zzbsA);
        return this.zzbsA;
    }

    public final zzcic zzww() {
        zzcgk.zza(this.zzbsB);
        return this.zzbsB;
    }

    public final zzces zzwv() {
        zzcgk.zza(this.zzbsC);
        return this.zzbsC;
    }

    public final zzcff zzwu() {
        zzcgk.zza(this.zzbsE);
        return this.zzbsE;
    }

    private final zzcft zzyV() {
        if (this.zzbsF == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbsF;
    }

    private final zzcjf zzyW() {
        zzcgk.zza(this.zzbsG);
        return this.zzbsG;
    }

    public final zzcei zzws() {
        zzcgk.zza(this.zzbsH);
        return this.zzbsH;
    }

    public final zzceb zzwr() {
        zzcgk.zza(this.zzbsI);
        return this.zzbsI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzcgk zzbj(Context context) {
        zzbo.zzu((Object)context);
        zzbo.zzu((Object)context.getApplicationContext());
        if (zzbsm != null) return zzbsm;
        Class<zzcgk> clazz = zzcgk.class;
        synchronized (zzcgk.class) {
            if (zzbsm != null) return zzbsm;
            zzchj zzchj2 = new zzchj(context);
            zzbsm = new zzcgk(zzchj2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbsm;
        }
    }

    private static void zza(zzchi zzchi2) {
        if (zzchi2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzchi2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzchh zzchh2) {
        if (zzchh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzyX() {
        this.zzwE().zzjC();
        String string = zzcel.zzxC();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbsN = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbsM = this.zzbsN.tryLock();
            if (this.zzbsM != null) {
                this.zzwF().zzyD().log("Storage concurrent access okay");
                return true;
            }
            this.zzwF().zzyx().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzwF().zzyx().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzwE().zzjC();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwF().zzyx().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzwF().zzyz().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzwE().zzjC();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwF().zzyx().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzwF().zzyx().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        this.zzwE().zzjC();
        this.zzkD();
        if (this.zzbsn.zzxF()) {
            return false;
        }
        Boolean bl = this.zzbsn.zzdN("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcel.zzqB();
        return this.zzwG().zzal(bl2);
    }

    final void zzd(zzceg zzceg2) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzcF((String)zzceg2.packageName);
        this.zzf(zzceg2);
    }

    final long zzyY() {
        Long l = this.zzwG().zzbrp.get();
        if (l == 0L) {
            return this.zzbsX;
        }
        return Math.min(this.zzbsX, l);
    }

    private final long zzyZ() {
        long l = this.zzvy.currentTimeMillis();
        zzcfv zzcfv2 = this.zzwG();
        zzcfv2.zzkD();
        zzcfv2.zzjC();
        long l2 = zzcfv2.zzbro.get();
        if (l2 == 0L) {
            l2 = 1 + zzcfv2.zzwB().zzzt().nextInt(86400000);
            zzcfv2.zzbro.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzceg zzel(String string) {
        zzcef zzcef2 = this.zzwz().zzdQ(string);
        if (zzcef2 == null || TextUtils.isEmpty((CharSequence)zzcef2.zzjH())) {
            this.zzwF().zzyC().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbgz.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcef2.zzjH() != null && !zzcef2.zzjH().equals(string2)) {
                this.zzwF().zzyz().zzj("App version does not match; dropping. appId", zzcfk.zzdZ(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzceg(string, zzcef2.getGmpAppId(), zzcef2.zzjH(), zzcef2.zzwN(), zzcef2.zzwO(), zzcef2.zzwP(), zzcef2.zzwQ(), null, zzcef2.zzwR(), false, zzcef2.zzwK(), zzcef2.zzxe(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcey zzcey2, String string) {
        Object object;
        zzcef zzcef2;
        block4: {
            zzcef2 = this.zzwz().zzdQ(string);
            if (zzcef2 == null || TextUtils.isEmpty((CharSequence)zzcef2.zzjH())) {
                this.zzwF().zzyC().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbgz.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcef2.zzjH() != null && !zzcef2.zzjH().equals(object)) {
                    this.zzwF().zzyz().zzj("App version does not match; dropping event. appId", zzcfk.zzdZ(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcey2.name)) break block4;
                this.zzwF().zzyz().zzj("Could not find package. appId", zzcfk.zzdZ(string));
            }
        }
        object = new zzceg(string, zzcef2.getGmpAppId(), zzcef2.zzjH(), zzcef2.zzwN(), zzcef2.zzwO(), zzcef2.zzwP(), zzcef2.zzwQ(), null, zzcef2.zzwR(), false, zzcef2.zzwK(), zzcef2.zzxe(), 0L, 0);
        this.zzb(zzcey2, (zzceg)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcey zzcey2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzceg2));
        zzbo.zzcF((String)zzceg2.packageName);
        this.zzwE().zzjC();
        this.zzkD();
        String string = zzceg2.packageName;
        long l = zzcey2.zzbpN;
        this.zzwB();
        if (!zzcjk.zzd(zzcey2, zzceg2)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        this.zzwz().beginTransaction();
        try {
            com.google.android.gms.common.internal.safeparcel.zza zza2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcem zzcem2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzcem2.zzjC();
            zzcem2.zzkD();
            if (l2 < 0L) {
                zzcem2.zzwF().zzyz().zze("Invalid time querying timed out conditional properties", zzcfk.zzdZ(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcem2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzwF().zzyC().zzd("User property timed out", object22.packageName, this.zzwA().zzdY(object22.zzbpd.name), object22.zzbpd.getValue());
                if (object22.zzbph != null) {
                    this.zzc(new zzcey(object22.zzbph, l), zzceg2);
                }
                this.zzwz().zzI(string, object22.zzbpd.name);
            }
            l2 = l;
            string3 = string;
            zzcem2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzcem2.zzjC();
            zzcem2.zzkD();
            if (l2 < 0L) {
                zzcem2.zzwF().zzyz().zze("Invalid time querying expired conditional properties", zzcfk.zzdZ(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcem2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcej)((Object)object4.next());
                if (object == null) continue;
                this.zzwF().zzyC().zzd("User property expired", object.packageName, this.zzwA().zzdY(object.zzbpd.name), object.zzbpd.getValue());
                this.zzwz().zzF(string, object.zzbpd.name);
                if (object.zzbpl != null) {
                    object22.add(object.zzbpl);
                }
                this.zzwz().zzI(string, object.zzbpd.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcey)((Object)e);
                this.zzc(new zzcey((zzcey)((Object)object), l), zzceg2);
            }
            long l3 = l;
            String string4 = zzcey2.name;
            string3 = string;
            zzcem2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzbo.zzcF((String)string4);
            zzcem2.zzjC();
            zzcem2.zzkD();
            if (l3 < 0L) {
                zzcem2.zzwF().zzyz().zzd("Invalid time querying triggered conditional properties", zzcfk.zzdZ(string3), zzcem2.zzwA().zzdW(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcem2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zza2 = (zzcej)((Object)iterator.next());
                if (zza2 == null) continue;
                zzcjh zzcjh2 = zza2.zzbpd;
                zzcjj zzcjj2 = new zzcjj(zza2.packageName, zza2.zzbpc, zzcjh2.name, l, zzcjh2.getValue());
                if (this.zzwz().zza(zzcjj2)) {
                    this.zzwF().zzyC().zzd("User property triggered", zza2.packageName, this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                } else {
                    this.zzwF().zzyx().zzd("Too many active user properties, ignoring", zzcfk.zzdZ(zza2.packageName), this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                }
                if (zza2.zzbpj != null) {
                    object.add(zza2.zzbpj);
                }
                zza2.zzbpd = new zzcjh(zzcjj2);
                zza2.zzbpf = true;
                this.zzwz().zza((zzcej)zza2);
            }
            this.zzc(zzcey2, zzceg2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zza2 = (zzcey)((Object)e);
                this.zzc(new zzcey((zzcey)zza2, l), zzceg2);
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcey zzcey2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzceg2));
        zzbo.zzcF((String)zzceg2.packageName);
        long l = System.nanoTime();
        this.zzwE().zzjC();
        this.zzkD();
        String string = zzceg2.packageName;
        this.zzwB();
        if (!zzcjk.zzd(zzcey2, zzceg2)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        if (this.zzwC().zzN(string, zzcey2.name)) {
            this.zzwF().zzyz().zze("Dropping blacklisted event. appId", zzcfk.zzdZ(string), this.zzwA().zzdW(zzcey2.name));
            boolean bl = this.zzwB().zzeA(string) || this.zzwB().zzeB(string);
            if (!bl && !"_err".equals(zzcey2.name)) {
                this.zzwB().zza(string, 11, "_ev", zzcey2.name, 0);
            }
            if (!bl) return;
            zzcef zzcef2 = this.zzwz().zzdQ(string);
            if (zzcef2 == null) return;
            long l2 = Math.max(zzcef2.zzwU(), zzcef2.zzwT());
            if (Math.abs(this.zzvy.currentTimeMillis() - l2) <= zzcel.zzxI()) return;
            this.zzwF().zzyC().log("Fetching config for blacklisted app");
            this.zzb(zzcef2);
            return;
        }
        if (this.zzwF().zzz(2)) {
            this.zzwF().zzyD().zzj("Logging event", this.zzwA().zzb(zzcey2));
        }
        this.zzwz().beginTransaction();
        try {
            zzceu zzceu2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcey2.zzbpM.zzyt();
            this.zzf(zzceg2);
            if ("_iap".equals(zzcey2.name) || "ecommerce_purchase".equals(zzcey2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcey2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzwF().zzyz().zze("Data lost. Currency value is too big. appId", zzcfk.zzdZ(string), d);
                            this.zzwz().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcjj zzcjj2 = this.zzwz().zzG(string, string6);
                    if (zzcjj2 == null || !(zzcjj2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzbsn.zzb(string2, zzcfa.zzbqz) - 1;
                        string2 = string;
                        zzcem zzcem2 = this.zzwz();
                        zzbo.zzcF((String)string2);
                        zzcem2.zzjC();
                        zzcem2.zzkD();
                        try {
                            zzcem2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcem2.zzwF().zzyx().zze("Error pruning currencies. appId", zzcfk.zzdZ(string2), (Object)sQLiteException);
                        }
                        zzcjj2 = new zzcjj(string, zzcey2.zzbpc, string6, this.zzvy.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcjj2.mValue;
                        zzcjj2 = new zzcjj(string, zzcey2.zzbpc, string6, this.zzvy.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzwz().zza(zzcjj2)) {
                        this.zzwF().zzyx().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcfk.zzdZ(string), this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                        this.zzwB().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcjk.zzeo(zzcey2.name);
            boolean bl2 = "_err".equals(zzcey2.name);
            zzcen zzcen2 = this.zzwz().zza(this.zzyZ(), string, true, bl, false, bl2, false);
            long l5 = zzcen2.zzbpv - zzcel.zzxq();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwF().zzyx().zze("Data loss. Too many events logged. appId, count", zzcfk.zzdZ(string), zzcen2.zzbpv);
                }
                this.zzwz().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcen2.zzbpu - zzcel.zzxr()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwF().zzyx().zze("Data loss. Too many public events logged. appId, count", zzcfk.zzdZ(string), zzcen2.zzbpu);
                }
                this.zzwB().zza(string, 16, "_ev", zzcey2.name, 0);
                this.zzwz().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzceg2.packageName;
                n = this.zzbsn.zzb(string2, zzcfa.zzbqg);
                l5 = zzcen2.zzbpx - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzwF().zzyx().zze("Too many error events logged. appId, count", zzcfk.zzdZ(string), zzcen2.zzbpx);
                    }
                    this.zzwz().setTransactionSuccessful();
                    return;
                }
            }
            this.zzwB().zza(bundle, "_o", (Object)zzcey2.zzbpc);
            if (this.zzwB().zzey(string)) {
                this.zzwB().zza(bundle, "_dbg", 1L);
                this.zzwB().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzwz().zzdR(string)) > 0L) {
                this.zzwF().zzyz().zze("Data lost. Too many events stored on disk, deleted. appId", zzcfk.zzdZ(string), l3);
            }
            zzcet zzcet2 = new zzcet(this, zzcey2.zzbpc, string, zzcey2.name, zzcey2.zzbpN, 0L, bundle);
            zzceu zzceu3 = this.zzwz().zzE(string, zzcet2.mName);
            if (zzceu3 == null) {
                long l6 = this.zzwz().zzdU(string);
                zzcel.zzxp();
                if (l6 >= 500L) {
                    this.zzwF().zzyx().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcfk.zzdZ(string), this.zzwA().zzdW(zzcet2.mName), zzcel.zzxp());
                    this.zzwB().zza(string, 8, null, null, 0);
                    return;
                }
                zzceu2 = new zzceu(string, zzcet2.mName, 0L, 0L, zzcet2.zzayS);
            } else {
                zzcet2 = zzcet2.zza(this, zzceu3.zzbpI);
                zzceu2 = zzceu3.zzab(zzcet2.zzayS);
            }
            this.zzwz().zza(zzceu2);
            this.zza(zzcet2, zzceg2);
            this.zzwz().setTransactionSuccessful();
            if (this.zzwF().zzz(2)) {
                this.zzwF().zzyD().zzj("Event recorded", this.zzwA().zza(zzcet2));
            }
        }
        finally {
            this.zzwz().endTransaction();
        }
        this.zzzc();
        this.zzwF().zzyD().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcej zzcej2) {
        zzceg zzceg2 = this.zzel(zzcej2.packageName);
        if (zzceg2 != null) {
            this.zzb(zzcej2, zzceg2);
        }
    }

    @WorkerThread
    final void zzb(zzcej zzcej2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzcej2));
        zzbo.zzcF((String)zzcej2.packageName);
        zzbo.zzu((Object)zzcej2.zzbpc);
        zzbo.zzu((Object)((Object)zzcej2.zzbpd));
        zzbo.zzcF((String)zzcej2.zzbpd.name);
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        zzcej zzcej3 = new zzcej(zzcej2);
        new zzcej(zzcej2).zzbpf = false;
        this.zzwz().beginTransaction();
        try {
            boolean bl = false;
            zzcej zzcej4 = this.zzwz().zzH(zzcej3.packageName, zzcej3.zzbpd.name);
            if (zzcej4 != null && !zzcej4.zzbpc.equals(zzcej3.zzbpc)) {
                this.zzwF().zzyz().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzwA().zzdY(zzcej3.zzbpd.name), zzcej3.zzbpc, zzcej4.zzbpc);
            }
            if (zzcej4 != null && zzcej4.zzbpf) {
                zzcej3.zzbpc = zzcej4.zzbpc;
                zzcej3.zzbpe = zzcej4.zzbpe;
                zzcej3.zzbpi = zzcej4.zzbpi;
                zzcej3.zzbpg = zzcej4.zzbpg;
                zzcej3.zzbpj = zzcej4.zzbpj;
                zzcej3.zzbpf = zzcej4.zzbpf;
                zzcej3.zzbpd = new zzcjh(zzcej3.zzbpd.name, zzcej4.zzbpd.zzbuy, zzcej3.zzbpd.getValue(), zzcej4.zzbpd.zzbpc);
            } else if (TextUtils.isEmpty((CharSequence)zzcej3.zzbpg)) {
                zzcej3.zzbpd = new zzcjh(zzcej3.zzbpd.name, zzcej3.zzbpe, zzcej3.zzbpd.getValue(), zzcej3.zzbpd.zzbpc);
                zzcej3.zzbpf = true;
                bl = true;
            }
            if (zzcej3.zzbpf) {
                zzcjh zzcjh2 = zzcej3.zzbpd;
                zzcjj zzcjj2 = new zzcjj(zzcej3.packageName, zzcej3.zzbpc, zzcjh2.name, zzcjh2.zzbuy, zzcjh2.getValue());
                if (this.zzwz().zza(zzcjj2)) {
                    this.zzwF().zzyC().zzd("User property updated immediately", zzcej3.packageName, this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                } else {
                    this.zzwF().zzyx().zzd("(2)Too many active user properties, ignoring", zzcfk.zzdZ(zzcej3.packageName), this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                }
                if (bl && zzcej3.zzbpj != null) {
                    zzcey zzcey2 = new zzcey(zzcej3.zzbpj, zzcej3.zzbpe);
                    this.zzc(zzcey2, zzceg2);
                }
            }
            if (this.zzwz().zza(zzcej3)) {
                this.zzwF().zzyC().zzd("Conditional property added", zzcej3.packageName, this.zzwA().zzdY(zzcej3.zzbpd.name), zzcej3.zzbpd.getValue());
            } else {
                this.zzwF().zzyx().zzd("Too many conditional properties, ignoring", zzcfk.zzdZ(zzcej3.packageName), this.zzwA().zzdY(zzcej3.zzbpd.name), zzcej3.zzbpd.getValue());
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcej zzcej2) {
        zzceg zzceg2 = this.zzel(zzcej2.packageName);
        if (zzceg2 != null) {
            this.zzc(zzcej2, zzceg2);
        }
    }

    @WorkerThread
    final void zzc(zzcej zzcej2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzcej2));
        zzbo.zzcF((String)zzcej2.packageName);
        zzbo.zzu((Object)((Object)zzcej2.zzbpd));
        zzbo.zzcF((String)zzcej2.zzbpd.name);
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceg2);
            zzcej zzcej3 = this.zzwz().zzH(zzcej2.packageName, zzcej2.zzbpd.name);
            if (zzcej3 != null) {
                this.zzwF().zzyC().zze("Removing conditional user property", zzcej2.packageName, this.zzwA().zzdY(zzcej2.zzbpd.name));
                this.zzwz().zzI(zzcej2.packageName, zzcej2.zzbpd.name);
                if (zzcej3.zzbpf) {
                    this.zzwz().zzF(zzcej2.packageName, zzcej2.zzbpd.name);
                }
                if (zzcej2.zzbpl != null) {
                    Bundle bundle = null;
                    if (zzcej2.zzbpl.zzbpM != null) {
                        bundle = zzcej2.zzbpl.zzbpM.zzyt();
                    }
                    zzcey zzcey2 = this.zzwB().zza(zzcej2.zzbpl.name, bundle, zzcej3.zzbpc, zzcej2.zzbpl.zzbpN, true, false);
                    this.zzc(zzcey2, zzceg2);
                }
            } else {
                this.zzwF().zzyz().zze("Conditional user property doesn't exist", zzcfk.zzdZ(zzcej2.packageName), this.zzwA().zzdY(zzcej2.zzbpd.name));
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcey zzcey2, @Size(min=1L) String string) {
        Object object;
        this.zzkD();
        this.zzwE().zzjC();
        zzcgk.zzwo();
        zzbo.zzu((Object)((Object)zzcey2));
        zzbo.zzcF((String)string);
        zzcjx zzcjx2 = new zzcjx();
        this.zzwz().beginTransaction();
        try {
            zzceu zzceu2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcef zzcef2 = this.zzwz().zzdQ(string);
            if (zzcef2 == null) {
                this.zzwF().zzyC().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcef2.zzwR()) {
                this.zzwF().zzyC().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcjy();
            zzcjx2.zzbvB = new zzcjy[]{object};
            object.zzbvD = 1;
            object.zzbvL = "android";
            object.zzaJ = zzcef2.zzhl();
            object.zzboR = zzcef2.zzwO();
            object.zzbgW = zzcef2.zzjH();
            long l2 = zzcef2.zzwN();
            object.zzbvY = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzbvP = zzcef2.zzwP();
            object.zzboQ = zzcef2.getGmpAppId();
            object.zzbvU = zzcef2.zzwQ();
            if (this.isEnabled() && zzcel.zzyb() && this.zzbsn.zzdO(object.zzaJ)) {
                this.zzwu();
                object.zzbwd = null;
            }
            if ((pair = this.zzwG().zzeb(zzcef2.zzhl())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzbvR = (String)pair.first;
                object.zzbvS = (Boolean)pair.second;
            }
            this.zzwv().zzkD();
            object.zzbvM = Build.MODEL;
            this.zzwv().zzkD();
            object.zzba = Build.VERSION.RELEASE;
            object.zzbvO = (int)this.zzwv().zzyq();
            object.zzbvN = this.zzwv().zzyr();
            object.zzbvT = zzcef2.getAppInstanceId();
            object.zzboY = zzcef2.zzwK();
            List<zzcjj> list = this.zzwz().zzdP(zzcef2.zzhl());
            object.zzbvF = new zzcka[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcka();
                object.zzbvF[i] = object2;
                ((zzcka)((Object)object2)).name = list.get((int)i).mName;
                ((zzcka)((Object)object2)).zzbwh = list.get((int)i).zzbuC;
                this.zzwB().zza((zzcka)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcey2.zzbpM.zzyt();
            if ("_iap".equals(zzcey2.name)) {
                bundle.putLong("_c", 1L);
                this.zzwF().zzyC().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcey2.zzbpc);
            if (this.zzwB().zzey(object.zzaJ)) {
                this.zzwB().zza(bundle, "_dbg", 1L);
                this.zzwB().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzwz().zzE(string, zzcey2.name)) == null) {
                l = 0L;
                zzceu2 = new zzceu(string, zzcey2.name, 1L, 0L, zzcey2.zzbpN);
                this.zzwz().zza(zzceu2);
            } else {
                l = ((zzceu)object2).zzbpI;
                zzceu2 = ((zzceu)object2).zzab(zzcey2.zzbpN).zzys();
                this.zzwz().zza(zzceu2);
            }
            zzcet zzcet2 = new zzcet(this, zzcey2.zzbpc, string, zzcey2.name, zzcey2.zzbpN, l, bundle);
            zzcjv zzcjv2 = new zzcjv();
            object.zzbvE = new zzcjv[]{zzcjv2};
            zzcjv2.zzbvx = zzcet2.zzayS;
            zzcjv2.name = zzcet2.mName;
            zzcjv2.zzbvy = zzcet2.zzbpE;
            zzcjv2.zzbvw = new zzcjw[zzcet2.zzbpF.size()];
            int n = 0;
            for (String string2 : zzcet2.zzbpF) {
                zzcjw zzcjw2 = new zzcjw();
                zzcjv2.zzbvw[n++] = zzcjw2;
                zzcjw2.name = string2;
                Object object3 = zzcet2.zzbpF.get(string2);
                this.zzwB().zza(zzcjw2, object3);
            }
            object.zzbvX = this.zza(zzcef2.zzhl(), object.zzbvF, object.zzbvE);
            object.zzbvH = zzcjv2.zzbvx;
            object.zzbvI = zzcjv2.zzbvx;
            long l3 = zzcef2.zzwM();
            object.zzbvK = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcef2.zzwL();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzbvJ = l4 != 0L ? Long.valueOf(l4) : null;
            zzcef2.zzwV();
            object.zzbvV = (int)zzcef2.zzwS();
            object.zzbvQ = zzcel.zzwP();
            object.zzbvG = this.zzvy.currentTimeMillis();
            object.zzbvW = Boolean.TRUE;
            zzcef2.zzL(object.zzbvH);
            zzcef2.zzM(object.zzbvI);
            this.zzwz().zza(zzcef2);
            this.zzwz().setTransactionSuccessful();
        }
        finally {
            this.zzwz().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcjx2.zzLT()];
            object = byArray;
            byte[] byArray2 = byArray;
            acy acy2 = acy.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjx2.zza(acy2);
            acy2.zzLK();
            return this.zzwB().zzl((byte[])object);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to bundle and serialize. appId", zzcfk.zzdZ(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcet var1_1, zzceg var2_2) {
        block10: {
            this.zzwE().zzjC();
            this.zzkD();
            zzbo.zzu((Object)var1_1);
            zzbo.zzu((Object)var2_2);
            zzbo.zzcF((String)var1_1.mAppId);
            zzbo.zzaf((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcjy();
            new zzcjy().zzbvD = 1;
            var3_3.zzbvL = "android";
            var3_3.zzaJ = var2_2.packageName;
            var3_3.zzboR = var2_2.zzboR;
            var3_3.zzbgW = var2_2.zzbgW;
            var3_3.zzbvY = var2_2.zzboX == -2147483648L ? null : Integer.valueOf((int)var2_2.zzboX);
            var3_3.zzbvP = var2_2.zzboS;
            var3_3.zzboQ = var2_2.zzboQ;
            var3_3.zzbvU = var2_2.zzboT == 0L ? null : Long.valueOf(var2_2.zzboT);
            var4_4 = this.zzwG().zzeb(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzbvR = (String)var4_4.first;
                var3_3.zzbvS = (Boolean)var4_4.second;
            }
            this.zzwv().zzkD();
            var3_3.zzbvM = Build.MODEL;
            this.zzwv().zzkD();
            var3_3.zzba = Build.VERSION.RELEASE;
            var3_3.zzbvO = (int)this.zzwv().zzyq();
            var3_3.zzbvN = this.zzwv().zzyr();
            var3_3.zzbvQ = null;
            var3_3.zzbvG = null;
            var3_3.zzbvH = null;
            var3_3.zzbvI = null;
            var3_3.zzbwc = var2_2.zzboZ;
            if (this.isEnabled() && zzcel.zzyb()) {
                this.zzwu();
                var3_3.zzbwd = null;
            }
            if ((var5_5 = this.zzwz().zzdQ(var2_2.packageName)) == null) {
                var5_5 = new zzcef(this, var2_2.packageName);
                var5_5.zzdG(this.zzwu().zzyu());
                var5_5.zzdJ(var2_2.zzboY);
                var5_5.zzdH(var2_2.zzboQ);
                var5_5.zzdI(this.zzwG().zzec(var2_2.packageName));
                var5_5.zzQ(0L);
                var5_5.zzL(0L);
                var5_5.zzM(0L);
                var5_5.setAppVersion(var2_2.zzbgW);
                var5_5.zzN(var2_2.zzboX);
                var5_5.zzdK(var2_2.zzboR);
                var5_5.zzO(var2_2.zzboS);
                var5_5.zzP(var2_2.zzboT);
                var5_5.setMeasurementEnabled(var2_2.zzboV);
                var5_5.zzZ(var2_2.zzboZ);
                this.zzwz().zza(var5_5);
            }
            var3_3.zzbvT = var5_5.getAppInstanceId();
            var3_3.zzboY = var5_5.zzwK();
            var6_6 = this.zzwz().zzdP(var2_2.packageName);
            var3_3.zzbvF = new zzcka[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzbvF[var7_7] = var8_9 = new zzcka();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzbwh = var6_6.get((int)var7_7).zzbuC;
                this.zzwB().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzwz().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzwF().zzyx().zze("Data loss. Failed to insert raw event metadata. appId", zzcfk.zzdZ(var3_3.zzaJ), var9_10);
                return;
            }
            v0 = this.zzwz();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzbpF == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzbpF) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block10;
            }
            var12_14 = var10_12.zzwC().zzO(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzwz().zza(var10_12.zzyZ(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzbpy < (long)var10_12.zzbsn.zzdM(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzbsT = 0L;
        }
    }

    public final String zzem(String string) {
        Future<String> future = this.zzwE().zze(new zzcgm(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzwF().zzyx().zze("Failed to get app instance id. appId", zzcfk.zzdZ(string), exception);
            return null;
        }
    }

    static void zzwo() {
        zzcel.zzxE();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcjh zzcjh2, zzceg zzceg2) {
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        int n = this.zzwB().zzes(zzcjh2.name);
        if (n != 0) {
            this.zzwB();
            String string = zzcjk.zza(zzcjh2.name, zzcel.zzxi(), true);
            int n2 = zzcjh2.name != null ? zzcjh2.name.length() : 0;
            this.zzwB().zza(zzceg2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzwB().zzl(zzcjh2.name, zzcjh2.getValue());
        if (n != 0) {
            this.zzwB();
            String string = zzcjk.zza(zzcjh2.name, zzcel.zzxi(), true);
            Object object = zzcjh2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzwB().zza(zzceg2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzwB().zzm(zzcjh2.name, zzcjh2.getValue());
        if (object == null) {
            return;
        }
        zzcjj zzcjj2 = new zzcjj(zzceg2.packageName, zzcjh2.zzbpc, zzcjh2.name, zzcjh2.zzbuy, object);
        this.zzwF().zzyC().zze("Setting user property", this.zzwA().zzdY(zzcjj2.mName), object);
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceg2);
            boolean bl = this.zzwz().zza(zzcjj2);
            this.zzwz().setTransactionSuccessful();
            if (bl) {
                this.zzwF().zzyC().zze("User property set", this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
            } else {
                this.zzwF().zzyx().zze("Too many unique user properties are set. Ignoring user property", this.zzwA().zzdY(zzcjj2.mName), zzcjj2.mValue);
                this.zzwB().zza(zzceg2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcjh zzcjh2, zzceg zzceg2) {
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            return;
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        this.zzwF().zzyC().zzj("Removing user property", this.zzwA().zzdY(zzcjh2.name));
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceg2);
            this.zzwz().zzF(zzceg2.packageName, zzcjh2.name);
            this.zzwz().setTransactionSuccessful();
            this.zzwF().zzyC().zzj("User property removed", this.zzwA().zzdY(zzcjh2.name));
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    public final void zzza() {
        this.zzwE().zzjC();
        this.zzkD();
        this.zzbsW = true;
        try {
            String string;
            zzcel.zzxE();
            Boolean bl = this.zzwG().zzyI();
            if (bl == null) {
                this.zzwF().zzyz().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzwF().zzyx().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzbsT > 0L) {
                this.zzzc();
                return;
            }
            Object object = this;
            ((zzcgk)object).zzwE().zzjC();
            if (((zzcgk)object).zzbsO != null) {
                this.zzwF().zzyD().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzyU().zzlQ()) {
                this.zzwF().zzyD().log("Network not connected, ignoring upload request");
                this.zzzc();
                return;
            }
            long l = this.zzvy.currentTimeMillis();
            long l2 = l - zzcel.zzxP();
            this.zzg(null, l2);
            long l3 = this.zzwG().zzbrk.get();
            if (l3 != 0L) {
                this.zzwF().zzyC().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzwz().zzyc()))) {
                if (this.zzbsS == -1L) {
                    this.zzbsS = this.zzwz().zzyj();
                }
                Object object2 = string;
                int n = this.zzbsn.zzb((String)object2, zzcfa.zzbqb);
                object2 = string;
                object = this.zzbsn;
                int n2 = Math.max(0, ((zzcel)object).zzb((String)object2, zzcfa.zzbqc));
                List<Pair<zzcjy, Long>> list = this.zzwz().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcjy zzcjy2 = (zzcjy)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcjy2.zzbvR)) continue;
                        string2 = zzcjy2.zzbvR;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcjy)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcjy)((Object)object3)).zzbvR) || ((zzcjy)((Object)object3)).zzbvR.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcjx();
                    new zzcjx().zzbvB = new zzcjy[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcel.zzyb() && this.zzbsn.zzdO(string);
                    for (int i = 0; i < ((zzcjx)((Object)object4)).zzbvB.length; ++i) {
                        ((zzcjx)((Object)object4)).zzbvB[i] = (zzcjy)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcjx)((Object)object4)).zzbvB[i].zzbvQ = zzcel.zzwP();
                        ((zzcjx)((Object)object4)).zzbvB[i].zzbvG = l;
                        ((zzcjx)((Object)object4)).zzbvB[i].zzbvW = zzcel.zzxE();
                        if (bl2) continue;
                        ((zzcjx)((Object)object4)).zzbvB[i].zzbwd = null;
                    }
                    String string3 = null;
                    if (this.zzwF().zzz(2)) {
                        string3 = this.zzwA().zza((zzcjx)((Object)object4));
                    }
                    byte[] byArray = this.zzwB().zzb((zzcjx)((Object)object4));
                    String string4 = zzcel.zzxO();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbo.zzaf((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzcgk)object).zzbsO != null) {
                            ((zzcgk)object).zzwF().zzyx().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzcgk)object).zzbsO = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzwG().zzbrl.set(l);
                        String string5 = "?";
                        if (((zzcjx)((Object)object4)).zzbvB.length > 0) {
                            string5 = ((zzcjx)((Object)object4)).zzbvB[0].zzaJ;
                        }
                        this.zzwF().zzyD().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzbsV = true;
                        this.zzyU().zza(string, uRL, byArray, null, new zzcgn(this));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzwF().zzyx().zze("Failed to parse upload URL. Not uploading. appId", zzcfk.zzdZ(string), string4);
                    }
                }
            } else {
                zzcef zzcef2;
                this.zzbsS = -1L;
                String string6 = this.zzwz().zzaa(l - zzcel.zzxP());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcef2 = this.zzwz().zzdQ(string6)) != null) {
                    this.zzb(zzcef2);
                }
            }
            return;
        }
        finally {
            this.zzbsW = false;
            this.zzzg();
        }
    }

    @WorkerThread
    private final void zzb(zzcef zzcef2) {
        this.zzwE().zzjC();
        if (TextUtils.isEmpty((CharSequence)zzcef2.getGmpAppId())) {
            this.zzb(zzcef2.zzhl(), 204, null, null, null);
            return;
        }
        String string = zzcef2.getAppInstanceId();
        String string2 = zzcef2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string2);
        builder.scheme(zzcfa.zzbpZ.get()).encodedAuthority(zzcfa.zzbqa.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11011");
        String string4 = builder.build().toString();
        try {
            URL uRL = new URL(string4);
            this.zzwF().zzyD().zzj("Fetching remote configuration", zzcef2.zzhl());
            zzcjs zzcjs2 = this.zzwC().zzeh(zzcef2.zzhl());
            ArrayMap arrayMap = null;
            String string5 = this.zzwC().zzei(zzcef2.zzhl());
            if (zzcjs2 != null && !TextUtils.isEmpty((CharSequence)string5)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string5);
            }
            this.zzbsU = true;
            this.zzyU().zza(zzcef2.zzhl(), uRL, (Map<String, String>)arrayMap, new zzcgo(this));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzwF().zzyx().zze("Failed to parse config URL. Not fetching. appId", zzcfk.zzdZ(zzcef2.zzhl()), string4);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzwz().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzbsS;
                    long l3 = l;
                    string2 = null;
                    object = this.zzwz();
                    zzbo.zzu((Object)zza3);
                    ((zzchh)object).zzjC();
                    ((zzchi)object).zzkD();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcem)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzchh)object).zzwF().zzyx().zzj("Raw event metadata record is missing. appId", zzcfk.zzdZ(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = acx.zzb((byte[])byArray, (int)0, (int)byArray.length);
                        zzcjy zzcjy2 = new zzcjy();
                        try {
                            zzcjy2.zza((acx)string5);
                        }
                        catch (IOException iOException) {
                            ((zzchh)object).zzwF().zzyx().zze("Data loss. Failed to merge raw event metadata. appId", zzcfk.zzdZ(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzchh)object).zzwF().zzyz().zzj("Get multiple raw event metadata records, expected one. appId", zzcfk.zzdZ(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcjy2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzchh)object).zzwF().zzyz().zzj("Raw event data disappeared while in transaction. appId", zzcfk.zzdZ(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = acx.zzb((byte[])byArray, (int)0, (int)byArray.length);
                            zzcjv zzcjv2 = new zzcjv();
                            try {
                                zzcjv2.zza((acx)string5);
                            }
                            catch (IOException iOException) {
                                ((zzchh)object).zzwF().zzyx().zze("Data loss. Failed to merge raw event. appId", zzcfk.zzdZ(string2), iOException);
                                continue;
                            }
                            zzcjv2.name = cursor.getString(1);
                            zzcjv2.zzbvx = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcjv2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zztJ == null || ((zza)object).zztJ.isEmpty()) break block69;
                boolean bl = false;
                zzcjy zzcjy3 = zza2.zzbsZ;
                zza2.zzbsZ.zzbvE = new zzcjv[zza2.zztJ.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zztJ.size(); ++n) {
                    block71: {
                        zzcjw[] zzcjwArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzwC().zzN(zza2.zzbsZ.zzaJ, zza2.zztJ.get((int)n).name)) {
                                this.zzwF().zzyz().zze("Dropping blacklisted raw event. appId", zzcfk.zzdZ(zza2.zzbsZ.zzaJ), this.zzwA().zzdW(zza2.zztJ.get((int)n).name));
                                if (this.zzwB().zzeA(zza2.zzbsZ.zzaJ) || this.zzwB().zzeB(zza2.zzbsZ.zzaJ) || "_err".equals(zza2.zztJ.get((int)n).name)) continue;
                                this.zzwB().zza(zza2.zzbsZ.zzaJ, 11, "_ev", zza2.zztJ.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzwC().zzO(zza2.zzbsZ.zzaJ, zza2.zztJ.get((int)n).name);
                            if (bl2) break block70;
                            this.zzwB();
                            if (!zzcjk.zzeC(zza2.zztJ.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zztJ.get((int)n).zzbvw == null) {
                            zza2.zztJ.get((int)n).zzbvw = new zzcjw[0];
                        }
                        zzcjw[] zzcjwArray2 = zza2.zztJ.get((int)n).zzbvw;
                        int n4 = zza2.zztJ.get((int)n).zzbvw.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcjwArray = zzcjwArray2[n3];
                            if ("_c".equals(zzcjwArray.name)) {
                                zzcjwArray.zzbvA = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcjwArray.name)) continue;
                            zzcjwArray.zzbvA = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzwF().zzyD().zzj("Marking event as conversion", this.zzwA().zzdW(zza2.zztJ.get((int)n).name));
                            zzcjwArray2 = Arrays.copyOf(zza2.zztJ.get((int)n).zzbvw, zza2.zztJ.get((int)n).zzbvw.length + 1);
                            zzcjw zzcjw2 = new zzcjw();
                            new zzcjw().name = "_c";
                            zzcjw2.zzbvA = 1L;
                            zzcjwArray2[zzcjwArray2.length - 1] = zzcjw2;
                            zza2.zztJ.get((int)n).zzbvw = zzcjwArray2;
                        }
                        if (!bl5) {
                            this.zzwF().zzyD().zzj("Marking event as real-time", this.zzwA().zzdW(zza2.zztJ.get((int)n).name));
                            zzcjwArray2 = Arrays.copyOf(zza2.zztJ.get((int)n).zzbvw, zza2.zztJ.get((int)n).zzbvw.length + 1);
                            zzcjw zzcjw3 = new zzcjw();
                            new zzcjw().name = "_r";
                            zzcjw3.zzbvA = 1L;
                            zzcjwArray2[zzcjwArray2.length - 1] = zzcjw3;
                            zza2.zztJ.get((int)n).zzbvw = zzcjwArray2;
                        }
                        bl = true;
                        if (this.zzwz().zza((long)this.zzyZ(), (String)zza2.zzbsZ.zzaJ, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzbpy > (long)this.zzbsn.zzdM(zza2.zzbsZ.zzaJ)) {
                            zzcjv zzcjv3 = zza2.zztJ.get(n);
                            for (n3 = 0; n3 < zzcjv3.zzbvw.length; ++n3) {
                                if (!"_r".equals(zzcjv3.zzbvw[n3].name)) continue;
                                zzcjwArray = new zzcjw[zzcjv3.zzbvw.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcjv3.zzbvw, 0, zzcjwArray, 0, n3);
                                }
                                if (n3 < zzcjwArray.length) {
                                    System.arraycopy(zzcjv3.zzbvw, n3 + 1, zzcjwArray, n3, zzcjwArray.length - n3);
                                }
                                zzcjv3.zzbvw = zzcjwArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcjk.zzeo(zza2.zztJ.get((int)n).name) && bl2 && this.zzwz().zza((long)this.zzyZ(), (String)zza2.zzbsZ.zzaJ, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzbpw > (long)this.zzbsn.zzb(string2 = zza2.zzbsZ.zzaJ, zzcfa.zzbqi)) {
                            this.zzwF().zzyz().zzj("Too many conversions. Not logging as conversion. appId", zzcfk.zzdZ(zza2.zzbsZ.zzaJ));
                            zzcjv zzcjv4 = zza2.zztJ.get(n);
                            boolean bl6 = false;
                            zzcjw zzcjw4 = null;
                            zzcjw[] zzcjwArray3 = zzcjv4.zzbvw;
                            int n5 = zzcjv4.zzbvw.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcjw zzcjw5 = zzcjwArray3[i];
                                if ("_c".equals(zzcjw5.name)) {
                                    zzcjw4 = zzcjw5;
                                    continue;
                                }
                                if (!"_err".equals(zzcjw5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcjw4 != null) {
                                zzcjwArray3 = new zzcjw[zzcjv4.zzbvw.length - 1];
                                n5 = 0;
                                zzcjw[] zzcjwArray4 = zzcjv4.zzbvw;
                                int n6 = zzcjv4.zzbvw.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcjw zzcjw6 = zzcjwArray4[i];
                                    if (zzcjw6 == zzcjw4) continue;
                                    zzcjwArray3[n5++] = zzcjw6;
                                }
                                zzcjv4.zzbvw = zzcjwArray3;
                            } else if (zzcjw4 != null) {
                                zzcjw4.name = "_err";
                                zzcjw4.zzbvA = 10L;
                            } else {
                                this.zzwF().zzyx().zzj("Did not find conversion parameter. appId", zzcfk.zzdZ(zza2.zzbsZ.zzaJ));
                            }
                        }
                    }
                    zzcjy3.zzbvE[n2++] = zza2.zztJ.get(n);
                }
                if (n2 < zza2.zztJ.size()) {
                    zzcjy3.zzbvE = Arrays.copyOf(zzcjy3.zzbvE, n2);
                }
                zzcjy3.zzbvX = this.zza(zza2.zzbsZ.zzaJ, zza2.zzbsZ.zzbvF, zzcjy3.zzbvE);
                zzcjy3.zzbvH = Long.MAX_VALUE;
                zzcjy3.zzbvI = Long.MIN_VALUE;
                for (n = 0; n < zzcjy3.zzbvE.length; ++n) {
                    zzcjv zzcjv5 = zzcjy3.zzbvE[n];
                    if (zzcjv5.zzbvx < zzcjy3.zzbvH) {
                        zzcjy3.zzbvH = zzcjv5.zzbvx;
                    }
                    if (zzcjv5.zzbvx <= zzcjy3.zzbvI) continue;
                    zzcjy3.zzbvI = zzcjv5.zzbvx;
                }
                String string6 = zza2.zzbsZ.zzaJ;
                zzcef zzcef2 = this.zzwz().zzdQ(string6);
                if (zzcef2 == null) {
                    this.zzwF().zzyx().zzj("Bundling raw events w/o app info. appId", zzcfk.zzdZ(zza2.zzbsZ.zzaJ));
                } else if (zzcjy3.zzbvE.length > 0) {
                    long l5 = zzcef2.zzwM();
                    zzcjy3.zzbvK = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcef2.zzwL();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcjy3.zzbvJ = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcef2.zzwV();
                    zzcjy3.zzbvV = (int)zzcef2.zzwS();
                    zzcef2.zzL(zzcjy3.zzbvH);
                    zzcef2.zzM(zzcjy3.zzbvI);
                    zzcjy3.zzboU = zzcef2.zzxd();
                    this.zzwz().zza(zzcef2);
                }
                if (zzcjy3.zzbvE.length > 0) {
                    zzcel.zzxE();
                    zzcjs zzcjs2 = this.zzwC().zzeh(zza2.zzbsZ.zzaJ);
                    if (zzcjs2 == null || zzcjs2.zzbvl == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzbsZ.zzboQ)) {
                            zzcjy3.zzbwb = -1L;
                        } else {
                            this.zzwF().zzyz().zzj("Did not find measurement config or missing version info. appId", zzcfk.zzdZ(zza2.zzbsZ.zzaJ));
                        }
                    } else {
                        zzcjy3.zzbwb = zzcjs2.zzbvl;
                    }
                    this.zzwz().zza(zzcjy3, bl);
                }
                this.zzwz().zzG(zza2.zzbta);
                string2 = string6;
                object = this.zzwz();
                SQLiteDatabase sQLiteDatabase = ((zzcem)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzchh)object).zzwF().zzyx().zze("Failed to remove unused event metadata. appId", zzcfk.zzdZ(string2), (Object)sQLiteException);
                }
                this.zzwz().setTransactionSuccessful();
                boolean bl7 = zzcjy3.zzbvE.length > 0;
                return bl7;
            }
            this.zzwz().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    private final zzcju[] zza(String string, zzcka[] zzckaArray, zzcjv[] zzcjvArray) {
        zzbo.zzcF((String)string);
        return this.zzws().zza(string, zzcjvArray, zzckaArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzcF((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzwF().zzyD().zzj("onConfigFetched. Response size", byArray.length);
            this.zzwz().beginTransaction();
            try {
                boolean bl;
                zzcef zzcef2 = this.zzwz().zzdQ(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcef2 == null) {
                    this.zzwF().zzyz().zzj("App does not exist in onConfigFetched. appId", zzcfk.zzdZ(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzwC().zzeh(string) == null && !this.zzwC().zzb(string, null, null) : !this.zzwC().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcef2.zzR(this.zzvy.currentTimeMillis());
                    this.zzwz().zza(zzcef2);
                    if (n == 404) {
                        this.zzwF().zzyA().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzwF().zzyD().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzyU().zzlQ() && this.zzzb()) {
                        this.zzza();
                    } else {
                        this.zzzc();
                    }
                } else {
                    zzcef2.zzS(this.zzvy.currentTimeMillis());
                    this.zzwz().zza(zzcef2);
                    this.zzwF().zzyD().zze("Fetching config failed. code, error", n, throwable);
                    this.zzwC().zzej(string);
                    this.zzwG().zzbrl.set(this.zzvy.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzwG().zzbrm.set(this.zzvy.currentTimeMillis());
                    }
                    this.zzzc();
                }
                this.zzwz().setTransactionSuccessful();
            }
            finally {
                this.zzwz().endTransaction();
            }
            return;
        }
        finally {
            this.zzbsU = false;
            this.zzzg();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzwE().zzjC();
        this.zzkD();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzbsO;
            this.zzbsO = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzwG().zzbrk.set(this.zzvy.currentTimeMillis());
                    this.zzwG().zzbrl.set(0L);
                    this.zzzc();
                    this.zzwF().zzyD().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzwz().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcem zzcem2 = this.zzwz();
                            zzcem2.zzjC();
                            zzcem2.zzkD();
                            SQLiteDatabase sQLiteDatabase = zzcem2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcem2.zzwF().zzyx().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzwz().setTransactionSuccessful();
                    }
                    finally {
                        this.zzwz().endTransaction();
                    }
                    if (this.zzyU().zzlQ() && this.zzzb()) {
                        this.zzza();
                    } else {
                        this.zzbsS = -1L;
                        this.zzzc();
                    }
                    this.zzbsT = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzwF().zzyx().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzbsT = this.zzvy.elapsedRealtime();
                    this.zzwF().zzyD().zzj("Disable upload, time", this.zzbsT);
                }
            } else {
                this.zzwF().zzyD().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzwG().zzbrl.set(this.zzvy.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzwG().zzbrm.set(this.zzvy.currentTimeMillis());
                }
                this.zzzc();
            }
            return;
        }
        finally {
            this.zzbsV = false;
            this.zzzg();
        }
    }

    private final boolean zzzb() {
        this.zzwE().zzjC();
        this.zzkD();
        return this.zzwz().zzyh() || !TextUtils.isEmpty((CharSequence)this.zzwz().zzyc());
    }

    @WorkerThread
    private final void zzzc() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzwE().zzjC();
            this.zzkD();
            if (!this.zzzf()) {
                return;
            }
            if (this.zzbsT > 0L) {
                l3 = this.zzvy.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzbsT);
                if (l2 > 0L) {
                    this.zzwF().zzyD().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzyV().unregister();
                    this.zzyW().cancel();
                    return;
                }
                this.zzbsT = 0L;
            }
            if (!this.zzyP() || !this.zzzb()) {
                this.zzwF().zzyD().log("Nothing to upload or uploading impossible");
                this.zzyV().unregister();
                this.zzyW().cancel();
                return;
            }
            zzcgk zzcgk2 = this;
            long l4 = zzcgk2.zzvy.currentTimeMillis();
            long l5 = zzcel.zzxX();
            boolean bl = zzcgk2.zzwz().zzyi() || zzcgk2.zzwz().zzyd();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzcgk2.zzbsn.zzya())) && !".none.".equals(string) ? zzcel.zzxT() : zzcel.zzxS()) : zzcel.zzxR();
            long l7 = zzcgk2.zzwG().zzbrk.get();
            long l8 = zzcgk2.zzwG().zzbrl.get();
            long l9 = zzcgk2.zzwz().zzyf();
            long l10 = zzcgk2.zzwz().zzyg();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzcgk2.zzwB().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcel.zzxZ(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcel.zzxY() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzwF().zzyD().log("Next upload time is 0");
            this.zzyV().unregister();
            this.zzyW().cancel();
            return;
        }
        if (!this.zzyU().zzlQ()) {
            this.zzwF().zzyD().log("No network");
            this.zzyV().zzlN();
            this.zzyW().cancel();
            return;
        }
        l2 = this.zzwG().zzbrm.get();
        long l16 = zzcel.zzxQ();
        if (!this.zzwB().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzyV().unregister();
        long l17 = l3 - this.zzvy.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcel.zzxU();
            this.zzwG().zzbrk.set(this.zzvy.currentTimeMillis());
        }
        this.zzwF().zzyD().zzj("Upload scheduled in approximately ms", l17);
        this.zzyW().zzs(l17);
    }

    public final void zzam(boolean bl) {
        this.zzzc();
    }

    final void zzb(zzchi zzchi2) {
        ++this.zzbsQ;
    }

    final void zzzd() {
        ++this.zzbsR;
    }

    @WorkerThread
    public final void zze(zzceg zzceg2) {
        int n;
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzceg2));
        zzbo.zzcF((String)zzceg2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            return;
        }
        zzcef zzcef2 = this.zzwz().zzdQ(zzceg2.packageName);
        if (zzcef2 != null && TextUtils.isEmpty((CharSequence)zzcef2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzceg2.zzboQ)) {
            zzcef2.zzR(0L);
            this.zzwz().zza(zzcef2);
            this.zzwC().zzek(zzceg2.packageName);
        }
        if (!zzceg2.zzboV) {
            this.zzf(zzceg2);
            return;
        }
        long l = zzceg2.zzbpa;
        if (l == 0L) {
            l = this.zzvy.currentTimeMillis();
        }
        if ((n = zzceg2.zzbpb) != 0 && n != 1) {
            this.zzwF().zzyz().zze("Incorrect app type, assuming installed app. appId, appType", zzcfk.zzdZ(zzceg2.packageName), n);
            n = 0;
        }
        this.zzwz().beginTransaction();
        try {
            zzcey zzcey2;
            Object object;
            long l2 = l;
            zzceg zzceg3 = zzceg2;
            zzcgk zzcgk2 = this;
            zzcef zzcef3 = zzcgk2.zzwz().zzdQ(zzceg3.packageName);
            if (zzcef3 != null && zzcef3.getGmpAppId() != null && !zzcef3.getGmpAppId().equals(zzceg3.zzboQ)) {
                zzcgk2.zzwF().zzyz().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcfk.zzdZ(zzcef3.zzhl()));
                String string = zzcef3.zzhl();
                zzcem zzcem2 = zzcgk2.zzwz();
                zzcem2.zzkD();
                zzcem2.zzjC();
                zzbo.zzcF((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcem2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcem2.zzwF().zzyD().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcem2.zzwF().zzyx().zze("Error deleting application data. appId, error", zzcfk.zzdZ(string), (Object)sQLiteException);
                }
                zzcef3 = null;
            }
            if (zzcef3 != null && zzcef3.zzjH() != null && !zzcef3.zzjH().equals(zzceg3.zzbgW)) {
                object = new Bundle();
                object.putString("_pv", zzcef3.zzjH());
                zzcey2 = new zzcey("_au", new zzcev((Bundle)object), "auto", l2);
                zzcgk2.zzb(zzcey2, zzceg3);
            }
            this.zzf(zzceg2);
            zzceu zzceu2 = null;
            if (n == 0) {
                zzceu2 = this.zzwz().zzE(zzceg2.packageName, "_f");
            } else if (n == 1) {
                zzceu2 = this.zzwz().zzE(zzceg2.packageName, "_v");
            }
            if (zzceu2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    com.google.android.gms.common.internal.safeparcel.zza zza2;
                    zzcjh zzcjh2 = new zzcjh("_fot", l, l3, "auto");
                    this.zzb(zzcjh2, zzceg2);
                    l2 = l;
                    zzceg3 = zzceg2;
                    zzcgk2 = this;
                    zzcgk2.zzwE().zzjC();
                    zzcgk2.zzkD();
                    zzcef3 = new Bundle();
                    zzcef3.putLong("_c", 1L);
                    zzcef3.putLong("_r", 1L);
                    zzcef3.putLong("_uwa", 0L);
                    zzcef3.putLong("_pfo", 0L);
                    zzcef3.putLong("_sys", 0L);
                    zzcef3.putLong("_sysu", 0L);
                    if (zzcgk2.mContext.getPackageManager() == null) {
                        zzcgk2.zzwF().zzyx().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcfk.zzdZ(zzceg3.packageName));
                    } else {
                        zzcey2 = null;
                        try {
                            zzcey2 = zzbgz.zzaP((Context)zzcgk2.mContext).getPackageInfo(zzceg3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcgk2.zzwF().zzyx().zze("Package info is null, first open report might be inaccurate. appId", zzcfk.zzdZ(zzceg3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcey2 != null && ((PackageInfo)zzcey2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcey2).firstInstallTime != ((PackageInfo)zzcey2).lastUpdateTime) {
                                zzcef3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zza2 = new zzcjh("_fi", l2, bl ? 1L : 0L, "auto");
                            zzcgk2.zzb((zzcjh)zza2, zzceg3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbgz.zzaP((Context)zzcgk2.mContext).getApplicationInfo(zzceg3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcgk2.zzwF().zzyx().zze("Application info is null, first open report might be inaccurate. appId", zzcfk.zzdZ(zzceg3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcef3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcef3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzceg3.packageName;
                    zzcem zzcem3 = zzcgk2.zzwz();
                    zzbo.zzcF((String)string);
                    zzcem3.zzjC();
                    zzcem3.zzkD();
                    long l4 = zzcem3.zzL(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcef3.putLong("_pfo", l4);
                    }
                    zza2 = new zzcey("_f", new zzcev((Bundle)zzcef3), "auto", l2);
                    zzcgk2.zzb((zzcey)zza2, zzceg3);
                } else if (n == 1) {
                    zzcjh zzcjh3 = new zzcjh("_fvt", l, l3, "auto");
                    this.zzb(zzcjh3, zzceg2);
                    l2 = l;
                    zzceg3 = zzceg2;
                    zzcgk2 = this;
                    zzcgk2.zzwE().zzjC();
                    zzcgk2.zzkD();
                    zzcef3 = new Bundle();
                    zzcef3.putLong("_c", 1L);
                    zzcef3.putLong("_r", 1L);
                    object = new zzcey("_v", new zzcev((Bundle)zzcef3), "auto", l2);
                    zzcgk2.zzb((zzcey)((Object)object), zzceg3);
                }
                l2 = l;
                zzceg3 = zzceg2;
                zzcgk2 = this;
                zzcef3 = new Bundle();
                zzcef3.putLong("_et", 1L);
                object = new zzcey("_e", new zzcev((Bundle)zzcef3), "auto", l2);
                zzcgk2.zzb((zzcey)((Object)object), zzceg3);
            } else if (zzceg2.zzboW) {
                l2 = l;
                zzceg3 = zzceg2;
                zzcgk2 = this;
                zzcef3 = new Bundle();
                object = new zzcey("_cd", new zzcev((Bundle)zzcef3), "auto", l2);
                zzcgk2.zzb((zzcey)((Object)object), zzceg3);
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzceg zzceg2) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzceg2));
        zzbo.zzcF((String)zzceg2.packageName);
        zzcef zzcef2 = this.zzwz().zzdQ(zzceg2.packageName);
        String string = this.zzwG().zzec(zzceg2.packageName);
        boolean bl = false;
        if (zzcef2 == null) {
            zzcef2 = new zzcef(this, zzceg2.packageName);
            zzcef2.zzdG(this.zzwu().zzyu());
            zzcef2.zzdI(string);
            bl = true;
        } else if (!string.equals(zzcef2.zzwJ())) {
            zzcef2.zzdI(string);
            zzcef2.zzdG(this.zzwu().zzyu());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceg2.zzboQ) && !zzceg2.zzboQ.equals(zzcef2.getGmpAppId())) {
            zzcef2.zzdH(zzceg2.zzboQ);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceg2.zzboY) && !zzceg2.zzboY.equals(zzcef2.zzwK())) {
            zzcef2.zzdJ(zzceg2.zzboY);
            bl = true;
        }
        if (zzceg2.zzboS != 0L && zzceg2.zzboS != zzcef2.zzwP()) {
            zzcef2.zzO(zzceg2.zzboS);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceg2.zzbgW) && !zzceg2.zzbgW.equals(zzcef2.zzjH())) {
            zzcef2.setAppVersion(zzceg2.zzbgW);
            bl = true;
        }
        if (zzceg2.zzboX != zzcef2.zzwN()) {
            zzcef2.zzN(zzceg2.zzboX);
            bl = true;
        }
        if (zzceg2.zzboR != null && !zzceg2.zzboR.equals(zzcef2.zzwO())) {
            zzcef2.zzdK(zzceg2.zzboR);
            bl = true;
        }
        if (zzceg2.zzboT != zzcef2.zzwQ()) {
            zzcef2.zzP(zzceg2.zzboT);
            bl = true;
        }
        if (zzceg2.zzboV != zzcef2.zzwR()) {
            zzcef2.setMeasurementEnabled(zzceg2.zzboV);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceg2.zzboU) && !zzceg2.zzboU.equals(zzcef2.zzxc())) {
            zzcef2.zzdL(zzceg2.zzboU);
            bl = true;
        }
        if (zzceg2.zzboZ != zzcef2.zzxe()) {
            zzcef2.zzZ(zzceg2.zzboZ);
            bl = true;
        }
        if (bl) {
            this.zzwz().zza(zzcef2);
        }
    }

    @WorkerThread
    final void zzze() {
        this.zzwE().zzjC();
        this.zzkD();
        if (!this.zzbsJ) {
            this.zzwF().zzyB().log("This instance being marked as an uploader");
            zzcgk zzcgk2 = this;
            zzcgk2.zzwE().zzjC();
            zzcgk2.zzkD();
            if (zzcgk2.zzzf() && zzcgk2.zzyX()) {
                int n;
                int n2 = zzcgk2.zza(zzcgk2.zzbsN);
                int n3 = n = zzcgk2.zzwu().zzyv();
                int n4 = n2;
                zzcgk zzcgk3 = zzcgk2;
                zzcgk3.zzwE().zzjC();
                if (n4 > n3) {
                    zzcgk3.zzwF().zzyx().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzcgk3.zza(n3, zzcgk3.zzbsN)) {
                        zzcgk3.zzwF().zzyD().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzcgk3.zzwF().zzyx().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzbsJ = true;
            this.zzzc();
        }
    }

    @WorkerThread
    private final boolean zzzf() {
        this.zzwE().zzjC();
        this.zzkD();
        return this.zzbsJ;
    }

    @WorkerThread
    final void zzl(Runnable runnable) {
        this.zzwE().zzjC();
        if (this.zzbsP == null) {
            this.zzbsP = new ArrayList<Runnable>();
        }
        this.zzbsP.add(runnable);
    }

    @WorkerThread
    private final void zzzg() {
        this.zzwE().zzjC();
        if (this.zzbsU || this.zzbsV || this.zzbsW) {
            this.zzwF().zzyD().zzd("Not stopping services. fetch, network, upload", this.zzbsU, this.zzbsV, this.zzbsW);
            return;
        }
        this.zzwF().zzyD().log("Stopping uploading service(s)");
        if (this.zzbsP == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzbsP.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzbsP.clear();
    }

    final class zza
    implements zzceo {
        zzcjy zzbsZ;
        List<Long> zzbta;
        List<zzcjv> zztJ;
        private long zzbtb;
        private /* synthetic */ zzcgk zzbsY;

        private zza(zzcgk zzcgk2) {
            this.zzbsY = zzcgk2;
        }

        @Override
        public final void zzb(zzcjy zzcjy2) {
            zzbo.zzu((Object)((Object)zzcjy2));
            this.zzbsZ = zzcjy2;
        }

        @Override
        public final boolean zza(long l, zzcjv zzcjv2) {
            zzbo.zzu((Object)((Object)zzcjv2));
            if (this.zztJ == null) {
                this.zztJ = new ArrayList<zzcjv>();
            }
            if (this.zzbta == null) {
                this.zzbta = new ArrayList<Long>();
            }
            if (this.zztJ.size() > 0 && zza.zza(this.zztJ.get(0)) != zza.zza(zzcjv2)) {
                return false;
            }
            long l2 = this.zzbtb + (long)zzcjv2.zzLT();
            if (l2 >= (long)zzcel.zzxL()) {
                return false;
            }
            this.zzbtb = l2;
            this.zztJ.add(zzcjv2);
            this.zzbta.add(l);
            return this.zztJ.size() < zzcel.zzxM();
        }

        private static long zza(zzcjv zzcjv2) {
            return zzcjv2.zzbvx / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzcgk zzcgk2, zzcgl zzcgl2) {
            this(zzcgk2);
        }
    }
}

