/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcfj;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzciq;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;

public final class zzcip
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzbuh;
    private volatile zzcfj zzbui;
    final /* synthetic */ zzcic zzbua;

    protected zzcip(zzcic zzcic2) {
        this.zzbua = zzcic2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        this.zzbua.zzjC();
        Context context = this.zzbua.getContext();
        zza zza2 = zza.zzrU();
        zzcip zzcip2 = this;
        synchronized (zzcip2) {
            if (this.zzbuh) {
                this.zzbua.zzwF().zzyD().log("Connection attempt already in progress");
                return;
            }
            this.zzbuh = true;
            zza2.zza(context, intent, (ServiceConnection)zzcic.zza(this.zzbua), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onServiceConnected");
        zzcip zzcip2 = this;
        synchronized (zzcip2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzbuh = false;
                this.zzbua.zzwF().zzyx().log("Service connected with null binder");
                return;
            }
            zzcfc zzcfc2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcfc2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcfc ? (zzcfc)iInterface : new zzcfe(iBinder2));
                    this.zzbua.zzwF().zzyD().log("Bound to IMeasurementService interface");
                } else {
                    this.zzbua.zzwF().zzyx().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                this.zzbua.zzwF().zzyx().log("Service connect failed to get IMeasurementService");
            }
            if (zzcfc2 == null) {
                this.zzbuh = false;
                try {
                    zza.zzrU();
                    zzcip zzcip3 = zzcic.zza(this.zzbua);
                    iInterface = this.zzbua.getContext();
                    iInterface.unbindService((ServiceConnection)zzcip3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcfc2;
                this.zzbua.zzwE().zzj(new zzciq(this, (zzcfc)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zzbua.zzwF().zzyC().log("Service disconnected");
        this.zzbua.zzwE().zzj(new zzcir(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzzm() {
        this.zzbua.zzjC();
        Context context = this.zzbua.getContext();
        zzcip zzcip2 = this;
        synchronized (zzcip2) {
            if (this.zzbuh) {
                this.zzbua.zzwF().zzyD().log("Connection attempt already in progress");
                return;
            }
            if (this.zzbui != null) {
                this.zzbua.zzwF().zzyD().log("Already awaiting connection attempt");
                return;
            }
            this.zzbui = new zzcfj(context, Looper.getMainLooper(), this, this);
            this.zzbua.zzwF().zzyD().log("Connecting to remote service");
            this.zzbuh = true;
            this.zzbui.zzrb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnected");
        zzcip zzcip2 = this;
        synchronized (zzcip2) {
            try {
                zzcfc zzcfc2 = (zzcfc)this.zzbui.zzrf();
                this.zzbui = null;
                this.zzbua.zzwE().zzj(new zzcis(this, zzcfc2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzbui = null;
                this.zzbuh = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zzbua.zzwF().zzyC().log("Service connection suspended");
        this.zzbua.zzwE().zzj(new zzcit(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcfk zzcfk2 = this.zzbua.zzboe.zzyQ();
        if (zzcfk2 != null) {
            zzcfk2.zzyz().zzj("Service connection failed", connectionResult);
        }
        zzcip zzcip2 = this;
        synchronized (zzcip2) {
            this.zzbuh = false;
            this.zzbui = null;
        }
        this.zzbua.zzwE().zzj(new zzciu(this));
    }

    static /* synthetic */ boolean zza(zzcip zzcip2, boolean bl) {
        zzcip2.zzbuh = false;
        return false;
    }
}

