/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgp;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzcjk;

public final class zzciv {
    private final Context mContext;
    private final zzciy zzbum;

    public zzciv(zzciy zzciy2) {
        this.mContext = zzciy2.getContext();
        zzbo.zzu((Object)this.mContext);
        this.zzbum = zzciy2;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbo.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcjk.zzw(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcjk.zzw(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcfk zzcfk2 = zzcgk.zzbj(this.mContext).zzwF();
        zzcel.zzxE();
        zzcfk2.zzyD().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcfk zzcfk2 = zzcgk.zzbj(this.mContext).zzwF();
        zzcel.zzxE();
        zzcfk2.zzyD().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcfk zzcfk2 = zzcgk.zzbj(this.mContext).zzwF();
        if (intent == null) {
            zzcfk2.zzyz().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcel.zzxE();
        zzcfk2.zzyD().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzcgk zzcgk2 = zzcgk.zzbj(this.mContext);
        zzcfk zzcfk2 = zzcgk2.zzwF();
        zzcgk2.zzwE().zzj(new zzciw(this, zzcgk2, n, zzcfk2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcgp(zzcgk.zzbj(this.mContext));
        }
        this.zzwF().zzyz().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzwF().zzyD().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcfk zzcfk2 = zzcgk.zzbj(this.mContext).zzwF();
        String string = jobParameters.getExtras().getString("action");
        zzcel.zzxE();
        zzcfk2.zzyD().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzwF().zzyD().zzj("onRebind called. action", string);
    }

    private final zzcfk zzwF() {
        return zzcgk.zzbj(this.mContext).zzwF();
    }

    static /* synthetic */ zzciy zza(zzciv zzciv2) {
        return zzciv2.zzbum;
    }
}

