/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcfh;

@TargetApi(value=11)
final class zzcfi
extends SQLiteOpenHelper {
    private /* synthetic */ zzcfh zzbqH;

    zzcfi(zzcfh zzcfh2, Context context, String string) {
        this.zzbqH = zzcfh2;
        super(context, string, null, 1);
    }

    @WorkerThread
    public final SQLiteDatabase getWritableDatabase() {
        try {
            return super.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                throw sQLiteException;
            }
            this.zzbqH.zzwF().zzyx().log("Opening the local database failed, dropping and recreating it");
            String string = zzcem.zzxD();
            if (!this.zzbqH.getContext().getDatabasePath(string).delete()) {
                this.zzbqH.zzwF().zzyx().zzj("Failed to delete corrupted local db file", string);
            }
            try {
                return super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException2) {
                this.zzbqH.zzwF().zzyx().zzj("Failed to open local database. Events will bypass local storage", (Object)sQLiteException2);
                return null;
            }
        }
    }

    @WorkerThread
    public final void onOpen(SQLiteDatabase sQLiteDatabase) {
        if (Build.VERSION.SDK_INT < 15) {
            try (Cursor cursor = sQLiteDatabase.rawQuery("PRAGMA journal_mode=memory", null);){
                cursor.moveToFirst();
            }
        }
        zzcen.zza(this.zzbqH.zzwF(), sQLiteDatabase, "messages", "create table if not exists messages ( type INTEGER NOT NULL, entry BLOB NOT NULL)", "type,entry", null);
    }

    @WorkerThread
    public final void onCreate(SQLiteDatabase sQLiteDatabase) {
        zzcen.zza(this.zzbqH.zzwF(), sQLiteDatabase);
    }

    @WorkerThread
    public final void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
    }

    @WorkerThread
    public final void onDowngrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
    }
}

