/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcib;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzchz
extends zzchj {
    protected zzcic zzbtE;
    private volatile AppMeasurement.zzb zzbtF;
    private AppMeasurement.zzb zzbtG;
    private long zzbtH;
    private final Map<Activity, zzcic> zzbtI = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzbtJ = new CopyOnWriteArrayList();
    private boolean zzbtK;
    private AppMeasurement.zzb zzbtL;
    private String zzbtM;

    public zzchz(zzcgl zzcgl2) {
        super(zzcgl2);
    }

    @Override
    protected final void zzjD() {
    }

    @WorkerThread
    public final zzcic zzzh() {
        this.zzkD();
        super.zzjC();
        return this.zzbtE;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            super.zzwF().zzyz().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        super.zzwE();
        if (!zzcgg.zzS()) {
            super.zzwF().zzyz().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzbtK) {
            super.zzwF().zzyz().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzbtF == null) {
            super.zzwF().zzyz().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzbtI.get(activity) == null) {
            super.zzwF().zzyz().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzchz.zzen(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzbtF.zzbok.equals(string2);
        boolean bl2 = zzcjl.zzR(this.zzbtF.zzboj, string);
        if (bl && bl2) {
            super.zzwF().zzyA().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcem.zzxk())) {
            super.zzwF().zzyz().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcem.zzxk())) {
            super.zzwF().zzyz().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        super.zzwF().zzyD().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcic zzcic2 = new zzcic(string, string2, super.zzwB().zzzs());
        this.zzbtI.put(activity, zzcic2);
        this.zza(activity, zzcic2, true);
    }

    public final AppMeasurement.zzb zzzi() {
        super.zzwp();
        AppMeasurement.zzb zzb2 = this.zzbtF;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        super.zzwp();
        if (zza2 == null) {
            super.zzwF().zzyz().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzbtJ.remove(zza2);
        this.zzbtJ.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        super.zzwp();
        this.zzbtJ.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcic zzcic2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzbtF != null) {
            zzb2 = this.zzbtF;
        } else if (this.zzbtG != null && Math.abs(super.zzkq().elapsedRealtime() - this.zzbtH) < 1000L) {
            zzb2 = this.zzbtG;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzbtK = true;
        try {
            object2 = this.zzbtJ.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcic2);
                }
                catch (Exception exception) {
                    super.zzwF().zzyx().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            super.zzwF().zzyx().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzbtK = false;
        }
        Object object3 = object2 = this.zzbtF == null ? this.zzbtG : this.zzbtF;
        if (bl2) {
            if (zzcic2.zzbok == null) {
                zzcic2.zzbok = zzchz.zzen(activity.getClass().getCanonicalName());
            }
            object = new zzcic(zzcic2);
            this.zzbtG = this.zzbtF;
            this.zzbtH = super.zzkq().elapsedRealtime();
            this.zzbtF = object;
            super.zzwE().zzj(new zzcia(this, bl, (AppMeasurement.zzb)object2, (zzcic)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcic zzcic2) {
        super.zzwr().zzJ(super.zzkq().elapsedRealtime());
        if (super.zzwD().zzap(zzcic2.zzbtS)) {
            zzcic2.zzbtS = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzboj != null) {
                bundle.putString("_sn", zzb2.zzboj);
            }
            bundle.putString("_sc", zzb2.zzbok);
            bundle.putLong("_si", zzb2.zzbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        super.zzjC();
        zzchz zzchz2 = this;
        synchronized (zzchz2) {
            if (this.zzbtM == null || this.zzbtM.equals(string) || zzb2 != null) {
                this.zzbtM = string;
                this.zzbtL = zzb2;
            }
            return;
        }
    }

    private static String zzen(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcic zzq(@NonNull Activity activity) {
        zzbo.zzu((Object)activity);
        zzcic zzcic2 = this.zzbtI.get(activity);
        if (zzcic2 == null) {
            String string = zzchz.zzen(activity.getClass().getCanonicalName());
            zzcic2 = new zzcic(null, string, super.zzwB().zzzs());
            this.zzbtI.put(activity, zzcic2);
        }
        return zzcic2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcic zzcic2 = this.zzq(activity);
        this.zza(activity, zzcic2, false);
        super.zzwr().zzwn();
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcic zzcic2 = this.zzq(activity);
        this.zzbtG = this.zzbtF;
        this.zzbtH = super.zzkq().elapsedRealtime();
        this.zzbtF = null;
        super.zzwE().zzj(new zzcib(this, zzcic2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcic zzcic2 = this.zzbtI.get(activity);
        if (zzcic2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcic2.zzbol);
        bundle2.putString("name", zzcic2.zzboj);
        bundle2.putString("referrer_name", zzcic2.zzbok);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzbtI.remove(activity);
    }

    static /* synthetic */ void zza(zzchz zzchz2, zzcic zzcic2) {
        zzchz2.zza(zzcic2);
    }
}

