/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzced;
import com.google.android.gms.internal.zzcee;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcec
extends zzchi {
    private final Map<String, Long> zzboq;
    private final Map<String, Integer> zzbor = new ArrayMap();
    private long zzbos;

    public zzcec(zzcgl zzcgl2) {
        super(zzcgl2);
        this.zzboq = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            super.zzwF().zzyx().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = super.zzkq().elapsedRealtime();
        super.zzwE().zzj(new zzced(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        super.zzwp();
        super.zzjC();
        zzbo.zzcF((String)string);
        if (this.zzbor.isEmpty()) {
            this.zzbos = l;
        }
        if ((n = this.zzbor.get(string)) != null) {
            this.zzbor.put(string, n + 1);
            return;
        }
        if (this.zzbor.size() >= 100) {
            super.zzwF().zzyz().log("Too many ads visible");
            return;
        }
        this.zzbor.put(string, 1);
        this.zzboq.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            super.zzwF().zzyx().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = super.zzkq().elapsedRealtime();
        super.zzwE().zzj(new zzcee(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        super.zzwp();
        super.zzjC();
        zzbo.zzcF((String)string);
        Integer n = this.zzbor.get(string);
        if (n != null) {
            zzcic zzcic2 = super.zzwx().zzzh();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbor.remove(string);
                Long l2 = this.zzboq.get(string);
                if (l2 == null) {
                    super.zzwF().zzyx().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzboq.remove(string);
                    this.zza(string, l3, zzcic2);
                }
                if (this.zzbor.isEmpty()) {
                    if (this.zzbos == 0L) {
                        super.zzwF().zzyx().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzbos, zzcic2);
                    this.zzbos = 0L;
                }
                return;
            }
            this.zzbor.put(string, n2);
            return;
        }
        super.zzwF().zzyx().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            super.zzwF().zzyD().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            super.zzwF().zzyD().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzchz.zza(zzb2, bundle);
        super.zzwt().zzd("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            super.zzwF().zzyD().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            super.zzwF().zzyD().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzchz.zza(zzb2, bundle);
        super.zzwt().zzd("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzJ(long l) {
        zzcic zzcic2 = super.zzwx().zzzh();
        for (String string : this.zzboq.keySet()) {
            long l2 = this.zzboq.get(string);
            this.zza(string, l - l2, zzcic2);
        }
        if (!this.zzboq.isEmpty()) {
            this.zza(l - this.zzbos, zzcic2);
        }
        this.zzK(l);
    }

    public final void zzwn() {
        long l = super.zzkq().elapsedRealtime();
        super.zzwE().zzj(new zzcef(this, l));
    }

    @WorkerThread
    private final void zzK(long l) {
        for (String string : this.zzboq.keySet()) {
            this.zzboq.put(string, l);
        }
        if (!this.zzboq.isEmpty()) {
            this.zzbos = l;
        }
    }

    static /* synthetic */ void zza(zzcec zzcec2, String string, long l) {
        zzcec2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcec zzcec2, String string, long l) {
        zzcec2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcec zzcec2, long l) {
        zzcec2.zzK(l);
    }
}

