/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.adg;
import com.google.android.gms.internal.adh;
import com.google.android.gms.internal.adj;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcjf;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjm;
import com.google.android.gms.internal.zzcjn;
import com.google.android.gms.internal.zzcjq;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzcka;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcen
extends zzchj {
    private static final Map<String, String> zzbpn = new ArrayMap(1);
    private static final Map<String, String> zzbpo;
    private static final Map<String, String> zzbpp;
    private static final Map<String, String> zzbpq;
    private static final Map<String, String> zzbpr;
    private final zzceq zzbps;
    private final zzcjf zzbpt = new zzcjf(this.zzkq());

    zzcen(zzcgl zzcgl2) {
        super(zzcgl2);
        String string = zzcem.zzxC();
        this.zzbps = new zzceq(this, this.getContext(), string);
    }

    @Override
    protected final void zzjD() {
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzkD();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzkD();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzkD();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzwF().zzyx().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzjC();
        try {
            return this.zzbps.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyz().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcev zzE(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzcev zzcev2 = new zzcev(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for event aggregates, expected one. appId", zzcfl.zzdZ(string));
            }
            zzcev zzcev3 = zzcev2;
            return zzcev3;
        }
    }

    @WorkerThread
    public final void zza(zzcev zzcev2) {
        zzbo.zzu((Object)zzcev2);
        this.zzjC();
        this.zzkD();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcev2.mAppId);
        contentValues.put("name", zzcev2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcev2.zzbpG));
        contentValues.put("current_bundle_count", Long.valueOf(zzcev2.zzbpH));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcev2.zzbpI));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update event aggregates (got -1). appId", zzcfl.zzdZ(zzcev2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing event aggregates. appId", zzcfl.zzdZ(zzcev2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzF(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzwF().zzyD().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error deleting user attribute. appId", zzcfl.zzdZ(string), this.zzwA().zzdY(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcjk zzcjk2) {
        zzbo.zzu((Object)zzcjk2);
        this.zzjC();
        this.zzkD();
        if (this.zzG(zzcjk2.mAppId, zzcjk2.mName) == null) {
            if (zzcjl.zzeo(zzcjk2.mName)) {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcjk2.mAppId});
                zzcem.zzxs();
                if (l >= 25L) {
                    return false;
                }
            } else {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcjk2.mAppId, zzcjk2.mOrigin});
                zzcem.zzxu();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjk2.mAppId);
        contentValues.put("origin", zzcjk2.mOrigin);
        contentValues.put("name", zzcjk2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzcjk2.zzbuC));
        zzcen.zza(contentValues, "value", zzcjk2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update user property (got -1). appId", zzcfl.zzdZ(zzcjk2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing user property. appId", zzcfl.zzdZ(zzcjk2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcjk zzG(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcjk zzcjk2 = new zzcjk(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for user property, expected one. appId", zzcfl.zzdZ(string));
            }
            zzcjk zzcjk3 = zzcjk2;
            return zzcjk3;
        }
    }

    @WorkerThread
    public final List<zzcjk> zzdP(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<zzcjk> arrayList = new ArrayList<zzcjk>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(zzcem.zzxt()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzcjk> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzwF().zzyx().zzj("Read invalid user property value, ignoring it. appId", zzcfl.zzdZ(string));
                    continue;
                }
                zzcjk zzcjk2 = new zzcjk(string, string2, (String)object, l, object2);
                arrayList.add(zzcjk2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcjk> zzh(String string, String string2, String string3) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<zzcjk> arrayList = new ArrayList<zzcjk>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "set_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            zzcem.zzxt();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcjk> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= zzcem.zzxt()) {
                    this.zzwF().zzyx().zzj("Read more than the max allowed user properties, ignoring excess", zzcem.zzxt());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzwF().zzyx().zzd("(2)Read invalid user property value, ignoring it", zzcfl.zzdZ(string), string2, string3);
                    continue;
                }
                zzcjk zzcjk2 = new zzcjk(string, string2, (String)object, l, object2);
                arrayList.add(zzcjk2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcek zzcek2) {
        zzbo.zzu((Object)((Object)zzcek2));
        this.zzjC();
        this.zzkD();
        if (this.zzG(zzcek2.packageName, zzcek2.zzbpd.name) == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcek2.packageName});
            zzcem.zzxv();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcek2.packageName);
        contentValues.put("origin", zzcek2.zzbpc);
        contentValues.put("name", zzcek2.zzbpd.name);
        zzcen.zza(contentValues, "value", zzcek2.zzbpd.getValue());
        contentValues.put("active", Boolean.valueOf(zzcek2.zzbpf));
        contentValues.put("trigger_event_name", zzcek2.zzbpg);
        contentValues.put("trigger_timeout", Long.valueOf(zzcek2.zzbpi));
        this.zzwB();
        contentValues.put("timed_out_event", zzcjl.zza((Parcelable)zzcek2.zzbph));
        contentValues.put("creation_timestamp", Long.valueOf(zzcek2.zzbpe));
        this.zzwB();
        contentValues.put("triggered_event", zzcjl.zza((Parcelable)zzcek2.zzbpj));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcek2.zzbpd.zzbuy));
        contentValues.put("time_to_live", Long.valueOf(zzcek2.zzbpk));
        this.zzwB();
        contentValues.put("expired_event", zzcjl.zza((Parcelable)zzcek2.zzbpl));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update conditional user property (got -1)", zzcfl.zzdZ(zzcek2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing conditional user property", zzcfl.zzdZ(zzcek2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcek zzH(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcez zzcez2 = this.zzwB().zzb(cursor.getBlob(5), zzcez.CREATOR);
            long l2 = cursor.getLong(6);
            zzcez zzcez3 = this.zzwB().zzb(cursor.getBlob(7), zzcez.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcez zzcez4 = this.zzwB().zzb(cursor.getBlob(10), zzcez.CREATOR);
            zzcji zzcji2 = new zzcji(string2, l3, object, string3);
            zzcek zzcek2 = new zzcek(string, string3, zzcji2, l2, bl, string4, zzcez2, l, zzcez3, l4, zzcez4);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zze("Got multiple records for conditional property, expected one", zzcfl.zzdZ(string), this.zzwA().zzdY(string2));
            }
            zzcek zzcek3 = zzcek2;
            return zzcek3;
        }
    }

    @WorkerThread
    public final int zzI(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error deleting conditional property", zzcfl.zzdZ(string), this.zzwA().zzdY(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcek> zzi(String string, String string2, String string3) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcek> zzc(String string, String[] stringArray) {
        this.zzjC();
        this.zzkD();
        ArrayList<zzcek> arrayList = new ArrayList<zzcek>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            zzcem.zzxv();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcek> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= zzcem.zzxv()) {
                    this.zzwF().zzyx().zzj("Read more than the max allowed conditional properties, ignoring extra", zzcem.zzxv());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcez zzcez2 = this.zzwB().zzb(cursor.getBlob(7), zzcez.CREATOR);
                long l2 = cursor.getLong(8);
                zzcez zzcez3 = this.zzwB().zzb(cursor.getBlob(9), zzcez.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcez zzcez4 = this.zzwB().zzb(cursor.getBlob(12), zzcez.CREATOR);
                zzcji zzcji2 = new zzcji(string3, l3, object2, string2);
                zzcek zzcek2 = new zzcek((String)object, string2, zzcji2, l2, bl, string4, zzcez2, l, zzcez3, l4, zzcez4);
                arrayList.add(zzcek2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzceg zzdQ(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzceg zzceg2 = new zzceg(this.zzboe, string);
            zzceg2.zzdG(cursor.getString(0));
            zzceg2.zzdH(cursor.getString(1));
            zzceg2.zzdI(cursor.getString(2));
            zzceg2.zzQ(cursor.getLong(3));
            zzceg2.zzL(cursor.getLong(4));
            zzceg2.zzM(cursor.getLong(5));
            zzceg2.setAppVersion(cursor.getString(6));
            zzceg2.zzdK(cursor.getString(7));
            zzceg2.zzO(cursor.getLong(8));
            zzceg2.zzP(cursor.getLong(9));
            zzceg2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzceg2.zzT(cursor.getLong(11));
            zzceg2.zzU(cursor.getLong(12));
            zzceg2.zzV(cursor.getLong(13));
            zzceg2.zzW(cursor.getLong(14));
            zzceg2.zzR(cursor.getLong(15));
            zzceg2.zzS(cursor.getLong(16));
            zzceg2.zzN(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzceg2.zzdJ(cursor.getString(18));
            zzceg2.zzY(cursor.getLong(19));
            zzceg2.zzX(cursor.getLong(20));
            zzceg2.zzdL(cursor.getString(21));
            zzceg2.zzZ(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzceg2.zzwI();
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for app, expected one. appId", zzcfl.zzdZ(string));
            }
            zzceg zzceg3 = zzceg2;
            return zzceg3;
        }
    }

    @WorkerThread
    public final void zza(zzceg zzceg2) {
        zzbo.zzu((Object)zzceg2);
        this.zzjC();
        this.zzkD();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzceg2.zzhl());
        contentValues.put("app_instance_id", zzceg2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzceg2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzceg2.zzwJ());
        contentValues.put("last_bundle_index", Long.valueOf(zzceg2.zzwS()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzceg2.zzwL()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzceg2.zzwM()));
        contentValues.put("app_version", zzceg2.zzjH());
        contentValues.put("app_store", zzceg2.zzwO());
        contentValues.put("gmp_version", Long.valueOf(zzceg2.zzwP()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzceg2.zzwQ()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzceg2.zzwR()));
        contentValues.put("day", Long.valueOf(zzceg2.zzwW()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzceg2.zzwX()));
        contentValues.put("daily_events_count", Long.valueOf(zzceg2.zzwY()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzceg2.zzwZ()));
        contentValues.put("config_fetched_time", Long.valueOf(zzceg2.zzwT()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzceg2.zzwU()));
        contentValues.put("app_version_int", Long.valueOf(zzceg2.zzwN()));
        contentValues.put("firebase_instance_id", zzceg2.zzwK());
        contentValues.put("daily_error_events_count", Long.valueOf(zzceg2.zzxb()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzceg2.zzxa()));
        contentValues.put("health_monitor_sample", zzceg2.zzxc());
        contentValues.put("android_id", Long.valueOf(zzceg2.zzxe()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzceg2.zzhl()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update app (got -1). appId", zzcfl.zzdZ(zzceg2.zzhl()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing app. appId", zzcfl.zzdZ(zzceg2.zzhl()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzdR(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzwH().zzb(string2, zzcfb.zzbqk);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error deleting over the limit events. appId", zzcfl.zzdZ(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzceo zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        String[] stringArray = new String[]{string};
        zzceo zzceo2 = new zzceo();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzwF().zzyz().zzj("Not updating daily counts, app is not known. appId", zzcfl.zzdZ(string));
                zzceo zzceo3 = zzceo2;
                return zzceo3;
            }
            if (cursor.getLong(0) == l) {
                zzceo2.zzbpv = cursor.getLong(1);
                zzceo2.zzbpu = cursor.getLong(2);
                zzceo2.zzbpw = cursor.getLong(3);
                zzceo2.zzbpx = cursor.getLong(4);
                zzceo2.zzbpy = cursor.getLong(5);
            }
            if (bl) {
                ++zzceo2.zzbpv;
            }
            if (bl2) {
                ++zzceo2.zzbpu;
            }
            if (bl3) {
                ++zzceo2.zzbpw;
            }
            if (bl4) {
                ++zzceo2.zzbpx;
            }
            if (bl5) {
                ++zzceo2.zzbpy;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzceo2.zzbpu));
            contentValues.put("daily_events_count", Long.valueOf(zzceo2.zzbpv));
            contentValues.put("daily_conversions_count", Long.valueOf(zzceo2.zzbpw));
            contentValues.put("daily_error_events_count", Long.valueOf(zzceo2.zzbpx));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzceo2.zzbpy));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzceo zzceo4 = zzceo2;
            return zzceo4;
        }
    }

    @WorkerThread
    public final byte[] zzdS(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for app config, expected one. appId", zzcfl.zzdZ(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcjz zzcjz2, boolean bl) {
        byte[] byArray;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzcjz2));
        zzbo.zzcF((String)zzcjz2.zzaH);
        zzbo.zzu((Object)zzcjz2.zzbvI);
        this.zzye();
        long l = this.zzkq().currentTimeMillis();
        if (zzcjz2.zzbvI < l - zzcem.zzxG() || zzcjz2.zzbvI > l + zzcem.zzxG()) {
            this.zzwF().zzyz().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcfl.zzdZ(zzcjz2.zzaH), l, zzcjz2.zzbvI);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcjz2.zzLV()];
            adh adh2 = adh.zzc((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcjz2.zza(adh2);
            adh2.zzLM();
            byArray = this.zzwB().zzl(byArray2);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize bundle. appId", zzcfl.zzdZ(zzcjz2.zzaH), iOException);
            return false;
        }
        this.zzwF().zzyD().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjz2.zzaH);
        contentValues.put("bundle_end_timestamp", zzcjz2.zzbvI);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert bundle (got -1). appId", zzcfl.zzdZ(zzcjz2.zzaH));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing bundle. appId", zzcfl.zzdZ(zzcjz2.zzaH), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzyc() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzyd() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcjz, Long>> zzl(String string, int n, int n2) {
        this.zzjC();
        this.zzkD();
        zzbo.zzaf((n > 0 ? 1 : 0) != 0);
        zzbo.zzaf((n2 > 0 ? 1 : 0) != 0);
        zzbo.zzcF((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcjz, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcjz, Long>> arrayList = new ArrayList<Pair<zzcjz, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzwB().zzm((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to unzip queued bundle. appId", zzcfl.zzdZ(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = adg.zzb((byte[])byArray, (int)0, (int)byArray2.length);
                zzcjz zzcjz2 = new zzcjz();
                try {
                    zzcjz2.zza((adg)object);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge queued bundle. appId", zzcfl.zzdZ(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcjz, Long>)Pair.create((Object)((Object)zzcjz2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcjz, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzye() {
        this.zzjC();
        this.zzkD();
        if (!this.zzyk()) {
            return;
        }
        long l = this.zzwG().zzbrn.get();
        long l2 = this.zzkq().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcem.zzxH()) {
            this.zzwG().zzbrn.set(l2);
            zzcen zzcen2 = this;
            zzcen2.zzjC();
            zzcen2.zzkD();
            if (zzcen2.zzyk()) {
                SQLiteDatabase sQLiteDatabase = zzcen2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcen2.zzkq().currentTimeMillis()), String.valueOf(zzcem.zzxG())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcen2.zzwF().zzyD().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcjm[] zzcjmArray) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)zzcjmArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcen zzcen2 = this;
            zzcen2.zzkD();
            zzcen2.zzjC();
            zzbo.zzcF((String)string2);
            Object object = zzcen2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcjmArray;
            int n2 = zzcjmArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcjn zzcjn2;
                int n3;
                int n4;
                zzcjm zzcjm2 = object2[n];
                object = zzcjm2;
                string2 = string;
                zzcen2 = this;
                zzcen2.zzkD();
                zzcen2.zzjC();
                zzbo.zzcF((String)string2);
                zzbo.zzu((Object)object);
                zzbo.zzu((Object)object.zzbuK);
                zzbo.zzu((Object)object.zzbuJ);
                if (object.zzbuI == null) {
                    zzcen2.zzwF().zzyz().zzj("Audience with no ID. appId", zzcfl.zzdZ(string2));
                    continue;
                }
                int n5 = object.zzbuI;
                adj[] adjArray = object.zzbuK;
                int n6 = object.zzbuK.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (adjArray[n4].zzbuM != null) continue;
                    zzcen2.zzwF().zzyz().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcfl.zzdZ(string2), object.zzbuI);
                    continue block3;
                }
                adjArray = object.zzbuJ;
                n6 = object.zzbuJ.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (adjArray[n4].zzbuM != null) continue;
                    zzcen2.zzwF().zzyz().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcfl.zzdZ(string2), object.zzbuI);
                    continue block3;
                }
                boolean bl = true;
                adj[] adjArray2 = object.zzbuK;
                n4 = object.zzbuK.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcjn2 = adjArray2[n3];
                    if (zzcen2.zza(string2, n5, zzcjn2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    adjArray2 = object.zzbuJ;
                    n4 = object.zzbuJ.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcjn2 = adjArray2[n3];
                        if (zzcen2.zza(string2, n5, (zzcjq)((Object)zzcjn2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcen zzcen3 = zzcen2;
                zzcen3.zzkD();
                zzcen3.zzjC();
                zzbo.zzcF((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcen3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcjm[] zzcjmArray2 = zzcjmArray;
            n = zzcjmArray.length;
            for (int i = 0; i < n; ++i) {
                zzcjm zzcjm3 = zzcjmArray2[i];
                object2.add(zzcjm3.zzbuI);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcjn zzcjn2) {
        byte[] byArray;
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcjn2));
        if (TextUtils.isEmpty((CharSequence)zzcjn2.zzbuN)) {
            this.zzwF().zzyz().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcfl.zzdZ(string), n, String.valueOf(zzcjn2.zzbuM));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcjn2.zzLV()];
            adh adh2 = adh.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjn2.zza(adh2);
            adh2.zzLM();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Configuration loss. Failed to serialize event filter. appId", zzcfl.zzdZ(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcjn2.zzbuM);
        contentValues.put("event_name", zzcjn2.zzbuN);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert event filter (got -1). appId", zzcfl.zzdZ(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing event filter. appId", zzcfl.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcjq zzcjq2) {
        byte[] byArray;
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcjq2));
        if (TextUtils.isEmpty((CharSequence)zzcjq2.zzbvc)) {
            this.zzwF().zzyz().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcfl.zzdZ(string), n, String.valueOf(zzcjq2.zzbuM));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcjq2.zzLV()];
            adh adh2 = adh.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjq2.zza(adh2);
            adh2.zzLM();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Configuration loss. Failed to serialize property filter. appId", zzcfl.zzdZ(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcjq2.zzbuM);
        contentValues.put("property_name", zzcjq2.zzbvc);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert property filter (got -1). appId", zzcfl.zzdZ(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing property filter. appId", zzcfl.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcjn>> zzJ(String string, String string2) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcjn>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                adg adg2 = adg.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcjn zzcjn2 = new zzcjn();
                try {
                    zzcjn2.zza(adg2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge filter. appId", zzcfl.zzdZ(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcjn> arrayList = (ArrayList<zzcjn>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcjn>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcjn2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcjq>> zzK(String string, String string2) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcjq>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                adg adg2 = adg.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcjq zzcjq2 = new zzcjq();
                try {
                    zzcjq2.zza(adg2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge filter", zzcfl.zzdZ(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcjq> arrayList = (ArrayList<zzcjq>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcjq>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcjq2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbo.zzcF((String)string);
        this.zzkD();
        this.zzjC();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Database error querying filters. appId", zzcfl.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzwH().zzb(string2, zzcfb.zzbqA);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcka> zzdT(String string) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                adg adg2 = adg.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcka zzcka2 = new zzcka();
                try {
                    zzcka2.zza(adg2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zzd("Failed to merge filter results. appId, audienceId, error", zzcfl.zzdZ(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcka2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzwF().zzyx().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzwF().zzyx().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzwF().zzyx().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzyf() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzL(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzwF().zzyx().zze("Failed to insert column (got -1). appId", zzcfl.zzdZ(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzwF().zzyx().zze("Failed to update column (got 0). appId", zzcfl.zzdZ(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error inserting column. appId", zzcfl.zzdZ(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzyg() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcjz zzcjz2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzcjz2));
        zzbo.zzcF((String)zzcjz2.zzaH);
        try {
            byArray = new byte[zzcjz2.zzLV()];
            object = byArray;
            adh adh2 = adh.zzc((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcjz2.zza(adh2);
            adh2.zzLM();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize event metadata. appId", zzcfl.zzdZ(zzcjz2.zzaH), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzwB();
        zzbo.zzu((Object)byArray2);
        ((zzcjl)object).zzjC();
        MessageDigest messageDigest = zzcjl.zzbE("MD5");
        if (messageDigest == null) {
            ((zzcjl)object).zzwF().zzyx().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcjl.zzn(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjz2.zzaH);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing raw event metadata. appId", zzcfl.zzdZ(zzcjz2.zzaH), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzyh() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzyi() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzG(List<Long> list) {
        zzbo.zzu(list);
        this.zzjC();
        this.zzkD();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzwF().zzyx().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzdU(String string) {
        zzbo.zzcF((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzaa(long l) {
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzwF().zzyD().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzyj() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzceu zzceu2, long l, boolean bl) {
        Object object;
        zzcjx zzcjx2;
        String string2;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)zzceu2);
        zzbo.zzcF((String)zzceu2.mAppId);
        zzcjw zzcjw2 = new zzcjw();
        new zzcjw().zzbvy = zzceu2.zzbpE;
        zzcjw2.zzbvw = new zzcjx[zzceu2.zzbpF.size()];
        int n = 0;
        for (String string2 : zzceu2.zzbpF) {
            zzcjx2 = new zzcjx();
            zzcjw2.zzbvw[n++] = zzcjx2;
            zzcjx2.name = string2;
            Object object2 = zzceu2.zzbpF.get(string2);
            this.zzwB().zza(zzcjx2, object2);
        }
        try {
            byte[] byArray = new byte[zzcjw2.zzLV()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcjx2 = adh.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjw2.zza((adh)zzcjx2);
            zzcjx2.zzLM();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize event params/data. appId", zzcfl.zzdZ(zzceu2.mAppId), iOException);
            return false;
        }
        this.zzwF().zzyD().zze("Saving event, name, data size", this.zzwA().zzdW(zzceu2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzceu2.mAppId);
        string2.put("name", zzceu2.mName);
        string2.put("timestamp", Long.valueOf(zzceu2.zzayS));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert raw event (got -1). appId", zzcfl.zzdZ(zzceu2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing raw event. appId", zzcfl.zzdZ(zzceu2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzyk() {
        return this.getContext().getDatabasePath(zzcem.zzxC()).exists();
    }

    @WorkerThread
    private static boolean zza(zzcfl zzcfl2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcfl2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcfl zzcfl2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzcfl2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcen.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzcfl2.zzyz().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcfl zzcfl2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzcfl2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcen.zza(zzcfl2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcen.zza(zzcfl2, sQLiteDatabase, string, string3, map);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcfl2.zzyx().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcfl zzcfl2, SQLiteDatabase sQLiteDatabase) {
        if (zzcfl2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcfl2.zzyz().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcfl2.zzyz().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcfl2.zzyz().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcfl2.zzyz().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcjf zza(zzcen zzcen2) {
        return zzcen2.zzbpt;
    }

    static /* synthetic */ Map zzyl() {
        return zzbpn;
    }

    static /* synthetic */ Map zzym() {
        return zzbpo;
    }

    static /* synthetic */ Map zzyn() {
        return zzbpq;
    }

    static /* synthetic */ Map zzyo() {
        return zzbpp;
    }

    static /* synthetic */ Map zzyp() {
        return zzbpr;
    }

    static {
        zzbpn.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zzbpo = new ArrayMap(18);
        zzbpo.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbpo.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbpo.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbpo.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbpo.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbpo.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbpo.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbpo.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbpo.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbpo.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbpo.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbpo.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbpo.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbpo.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbpo.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbpo.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzbpo.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzbpo.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzbpo.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzbpp = new ArrayMap(1);
        zzbpp.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzbpq = new ArrayMap(1);
        zzbpq.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzbpr = new ArrayMap(1);
        zzbpr.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }
}

