/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzchn;
import com.google.android.gms.internal.zzcho;
import com.google.android.gms.internal.zzchp;
import com.google.android.gms.internal.zzchq;
import com.google.android.gms.internal.zzchr;
import com.google.android.gms.internal.zzchs;
import com.google.android.gms.internal.zzcht;
import com.google.android.gms.internal.zzchu;
import com.google.android.gms.internal.zzchv;
import com.google.android.gms.internal.zzchw;
import com.google.android.gms.internal.zzchx;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzchl
extends zzchj {
    protected zzchy zzbto;
    private AppMeasurement.EventInterceptor zzbtp;
    private final Set<AppMeasurement.OnEventListener> zzbtq = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzbtr;
    private final AtomicReference<String> zzbts = new AtomicReference();

    protected zzchl(zzcgl zzcgl2) {
        super(zzcgl2);
    }

    @Override
    protected final void zzjD() {
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzkD();
        super.zzwp();
        super.zzwE().zzj(new zzchm(this, bl));
    }

    @WorkerThread
    private final void zzan(boolean bl) {
        super.zzjC();
        super.zzwp();
        this.zzkD();
        super.zzwF().zzyC().zzj("Setting app measurement enabled (FE)", bl);
        super.zzwG().setMeasurementEnabled(bl);
        super.zzww().zzzj();
    }

    public final void setMinimumSessionDuration(long l) {
        super.zzwp();
        super.zzwE().zzj(new zzchr(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        super.zzwp();
        super.zzwE().zzj(new zzchs(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        super.zzwp();
        boolean bl2 = this.zzbtp == null || zzcjl.zzex(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzd(String string, String string2, Bundle bundle) {
        super.zzwp();
        boolean bl = this.zzbtp == null || zzcjl.zzex(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        super.zzwp();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, super.zzkq().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        super.zzwE().zzj(new zzcht(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        zzbo.zzu((Object)bundle);
        super.zzjC();
        this.zzkD();
        if (!this.zzboe.isEnabled()) {
            super.zzwF().zzyC().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzbtr) {
            this.zzbtr = true;
            zzchl zzchl2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzchl zzchl3 = zzchl2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, super.getContext());
                }
                catch (Exception exception) {
                    super.zzwF().zzyz().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                super.zzwF().zzyB().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzcjl.zzex(string2);
        if (bl && this.zzbtp != null && !bl5 && !bl4) {
            super.zzwF().zzyC().zze("Passing event to registered event handler (FE)", super.zzwA().zzdW(string2), super.zzwA().zzA(bundle));
            this.zzbtp.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzboe.zzyP()) {
            return;
        }
        int n = super.zzwB().zzeq(string2);
        if (n != 0) {
            super.zzwB();
            String string4 = zzcjl.zza(string2, zzcem.zzxh(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzboe.zzwB().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = super.zzwB().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = super.zzwB().zzzt().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            super.zzwB();
            bundle2 = zzcjl.zzC(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = super.zzwB().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        zzcem.zzxE();
        zzcic zzcic2 = super.zzwx().zzzh();
        if (zzcic2 != null && !bundle3.containsKey("_sc")) {
            zzcic2.zzbtS = true;
        }
        object2 = zzcic2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzchz.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? super.zzwB().zzB(bundle5) : bundle5;
            super.zzwF().zzyC().zze("Logging event (FE)", super.zzwA().zzdW(string2), super.zzwA().zzA(bundle2));
            zzcez zzcez2 = new zzcez((String)object, new zzcew(bundle2), string, l);
            super.zzww().zzc(zzcez2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzbtq) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        zzcem.zzxE();
        if (super.zzwx().zzzh() != null && "_ae".equals(string2)) {
            super.zzwD().zzap(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbo.zzcF((String)string);
        long l = super.zzkq().currentTimeMillis();
        int n = super.zzwB().zzes(string2);
        if (n != 0) {
            super.zzwB();
            String string3 = zzcjl.zza(string2, zzcem.zzxi(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzboe.zzwB().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = super.zzwB().zzl(string2, object);
            if (n != 0) {
                super.zzwB();
                String string4 = zzcjl.zza(string2, zzcem.zzxi(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzboe.zzwB().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = super.zzwB().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        super.zzwE().zzj(new zzchu(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        super.zzjC();
        super.zzwp();
        this.zzkD();
        if (!this.zzboe.isEnabled()) {
            super.zzwF().zzyC().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzboe.zzyP()) {
            return;
        }
        super.zzwF().zzyC().zze("Setting user property (FE)", super.zzwA().zzdW(string2), object);
        zzcji zzcji2 = new zzcji(string2, l, object, string);
        super.zzww().zzb(zzcji2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcji> zzao(boolean bl) {
        super.zzwp();
        this.zzkD();
        super.zzwF().zzyC().log("Fetching user attributes (FE)");
        if (super.zzwE().zzyM()) {
            super.zzwF().zzyx().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        super.zzwE();
        if (zzcgg.zzS()) {
            super.zzwF().zzyx().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboe.zzwE().zzj(new zzchv(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwF().zzyz().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwF().zzyz().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = super.zzwG().zzyH();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)super.zzwE().zzyN(), (Callable)new zzchw(this));
        }
        catch (Exception exception) {
            super.zzwF().zzyz().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzyH() {
        super.zzwp();
        return this.zzbts.get();
    }

    @Nullable
    final String zzac(long l) {
        if (super.zzwE().zzyM()) {
            super.zzwF().zzyx().log("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        super.zzwE();
        if (zzcgg.zzS()) {
            super.zzwF().zzyx().log("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = super.zzkq().elapsedRealtime();
        String string = this.zzad(120000L);
        long l3 = super.zzkq().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zzad(120000L - l3);
        }
        return string;
    }

    final void zzee(@Nullable String string) {
        this.zzbts.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zzad(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            super.zzwE().zzj(new zzchx(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                super.zzwF().zzyz().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        super.zzjC();
        super.zzwp();
        this.zzkD();
        if (eventInterceptor != null && eventInterceptor != this.zzbtp) {
            zzbo.zza((this.zzbtp == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzbtp = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        super.zzwp();
        this.zzkD();
        zzbo.zzu((Object)onEventListener);
        if (!this.zzbtq.add(onEventListener)) {
            super.zzwF().zzyz().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        super.zzwp();
        this.zzkD();
        zzbo.zzu((Object)onEventListener);
        if (!this.zzbtq.remove(onEventListener)) {
            super.zzwF().zzyz().log("OnEventListener had not been registered");
        }
    }

    public static int getMaxUserProperties(String string) {
        zzbo.zzcF((String)string);
        return zzcem.zzxu();
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbo.zzu((Object)conditionalUserProperty);
        super.zzwp();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            super.zzwF().zzyz().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbo.zzu((Object)conditionalUserProperty);
        zzbo.zzcF((String)conditionalUserProperty.mAppId);
        super.zzwo();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = super.zzkq().currentTimeMillis();
        zzbo.zzu((Object)conditionalUserProperty);
        zzbo.zzcF((String)conditionalUserProperty.mName);
        zzbo.zzcF((String)conditionalUserProperty.mOrigin);
        zzbo.zzu((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (super.zzwB().zzes(string) != 0) {
            super.zzwF().zzyx().zzj("Invalid conditional user property name", super.zzwA().zzdY(string));
            return;
        }
        if (super.zzwB().zzl(string, object) != 0) {
            super.zzwF().zzyx().zze("Invalid conditional user property value", super.zzwA().zzdY(string), object);
            return;
        }
        Object object2 = super.zzwB().zzm(string, object);
        if (object2 == null) {
            super.zzwF().zzyx().zze("Unable to normalize conditional user property value", super.zzwA().zzdY(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= zzcem.zzxw() && l2 >= 1L)) {
            super.zzwF().zzyx().zze("Invalid conditional user property timeout", super.zzwA().zzdY(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > zzcem.zzxx() || l3 < 1L) {
            super.zzwF().zzyx().zze("Invalid conditional user property time to live", super.zzwA().zzdY(string), l3);
            return;
        }
        super.zzwE().zzj(new zzchn(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        super.zzwp();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbo.zzcF((String)string);
        super.zzwo();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = super.zzkq().currentTimeMillis();
        zzbo.zzcF((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        super.zzwE().zzj(new zzcho(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcez zzcez2;
        zzcez zzcez3;
        zzcez zzcez4;
        super.zzjC();
        this.zzkD();
        zzbo.zzu((Object)conditionalUserProperty);
        zzbo.zzcF((String)conditionalUserProperty.mName);
        zzbo.zzcF((String)conditionalUserProperty.mOrigin);
        zzbo.zzu((Object)conditionalUserProperty.mValue);
        if (!this.zzboe.isEnabled()) {
            super.zzwF().zzyC().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcji zzcji2 = new zzcji(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcez4 = super.zzwB().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcez3 = super.zzwB().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcez2 = super.zzwB().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcek zzcek2 = new zzcek(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcji2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcez3, conditionalUserProperty.mTriggerTimeout, zzcez4, conditionalUserProperty.mTimeToLive, zzcez2);
        super.zzww().zzf(zzcek2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcez zzcez2;
        super.zzjC();
        this.zzkD();
        zzbo.zzu((Object)conditionalUserProperty);
        zzbo.zzcF((String)conditionalUserProperty.mName);
        if (!this.zzboe.isEnabled()) {
            super.zzwF().zzyC().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcji zzcji2 = new zzcji(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcez2 = super.zzwB().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcek zzcek2 = new zzcek(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcji2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcez2);
        super.zzww().zzf(zzcek2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        super.zzwp();
        return this.zzl(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbo.zzcF((String)string);
        super.zzwo();
        return this.zzl(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzl(String string, String string2, String string3) {
        if (super.zzwE().zzyM()) {
            super.zzwF().zzyx().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        super.zzwE();
        if (zzcgg.zzS()) {
            super.zzwF().zzyx().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboe.zzwE().zzj(new zzchp(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwF().zzyz().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwF().zzyz().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcek zzcek2 = (zzcek)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcek2.zzbpe;
                conditionalUserProperty.mName = zzcek2.zzbpd.name;
                conditionalUserProperty.mValue = zzcek2.zzbpd.getValue();
                conditionalUserProperty.mActive = zzcek2.zzbpf;
                conditionalUserProperty.mTriggerEventName = zzcek2.zzbpg;
                if (zzcek2.zzbph != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcek2.zzbph.name;
                    if (zzcek2.zzbph.zzbpM != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcek2.zzbph.zzbpM.zzyt();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcek2.zzbpi;
                if (zzcek2.zzbpj != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcek2.zzbpj.name;
                    if (zzcek2.zzbpj.zzbpM != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcek2.zzbpj.zzbpM.zzyt();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcek2.zzbpd.zzbuy;
                conditionalUserProperty.mTimeToLive = zzcek2.zzbpk;
                if (zzcek2.zzbpl != null) {
                    conditionalUserProperty.mExpiredEventName = zzcek2.zzbpl.name;
                    if (zzcek2.zzbpl.zzbpM != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcek2.zzbpl.zzbpM.zzyt();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        super.zzwp();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbo.zzcF((String)string);
        super.zzwo();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (super.zzwE().zzyM()) {
            super.zzwF().zzyx().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        super.zzwE();
        if (zzcgg.zzS()) {
            super.zzwF().zzyx().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzboe.zzwE().zzj(new zzchq(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                super.zzwF().zzyz().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                super.zzwF().zzyz().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcji zzcji2 = (zzcji)((Object)iterator.next());
                arrayMap.put(zzcji2.name, zzcji2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzchl zzchl2, boolean bl) {
        zzchl2.zzan(bl);
    }

    static /* synthetic */ void zza(zzchl zzchl2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzchl2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzchl zzchl2, String string, String string2, Object object, long l) {
        zzchl2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzchl zzchl2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzchl2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzchl zzchl2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzchl2.zzc(conditionalUserProperty);
    }
}

