/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgq;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjl;

public final class zzciw {
    private final Context mContext;
    private final zzciz zzbum;

    public zzciw(zzciz zzciz2) {
        this.mContext = zzciz2.getContext();
        zzbo.zzu((Object)this.mContext);
        this.zzbum = zzciz2;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbo.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcjl.zzw(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcjl.zzw(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcfl zzcfl2 = zzcgl.zzbj(this.mContext).zzwF();
        zzcem.zzxE();
        zzcfl2.zzyD().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcfl zzcfl2 = zzcgl.zzbj(this.mContext).zzwF();
        zzcem.zzxE();
        zzcfl2.zzyD().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcfl zzcfl2 = zzcgl.zzbj(this.mContext).zzwF();
        if (intent == null) {
            zzcfl2.zzyz().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcem.zzxE();
        zzcfl2.zzyD().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzcgl zzcgl2 = zzcgl.zzbj(this.mContext);
        zzcfl zzcfl2 = zzcgl2.zzwF();
        zzcgl2.zzwE().zzj(new zzcix(this, zzcgl2, n, zzcfl2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcgq(zzcgl.zzbj(this.mContext));
        }
        this.zzwF().zzyz().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzwF().zzyD().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcfl zzcfl2 = zzcgl.zzbj(this.mContext).zzwF();
        String string = jobParameters.getExtras().getString("action");
        zzcem.zzxE();
        zzcfl2.zzyD().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzwF().zzyx().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzwF().zzyD().zzj("onRebind called. action", string);
    }

    private final zzcfl zzwF() {
        return zzcgl.zzbj(this.mContext).zzwF();
    }

    static /* synthetic */ zzciz zza(zzciw zzciw2) {
        return zzciw2.zzbum;
    }
}

