/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcam;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcal
extends zzcdr {
    private final Map<String, Long> zzikn;
    private final Map<String, Integer> zziko = new ArrayMap();
    private long zzikp;

    public zzcal(zzccu zzccu2) {
        super(zzccu2);
        this.zzikn = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdr)this).zzauk().zzayc().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdr)this).zzvu().elapsedRealtime();
        ((zzcdr)this).zzauj().zzg(new zzcam(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzug();
        zzbp.zzgf((String)string);
        if (this.zziko.isEmpty()) {
            this.zzikp = l;
        }
        if ((n = this.zziko.get(string)) != null) {
            this.zziko.put(string, n + 1);
            return;
        }
        if (this.zziko.size() >= 100) {
            ((zzcdr)this).zzauk().zzaye().log("Too many ads visible");
            return;
        }
        this.zziko.put(string, 1);
        this.zzikn.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdr)this).zzauk().zzayc().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdr)this).zzvu().elapsedRealtime();
        ((zzcdr)this).zzauj().zzg(new zzcan(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzug();
        zzbp.zzgf((String)string);
        Integer n = this.zziko.get(string);
        if (n != null) {
            zzcel zzcel2 = ((zzcdr)this).zzauc().zzazm();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zziko.remove(string);
                Long l2 = this.zzikn.get(string);
                if (l2 == null) {
                    ((zzcdr)this).zzauk().zzayc().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzikn.remove(string);
                    this.zza(string, l3, zzcel2);
                }
                if (this.zziko.isEmpty()) {
                    if (this.zzikp == 0L) {
                        ((zzcdr)this).zzauk().zzayc().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzikp, zzcel2);
                    this.zzikp = 0L;
                }
                return;
            }
            this.zziko.put(string, n2);
            return;
        }
        ((zzcdr)this).zzauk().zzayc().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdr)this).zzauk().zzayi().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdr)this).zzauk().zzayi().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzcei.zza(zzb2, bundle);
        ((zzcdr)this).zzaty().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdr)this).zzauk().zzayi().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdr)this).zzauk().zzayi().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzcei.zza(zzb2, bundle);
        ((zzcdr)this).zzaty().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzaj(long l) {
        zzcel zzcel2 = ((zzcdr)this).zzauc().zzazm();
        for (String string : this.zzikn.keySet()) {
            long l2 = this.zzikn.get(string);
            this.zza(string, l - l2, zzcel2);
        }
        if (!this.zzikn.isEmpty()) {
            this.zza(l - this.zzikp, zzcel2);
        }
        this.zzak(l);
    }

    @WorkerThread
    private final void zzak(long l) {
        for (String string : this.zzikn.keySet()) {
            this.zzikn.put(string, l);
        }
        if (!this.zzikn.isEmpty()) {
            this.zzikp = l;
        }
    }

    static /* synthetic */ void zza(zzcal zzcal2, String string, long l) {
        zzcal2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcal zzcal2, String string, long l) {
        zzcal2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcal zzcal2, long l) {
        zzcal2.zzak(l);
    }
}

