/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbce;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbr;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcfu;
import java.util.ArrayList;
import java.util.List;

public final class zzcbq
extends zzcds {
    private final zzcbr zzipc = new zzcbr(this, ((zzcdr)this).getContext(), zzcav.zzawi());
    private boolean zzipd;

    zzcbq(zzccu zzccu2) {
        super(zzccu2);
    }

    @Override
    protected final void zzuh() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    @WorkerThread
    private final boolean zzb(int n, byte[] byArray) {
        ((zzcdr)this).zzatu();
        ((zzcdr)this).zzug();
        if (this.zzipd) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        zzcav.zzaws();
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzcdr)this).zzauk().zzaye().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzcdr)this).zzauk().zzayc().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzcdr)this).zzauk().zzayc().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzipd = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcdr)this).zzauk().zzayc().zzj("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzipd = true;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block20;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcdr)this).zzauk().zzayc().zzj("Error writing entry to local database", (Object)sQLiteException);
                        this.zzipd = true;
                    }
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcbi zzcbi2) {
        Parcel parcel = Parcel.obtain();
        zzcbi2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcdr)this).zzauk().zzaye().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zzb(0, byArray);
    }

    public final boolean zza(zzcfr zzcfr2) {
        Parcel parcel = Parcel.obtain();
        zzcfr2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcdr)this).zzauk().zzaye().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(1, byArray);
    }

    public final boolean zzc(zzcat zzcat2) {
        ((zzcdr)this).zzaug();
        byte[] byArray = zzcfu.zza((Parcelable)zzcat2);
        if (byArray.length > 131072) {
            ((zzcdr)this).zzauk().zzaye().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public final List<zzbcc> zzdv(int n) {
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzatu();
        if (this.zzipd) {
            return null;
        }
        ArrayList<zzbcc> arrayList = new ArrayList<zzbcc>();
        if (!((zzcdr)this).getContext().getDatabasePath(zzcav.zzawi()).exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzcdr)this).zzauk().zzaye().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zzbcc zzbcc2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbcc2 = (zzcbi)((Object)zzcbi.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbce zzbce2) {
                                    ((zzcdr)this).zzauk().zzayc().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zzbcc2 == null) continue;
                                arrayList.add(zzbcc2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zzbcc2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbcc2 = (zzcfr)((Object)zzcfr.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbce zzbce3) {
                                    ((zzcdr)this).zzauk().zzayc().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbcc2 == null) continue;
                                arrayList.add(zzbcc2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zzbcc2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbcc2 = (zzcat)((Object)zzcat.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbce zzbce4) {
                                    ((zzcdr)this).zzauk().zzayc().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbcc2 == null) continue;
                                arrayList.add(zzbcc2);
                                continue;
                            }
                            ((zzcdr)this).zzauk().zzayc().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzcdr)this).zzauk().zzayc().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzipd = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcdr)this).zzauk().zzayc().zzj("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzipd = true;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block41;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcdr)this).zzauk().zzayc().zzj("Error reading entries from local database", (Object)sQLiteException);
                        this.zzipd = true;
                    }
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() {
        if (this.zzipd) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzipc.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzipd = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

