/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcal;
import com.google.android.gms.internal.zzcao;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzccp;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcei
extends zzcds {
    protected zzcel zziva;
    private volatile AppMeasurement.zzb zzivb;
    private AppMeasurement.zzb zzivc;
    private long zzivd;
    private final Map<Activity, zzcel> zzive = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzivf = new CopyOnWriteArrayList();
    private boolean zzivg;
    private AppMeasurement.zzb zzivh;
    private String zzivi;

    public zzcei(zzccu zzccu2) {
        super(zzccu2);
    }

    @Override
    protected final void zzuh() {
    }

    @WorkerThread
    public final zzcel zzazm() {
        this.zzwh();
        ((zzcdr)this).zzug();
        return this.zziva;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcdr)this).zzauk().zzaye().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcdr)this).zzauj();
        if (!zzccp.zzaq()) {
            ((zzcdr)this).zzauk().zzaye().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzivg) {
            ((zzcdr)this).zzauk().zzaye().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzivb == null) {
            ((zzcdr)this).zzauk().zzaye().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzive.get(activity) == null) {
            ((zzcdr)this).zzauk().zzaye().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcei.zzjt(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzivb.zzikh.equals(string2);
        boolean bl2 = zzcfu.zzau(this.zzivb.zzikg, string);
        if (bl && bl2) {
            ((zzcdr)this).zzauk().zzayf().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcav.zzavp())) {
            ((zzcdr)this).zzauk().zzaye().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcav.zzavp())) {
            ((zzcdr)this).zzauk().zzaye().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcdr)this).zzauk().zzayi().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcel zzcel2 = new zzcel(string, string2, ((zzcdr)this).zzaug().zzazw());
        this.zzive.put(activity, zzcel2);
        this.zza(activity, zzcel2, true);
    }

    public final AppMeasurement.zzb zzazn() {
        ((zzcdr)this).zzatu();
        AppMeasurement.zzb zzb2 = this.zzivb;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdr)this).zzatu();
        if (zza2 == null) {
            ((zzcdr)this).zzauk().zzaye().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzivf.remove(zza2);
        this.zzivf.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdr)this).zzatu();
        this.zzivf.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcel zzcel2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzivb != null) {
            zzb2 = this.zzivb;
        } else if (this.zzivc != null && Math.abs(((zzcdr)this).zzvu().elapsedRealtime() - this.zzivd) < 1000L) {
            zzb2 = this.zzivc;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzivg = true;
        try {
            object2 = this.zzivf.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcel2);
                }
                catch (Exception exception) {
                    ((zzcdr)this).zzauk().zzayc().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcdr)this).zzauk().zzayc().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzivg = false;
        }
        Object object3 = object2 = this.zzivb == null ? this.zzivc : this.zzivb;
        if (bl2) {
            if (zzcel2.zzikh == null) {
                zzcel2.zzikh = zzcei.zzjt(activity.getClass().getCanonicalName());
            }
            object = new zzcel(zzcel2);
            this.zzivc = this.zzivb;
            this.zzivd = ((zzcdr)this).zzvu().elapsedRealtime();
            this.zzivb = object;
            ((zzcdr)this).zzauj().zzg(new zzcej(this, bl, (AppMeasurement.zzb)object2, (zzcel)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcel zzcel2) {
        ((zzcdr)this).zzatw().zzaj(((zzcdr)this).zzvu().elapsedRealtime());
        if (((zzcdr)this).zzaui().zzbr(zzcel2.zzivo)) {
            zzcel2.zzivo = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzikg != null) {
                bundle.putString("_sn", zzb2.zzikg);
            }
            bundle.putString("_sc", zzb2.zzikh);
            bundle.putLong("_si", zzb2.zziki);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcdr)this).zzug();
        zzcei zzcei2 = this;
        synchronized (zzcei2) {
            if (this.zzivi == null || this.zzivi.equals(string) || zzb2 != null) {
                this.zzivi = string;
                this.zzivh = zzb2;
            }
            return;
        }
    }

    private static String zzjt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcel zzq(@NonNull Activity activity) {
        zzbp.zzu((Object)activity);
        zzcel zzcel2 = this.zzive.get(activity);
        if (zzcel2 == null) {
            String string = zzcei.zzjt(activity.getClass().getCanonicalName());
            zzcel2 = new zzcel(null, string, ((zzcdr)this).zzaug().zzazw());
            this.zzive.put(activity, zzcel2);
        }
        return zzcel2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcel zzcel2 = this.zzq(activity);
        this.zza(activity, zzcel2, false);
        zzcal zzcal2 = ((zzcdr)this).zzatw();
        long l = ((zzcdr)zzcal2).zzvu().elapsedRealtime();
        ((zzcdr)zzcal2).zzauj().zzg(new zzcao(zzcal2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcel zzcel2 = this.zzq(activity);
        this.zzivc = this.zzivb;
        this.zzivd = ((zzcdr)this).zzvu().elapsedRealtime();
        this.zzivb = null;
        ((zzcdr)this).zzauj().zzg(new zzcek(this, zzcel2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcel zzcel2 = this.zzive.get(activity);
        if (zzcel2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcel2.zziki);
        bundle2.putString("name", zzcel2.zzikg);
        bundle2.putString("referrer_name", zzcel2.zzikh);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzive.remove(activity);
    }

    static /* synthetic */ void zza(zzcei zzcei2, zzcel zzcel2) {
        zzcei2.zza(zzcel2);
    }
}

