/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzccz;
import com.google.android.gms.internal.zzcfg;
import com.google.android.gms.internal.zzcfu;

public final class zzcff<T extends Context> {
    private final T zziwi;

    public zzcff(T t) {
        zzbp.zzu(t);
        this.zziwi = t;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbp.zzu((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzcfu.zzw(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzcfu.zzw(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzcbu zzcbu2 = zzccu.zzdm(this.zziwi).zzauk();
        zzcav.zzawj();
        zzcbu2.zzayi().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzcbu zzcbu2 = zzccu.zzdm(this.zziwi).zzauk();
        zzcav.zzawj();
        zzcbu2.zzayi().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcbu zzcbu2 = zzccu.zzdm(this.zziwi).zzauk();
        if (intent == null) {
            zzcbu2.zzaye().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcav.zzawj();
        zzcbu2.zzayi().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(n2, null);
        }
        return 2;
    }

    private final void zza(Integer n, JobParameters jobParameters) {
        zzccu zzccu2 = zzccu.zzdm(this.zziwi);
        zzcbu zzcbu2 = zzccu2.zzauk();
        zzccu2.zzauj().zzg(new zzcfg(this, zzccu2, n, zzcbu2, jobParameters));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzccz(zzccu.zzdm(this.zziwi));
        }
        this.zzauk().zzaye().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzauk().zzayi().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcbu zzcbu2 = zzccu.zzdm(this.zziwi).zzauk();
        String string = jobParameters.getExtras().getString("action");
        zzcav.zzawj();
        zzcbu2.zzayi().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zza(null, jobParameters);
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzauk().zzayc().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzauk().zzayi().zzj("onRebind called. action", string);
    }

    private final zzcbu zzauk() {
        return zzccu.zzdm(this.zziwi).zzauk();
    }

    static /* synthetic */ Context zza(zzcff zzcff2) {
        return zzcff2.zziwi;
    }
}

