/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcba;
import com.google.android.gms.internal.zzccl;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfq;

public final class zzcfp
extends zzcds {
    private final AlarmManager zzdrc = (AlarmManager)((zzcdr)this).getContext().getSystemService("alarm");
    private final zzcba zziwr;
    private Integer zziws;

    protected zzcfp(zzccu zzccu2) {
        super(zzccu2);
        this.zziwr = new zzcfq(this, zzccu2);
    }

    @Override
    protected final void zzuh() {
        this.zzdrc.cancel(this.zzyh());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzazu();
        }
    }

    @TargetApi(value=24)
    private final void zzazu() {
        JobScheduler jobScheduler = (JobScheduler)((zzcdr)this).getContext().getSystemService("jobscheduler");
        ((zzcdr)this).zzauk().zzayi().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzwh();
        zzcav.zzawj();
        if (!zzccl.zzj(((zzcdr)this).getContext(), false)) {
            ((zzcdr)this).zzauk().zzayh().log("Receiver not registered/enabled");
        }
        zzcav.zzawj();
        if (!zzcff.zzk(((zzcdr)this).getContext(), false)) {
            ((zzcdr)this).zzauk().zzayh().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzcdr)this).zzvu().elapsedRealtime() + l;
        if (l < zzcav.zzaxa() && !this.zziwr.zzdp()) {
            ((zzcdr)this).zzauk().zzayi().log("Scheduling upload with DelayedRunnable");
            this.zziwr.zzs(l);
        }
        zzcav.zzawj();
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzcdr)this).zzauk().zzayi().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcfp zzcfp2 = this;
            ComponentName componentName = new ComponentName(((zzcdr)zzcfp2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzcdr)zzcfp2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcfp2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzcdr)zzcfp2).zzauk().zzayi().zzj("Scheduling job. JobID", zzcfp2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzcdr)this).zzauk().zzayi().log("Scheduling upload with AlarmManager");
        this.zzdrc.setInexactRepeating(2, l2, Math.max(zzcav.zzaxb(), l), this.zzyh());
    }

    private final int getJobId() {
        if (this.zziws == null) {
            String string = String.valueOf(((zzcdr)this).getContext().getPackageName());
            this.zziws = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zziws;
    }

    public final void cancel() {
        this.zzwh();
        this.zzdrc.cancel(this.zzyh());
        this.zziwr.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzazu();
        }
    }

    private final PendingIntent zzyh() {
        Intent intent = new Intent();
        Context context = ((zzcdr)this).getContext();
        zzcav.zzawj();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzcdr)this).getContext(), (int)0, (Intent)intent2, (int)0);
    }

    private final void zzazv() {
        Intent intent = new Intent();
        Context context = ((zzcdr)this).getContext();
        zzcav.zzawj();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        ((zzcdr)this).getContext().sendBroadcast(intent2);
    }

    static /* synthetic */ void zza(zzcfp zzcfp2) {
        zzcfp2.zzazv();
    }
}

