/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcbr
extends zzcdu {
    private String mAppId;
    private String zzdmb;
    private int zziph;
    private String zzile;
    private String zzdma;
    private long zzipi;
    private long zzili;
    private int zzipj;
    private String zzcyd;

    zzcbr(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcdt)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcdt)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcdt)this).zzaum().zzaye().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcbw.zzjf(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcdt)this).zzaum().zzaye().zzj("Error retrieving app installer package name. appId", zzcbw.zzjf(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcdt)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcdt)this).zzaum().zzaye().zze("Error retrieving package info. appId, appName", zzcbw.zzjf(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzile = string;
        this.zzdmb = string2;
        this.zziph = n;
        this.zzdma = string3;
        this.zzipi = 0L;
        zzcax.zzawl();
        packageInfo = zzca.zzcb((Context)((zzcdt)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcbr zzcbr2 = this;
            if (packageInfo2 == null) {
                ((zzcdt)zzcbr2).zzaum().zzaye().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcdt)zzcbr2).zzaum().zzaye().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcdt)this).zzauo().zzit("firebase_analytics_collection_enabled");
            if (((zzcdt)this).zzauo().zzawm()) {
                ((zzcdt)this).zzaum().zzayi().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcdt)this).zzaum().zzayi().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcax.zzaif()) {
                ((zzcdt)this).zzaum().zzayi().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcdt)this).zzaum().zzayk().log("Collection enabled");
            }
        }
        this.zzcyd = "";
        this.zzili = 0L;
        zzcax.zzawl();
        try {
            object = zzca.zzaie();
            Object object2 = this.zzcyd = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcdt)this).zzaum().zzayk().zze("App package, google app id", this.mAppId, this.zzcyd);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdt)this).zzaum().zzaye().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcbw.zzjf(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzipj = zzbeb.zzcp((Context)((zzcdt)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzipj = 0;
    }

    @WorkerThread
    final zzcas zzjb(String string) {
        ((zzcdt)this).zzuj();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcbr zzcbr2 = this;
        zzcbr2.zzwk();
        String string4 = zzcbr2.zzdmb;
        long l = this.zzayc();
        zzcbr2 = this;
        zzcbr2.zzwk();
        String string5 = zzcbr2.zzile;
        long l2 = zzcax.zzauw();
        zzcbr2 = this;
        zzcbr2.zzwk();
        ((zzcdt)zzcbr2).zzuj();
        if (zzcbr2.zzipi == 0L) {
            zzcbr2.zzipi = zzcbr2.zzikh.zzaui().zzah(((zzcdt)zzcbr2).getContext(), ((zzcdt)zzcbr2).getContext().getPackageName());
        }
        long l3 = zzcbr2.zzipi;
        boolean bl = this.zzikh.isEnabled();
        boolean bl2 = !((zzcdt)this).zzaun().zzirg;
        String string6 = this.zzaur();
        this.zzwk();
        long l4 = this.zzikh.zzazf();
        zzcbr2 = this;
        zzcbr2.zzwk();
        return new zzcas(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcbr2.zzipj);
    }

    @WorkerThread
    final String zzayb() {
        byte[] byArray = new byte[16];
        ((zzcdt)this).zzaui().zzazz().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzaur() {
        ((zzcdt)this).zzuj();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdt)this).zzaum().zzayg().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwk();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwk();
        return this.zzcyd;
    }

    final int zzayc() {
        this.zzwk();
        return this.zziph;
    }
}

