/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcdx;
import com.google.android.gms.internal.zzcdy;
import com.google.android.gms.internal.zzcdz;
import com.google.android.gms.internal.zzcea;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzced;
import com.google.android.gms.internal.zzcee;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcdw
extends zzcdu {
    protected zzcej zzius;
    private AppMeasurement.EventInterceptor zziut;
    private final Set<AppMeasurement.OnEventListener> zziuu = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zziuv;
    private final AtomicReference<String> zziuw = new AtomicReference();

    protected zzcdw(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzwk();
        ((zzcdt)this).zzatw();
        ((zzcdt)this).zzaul().zzg(new zzcdx(this, bl));
    }

    @WorkerThread
    private final void zzbp(boolean bl) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatw();
        this.zzwk();
        ((zzcdt)this).zzaum().zzayj().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcdt)this).zzaun().setMeasurementEnabled(bl);
        ((zzcdt)this).zzaud().zzazq();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcdt)this).zzatw();
        ((zzcdt)this).zzaul().zzg(new zzcec(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcdt)this).zzatw();
        ((zzcdt)this).zzaul().zzg(new zzced(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        ((zzcdt)this).zzatw();
        boolean bl2 = this.zziut == null || zzcfw.zzkd(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        ((zzcdt)this).zzatw();
        boolean bl = this.zziut == null || zzcfw.zzkd(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        ((zzcdt)this).zzatw();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcdt)this).zzvx().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcdt)this).zzaul().zzg(new zzcee(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        zzbp.zzu((Object)bundle);
        ((zzcdt)this).zzuj();
        this.zzwk();
        if (!this.zzikh.isEnabled()) {
            ((zzcdt)this).zzaum().zzayj().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zziuv) {
            this.zziuv = true;
            zzcdw zzcdw2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcdw zzcdw3 = zzcdw2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcdt)zzcdw3).getContext());
                }
                catch (Exception exception) {
                    ((zzcdt)zzcdw3).zzaum().zzayg().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcdt)zzcdw2).zzaum().zzayi().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzcfw.zzkd(string2);
        if (bl && this.zziut != null && !bl5 && !bl4) {
            ((zzcdt)this).zzaum().zzayj().zze("Passing event to registered event handler (FE)", ((zzcdt)this).zzauh().zzjc(string2), ((zzcdt)this).zzauh().zzx(bundle));
            this.zziut.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzikh.zzayw()) {
            return;
        }
        int n = ((zzcdt)this).zzaui().zzjw(string2);
        if (n != 0) {
            ((zzcdt)this).zzaui();
            String string4 = zzcfw.zza(string2, zzcax.zzavo(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzikh.zzaui().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcdt)this).zzaui().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcdt)this).zzaui().zzazz().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcdt)this).zzaui();
            bundle2 = zzcfw.zzac(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcdt)this).zzaui().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        zzcax.zzawl();
        zzcen zzcen2 = ((zzcdt)this).zzaue().zzazo();
        if (zzcen2 != null && !bundle3.containsKey("_sc")) {
            zzcen2.zzivw = true;
        }
        object2 = zzcen2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzcek.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcdt)this).zzaui().zzy(bundle5) : bundle5;
            ((zzcdt)this).zzaum().zzayj().zze("Logging event (FE)", ((zzcdt)this).zzauh().zzjc(string2), ((zzcdt)this).zzauh().zzx(bundle2));
            zzcbk zzcbk2 = new zzcbk((String)object, new zzcbh(bundle2), string, l);
            ((zzcdt)this).zzaud().zzc(zzcbk2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zziuu) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        zzcax.zzawl();
        if (((zzcdt)this).zzaue().zzazo() != null && "_ae".equals(string2)) {
            ((zzcdt)this).zzauk().zzbs(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbp.zzgg((String)string);
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        int n = ((zzcdt)this).zzaui().zzjy(string2);
        if (n != 0) {
            ((zzcdt)this).zzaui();
            String string3 = zzcfw.zza(string2, zzcax.zzavp(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzikh.zzaui().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcdt)this).zzaui().zzl(string2, object);
            if (n != 0) {
                ((zzcdt)this).zzaui();
                String string4 = zzcfw.zza(string2, zzcax.zzavp(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzikh.zzaui().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcdt)this).zzaui().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcdt)this).zzaul().zzg(new zzcef(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatw();
        this.zzwk();
        if (!this.zzikh.isEnabled()) {
            ((zzcdt)this).zzaum().zzayj().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzikh.zzayw()) {
            return;
        }
        ((zzcdt)this).zzaum().zzayj().zze("Setting user property (FE)", ((zzcdt)this).zzauh().zzjc(string2), object);
        zzcft zzcft2 = new zzcft(string2, l, object, string);
        ((zzcdt)this).zzaud().zzb(zzcft2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcft> zzbq(boolean bl) {
        ((zzcdt)this).zzatw();
        this.zzwk();
        ((zzcdt)this).zzaum().zzayj().log("Fetching user attributes (FE)");
        if (((zzcdt)this).zzaul().zzayt()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdt)this).zzaul();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikh.zzaul().zzg(new zzceg(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaum().zzayg().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaum().zzayg().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcdt)this).zzaun().zzayo();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcdt)this).zzaul().zzayu(), (Callable)new zzceh(this));
        }
        catch (Exception exception) {
            ((zzcdt)this).zzaum().zzayg().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzayo() {
        ((zzcdt)this).zzatw();
        return this.zziuw.get();
    }

    final void zzjk(@Nullable String string) {
        this.zziuw.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbc(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcdt)this).zzaul().zzg(new zzcei(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaum().zzayg().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatw();
        this.zzwk();
        if (eventInterceptor != null && eventInterceptor != this.zziut) {
            zzbp.zza((this.zziut == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zziut = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdt)this).zzatw();
        this.zzwk();
        zzbp.zzu((Object)onEventListener);
        if (!this.zziuu.add(onEventListener)) {
            ((zzcdt)this).zzaum().zzayg().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdt)this).zzatw();
        this.zzwk();
        zzbp.zzu((Object)onEventListener);
        if (!this.zziuu.remove(onEventListener)) {
            ((zzcdt)this).zzaum().zzayg().log("OnEventListener had not been registered");
        }
    }

    public static int getMaxUserProperties(String string) {
        zzbp.zzgg((String)string);
        return zzcax.zzawb();
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        ((zzcdt)this).zzatw();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcdt)this).zzaum().zzayg().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mAppId);
        ((zzcdt)this).zzatv();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        zzbp.zzgg((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcdt)this).zzaui().zzjy(string) != 0) {
            ((zzcdt)this).zzaum().zzaye().zzj("Invalid conditional user property name", ((zzcdt)this).zzauh().zzje(string));
            return;
        }
        if (((zzcdt)this).zzaui().zzl(string, object) != 0) {
            ((zzcdt)this).zzaum().zzaye().zze("Invalid conditional user property value", ((zzcdt)this).zzauh().zzje(string), object);
            return;
        }
        Object object2 = ((zzcdt)this).zzaui().zzm(string, object);
        if (object2 == null) {
            ((zzcdt)this).zzaum().zzaye().zze("Unable to normalize conditional user property value", ((zzcdt)this).zzauh().zzje(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= zzcax.zzawd() && l2 >= 1L)) {
            ((zzcdt)this).zzaum().zzaye().zze("Invalid conditional user property timeout", ((zzcdt)this).zzauh().zzje(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > zzcax.zzawe() || l3 < 1L) {
            ((zzcdt)this).zzaum().zzaye().zze("Invalid conditional user property time to live", ((zzcdt)this).zzauh().zzje(string), l3);
            return;
        }
        ((zzcdt)this).zzaul().zzg(new zzcdy(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzcdt)this).zzatw();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatv();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        zzbp.zzgg((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcdt)this).zzaul().zzg(new zzcdz(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbk zzcbk2;
        zzcbk zzcbk3;
        zzcbk zzcbk4;
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        zzbp.zzgg((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        if (!this.zzikh.isEnabled()) {
            ((zzcdt)this).zzaum().zzayj().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcft zzcft2 = new zzcft(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcbk4 = ((zzcdt)this).zzaui().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbk3 = ((zzcdt)this).zzaui().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbk2 = ((zzcdt)this).zzaui().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcav zzcav2 = new zzcav(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcft2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcbk3, conditionalUserProperty.mTriggerTimeout, zzcbk4, conditionalUserProperty.mTimeToLive, zzcbk2);
        ((zzcdt)this).zzaud().zzf(zzcav2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbk zzcbk2;
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        if (!this.zzikh.isEnabled()) {
            ((zzcdt)this).zzaum().zzayj().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcft zzcft2 = new zzcft(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcbk2 = ((zzcdt)this).zzaui().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcav zzcav2 = new zzcav(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcft2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcbk2);
        ((zzcdt)this).zzaud().zzf(zzcav2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzcdt)this).zzatw();
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatv();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcdt)this).zzaul().zzayt()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdt)this).zzaul();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikh.zzaul().zzg(new zzcea(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaum().zzayg().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaum().zzayg().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcav zzcav2 = (zzcav)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcav2.zzimh;
                conditionalUserProperty.mName = zzcav2.zzimg.name;
                conditionalUserProperty.mValue = zzcav2.zzimg.getValue();
                conditionalUserProperty.mActive = zzcav2.zzimi;
                conditionalUserProperty.mTriggerEventName = zzcav2.zzimj;
                if (zzcav2.zzimk != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcav2.zzimk.name;
                    if (zzcav2.zzimk.zzinq != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcav2.zzimk.zzinq.zzaya();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcav2.zziml;
                if (zzcav2.zzimm != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcav2.zzimm.name;
                    if (zzcav2.zzimm.zzinq != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcav2.zzimm.zzinq.zzaya();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcav2.zzimg.zziwy;
                conditionalUserProperty.mTimeToLive = zzcav2.zzimn;
                if (zzcav2.zzimo != null) {
                    conditionalUserProperty.mExpiredEventName = zzcav2.zzimo.name;
                    if (zzcav2.zzimo.zzinq != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcav2.zzimo.zzinq.zzaya();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzcdt)this).zzatw();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatv();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcdt)this).zzaul().zzayt()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcdt)this).zzaul();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaum().zzaye().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzikh.zzaul().zzg(new zzceb(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaum().zzayg().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaum().zzayg().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcft zzcft2 = (zzcft)((Object)iterator.next());
                arrayMap.put(zzcft2.name, zzcft2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, boolean bl) {
        zzcdw2.zzbp(bl);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcdw2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, String string, String string2, Object object, long l) {
        zzcdw2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdw2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcdw zzcdw2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdw2.zzc(conditionalUserProperty);
    }
}

