/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcao;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcan
extends zzcdt {
    private final Map<String, Long> zziku;
    private final Map<String, Integer> zzikv = new ArrayMap();
    private long zzikw;

    public zzcan(zzccw zzccw2) {
        super(zzccw2);
        this.zziku = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdt)this).zzaul().zzayd().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdt)this).zzvx().elapsedRealtime();
        ((zzcdt)this).zzauk().zzg(new zzcao(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzuj();
        zzbp.zzgg((String)string);
        if (this.zzikv.isEmpty()) {
            this.zzikw = l;
        }
        if ((n = this.zzikv.get(string)) != null) {
            this.zzikv.put(string, n + 1);
            return;
        }
        if (this.zzikv.size() >= 100) {
            ((zzcdt)this).zzaul().zzayf().log("Too many ads visible");
            return;
        }
        this.zzikv.put(string, 1);
        this.zziku.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcdt)this).zzaul().zzayd().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcdt)this).zzvx().elapsedRealtime();
        ((zzcdt)this).zzauk().zzg(new zzcap(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzuj();
        zzbp.zzgg((String)string);
        Integer n = this.zzikv.get(string);
        if (n != null) {
            zzcen zzcen2 = ((zzcdt)this).zzaud().zzazn();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzikv.remove(string);
                Long l2 = this.zziku.get(string);
                if (l2 == null) {
                    ((zzcdt)this).zzaul().zzayd().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zziku.remove(string);
                    this.zza(string, l3, zzcen2);
                }
                if (this.zzikv.isEmpty()) {
                    if (this.zzikw == 0L) {
                        ((zzcdt)this).zzaul().zzayd().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzikw, zzcen2);
                    this.zzikw = 0L;
                }
                return;
            }
            this.zzikv.put(string, n2);
            return;
        }
        ((zzcdt)this).zzaul().zzayd().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdt)this).zzaul().zzayj().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdt)this).zzaul().zzayj().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzcek.zza(zzb2, bundle);
        ((zzcdt)this).zzatz().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcdt)this).zzaul().zzayj().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcdt)this).zzaul().zzayj().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzcek.zza(zzb2, bundle);
        ((zzcdt)this).zzatz().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzaj(long l) {
        zzcen zzcen2 = ((zzcdt)this).zzaud().zzazn();
        for (String string : this.zziku.keySet()) {
            long l2 = this.zziku.get(string);
            this.zza(string, l - l2, zzcen2);
        }
        if (!this.zziku.isEmpty()) {
            this.zza(l - this.zzikw, zzcen2);
        }
        this.zzak(l);
    }

    @WorkerThread
    private final void zzak(long l) {
        for (String string : this.zziku.keySet()) {
            this.zziku.put(string, l);
        }
        if (!this.zziku.isEmpty()) {
            this.zzikw = l;
        }
    }

    static /* synthetic */ void zza(zzcan zzcan2, String string, long l) {
        zzcan2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcan zzcan2, String string, long l) {
        zzcan2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcan zzcan2, long l) {
        zzcan2.zzak(l);
    }
}

