/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcbr
extends zzcdu {
    private String mAppId;
    private String zzdmc;
    private int zzipi;
    private String zzilf;
    private String zzdmb;
    private long zzipj;
    private long zzilj;
    private int zzipk;
    private String zzcye;

    zzcbr(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcdt)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcdt)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcdt)this).zzaul().zzayd().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcbw.zzjf(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcdt)this).zzaul().zzayd().zzj("Error retrieving app installer package name. appId", zzcbw.zzjf(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcdt)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcdt)this).zzaul().zzayd().zze("Error retrieving package info. appId, appName", zzcbw.zzjf(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzilf = string;
        this.zzdmc = string2;
        this.zzipi = n;
        this.zzdmb = string3;
        this.zzipj = 0L;
        zzcax.zzawk();
        packageInfo = zzca.zzcb((Context)((zzcdt)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcbr zzcbr2 = this;
            if (packageInfo2 == null) {
                ((zzcdt)zzcbr2).zzaul().zzayd().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcdt)zzcbr2).zzaul().zzayd().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcdt)this).zzaun().zzit("firebase_analytics_collection_enabled");
            if (((zzcdt)this).zzaun().zzawl()) {
                ((zzcdt)this).zzaul().zzayh().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcdt)this).zzaul().zzayh().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcax.zzaif()) {
                ((zzcdt)this).zzaul().zzayh().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcdt)this).zzaul().zzayj().log("Collection enabled");
            }
        }
        this.zzcye = "";
        this.zzilj = 0L;
        zzcax.zzawk();
        try {
            object = zzca.zzaie();
            Object object2 = this.zzcye = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcdt)this).zzaul().zzayj().zze("App package, google app id", this.mAppId, this.zzcye);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdt)this).zzaul().zzayd().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcbw.zzjf(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzipk = zzbeb.zzcp((Context)((zzcdt)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzipk = 0;
    }

    @WorkerThread
    final zzcas zzjb(String string) {
        ((zzcdt)this).zzuj();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcbr zzcbr2 = this;
        zzcbr2.zzwk();
        String string4 = zzcbr2.zzdmc;
        long l = this.zzayb();
        zzcbr2 = this;
        zzcbr2.zzwk();
        String string5 = zzcbr2.zzilf;
        long l2 = zzcax.zzauv();
        zzcbr2 = this;
        zzcbr2.zzwk();
        ((zzcdt)zzcbr2).zzuj();
        if (zzcbr2.zzipj == 0L) {
            zzcbr2.zzipj = zzcbr2.zziki.zzauh().zzah(((zzcdt)zzcbr2).getContext(), ((zzcdt)zzcbr2).getContext().getPackageName());
        }
        long l3 = zzcbr2.zzipj;
        boolean bl = this.zziki.isEnabled();
        boolean bl2 = !((zzcdt)this).zzaum().zzirh;
        String string6 = this.zzauq();
        this.zzwk();
        long l4 = this.zziki.zzaze();
        zzcbr2 = this;
        zzcbr2.zzwk();
        return new zzcas(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcbr2.zzipk);
    }

    @WorkerThread
    final String zzaya() {
        byte[] byArray = new byte[16];
        ((zzcdt)this).zzauh().zzazy().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzauq() {
        ((zzcdt)this).zzuj();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdt)this).zzaul().zzayf().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwk();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwk();
        return this.zzcye;
    }

    final int zzayb() {
        this.zzwk();
        return this.zzipi;
    }
}

