/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzccj;
import com.google.android.gms.internal.zzcck;
import com.google.android.gms.internal.zzccl;
import com.google.android.gms.internal.zzccm;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcfw;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcch
extends zzcdu {
    static final Pair<String, Long> zziqn = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdtq;
    public final zzccl zziqo = new zzccl(this, "health_monitor", zzcax.zzawq(), null);
    public final zzcck zziqp = new zzcck(this, "last_upload", 0L);
    public final zzcck zziqq = new zzcck(this, "last_upload_attempt", 0L);
    public final zzcck zziqr = new zzcck(this, "backoff", 0L);
    public final zzcck zziqs = new zzcck(this, "last_delete_stale", 0L);
    public final zzcck zziqt;
    public final zzcck zziqu;
    public final zzccm zziqv;
    private String zziqw;
    private boolean zziqx;
    private long zziqy;
    private String zziqz;
    private long zzira;
    private final Object zzirb;
    public final zzcck zzirc = new zzcck(this, "time_before_start", 10000L);
    public final zzcck zzird = new zzcck(this, "session_timeout", 1800000L);
    public final zzccj zzire = new zzccj(this, "start_new_session", true);
    public final zzcck zzirf = new zzcck(this, "last_pause_time", 0L);
    public final zzcck zzirg = new zzcck(this, "time_active", 0L);
    public boolean zzirh;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjh(String string) {
        this.zzuj();
        long l = this.zzvx().elapsedRealtime();
        if (this.zziqw != null && l < this.zziqy) {
            return new Pair((Object)this.zziqw, (Object)this.zziqx);
        }
        String string2 = string;
        this.zziqy = l + this.zzaun().zza(string2, zzcbm.zzioc);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zziqw = info.getId();
                this.zziqx = info.isLimitAdTrackingEnabled();
            }
            if (this.zziqw == null) {
                this.zziqw = "";
            }
        }
        catch (Throwable throwable) {
            this.zzaul().zzayi().zzj("Unable to get advertising id", throwable);
            this.zziqw = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zziqw, (Object)this.zziqx);
    }

    @WorkerThread
    final String zzji(String string) {
        this.zzuj();
        String string2 = (String)this.zzjh((String)string).first;
        MessageDigest messageDigest = zzcfw.zzec("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcch(zzccw zzccw2) {
        super(zzccw2);
        this.zziqt = new zzcck(this, "midnight_offset", 0L);
        this.zziqu = new zzcck(this, "first_open_time", 0L);
        this.zziqv = new zzccm(this, "app_instance_id", null);
        this.zzirb = new Object();
    }

    @Override
    protected final void zzuk() {
        this.zzdtq = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzirh = this.zzdtq.getBoolean("has_been_opened", false);
        if (!this.zzirh) {
            SharedPreferences.Editor editor = this.zzdtq.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzayl() {
        this.zzuj();
        this.zzwk();
        return this.zzdtq;
    }

    @WorkerThread
    final void zzjj(String string) {
        this.zzuj();
        SharedPreferences.Editor editor = this.zzayl().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzaym() {
        this.zzuj();
        return this.zzayl().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjk(String string) {
        Object object = this.zzirb;
        synchronized (object) {
            this.zziqz = string;
            this.zzira = this.zzvx().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzayn() {
        Object object = this.zzirb;
        synchronized (object) {
            if (Math.abs(this.zzvx().elapsedRealtime() - this.zzira) < 1000L) {
                return this.zziqz;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzayo() {
        this.zzuj();
        if (!this.zzayl().contains("use_service")) {
            return null;
        }
        return this.zzayl().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbm(boolean bl) {
        this.zzuj();
        this.zzaul().zzayj().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzayl().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzayp() {
        this.zzuj();
        this.zzaul().zzayj().log("Clearing collection preferences.");
        boolean bl = this.zzayl().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbn(true);
        }
        SharedPreferences.Editor editor = this.zzayl().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzuj();
        this.zzaul().zzayj().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzayl().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbn(boolean bl) {
        this.zzuj();
        return this.zzayl().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzayq() {
        this.zzuj();
        String string = this.zzayl().getString("previous_os_version", null);
        this.zzaub().zzwk();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzayl().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcch zzcch2) {
        return zzcch2.zzdtq;
    }

    static /* synthetic */ SharedPreferences zzb(zzcch zzcch2) {
        return zzcch2.zzayl();
    }
}

