/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcar;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcau;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcay;
import com.google.android.gms.internal.zzcaz;
import com.google.android.gms.internal.zzcba;
import com.google.android.gms.internal.zzcbe;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbg;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcbr;
import com.google.android.gms.internal.zzcbs;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcby;
import com.google.android.gms.internal.zzcca;
import com.google.android.gms.internal.zzcce;
import com.google.android.gms.internal.zzccf;
import com.google.android.gms.internal.zzcch;
import com.google.android.gms.internal.zzccn;
import com.google.android.gms.internal.zzccq;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccx;
import com.google.android.gms.internal.zzccy;
import com.google.android.gms.internal.zzccz;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcdv;
import com.google.android.gms.internal.zzcdw;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgm;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyf;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzccw {
    private static volatile zzccw zzisr;
    private final Context mContext;
    private final zzcax zziss;
    private final zzcch zzist;
    private final zzcbw zzisu;
    private final zzccr zzisv;
    private final zzcfl zzisw;
    private final zzccq zzisx;
    private final AppMeasurement zzisy;
    private final FirebaseAnalytics zzisz;
    private final zzcfw zzita;
    private final zzcbu zzitb;
    private final zzcay zzitc;
    private final zzcbs zzitd;
    private final zzcca zzite;
    private final zzd zzasc;
    private final zzcek zzitf;
    private final zzceo zzitg;
    private final zzcbe zzith;
    private final zzcdw zziti;
    private final zzcbr zzitj;
    private final zzccf zzitk;
    private final zzcfr zzitl;
    private final zzcau zzitm;
    private final zzcan zzitn;
    private final boolean zzdoe;
    private boolean zzito;
    private Boolean zzitp;
    private long zzitq;
    private FileLock zzitr;
    private FileChannel zzits;
    private List<Long> zzitt;
    private List<Runnable> zzitu;
    private int zzitv;
    private int zzitw;
    private long zzitx;
    private long zzity;
    private boolean zzitz;
    private boolean zziua;
    private boolean zziub;
    private final long zziuc;

    private zzccw(zzcdv zzcdv2) {
        zzcan zzcan2;
        String string;
        zzcby zzcby2;
        zzbp.zzu((Object)zzcdv2);
        this.mContext = zzcdv2.mContext;
        this.zzitx = -1L;
        this.zzasc = zzh.zzalc();
        this.zziuc = this.zzasc.currentTimeMillis();
        Object object = this;
        this.zziss = new zzcax((zzccw)object);
        object = this;
        zzcch zzcch2 = new zzcch((zzccw)object);
        zzcch2.initialize();
        this.zzist = zzcch2;
        object = this;
        zzcbw zzcbw2 = new zzcbw((zzccw)object);
        zzcbw2.initialize();
        this.zzisu = zzcbw2;
        this.zzaul().zzayh().zzj("App measurement is starting up, version", zzcax.zzauv());
        zzcax.zzawk();
        this.zzaul().zzayh().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcfw zzcfw2 = new zzcfw((zzccw)object);
        zzcfw2.initialize();
        this.zzita = zzcfw2;
        object = this;
        zzcbu zzcbu2 = new zzcbu((zzccw)object);
        zzcbu2.initialize();
        this.zzitb = zzcbu2;
        object = this;
        zzcbe zzcbe2 = new zzcbe((zzccw)object);
        zzcbe2.initialize();
        this.zzith = zzcbe2;
        object = this;
        zzcbr zzcbr2 = new zzcbr((zzccw)object);
        zzcbr2.initialize();
        this.zzitj = zzcbr2;
        zzcax.zzawk();
        Object object2 = zzcbr2.getAppId();
        if (this.zzauh().zzke((String)object2)) {
            zzcby2 = this.zzaul().zzayh();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcby2 = this.zzaul().zzayh();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcby2.log(string);
        this.zzaul().zzayi().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcay((zzccw)object);
        ((zzcdu)object2).initialize();
        this.zzitc = object2;
        object = this;
        zzcbs zzcbs2 = new zzcbs((zzccw)object);
        zzcbs2.initialize();
        this.zzitd = zzcbs2;
        object = this;
        zzcau zzcau2 = new zzcau((zzccw)object);
        zzcau2.initialize();
        this.zzitm = zzcau2;
        object = this;
        this.zzitn = zzcan2 = new zzcan((zzccw)object);
        object = this;
        zzcca zzcca2 = new zzcca((zzccw)object);
        zzcca2.initialize();
        this.zzite = zzcca2;
        object = this;
        zzcek zzcek2 = new zzcek((zzccw)object);
        zzcek2.initialize();
        this.zzitf = zzcek2;
        object = this;
        zzceo zzceo2 = new zzceo((zzccw)object);
        zzceo2.initialize();
        this.zzitg = zzceo2;
        object = this;
        zzcdw zzcdw2 = new zzcdw((zzccw)object);
        zzcdw2.initialize();
        this.zziti = zzcdw2;
        object = this;
        zzcfr zzcfr2 = new zzcfr((zzccw)object);
        zzcfr2.initialize();
        this.zzitl = zzcfr2;
        object = this;
        this.zzitk = new zzccf((zzccw)object);
        object = this;
        this.zzisy = new AppMeasurement((zzccw)object);
        object = this;
        this.zzisz = new FirebaseAnalytics((zzccw)object);
        object = this;
        zzcfl zzcfl2 = new zzcfl((zzccw)object);
        zzcfl2.initialize();
        this.zzisw = zzcfl2;
        object = this;
        zzccq zzccq2 = new zzccq((zzccw)object);
        zzccq2.initialize();
        this.zzisx = zzccq2;
        object = this;
        zzccr zzccr2 = new zzccr((zzccw)object);
        zzccr2.initialize();
        this.zzisv = zzccr2;
        if (this.zzitv != this.zzitw) {
            this.zzaul().zzayd().zze("Not all components initialized", this.zzitv, this.zzitw);
        }
        this.zzdoe = true;
        zzcax.zzawk();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzatz();
            if (((zzcdt)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcdt)object).getContext().getApplicationContext();
                if (((zzcdw)object).zziut == null) {
                    ((zzcdw)object).zziut = new zzcej((zzcdw)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdw)object).zziut);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdw)object).zziut);
                ((zzcdt)object).zzaul().zzayj().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzaul().zzayf().log("Application context is not an Application");
        }
        this.zzisv.zzg(new zzccx(this));
    }

    final void zzwk() {
        if (!this.zzdoe) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzayv() {
        this.zzwk();
        ((zzcdt)this.zzauk()).zzuj();
        if (this.zzitp == null || this.zzitq == 0L || this.zzitp != null && !this.zzitp.booleanValue() && Math.abs(this.zzasc.elapsedRealtime() - this.zzitq) > 1000L) {
            this.zzitq = this.zzasc.elapsedRealtime();
            zzcax.zzawk();
            this.zzitp = this.zzauh().zzdt("android.permission.INTERNET") && this.zzauh().zzdt("android.permission.ACCESS_NETWORK_STATE") && (zzbed.zzcr((Context)this.mContext).zzalq() || zzccn.zzj(this.mContext, false) && zzcfh.zzk(this.mContext, false));
            if (this.zzitp.booleanValue()) {
                this.zzitp = this.zzauh().zzkb(this.zzaua().getGmpAppId());
            }
        }
        return this.zzitp;
    }

    @WorkerThread
    protected final void start() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzauf().zzaxk();
        if (this.zzaum().zziqp.get() == 0L) {
            this.zzaum().zziqp.set(this.zzasc.currentTimeMillis());
        }
        if (Long.valueOf(this.zzaum().zziqu.get()) == 0L) {
            this.zzaul().zzayj().zzj("Persisting first open", this.zziuc);
            this.zzaum().zziqu.set(this.zziuc);
        }
        if (!this.zzayv()) {
            if (this.isEnabled()) {
                if (!this.zzauh().zzdt("android.permission.INTERNET")) {
                    this.zzaul().zzayd().log("App is missing INTERNET permission");
                }
                if (!this.zzauh().zzdt("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzaul().zzayd().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcax.zzawk();
                if (!zzbed.zzcr((Context)this.mContext).zzalq()) {
                    if (!zzccn.zzj(this.mContext, false)) {
                        this.zzaul().zzayd().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcfh.zzk(this.mContext, false)) {
                        this.zzaul().zzayd().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzaul().zzayd().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcax.zzawk();
            if (!TextUtils.isEmpty((CharSequence)this.zzaua().getGmpAppId())) {
                String string = this.zzaum().zzaym();
                if (string == null) {
                    this.zzaum().zzjj(this.zzaua().getGmpAppId());
                } else if (!string.equals(this.zzaua().getGmpAppId())) {
                    this.zzaul().zzayh().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzaum().zzayp();
                    this.zzitg.disconnect();
                    this.zzitg.zzxh();
                    this.zzaum().zzjj(this.zzaua().getGmpAppId());
                    this.zzaum().zziqu.set(this.zziuc);
                    this.zzaum().zziqv.zzjl(null);
                }
            }
            this.zzatz().zzjk(this.zzaum().zziqv.zzayr());
            zzcax.zzawk();
            if (!TextUtils.isEmpty((CharSequence)this.zzaua().getGmpAppId())) {
                zzcdw zzcdw2 = this.zzatz();
                ((zzcdt)zzcdw2).zzuj();
                ((zzcdt)zzcdw2).zzatv();
                zzcdw2.zzwk();
                if (zzcdw2.zziki.zzayv()) {
                    ((zzcdt)zzcdw2).zzauc().zzazq();
                    String string = ((zzcdt)zzcdw2).zzaum().zzayq();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcdt)zzcdw2).zzaub().zzwk();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcdw2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzauc().zza(new AtomicReference<String>());
            }
        }
        this.zzazi();
    }

    public final zzcax zzaun() {
        return this.zziss;
    }

    public final zzcch zzaum() {
        zzccw.zza((zzcdt)this.zzist);
        return this.zzist;
    }

    public final zzcbw zzaul() {
        zzccw.zza(this.zzisu);
        return this.zzisu;
    }

    public final zzcbw zzayw() {
        if (this.zzisu != null && this.zzisu.isInitialized()) {
            return this.zzisu;
        }
        return null;
    }

    public final zzccr zzauk() {
        zzccw.zza(this.zzisv);
        return this.zzisv;
    }

    public final zzcfl zzauj() {
        zzccw.zza(this.zzisw);
        return this.zzisw;
    }

    public final zzccq zzaui() {
        zzccw.zza(this.zzisx);
        return this.zzisx;
    }

    final zzccr zzayx() {
        return this.zzisv;
    }

    public final zzcdw zzatz() {
        zzccw.zza(this.zziti);
        return this.zziti;
    }

    public final AppMeasurement zzayy() {
        return this.zzisy;
    }

    public final FirebaseAnalytics zzayz() {
        return this.zzisz;
    }

    public final zzcfw zzauh() {
        zzccw.zza((zzcdt)this.zzita);
        return this.zzita;
    }

    public final zzcbu zzaug() {
        zzccw.zza((zzcdt)this.zzitb);
        return this.zzitb;
    }

    public final zzcay zzauf() {
        zzccw.zza(this.zzitc);
        return this.zzitc;
    }

    public final zzcbs zzaue() {
        zzccw.zza(this.zzitd);
        return this.zzitd;
    }

    public final zzcca zzaza() {
        zzccw.zza(this.zzite);
        return this.zzite;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzvx() {
        return this.zzasc;
    }

    public final zzcek zzaud() {
        zzccw.zza(this.zzitf);
        return this.zzitf;
    }

    public final zzceo zzauc() {
        zzccw.zza(this.zzitg);
        return this.zzitg;
    }

    public final zzcbe zzaub() {
        zzccw.zza(this.zzith);
        return this.zzith;
    }

    public final zzcbr zzaua() {
        zzccw.zza(this.zzitj);
        return this.zzitj;
    }

    private final zzccf zzazb() {
        if (this.zzitk == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzitk;
    }

    private final zzcfr zzazc() {
        zzccw.zza(this.zzitl);
        return this.zzitl;
    }

    public final zzcau zzaty() {
        zzccw.zza(this.zzitm);
        return this.zzitm;
    }

    public final zzcan zzatx() {
        zzccw.zza(this.zzitn);
        return this.zzitn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzccw zzdn(Context context) {
        zzbp.zzu((Object)context);
        zzbp.zzu((Object)context.getApplicationContext());
        if (zzisr != null) return zzisr;
        Class<zzccw> clazz = zzccw.class;
        synchronized (zzccw.class) {
            if (zzisr != null) return zzisr;
            zzcdv zzcdv2 = new zzcdv(context);
            zzisr = new zzccw(zzcdv2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzisr;
        }
    }

    private static void zza(zzcdu zzcdu2) {
        if (zzcdu2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcdu2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcdt zzcdt2) {
        if (zzcdt2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzazd() {
        ((zzcdt)this.zzauk()).zzuj();
        String string = zzcax.zzawi();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzits = new RandomAccessFile(file2, "rw").getChannel();
            this.zzitr = this.zzits.tryLock();
            if (this.zzitr != null) {
                this.zzaul().zzayj().log("Storage concurrent access okay");
                return true;
            }
            this.zzaul().zzayd().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzaul().zzayd().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcdt)this.zzauk()).zzuj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzaul().zzayd().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzaul().zzayf().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcdt)this.zzauk()).zzuj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzaul().zzayd().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzaul().zzayd().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (this.zziss.zzawl()) {
            return false;
        }
        Boolean bl = this.zziss.zzit("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcax.zzaif();
        return this.zzaum().zzbn(bl2);
    }

    final void zzd(zzcas zzcas2) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        zzbp.zzgg((String)zzcas2.packageName);
        this.zzf(zzcas2);
    }

    final long zzaze() {
        Long l = this.zzaum().zziqu.get();
        if (l == 0L) {
            return this.zziuc;
        }
        return Math.min(this.zziuc, l);
    }

    private final long zzazf() {
        long l = this.zzasc.currentTimeMillis();
        zzcch zzcch2 = this.zzaum();
        zzcch2.zzwk();
        zzcch2.zzuj();
        long l2 = zzcch2.zziqt.get();
        if (l2 == 0L) {
            l2 = 1 + zzcch2.zzauh().zzazy().nextInt(86400000);
            zzcch2.zziqt.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcas zzjr(String string) {
        zzcar zzcar2 = this.zzauf().zziw(string);
        if (zzcar2 == null || TextUtils.isEmpty((CharSequence)zzcar2.zzuo())) {
            this.zzaul().zzayi().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbed.zzcr((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcar2.zzuo() != null && !zzcar2.zzuo().equals(string2)) {
                this.zzaul().zzayf().zzj("App version does not match; dropping. appId", zzcbw.zzjf(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcas(string, zzcar2.getGmpAppId(), zzcar2.zzuo(), zzcar2.zzaut(), zzcar2.zzauu(), zzcar2.zzauv(), zzcar2.zzauw(), null, zzcar2.zzaux(), false, zzcar2.zzauq(), zzcar2.zzavk(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcbk zzcbk2, String string) {
        Object object;
        zzcar zzcar2;
        block4: {
            zzcar2 = this.zzauf().zziw(string);
            if (zzcar2 == null || TextUtils.isEmpty((CharSequence)zzcar2.zzuo())) {
                this.zzaul().zzayi().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbed.zzcr((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcar2.zzuo() != null && !zzcar2.zzuo().equals(object)) {
                    this.zzaul().zzayf().zzj("App version does not match; dropping event. appId", zzcbw.zzjf(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcbk2.name)) break block4;
                this.zzaul().zzayf().zzj("Could not find package. appId", zzcbw.zzjf(string));
            }
        }
        object = new zzcas(string, zzcar2.getGmpAppId(), zzcar2.zzuo(), zzcar2.zzaut(), zzcar2.zzauu(), zzcar2.zzauv(), zzcar2.zzauw(), null, zzcar2.zzaux(), false, zzcar2.zzauq(), zzcar2.zzavk(), 0L, 0);
        this.zzb(zzcbk2, (zzcas)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcbk zzcbk2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        String string = zzcas2.packageName;
        long l = zzcbk2.zzins;
        this.zzauh();
        if (!zzcfw.zzd(zzcbk2, zzcas2)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        this.zzauf().beginTransaction();
        try {
            zzbck zzbck2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcay zzcay2 = this.zzauf();
            zzbp.zzgg((String)string3);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l2 < 0L) {
                zzcay2.zzaul().zzayf().zze("Invalid time querying timed out conditional properties", zzcbw.zzjf(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcay2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzaul().zzayi().zzd("User property timed out", object22.packageName, this.zzaug().zzje(object22.zzimh.name), object22.zzimh.getValue());
                if (object22.zziml != null) {
                    this.zzc(new zzcbk(object22.zziml, l), zzcas2);
                }
                this.zzauf().zzaj(string, object22.zzimh.name);
            }
            l2 = l;
            string3 = string;
            zzcay2 = this.zzauf();
            zzbp.zzgg((String)string3);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l2 < 0L) {
                zzcay2.zzaul().zzayf().zze("Invalid time querying expired conditional properties", zzcbw.zzjf(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcay2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcav)((Object)object4.next());
                if (object == null) continue;
                this.zzaul().zzayi().zzd("User property expired", object.packageName, this.zzaug().zzje(object.zzimh.name), object.zzimh.getValue());
                this.zzauf().zzag(string, object.zzimh.name);
                if (object.zzimp != null) {
                    object22.add(object.zzimp);
                }
                this.zzauf().zzaj(string, object.zzimh.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcbk)((Object)e);
                this.zzc(new zzcbk((zzcbk)((Object)object), l), zzcas2);
            }
            long l3 = l;
            String string4 = zzcbk2.name;
            string3 = string;
            zzcay2 = this.zzauf();
            zzbp.zzgg((String)string3);
            zzbp.zzgg((String)string4);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l3 < 0L) {
                zzcay2.zzaul().zzayf().zzd("Invalid time querying triggered conditional properties", zzcbw.zzjf(string3), zzcay2.zzaug().zzjc(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcay2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbck2 = (zzcav)((Object)iterator.next());
                if (zzbck2 == null) continue;
                zzcft zzcft2 = zzbck2.zzimh;
                zzcfv zzcfv2 = new zzcfv(zzbck2.packageName, zzbck2.zzimg, zzcft2.name, l, zzcft2.getValue());
                if (this.zzauf().zza(zzcfv2)) {
                    this.zzaul().zzayi().zzd("User property triggered", zzbck2.packageName, this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                } else {
                    this.zzaul().zzayd().zzd("Too many active user properties, ignoring", zzcbw.zzjf(zzbck2.packageName), this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                }
                if (zzbck2.zzimn != null) {
                    object.add(zzbck2.zzimn);
                }
                zzbck2.zzimh = new zzcft(zzcfv2);
                zzbck2.zzimj = true;
                this.zzauf().zza((zzcav)zzbck2);
            }
            this.zzc(zzcbk2, zzcas2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbck2 = (zzcbk)((Object)e);
                this.zzc(new zzcbk((zzcbk)zzbck2, l), zzcas2);
            }
            this.zzauf().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcbk zzcbk2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        long l = System.nanoTime();
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        String string = zzcas2.packageName;
        this.zzauh();
        if (!zzcfw.zzd(zzcbk2, zzcas2)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        if (this.zzaui().zzao(string, zzcbk2.name)) {
            this.zzaul().zzayf().zze("Dropping blacklisted event. appId", zzcbw.zzjf(string), this.zzaug().zzjc(zzcbk2.name));
            boolean bl = this.zzauh().zzkg(string) || this.zzauh().zzkh(string);
            if (!bl && !"_err".equals(zzcbk2.name)) {
                this.zzauh().zza(string, 11, "_ev", zzcbk2.name, 0);
            }
            if (!bl) return;
            zzcar zzcar2 = this.zzauf().zziw(string);
            if (zzcar2 == null) return;
            long l2 = Math.max(zzcar2.zzava(), zzcar2.zzauz());
            if (Math.abs(this.zzasc.currentTimeMillis() - l2) <= zzcax.zzawo()) return;
            this.zzaul().zzayi().log("Fetching config for blacklisted app");
            this.zzb(zzcar2);
            return;
        }
        if (this.zzaul().zzad(2)) {
            this.zzaul().zzayj().zzj("Logging event", this.zzaug().zzb(zzcbk2));
        }
        this.zzauf().beginTransaction();
        try {
            zzcbg zzcbg2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcbk2.zzinr.zzaxz();
            this.zzf(zzcas2);
            if ("_iap".equals(zzcbk2.name) || "ecommerce_purchase".equals(zzcbk2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcbk2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzaul().zzayf().zze("Data lost. Currency value is too big. appId", zzcbw.zzjf(string), d);
                            this.zzauf().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcfv zzcfv2 = this.zzauf().zzah(string, string6);
                    if (zzcfv2 == null || !(zzcfv2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zziss.zzb(string2, zzcbm.zzipf) - 1;
                        string2 = string;
                        zzcay zzcay2 = this.zzauf();
                        zzbp.zzgg((String)string2);
                        zzcay2.zzuj();
                        zzcay2.zzwk();
                        try {
                            zzcay2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcay2.zzaul().zzayd().zze("Error pruning currencies. appId", zzcbw.zzjf(string2), (Object)sQLiteException);
                        }
                        zzcfv2 = new zzcfv(string, zzcbk2.zzimg, string6, this.zzasc.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcfv2.mValue;
                        zzcfv2 = new zzcfv(string, zzcbk2.zzimg, string6, this.zzasc.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzauf().zza(zzcfv2)) {
                        this.zzaul().zzayd().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcbw.zzjf(string), this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                        this.zzauh().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcfw.zzju(zzcbk2.name);
            boolean bl2 = "_err".equals(zzcbk2.name);
            zzcaz zzcaz2 = this.zzauf().zza(this.zzazf(), string, true, bl, false, bl2, false);
            long l5 = zzcaz2.zzimz - zzcax.zzavw();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzaul().zzayd().zze("Data loss. Too many events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzimz);
                }
                this.zzauf().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcaz2.zzimy - zzcax.zzavx()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzaul().zzayd().zze("Data loss. Too many public events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzimy);
                }
                this.zzauh().zza(string, 16, "_ev", zzcbk2.name, 0);
                this.zzauf().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzcas2.packageName;
                n = this.zziss.zzb(string2, zzcbm.zziom);
                l5 = zzcaz2.zzinb - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzaul().zzayd().zze("Too many error events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzinb);
                    }
                    this.zzauf().setTransactionSuccessful();
                    return;
                }
            }
            this.zzauh().zza(bundle, "_o", (Object)zzcbk2.zzimg);
            if (this.zzauh().zzke(string)) {
                this.zzauh().zza(bundle, "_dbg", 1L);
                this.zzauh().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzauf().zzix(string)) > 0L) {
                this.zzaul().zzayf().zze("Data lost. Too many events stored on disk, deleted. appId", zzcbw.zzjf(string), l3);
            }
            zzcbf zzcbf2 = new zzcbf(this, zzcbk2.zzimg, string, zzcbk2.name, zzcbk2.zzins, 0L, bundle);
            zzcbg zzcbg3 = this.zzauf().zzaf(string, zzcbf2.mName);
            if (zzcbg3 == null) {
                long l6 = this.zzauf().zzja(string);
                zzcax.zzavv();
                if (l6 >= 500L) {
                    this.zzaul().zzayd().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcbw.zzjf(string), this.zzaug().zzjc(zzcbf2.mName), zzcax.zzavv());
                    this.zzauh().zza(string, 8, null, null, 0);
                    return;
                }
                zzcbg2 = new zzcbg(string, zzcbf2.mName, 0L, 0L, zzcbf2.zzfdc);
            } else {
                zzcbf2 = zzcbf2.zza(this, zzcbg3.zzinn);
                zzcbg2 = zzcbg3.zzbb(zzcbf2.zzfdc);
            }
            this.zzauf().zza(zzcbg2);
            this.zza(zzcbf2, zzcas2);
            this.zzauf().setTransactionSuccessful();
            if (this.zzaul().zzad(2)) {
                this.zzaul().zzayj().zzj("Event recorded", this.zzaug().zza(zzcbf2));
            }
        }
        finally {
            this.zzauf().endTransaction();
        }
        this.zzazi();
        this.zzaul().zzayj().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcav zzcav2) {
        zzcas zzcas2 = this.zzjr(zzcav2.packageName);
        if (zzcas2 != null) {
            this.zzb(zzcav2, zzcas2);
        }
    }

    @WorkerThread
    final void zzb(zzcav zzcav2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzgg((String)zzcav2.packageName);
        zzbp.zzu((Object)zzcav2.zzimg);
        zzbp.zzu((Object)((Object)zzcav2.zzimh));
        zzbp.zzgg((String)zzcav2.zzimh.name);
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        zzcav zzcav3 = new zzcav(zzcav2);
        new zzcav(zzcav2).zzimj = false;
        this.zzauf().beginTransaction();
        try {
            boolean bl = false;
            zzcav zzcav4 = this.zzauf().zzai(zzcav3.packageName, zzcav3.zzimh.name);
            if (zzcav4 != null && !zzcav4.zzimg.equals(zzcav3.zzimg)) {
                this.zzaul().zzayf().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzaug().zzje(zzcav3.zzimh.name), zzcav3.zzimg, zzcav4.zzimg);
            }
            if (zzcav4 != null && zzcav4.zzimj) {
                zzcav3.zzimg = zzcav4.zzimg;
                zzcav3.zzimi = zzcav4.zzimi;
                zzcav3.zzimm = zzcav4.zzimm;
                zzcav3.zzimk = zzcav4.zzimk;
                zzcav3.zzimn = zzcav4.zzimn;
                zzcav3.zzimj = zzcav4.zzimj;
                zzcav3.zzimh = new zzcft(zzcav3.zzimh.name, zzcav4.zzimh.zziwz, zzcav3.zzimh.getValue(), zzcav4.zzimh.zzimg);
            } else if (TextUtils.isEmpty((CharSequence)zzcav3.zzimk)) {
                zzcav3.zzimh = new zzcft(zzcav3.zzimh.name, zzcav3.zzimi, zzcav3.zzimh.getValue(), zzcav3.zzimh.zzimg);
                zzcav3.zzimj = true;
                bl = true;
            }
            if (zzcav3.zzimj) {
                zzcft zzcft2 = zzcav3.zzimh;
                zzcfv zzcfv2 = new zzcfv(zzcav3.packageName, zzcav3.zzimg, zzcft2.name, zzcft2.zziwz, zzcft2.getValue());
                if (this.zzauf().zza(zzcfv2)) {
                    this.zzaul().zzayi().zzd("User property updated immediately", zzcav3.packageName, this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                } else {
                    this.zzaul().zzayd().zzd("(2)Too many active user properties, ignoring", zzcbw.zzjf(zzcav3.packageName), this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                }
                if (bl && zzcav3.zzimn != null) {
                    zzcbk zzcbk2 = new zzcbk(zzcav3.zzimn, zzcav3.zzimi);
                    this.zzc(zzcbk2, zzcas2);
                }
            }
            if (this.zzauf().zza(zzcav3)) {
                this.zzaul().zzayi().zzd("Conditional property added", zzcav3.packageName, this.zzaug().zzje(zzcav3.zzimh.name), zzcav3.zzimh.getValue());
            } else {
                this.zzaul().zzayd().zzd("Too many conditional properties, ignoring", zzcbw.zzjf(zzcav3.packageName), this.zzaug().zzje(zzcav3.zzimh.name), zzcav3.zzimh.getValue());
            }
            this.zzauf().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcav zzcav2) {
        zzcas zzcas2 = this.zzjr(zzcav2.packageName);
        if (zzcas2 != null) {
            this.zzc(zzcav2, zzcas2);
        }
    }

    @WorkerThread
    final void zzc(zzcav zzcav2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzgg((String)zzcav2.packageName);
        zzbp.zzu((Object)((Object)zzcav2.zzimh));
        zzbp.zzgg((String)zzcav2.zzimh.name);
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        this.zzauf().beginTransaction();
        try {
            this.zzf(zzcas2);
            zzcav zzcav3 = this.zzauf().zzai(zzcav2.packageName, zzcav2.zzimh.name);
            if (zzcav3 != null) {
                this.zzaul().zzayi().zze("Removing conditional user property", zzcav2.packageName, this.zzaug().zzje(zzcav2.zzimh.name));
                this.zzauf().zzaj(zzcav2.packageName, zzcav2.zzimh.name);
                if (zzcav3.zzimj) {
                    this.zzauf().zzag(zzcav2.packageName, zzcav2.zzimh.name);
                }
                if (zzcav2.zzimp != null) {
                    Bundle bundle = null;
                    if (zzcav2.zzimp.zzinr != null) {
                        bundle = zzcav2.zzimp.zzinr.zzaxz();
                    }
                    zzcbk zzcbk2 = this.zzauh().zza(zzcav2.zzimp.name, bundle, zzcav3.zzimg, zzcav2.zzimp.zzins, true, false);
                    this.zzc(zzcbk2, zzcas2);
                }
            } else {
                this.zzaul().zzayf().zze("Conditional user property doesn't exist", zzcbw.zzjf(zzcav2.packageName), this.zzaug().zzje(zzcav2.zzimh.name));
            }
            this.zzauf().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcbk zzcbk2, @Size(min=1L) String string) {
        Object object;
        this.zzwk();
        ((zzcdt)this.zzauk()).zzuj();
        zzccw.zzatu();
        zzbp.zzu((Object)((Object)zzcbk2));
        zzbp.zzgg((String)string);
        zzcgj zzcgj2 = new zzcgj();
        this.zzauf().beginTransaction();
        try {
            zzcbg zzcbg2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcar zzcar2 = this.zzauf().zziw(string);
            if (zzcar2 == null) {
                this.zzaul().zzayi().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcar2.zzaux()) {
                this.zzaul().zzayi().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcgk();
            zzcgj2.zzizc = new zzcgk[]{object};
            object.zzize = 1;
            object.zzizm = "android";
            object.zzci = zzcar2.getAppId();
            object.zzilv = zzcar2.zzauu();
            object.zzhtt = zzcar2.zzuo();
            long l2 = zzcar2.zzaut();
            object.zzizz = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzizq = zzcar2.zzauv();
            object.zzilu = zzcar2.getGmpAppId();
            object.zzizv = zzcar2.zzauw();
            if (this.isEnabled() && zzcax.zzaxh() && this.zziss.zziu(object.zzci)) {
                this.zzaua();
                object.zzjaf = null;
            }
            if ((pair = this.zzaum().zzjh(zzcar2.getAppId())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzizs = (String)pair.first;
                object.zzizt = (Boolean)pair.second;
            }
            this.zzaub().zzwk();
            object.zzizn = Build.MODEL;
            this.zzaub().zzwk();
            object.zzcw = Build.VERSION.RELEASE;
            object.zzizp = (int)this.zzaub().zzaxw();
            object.zzizo = this.zzaub().zzaxx();
            object.zzizu = zzcar2.getAppInstanceId();
            object.zzimc = zzcar2.zzauq();
            List<zzcfv> list = this.zzauf().zziv(zzcar2.getAppId());
            object.zzizg = new zzcgm[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcgm();
                object.zzizg[i] = object2;
                ((zzcgm)((Object)object2)).name = list.get((int)i).mName;
                ((zzcgm)((Object)object2)).zzjaj = list.get((int)i).zzixd;
                this.zzauh().zza((zzcgm)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcbk2.zzinr.zzaxz();
            if ("_iap".equals(zzcbk2.name)) {
                bundle.putLong("_c", 1L);
                this.zzaul().zzayi().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcbk2.zzimg);
            if (this.zzauh().zzke(object.zzci)) {
                this.zzauh().zza(bundle, "_dbg", 1L);
                this.zzauh().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzauf().zzaf(string, zzcbk2.name)) == null) {
                l = 0L;
                zzcbg2 = new zzcbg(string, zzcbk2.name, 1L, 0L, zzcbk2.zzins);
                this.zzauf().zza(zzcbg2);
            } else {
                l = ((zzcbg)object2).zzinn;
                zzcbg2 = ((zzcbg)object2).zzbb(zzcbk2.zzins).zzaxy();
                this.zzauf().zza(zzcbg2);
            }
            zzcbf zzcbf2 = new zzcbf(this, zzcbk2.zzimg, string, zzcbk2.name, zzcbk2.zzins, l, bundle);
            zzcgh zzcgh2 = new zzcgh();
            object.zzizf = new zzcgh[]{zzcgh2};
            zzcgh2.zziyy = zzcbf2.zzfdc;
            zzcgh2.name = zzcbf2.mName;
            zzcgh2.zziyz = zzcbf2.zzinj;
            zzcgh2.zziyx = new zzcgi[zzcbf2.zzink.size()];
            int n = 0;
            for (String string2 : zzcbf2.zzink) {
                zzcgi zzcgi2 = new zzcgi();
                zzcgh2.zziyx[n++] = zzcgi2;
                zzcgi2.name = string2;
                Object object3 = zzcbf2.zzink.get(string2);
                this.zzauh().zza(zzcgi2, object3);
            }
            object.zzizy = this.zza(zzcar2.getAppId(), object.zzizg, object.zzizf);
            object.zzizi = zzcgh2.zziyy;
            object.zzizj = zzcgh2.zziyy;
            long l3 = zzcar2.zzaus();
            object.zzizl = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcar2.zzaur();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzizk = l4 != 0L ? Long.valueOf(l4) : null;
            zzcar2.zzavb();
            object.zzizw = (int)zzcar2.zzauy();
            object.zzizr = zzcax.zzauv();
            object.zzizh = this.zzasc.currentTimeMillis();
            object.zzizx = Boolean.TRUE;
            zzcar2.zzal(object.zzizi);
            zzcar2.zzam(object.zzizj);
            this.zzauf().zza(zzcar2);
            this.zzauf().setTransactionSuccessful();
        }
        finally {
            this.zzauf().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcgj2.zzhi()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzeyf zzeyf2 = zzeyf.zzn((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgj2.zza(zzeyf2);
            zzeyf2.zzctn();
            return this.zzauh().zzp((byte[])object);
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Data loss. Failed to bundle and serialize. appId", zzcbw.zzjf(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcbf var1_1, zzcas var2_2) {
        block15: {
            this.zzauk().zzuj();
            this.zzwk();
            zzbp.zzu((Object)var1_1);
            zzbp.zzu((Object)var2_2);
            zzbp.zzgg((String)var1_1.mAppId);
            zzbp.zzbh((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcgk();
            new zzcgk().zzize = 1;
            var3_3.zzizm = "android";
            var3_3.zzci = var2_2.packageName;
            var3_3.zzilv = var2_2.zzilv;
            var3_3.zzhtt = var2_2.zzhtt;
            var3_3.zzizz = var2_2.zzimb == -2147483648L ? null : Integer.valueOf((int)var2_2.zzimb);
            var3_3.zzizq = var2_2.zzilw;
            var3_3.zzilu = var2_2.zzilu;
            var3_3.zzizv = var2_2.zzilx == 0L ? null : Long.valueOf(var2_2.zzilx);
            var4_4 = this.zzaum().zzjh(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzizs = (String)var4_4.first;
                var3_3.zzizt = (Boolean)var4_4.second;
            } else if (!this.zzaub().zzdm(this.mContext)) {
                var5_5 = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
                if (var5_5 == null) {
                    this.zzaul().zzayf().zzj("null secure ID. appId", zzcbw.zzjf(var3_3.zzci));
                    var5_5 = "null";
                } else if (var5_5.isEmpty()) {
                    this.zzaul().zzayf().zzj("empty secure ID. appId", zzcbw.zzjf(var3_3.zzci));
                }
                var3_3.zzjac = var5_5;
            }
            this.zzaub().zzwk();
            var3_3.zzizn = Build.MODEL;
            this.zzaub().zzwk();
            var3_3.zzcw = Build.VERSION.RELEASE;
            var3_3.zzizp = (int)this.zzaub().zzaxw();
            var3_3.zzizo = this.zzaub().zzaxx();
            var3_3.zzizr = null;
            var3_3.zzizh = null;
            var3_3.zzizi = null;
            var3_3.zzizj = null;
            var3_3.zzjae = var2_2.zzimd;
            if (this.isEnabled() && zzcax.zzaxh()) {
                this.zzaua();
                var3_3.zzjaf = null;
            }
            if ((var5_5 = this.zzauf().zziw(var2_2.packageName)) == null) {
                var5_5 = new zzcar(this, var2_2.packageName);
                var5_5.zzim(this.zzaua().zzaya());
                var5_5.zzip(var2_2.zzimc);
                var5_5.zzin(var2_2.zzilu);
                var5_5.zzio(this.zzaum().zzji(var2_2.packageName));
                var5_5.zzaq(0L);
                var5_5.zzal(0L);
                var5_5.zzam(0L);
                var5_5.setAppVersion(var2_2.zzhtt);
                var5_5.zzan(var2_2.zzimb);
                var5_5.zziq(var2_2.zzilv);
                var5_5.zzao(var2_2.zzilw);
                var5_5.zzap(var2_2.zzilx);
                var5_5.setMeasurementEnabled(var2_2.zzilz);
                var5_5.zzaz(var2_2.zzimd);
                this.zzauf().zza((zzcar)var5_5);
            }
            var3_3.zzizu = var5_5.getAppInstanceId();
            var3_3.zzimc = var5_5.zzauq();
            var6_6 = this.zzauf().zziv(var2_2.packageName);
            var3_3.zzizg = new zzcgm[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzizg[var7_7] = var8_9 = new zzcgm();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzjaj = var6_6.get((int)var7_7).zzixd;
                this.zzauh().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzauf().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzaul().zzayd().zze("Data loss. Failed to insert raw event metadata. appId", zzcbw.zzjf(var3_3.zzci), var9_10);
                return;
            }
            v0 = this.zzauf();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzink == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzink) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block15;
            }
            var12_14 = var10_12.zzaui().zzap(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzauf().zza(var10_12.zzazf(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzinc < (long)var10_12.zziss.zzis(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzity = 0L;
        }
    }

    public final String zzjs(String string) {
        Future<String> future = this.zzauk().zzd(new zzccy(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzaul().zzayd().zze("Failed to get app instance id. appId", zzcbw.zzjf(string), exception);
            return null;
        }
    }

    static void zzatu() {
        zzcax.zzawk();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcft zzcft2, zzcas zzcas2) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        int n = this.zzauh().zzjy(zzcft2.name);
        if (n != 0) {
            this.zzauh();
            String string = zzcfw.zza(zzcft2.name, zzcax.zzavo(), true);
            int n2 = zzcft2.name != null ? zzcft2.name.length() : 0;
            this.zzauh().zza(zzcas2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzauh().zzl(zzcft2.name, zzcft2.getValue());
        if (n != 0) {
            this.zzauh();
            String string = zzcfw.zza(zzcft2.name, zzcax.zzavo(), true);
            Object object = zzcft2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzauh().zza(zzcas2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzauh().zzm(zzcft2.name, zzcft2.getValue());
        if (object == null) {
            return;
        }
        zzcfv zzcfv2 = new zzcfv(zzcas2.packageName, zzcft2.zzimg, zzcft2.name, zzcft2.zziwz, object);
        this.zzaul().zzayi().zze("Setting user property", this.zzaug().zzje(zzcfv2.mName), object);
        this.zzauf().beginTransaction();
        try {
            this.zzf(zzcas2);
            boolean bl = this.zzauf().zza(zzcfv2);
            this.zzauf().setTransactionSuccessful();
            if (bl) {
                this.zzaul().zzayi().zze("User property set", this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
            } else {
                this.zzaul().zzayd().zze("Too many unique user properties are set. Ignoring user property", this.zzaug().zzje(zzcfv2.mName), zzcfv2.mValue);
                this.zzauh().zza(zzcas2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcft zzcft2, zzcas zzcas2) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            return;
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        this.zzaul().zzayi().zzj("Removing user property", this.zzaug().zzje(zzcft2.name));
        this.zzauf().beginTransaction();
        try {
            this.zzf(zzcas2);
            this.zzauf().zzag(zzcas2.packageName, zzcft2.name);
            this.zzauf().setTransactionSuccessful();
            this.zzaul().zzayi().zzj("User property removed", this.zzaug().zzje(zzcft2.name));
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazg() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        this.zziub = true;
        try {
            String string;
            zzcax.zzawk();
            Boolean bl = this.zzaum().zzayo();
            if (bl == null) {
                this.zzaul().zzayf().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzaul().zzayd().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzity > 0L) {
                this.zzazi();
                return;
            }
            Object object = this;
            ((zzcdt)((zzccw)object).zzauk()).zzuj();
            if (((zzccw)object).zzitt != null) {
                this.zzaul().zzayj().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzaza().zzyx()) {
                this.zzaul().zzayj().log("Network not connected, ignoring upload request");
                this.zzazi();
                return;
            }
            long l = this.zzasc.currentTimeMillis();
            long l2 = l - zzcax.zzawv();
            this.zzg(null, l2);
            long l3 = this.zzaum().zziqp.get();
            if (l3 != 0L) {
                this.zzaul().zzayi().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzauf().zzaxi()))) {
                if (this.zzitx == -1L) {
                    this.zzitx = this.zzauf().zzaxp();
                }
                Object object2 = string;
                int n = this.zziss.zzb((String)object2, zzcbm.zzioh);
                object2 = string;
                object = this.zziss;
                int n2 = Math.max(0, ((zzcax)object).zzb((String)object2, zzcbm.zzioi));
                List<Pair<zzcgk, Long>> list = this.zzauf().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcgk zzcgk2 = (zzcgk)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcgk2.zzizs)) continue;
                        string2 = zzcgk2.zzizs;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcgk)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcgk)((Object)object3)).zzizs) || ((zzcgk)((Object)object3)).zzizs.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcgj();
                    new zzcgj().zzizc = new zzcgk[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcax.zzaxh() && this.zziss.zziu(string);
                    for (int i = 0; i < ((zzcgj)((Object)object4)).zzizc.length; ++i) {
                        ((zzcgj)((Object)object4)).zzizc[i] = (zzcgk)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcgj)((Object)object4)).zzizc[i].zzizr = zzcax.zzauv();
                        ((zzcgj)((Object)object4)).zzizc[i].zzizh = l;
                        ((zzcgj)((Object)object4)).zzizc[i].zzizx = zzcax.zzawk();
                        if (bl2) continue;
                        ((zzcgj)((Object)object4)).zzizc[i].zzjaf = null;
                    }
                    String string3 = null;
                    if (this.zzaul().zzad(2)) {
                        string3 = this.zzaug().zza((zzcgj)((Object)object4));
                    }
                    byte[] byArray = this.zzauh().zzb((zzcgj)((Object)object4));
                    String string4 = zzcax.zzawu();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbp.zzbh((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzccw)object).zzitt != null) {
                            ((zzccw)object).zzaul().zzayd().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzccw)object).zzitt = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzaum().zziqq.set(l);
                        String string5 = "?";
                        if (((zzcgj)((Object)object4)).zzizc.length > 0) {
                            string5 = ((zzcgj)((Object)object4)).zzizc[0].zzci;
                        }
                        this.zzaul().zzayj().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zziua = true;
                        zzccz zzccz2 = new zzccz(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzaza();
                        ((zzcdt)object).zzuj();
                        ((zzcdu)object).zzwk();
                        zzbp.zzu((Object)uRL2);
                        zzbp.zzu((Object)byArray2);
                        zzbp.zzu((Object)zzccz2);
                        ((zzcdt)object).zzauk().zzh(new zzcce((zzcca)object, (String)object2, uRL2, byArray2, null, zzccz2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzaul().zzayd().zze("Failed to parse upload URL. Not uploading. appId", zzcbw.zzjf(string), string4);
                    }
                }
            } else {
                zzcar zzcar2;
                this.zzitx = -1L;
                String string6 = this.zzauf().zzba(l - zzcax.zzawv());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcar2 = this.zzauf().zziw(string6)) != null) {
                    this.zzb(zzcar2);
                }
            }
            return;
        }
        finally {
            this.zziub = false;
            this.zzazm();
        }
    }

    @WorkerThread
    private final void zzb(zzcar zzcar2) {
        ((zzcdt)this.zzauk()).zzuj();
        if (TextUtils.isEmpty((CharSequence)zzcar2.getGmpAppId())) {
            this.zzb(zzcar2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcar2.getAppInstanceId();
        String string = zzcar2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcbm.zziof.get()).encodedAuthority(zzcbm.zziog.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11400");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzaul().zzayj().zzj("Fetching remote configuration", zzcar2.getAppId());
            zzcge zzcge2 = this.zzaui().zzjn(zzcar2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzaui().zzjo(zzcar2.getAppId());
            if (zzcge2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzitz = true;
            zzcda zzcda2 = new zzcda(this);
            builder = arrayMap;
            object = uRL;
            string = zzcar2.getAppId();
            zzcca zzcca2 = this.zzaza();
            ((zzcdt)zzcca2).zzuj();
            zzcca2.zzwk();
            zzbp.zzu((Object)object);
            zzbp.zzu((Object)zzcda2);
            ((zzcdt)zzcca2).zzauk().zzh(new zzcce(zzcca2, string, (URL)object, null, (Map)builder, zzcda2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzaul().zzayd().zze("Failed to parse config URL. Not fetching. appId", zzcbw.zzjf(zzcar2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzauf().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzitx;
                    long l3 = l;
                    string2 = null;
                    object = this.zzauf();
                    zzbp.zzu((Object)zza3);
                    ((zzcdt)object).zzuj();
                    ((zzcdu)object).zzwk();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcay)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcdt)object).zzaul().zzayd().zzj("Raw event metadata record is missing. appId", zzcbw.zzjf(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzeye.zzm((byte[])byArray, (int)0, (int)byArray.length);
                        zzcgk zzcgk2 = new zzcgk();
                        try {
                            zzcgk2.zza((zzeye)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcdt)object).zzaul().zzayd().zze("Data loss. Failed to merge raw event metadata. appId", zzcbw.zzjf(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcdt)object).zzaul().zzayf().zzj("Get multiple raw event metadata records, expected one. appId", zzcbw.zzjf(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcgk2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcdt)object).zzaul().zzayf().zzj("Raw event data disappeared while in transaction. appId", zzcbw.zzjf(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzeye.zzm((byte[])byArray, (int)0, (int)byArray.length);
                            zzcgh zzcgh2 = new zzcgh();
                            try {
                                zzcgh2.zza((zzeye)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcdt)object).zzaul().zzayd().zze("Data loss. Failed to merge raw event. appId", zzcbw.zzjf(string2), iOException);
                                continue;
                            }
                            zzcgh2.name = cursor.getString(1);
                            zzcgh2.zziyy = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcgh2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zzaoc == null || ((zza)object).zzaoc.isEmpty()) break block69;
                boolean bl = false;
                zzcgk zzcgk3 = zza2.zziue;
                zza2.zziue.zzizf = new zzcgh[zza2.zzaoc.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzaoc.size(); ++n) {
                    block71: {
                        zzcgi[] zzcgiArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzaui().zzao(zza2.zziue.zzci, zza2.zzaoc.get((int)n).name)) {
                                this.zzaul().zzayf().zze("Dropping blacklisted raw event. appId", zzcbw.zzjf(zza2.zziue.zzci), this.zzaug().zzjc(zza2.zzaoc.get((int)n).name));
                                if (this.zzauh().zzkg(zza2.zziue.zzci) || this.zzauh().zzkh(zza2.zziue.zzci) || "_err".equals(zza2.zzaoc.get((int)n).name)) continue;
                                this.zzauh().zza(zza2.zziue.zzci, 11, "_ev", zza2.zzaoc.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzaui().zzap(zza2.zziue.zzci, zza2.zzaoc.get((int)n).name);
                            if (bl2) break block70;
                            this.zzauh();
                            if (!zzcfw.zzki(zza2.zzaoc.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zzaoc.get((int)n).zziyx == null) {
                            zza2.zzaoc.get((int)n).zziyx = new zzcgi[0];
                        }
                        zzcgi[] zzcgiArray2 = zza2.zzaoc.get((int)n).zziyx;
                        int n4 = zza2.zzaoc.get((int)n).zziyx.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcgiArray = zzcgiArray2[n3];
                            if ("_c".equals(zzcgiArray.name)) {
                                zzcgiArray.zzizb = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcgiArray.name)) continue;
                            zzcgiArray.zzizb = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzaul().zzayj().zzj("Marking event as conversion", this.zzaug().zzjc(zza2.zzaoc.get((int)n).name));
                            zzcgiArray2 = Arrays.copyOf(zza2.zzaoc.get((int)n).zziyx, zza2.zzaoc.get((int)n).zziyx.length + 1);
                            zzcgi zzcgi2 = new zzcgi();
                            new zzcgi().name = "_c";
                            zzcgi2.zzizb = 1L;
                            zzcgiArray2[zzcgiArray2.length - 1] = zzcgi2;
                            zza2.zzaoc.get((int)n).zziyx = zzcgiArray2;
                        }
                        if (!bl5) {
                            this.zzaul().zzayj().zzj("Marking event as real-time", this.zzaug().zzjc(zza2.zzaoc.get((int)n).name));
                            zzcgiArray2 = Arrays.copyOf(zza2.zzaoc.get((int)n).zziyx, zza2.zzaoc.get((int)n).zziyx.length + 1);
                            zzcgi zzcgi3 = new zzcgi();
                            new zzcgi().name = "_r";
                            zzcgi3.zzizb = 1L;
                            zzcgiArray2[zzcgiArray2.length - 1] = zzcgi3;
                            zza2.zzaoc.get((int)n).zziyx = zzcgiArray2;
                        }
                        bl = true;
                        if (this.zzauf().zza((long)this.zzazf(), (String)zza2.zziue.zzci, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzinc > (long)this.zziss.zzis(zza2.zziue.zzci)) {
                            zzcgh zzcgh3 = zza2.zzaoc.get(n);
                            for (n3 = 0; n3 < zzcgh3.zziyx.length; ++n3) {
                                if (!"_r".equals(zzcgh3.zziyx[n3].name)) continue;
                                zzcgiArray = new zzcgi[zzcgh3.zziyx.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcgh3.zziyx, 0, zzcgiArray, 0, n3);
                                }
                                if (n3 < zzcgiArray.length) {
                                    System.arraycopy(zzcgh3.zziyx, n3 + 1, zzcgiArray, n3, zzcgiArray.length - n3);
                                }
                                zzcgh3.zziyx = zzcgiArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcfw.zzju(zza2.zzaoc.get((int)n).name) && bl2 && this.zzauf().zza((long)this.zzazf(), (String)zza2.zziue.zzci, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzina > (long)this.zziss.zzb(string2 = zza2.zziue.zzci, zzcbm.zzioo)) {
                            this.zzaul().zzayf().zzj("Too many conversions. Not logging as conversion. appId", zzcbw.zzjf(zza2.zziue.zzci));
                            zzcgh zzcgh4 = zza2.zzaoc.get(n);
                            boolean bl6 = false;
                            zzcgi zzcgi4 = null;
                            zzcgi[] zzcgiArray3 = zzcgh4.zziyx;
                            int n5 = zzcgh4.zziyx.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcgi zzcgi5 = zzcgiArray3[i];
                                if ("_c".equals(zzcgi5.name)) {
                                    zzcgi4 = zzcgi5;
                                    continue;
                                }
                                if (!"_err".equals(zzcgi5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcgi4 != null) {
                                zzcgiArray3 = new zzcgi[zzcgh4.zziyx.length - 1];
                                n5 = 0;
                                zzcgi[] zzcgiArray4 = zzcgh4.zziyx;
                                int n6 = zzcgh4.zziyx.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcgi zzcgi6 = zzcgiArray4[i];
                                    if (zzcgi6 == zzcgi4) continue;
                                    zzcgiArray3[n5++] = zzcgi6;
                                }
                                zzcgh4.zziyx = zzcgiArray3;
                            } else if (zzcgi4 != null) {
                                zzcgi4.name = "_err";
                                zzcgi4.zzizb = 10L;
                            } else {
                                this.zzaul().zzayd().zzj("Did not find conversion parameter. appId", zzcbw.zzjf(zza2.zziue.zzci));
                            }
                        }
                    }
                    zzcgk3.zzizf[n2++] = zza2.zzaoc.get(n);
                }
                if (n2 < zza2.zzaoc.size()) {
                    zzcgk3.zzizf = Arrays.copyOf(zzcgk3.zzizf, n2);
                }
                zzcgk3.zzizy = this.zza(zza2.zziue.zzci, zza2.zziue.zzizg, zzcgk3.zzizf);
                zzcgk3.zzizi = Long.MAX_VALUE;
                zzcgk3.zzizj = Long.MIN_VALUE;
                for (n = 0; n < zzcgk3.zzizf.length; ++n) {
                    zzcgh zzcgh5 = zzcgk3.zzizf[n];
                    if (zzcgh5.zziyy < zzcgk3.zzizi) {
                        zzcgk3.zzizi = zzcgh5.zziyy;
                    }
                    if (zzcgh5.zziyy <= zzcgk3.zzizj) continue;
                    zzcgk3.zzizj = zzcgh5.zziyy;
                }
                String string6 = zza2.zziue.zzci;
                zzcar zzcar2 = this.zzauf().zziw(string6);
                if (zzcar2 == null) {
                    this.zzaul().zzayd().zzj("Bundling raw events w/o app info. appId", zzcbw.zzjf(zza2.zziue.zzci));
                } else if (zzcgk3.zzizf.length > 0) {
                    long l5 = zzcar2.zzaus();
                    zzcgk3.zzizl = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcar2.zzaur();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcgk3.zzizk = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcar2.zzavb();
                    zzcgk3.zzizw = (int)zzcar2.zzauy();
                    zzcar2.zzal(zzcgk3.zzizi);
                    zzcar2.zzam(zzcgk3.zzizj);
                    zzcgk3.zzily = zzcar2.zzavj();
                    this.zzauf().zza(zzcar2);
                }
                if (zzcgk3.zzizf.length > 0) {
                    zzcax.zzawk();
                    zzcge zzcge2 = this.zzaui().zzjn(zza2.zziue.zzci);
                    if (zzcge2 == null || zzcge2.zziym == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zziue.zzilu)) {
                            zzcgk3.zzjad = -1L;
                        } else {
                            this.zzaul().zzayf().zzj("Did not find measurement config or missing version info. appId", zzcbw.zzjf(zza2.zziue.zzci));
                        }
                    } else {
                        zzcgk3.zzjad = zzcge2.zziym;
                    }
                    this.zzauf().zza(zzcgk3, bl);
                }
                this.zzauf().zzae(zza2.zziuf);
                string2 = string6;
                object = this.zzauf();
                SQLiteDatabase sQLiteDatabase = ((zzcay)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcdt)object).zzaul().zzayd().zze("Failed to remove unused event metadata. appId", zzcbw.zzjf(string2), (Object)sQLiteException);
                }
                this.zzauf().setTransactionSuccessful();
                boolean bl7 = zzcgk3.zzizf.length > 0;
                return bl7;
            }
            this.zzauf().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    private final zzcgg[] zza(String string, zzcgm[] zzcgmArray, zzcgh[] zzcghArray) {
        zzbp.zzgg((String)string);
        return this.zzaty().zza(string, zzcghArray, zzcgmArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        zzbp.zzgg((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzaul().zzayj().zzj("onConfigFetched. Response size", byArray.length);
            this.zzauf().beginTransaction();
            try {
                boolean bl;
                zzcar zzcar2 = this.zzauf().zziw(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcar2 == null) {
                    this.zzaul().zzayf().zzj("App does not exist in onConfigFetched. appId", zzcbw.zzjf(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzaui().zzjn(string) == null && !this.zzaui().zzb(string, null, null) : !this.zzaui().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcar2.zzar(this.zzasc.currentTimeMillis());
                    this.zzauf().zza(zzcar2);
                    if (n == 404) {
                        this.zzaul().zzayg().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzaul().zzayj().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzaza().zzyx() && this.zzazh()) {
                        this.zzazg();
                    } else {
                        this.zzazi();
                    }
                } else {
                    zzcar2.zzas(this.zzasc.currentTimeMillis());
                    this.zzauf().zza(zzcar2);
                    this.zzaul().zzayj().zze("Fetching config failed. code, error", n, throwable);
                    this.zzaui().zzjp(string);
                    this.zzaum().zziqq.set(this.zzasc.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzaum().zziqr.set(this.zzasc.currentTimeMillis());
                    }
                    this.zzazi();
                }
                this.zzauf().setTransactionSuccessful();
            }
            finally {
                this.zzauf().endTransaction();
            }
            return;
        }
        finally {
            this.zzitz = false;
            this.zzazm();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzitt;
            this.zzitt = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzaum().zziqp.set(this.zzasc.currentTimeMillis());
                    this.zzaum().zziqq.set(0L);
                    this.zzazi();
                    this.zzaul().zzayj().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzauf().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcay zzcay2 = this.zzauf();
                            zzcay2.zzuj();
                            zzcay2.zzwk();
                            SQLiteDatabase sQLiteDatabase = zzcay2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcay2.zzaul().zzayd().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzauf().setTransactionSuccessful();
                    }
                    finally {
                        this.zzauf().endTransaction();
                    }
                    if (this.zzaza().zzyx() && this.zzazh()) {
                        this.zzazg();
                    } else {
                        this.zzitx = -1L;
                        this.zzazi();
                    }
                    this.zzity = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzaul().zzayd().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzity = this.zzasc.elapsedRealtime();
                    this.zzaul().zzayj().zzj("Disable upload, time", this.zzity);
                }
            } else {
                this.zzaul().zzayj().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzaum().zziqq.set(this.zzasc.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzaum().zziqr.set(this.zzasc.currentTimeMillis());
                }
                this.zzazi();
            }
            return;
        }
        finally {
            this.zziua = false;
            this.zzazm();
        }
    }

    private final boolean zzazh() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        return this.zzauf().zzaxn() || !TextUtils.isEmpty((CharSequence)this.zzauf().zzaxi());
    }

    @WorkerThread
    private final void zzazi() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcdt)this.zzauk()).zzuj();
            this.zzwk();
            if (!this.zzazl()) {
                return;
            }
            if (this.zzity > 0L) {
                l3 = this.zzasc.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzity);
                if (l2 > 0L) {
                    this.zzaul().zzayj().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzazb().unregister();
                    this.zzazc().cancel();
                    return;
                }
                this.zzity = 0L;
            }
            if (!this.zzayv() || !this.zzazh()) {
                this.zzaul().zzayj().log("Nothing to upload or uploading impossible");
                this.zzazb().unregister();
                this.zzazc().cancel();
                return;
            }
            zzccw zzccw2 = this;
            long l4 = zzccw2.zzasc.currentTimeMillis();
            long l5 = zzcax.zzaxd();
            boolean bl = zzccw2.zzauf().zzaxo() || zzccw2.zzauf().zzaxj();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzccw2.zziss.zzaxg())) && !".none.".equals(string) ? zzcax.zzawz() : zzcax.zzawy()) : zzcax.zzawx();
            long l7 = zzccw2.zzaum().zziqp.get();
            long l8 = zzccw2.zzaum().zziqq.get();
            long l9 = zzccw2.zzauf().zzaxl();
            long l10 = zzccw2.zzauf().zzaxm();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzccw2.zzauh().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcax.zzaxf(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcax.zzaxe() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzaul().zzayj().log("Next upload time is 0");
            this.zzazb().unregister();
            this.zzazc().cancel();
            return;
        }
        if (!this.zzaza().zzyx()) {
            this.zzaul().zzayj().log("No network");
            this.zzazb().zzyu();
            this.zzazc().cancel();
            return;
        }
        l2 = this.zzaum().zziqr.get();
        long l16 = zzcax.zzaww();
        if (!this.zzauh().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzazb().unregister();
        long l17 = l3 - this.zzasc.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcax.zzaxa();
            this.zzaum().zziqp.set(this.zzasc.currentTimeMillis());
        }
        this.zzaul().zzayj().zzj("Upload scheduled in approximately ms", l17);
        this.zzazc().zzs(l17);
    }

    public final void zzbo(boolean bl) {
        this.zzazi();
    }

    final void zzb(zzcdu zzcdu2) {
        ++this.zzitv;
    }

    final void zzazj() {
        ++this.zzitw;
    }

    @WorkerThread
    public final void zze(zzcas zzcas2) {
        int n;
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            return;
        }
        zzcar zzcar2 = this.zzauf().zziw(zzcas2.packageName);
        if (zzcar2 != null && TextUtils.isEmpty((CharSequence)zzcar2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcas2.zzilu)) {
            zzcar2.zzar(0L);
            this.zzauf().zza(zzcar2);
            this.zzaui().zzjq(zzcas2.packageName);
        }
        if (!zzcas2.zzilz) {
            this.zzf(zzcas2);
            return;
        }
        long l = zzcas2.zzime;
        if (l == 0L) {
            l = this.zzasc.currentTimeMillis();
        }
        if ((n = zzcas2.zzimf) != 0 && n != 1) {
            this.zzaul().zzayf().zze("Incorrect app type, assuming installed app. appId, appType", zzcbw.zzjf(zzcas2.packageName), n);
            n = 0;
        }
        this.zzauf().beginTransaction();
        try {
            zzcbk zzcbk2;
            Object object;
            long l2 = l;
            zzcas zzcas3 = zzcas2;
            zzccw zzccw2 = this;
            zzcar zzcar3 = zzccw2.zzauf().zziw(zzcas3.packageName);
            if (zzcar3 != null && zzcar3.getGmpAppId() != null && !zzcar3.getGmpAppId().equals(zzcas3.zzilu)) {
                zzccw2.zzaul().zzayf().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcbw.zzjf(zzcar3.getAppId()));
                String string = zzcar3.getAppId();
                zzcay zzcay2 = zzccw2.zzauf();
                zzcay2.zzwk();
                zzcay2.zzuj();
                zzbp.zzgg((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcay2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcay2.zzaul().zzayj().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcay2.zzaul().zzayd().zze("Error deleting application data. appId, error", zzcbw.zzjf(string), (Object)sQLiteException);
                }
                zzcar3 = null;
            }
            if (zzcar3 != null && zzcar3.zzuo() != null && !zzcar3.zzuo().equals(zzcas3.zzhtt)) {
                object = new Bundle();
                object.putString("_pv", zzcar3.zzuo());
                zzcbk2 = new zzcbk("_au", new zzcbh((Bundle)object), "auto", l2);
                zzccw2.zzb(zzcbk2, zzcas3);
            }
            this.zzf(zzcas2);
            zzcbg zzcbg2 = null;
            if (n == 0) {
                zzcbg2 = this.zzauf().zzaf(zzcas2.packageName, "_f");
            } else if (n == 1) {
                zzcbg2 = this.zzauf().zzaf(zzcas2.packageName, "_v");
            }
            if (zzcbg2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbck zzbck2;
                    zzcft zzcft2 = new zzcft("_fot", l, l3, "auto");
                    this.zzb(zzcft2, zzcas2);
                    l2 = l;
                    zzcas3 = zzcas2;
                    zzccw2 = this;
                    ((zzcdt)zzccw2.zzauk()).zzuj();
                    zzccw2.zzwk();
                    zzcar3 = new Bundle();
                    zzcar3.putLong("_c", 1L);
                    zzcar3.putLong("_r", 1L);
                    zzcar3.putLong("_uwa", 0L);
                    zzcar3.putLong("_pfo", 0L);
                    zzcar3.putLong("_sys", 0L);
                    zzcar3.putLong("_sysu", 0L);
                    if (zzccw2.mContext.getPackageManager() == null) {
                        zzccw2.zzaul().zzayd().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName));
                    } else {
                        zzcbk2 = null;
                        try {
                            zzcbk2 = zzbed.zzcr((Context)zzccw2.mContext).getPackageInfo(zzcas3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccw2.zzaul().zzayd().zze("Package info is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcbk2 != null && ((PackageInfo)zzcbk2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcbk2).firstInstallTime != ((PackageInfo)zzcbk2).lastUpdateTime) {
                                zzcar3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbck2 = new zzcft("_fi", l2, bl ? 1L : 0L, "auto");
                            zzccw2.zzb((zzcft)zzbck2, zzcas3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbed.zzcr((Context)zzccw2.mContext).getApplicationInfo(zzcas3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccw2.zzaul().zzayd().zze("Application info is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcar3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcar3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcas3.packageName;
                    zzcay zzcay3 = zzccw2.zzauf();
                    zzbp.zzgg((String)string);
                    zzcay3.zzuj();
                    zzcay3.zzwk();
                    long l4 = zzcay3.zzam(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcar3.putLong("_pfo", l4);
                    }
                    zzbck2 = new zzcbk("_f", new zzcbh((Bundle)zzcar3), "auto", l2);
                    zzccw2.zzb((zzcbk)zzbck2, zzcas3);
                } else if (n == 1) {
                    zzcft zzcft3 = new zzcft("_fvt", l, l3, "auto");
                    this.zzb(zzcft3, zzcas2);
                    l2 = l;
                    zzcas3 = zzcas2;
                    zzccw2 = this;
                    ((zzcdt)zzccw2.zzauk()).zzuj();
                    zzccw2.zzwk();
                    zzcar3 = new Bundle();
                    zzcar3.putLong("_c", 1L);
                    zzcar3.putLong("_r", 1L);
                    object = new zzcbk("_v", new zzcbh((Bundle)zzcar3), "auto", l2);
                    zzccw2.zzb((zzcbk)((Object)object), zzcas3);
                }
                l2 = l;
                zzcas3 = zzcas2;
                zzccw2 = this;
                zzcar3 = new Bundle();
                zzcar3.putLong("_et", 1L);
                object = new zzcbk("_e", new zzcbh((Bundle)zzcar3), "auto", l2);
                zzccw2.zzb((zzcbk)((Object)object), zzcas3);
            } else if (zzcas2.zzima) {
                l2 = l;
                zzcas3 = zzcas2;
                zzccw2 = this;
                zzcar3 = new Bundle();
                object = new zzcbk("_cd", new zzcbh((Bundle)zzcar3), "auto", l2);
                zzccw2.zzb((zzcbk)((Object)object), zzcas3);
            }
            this.zzauf().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzauf().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzcas zzcas2) {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        zzcar zzcar2 = this.zzauf().zziw(zzcas2.packageName);
        String string = this.zzaum().zzji(zzcas2.packageName);
        boolean bl = false;
        if (zzcar2 == null) {
            zzcar2 = new zzcar(this, zzcas2.packageName);
            zzcar2.zzim(this.zzaua().zzaya());
            zzcar2.zzio(string);
            bl = true;
        } else if (!string.equals(zzcar2.zzaup())) {
            zzcar2.zzio(string);
            zzcar2.zzim(this.zzaua().zzaya());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzilu) && !zzcas2.zzilu.equals(zzcar2.getGmpAppId())) {
            zzcar2.zzin(zzcas2.zzilu);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzimc) && !zzcas2.zzimc.equals(zzcar2.zzauq())) {
            zzcar2.zzip(zzcas2.zzimc);
            bl = true;
        }
        if (zzcas2.zzilw != 0L && zzcas2.zzilw != zzcar2.zzauv()) {
            zzcar2.zzao(zzcas2.zzilw);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzhtt) && !zzcas2.zzhtt.equals(zzcar2.zzuo())) {
            zzcar2.setAppVersion(zzcas2.zzhtt);
            bl = true;
        }
        if (zzcas2.zzimb != zzcar2.zzaut()) {
            zzcar2.zzan(zzcas2.zzimb);
            bl = true;
        }
        if (zzcas2.zzilv != null && !zzcas2.zzilv.equals(zzcar2.zzauu())) {
            zzcar2.zziq(zzcas2.zzilv);
            bl = true;
        }
        if (zzcas2.zzilx != zzcar2.zzauw()) {
            zzcar2.zzap(zzcas2.zzilx);
            bl = true;
        }
        if (zzcas2.zzilz != zzcar2.zzaux()) {
            zzcar2.setMeasurementEnabled(zzcas2.zzilz);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzily) && !zzcas2.zzily.equals(zzcar2.zzavi())) {
            zzcar2.zzir(zzcas2.zzily);
            bl = true;
        }
        if (zzcas2.zzimd != zzcar2.zzavk()) {
            zzcar2.zzaz(zzcas2.zzimd);
            bl = true;
        }
        if (bl) {
            this.zzauf().zza(zzcar2);
        }
    }

    @WorkerThread
    final void zzazk() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        if (!this.zzito) {
            this.zzaul().zzayh().log("This instance being marked as an uploader");
            zzccw zzccw2 = this;
            ((zzcdt)zzccw2.zzauk()).zzuj();
            zzccw2.zzwk();
            if (zzccw2.zzazl() && zzccw2.zzazd()) {
                int n;
                int n2 = zzccw2.zza(zzccw2.zzits);
                int n3 = n = zzccw2.zzaua().zzayb();
                int n4 = n2;
                zzccw zzccw3 = zzccw2;
                ((zzcdt)zzccw3.zzauk()).zzuj();
                if (n4 > n3) {
                    zzccw3.zzaul().zzayd().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzccw3.zza(n3, zzccw3.zzits)) {
                        zzccw3.zzaul().zzayj().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzccw3.zzaul().zzayd().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzito = true;
            this.zzazi();
        }
    }

    @WorkerThread
    private final boolean zzazl() {
        ((zzcdt)this.zzauk()).zzuj();
        this.zzwk();
        return this.zzito;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcdt)this.zzauk()).zzuj();
        if (this.zzitu == null) {
            this.zzitu = new ArrayList<Runnable>();
        }
        this.zzitu.add(runnable);
    }

    @WorkerThread
    private final void zzazm() {
        ((zzcdt)this.zzauk()).zzuj();
        if (this.zzitz || this.zziua || this.zziub) {
            this.zzaul().zzayj().zzd("Not stopping services. fetch, network, upload", this.zzitz, this.zziua, this.zziub);
            return;
        }
        this.zzaul().zzayj().log("Stopping uploading service(s)");
        if (this.zzitu == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzitu.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzitu.clear();
    }

    final class zza
    implements zzcba {
        zzcgk zziue;
        List<Long> zziuf;
        List<zzcgh> zzaoc;
        private long zziug;
        private /* synthetic */ zzccw zziud;

        private zza(zzccw zzccw2) {
            this.zziud = zzccw2;
        }

        @Override
        public final void zzb(zzcgk zzcgk2) {
            zzbp.zzu((Object)((Object)zzcgk2));
            this.zziue = zzcgk2;
        }

        @Override
        public final boolean zza(long l, zzcgh zzcgh2) {
            zzbp.zzu((Object)((Object)zzcgh2));
            if (this.zzaoc == null) {
                this.zzaoc = new ArrayList<zzcgh>();
            }
            if (this.zziuf == null) {
                this.zziuf = new ArrayList<Long>();
            }
            if (this.zzaoc.size() > 0 && zza.zza(this.zzaoc.get(0)) != zza.zza(zzcgh2)) {
                return false;
            }
            long l2 = this.zziug + (long)zzcgh2.zzhi();
            if (l2 >= (long)zzcax.zzawr()) {
                return false;
            }
            this.zziug = l2;
            this.zzaoc.add(zzcgh2);
            this.zziuf.add(l);
            return this.zzaoc.size() < zzcax.zzaws();
        }

        private static long zza(zzcgh zzcgh2) {
            return zzcgh2.zziyy / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzccw zzccw2, zzccx zzccx2) {
            this(zzccw2);
        }
    }
}

