/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzchh;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzche
extends zzcii {
    private ExecutorService zzicc;
    private zzchi zzjbu;
    private zzchi zzjbv;
    private final PriorityBlockingQueue<zzchh<?>> zzjbw;
    private final BlockingQueue<zzchh<?>> zzjbx;
    private final Thread.UncaughtExceptionHandler zzjby;
    private final Thread.UncaughtExceptionHandler zzjbz;
    private final Object zzjca = new Object();
    private final Semaphore zzjcb = new Semaphore(2);
    private volatile boolean zzjcc;
    private static final AtomicLong zzjcd = new AtomicLong(Long.MIN_VALUE);

    zzche(zzchj zzchj2) {
        super(zzchj2);
        this.zzjbw = new PriorityBlockingQueue();
        this.zzjbx = new LinkedBlockingQueue();
        this.zzjby = new zzchg(this, "Thread death: Uncaught exception on worker thread");
        this.zzjbz = new zzchg(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzaxo() {
        return false;
    }

    @Override
    public final void zzut() {
        if (Thread.currentThread() != this.zzjbu) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzavy() {
        if (Thread.currentThread() != this.zzjbv) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzas() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzazh() {
        return Thread.currentThread() == this.zzjbu;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull(callable);
        zzchh zzchh2 = new zzchh(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjbu) {
            if (!this.zzjbw.isEmpty()) {
                ((zzcih)this).zzawn().zzayu().log("Callable skipped the worker queue.");
            }
            zzchh2.run();
        } else {
            this.zza(zzchh2);
        }
        return zzchh2;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull(callable);
        zzchh zzchh2 = new zzchh(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzjbu) {
            zzchh2.run();
        } else {
            this.zza(zzchh2);
        }
        return zzchh2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull((Object)runnable);
        this.zza(new zzchh(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzchh<?> zzchh2) {
        Object object = this.zzjca;
        synchronized (object) {
            this.zzjbw.add(zzchh2);
            if (this.zzjbu == null) {
                this.zzjbu = new zzchi(this, "Measurement Worker", this.zzjbw);
                this.zzjbu.setUncaughtExceptionHandler(this.zzjby);
                this.zzjbu.start();
            } else {
                this.zzjbu.zzrb();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwu();
        zzbq.checkNotNull((Object)runnable);
        zzchh zzchh2 = new zzchh(this, runnable, false, "Task exception on network thread");
        zzche zzche2 = this;
        Object object = zzche2.zzjca;
        synchronized (object) {
            zzche2.zzjbx.add(zzchh2);
            if (zzche2.zzjbv == null) {
                zzche2.zzjbv = new zzchi(zzche2, "Measurement Network", zzche2.zzjbx);
                zzche2.zzjbv.setUncaughtExceptionHandler(zzche2.zzjbz);
                zzche2.zzjbv.start();
            } else {
                zzche2.zzjbv.zzrb();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzazi() {
        Object object = this.zzjca;
        synchronized (object) {
            if (this.zzicc == null) {
                this.zzicc = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzicc;
        }
    }

    static /* synthetic */ Semaphore zza(zzche zzche2) {
        return zzche2.zzjcb;
    }

    static /* synthetic */ boolean zzb(zzche zzche2) {
        return zzche2.zzjcc;
    }

    static /* synthetic */ Object zzc(zzche zzche2) {
        return zzche2.zzjca;
    }

    static /* synthetic */ zzchi zzd(zzche zzche2) {
        return zzche2.zzjbu;
    }

    static /* synthetic */ zzchi zza(zzche zzche2, zzchi zzchi2) {
        zzche2.zzjbu = null;
        return null;
    }

    static /* synthetic */ zzchi zze(zzche zzche2) {
        return zzche2.zzjbv;
    }

    static /* synthetic */ zzchi zzb(zzche zzche2, zzchi zzchi2) {
        zzche2.zzjbv = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzazj() {
        return zzjcd;
    }
}

