/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbgc;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcfs;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzchn;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcij;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjd;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzckv;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;
import com.google.android.gms.internal.zzcla;
import com.google.android.gms.internal.zzclb;
import com.google.android.gms.internal.zzcld;
import com.google.android.gms.internal.zzfhj;
import com.google.android.gms.internal.zzfhk;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzchj {
    private static volatile zzchj zzjck;
    private final Context mContext;
    private final zzcfk zzjcl;
    private final zzcgu zzjcm;
    private final zzcgj zzjcn;
    private final zzche zzjco;
    private final zzckc zzjcp;
    private final zzchd zzjcq;
    private final AppMeasurement zzjcr;
    private final FirebaseAnalytics zzjcs;
    private final zzckn zzjct;
    private final zzcgh zzjcu;
    private final zzcfl zzjcv;
    private final zzcgf zzjcw;
    private final zzcgn zzjcx;
    private final zzd zzasd;
    private final zzciz zzjcy;
    private final zzcjd zzjcz;
    private final zzcfr zzjda;
    private final zzcik zzjdb;
    private final zzcge zzjdc;
    private final zzcgs zzjdd;
    private final zzcki zzjde;
    private final zzcfh zzjdf;
    private final zzcfa zzjdg;
    private boolean zzdqd = false;
    private boolean zzjdh;
    private Boolean zzjdi;
    private long zzjdj;
    private FileLock zzjdk;
    private FileChannel zzjdl;
    private List<Long> zzjdm;
    private List<Runnable> zzjdn;
    private int zzjdo;
    private int zzjdp;
    private long zzjdq;
    private long zzjdr;
    private boolean zzjds;
    private boolean zzjdt;
    private boolean zzjdu;
    private final long zzjdv;

    private zzchj(zzcij zzcij2) {
        zzcfa zzcfa2;
        zzbq.checkNotNull((Object)zzcij2);
        this.mContext = zzcij2.mContext;
        this.zzjdq = -1L;
        this.zzasd = zzh.zzalv();
        this.zzjdv = this.zzasd.currentTimeMillis();
        Object object = this;
        this.zzjcl = new zzcfk((zzchj)object);
        object = this;
        zzcgu zzcgu2 = new zzcgu((zzchj)object);
        zzcgu2.initialize();
        this.zzjcm = zzcgu2;
        object = this;
        zzcgj zzcgj2 = new zzcgj((zzchj)object);
        zzcgj2.initialize();
        this.zzjcn = zzcgj2;
        object = this;
        zzckn zzckn2 = new zzckn((zzchj)object);
        zzckn2.initialize();
        this.zzjct = zzckn2;
        object = this;
        zzcgh zzcgh2 = new zzcgh((zzchj)object);
        zzcgh2.initialize();
        this.zzjcu = zzcgh2;
        object = this;
        zzcfr zzcfr2 = new zzcfr((zzchj)object);
        zzcfr2.initialize();
        this.zzjda = zzcfr2;
        object = this;
        zzcge zzcge2 = new zzcge((zzchj)object);
        zzcge2.initialize();
        this.zzjdc = zzcge2;
        object = this;
        zzcfl zzcfl2 = new zzcfl((zzchj)object);
        zzcfl2.initialize();
        this.zzjcv = zzcfl2;
        object = this;
        zzcgf zzcgf2 = new zzcgf((zzchj)object);
        zzcgf2.initialize();
        this.zzjcw = zzcgf2;
        object = this;
        zzcfh zzcfh2 = new zzcfh((zzchj)object);
        zzcfh2.initialize();
        this.zzjdf = zzcfh2;
        object = this;
        this.zzjdg = zzcfa2 = new zzcfa((zzchj)object);
        object = this;
        zzcgn zzcgn2 = new zzcgn((zzchj)object);
        zzcgn2.initialize();
        this.zzjcx = zzcgn2;
        object = this;
        zzciz zzciz2 = new zzciz((zzchj)object);
        zzciz2.initialize();
        this.zzjcy = zzciz2;
        object = this;
        zzcjd zzcjd2 = new zzcjd((zzchj)object);
        zzcjd2.initialize();
        this.zzjcz = zzcjd2;
        object = this;
        zzcik zzcik2 = new zzcik((zzchj)object);
        zzcik2.initialize();
        this.zzjdb = zzcik2;
        object = this;
        zzcki zzcki2 = new zzcki((zzchj)object);
        zzcki2.initialize();
        this.zzjde = zzcki2;
        object = this;
        this.zzjdd = new zzcgs((zzchj)object);
        object = this;
        this.zzjcr = new AppMeasurement((zzchj)object);
        object = this;
        this.zzjcs = new FirebaseAnalytics((zzchj)object);
        object = this;
        zzckc zzckc2 = new zzckc((zzchj)object);
        zzckc2.initialize();
        this.zzjcp = zzckc2;
        object = this;
        zzchd zzchd2 = new zzchd((zzchj)object);
        zzchd2.initialize();
        this.zzjcq = zzchd2;
        object = this;
        zzche zzche2 = new zzche((zzchj)object);
        zzche2.initialize();
        this.zzjco = zzche2;
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzawb();
            if (((zzcih)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcih)object).getContext().getApplicationContext();
                if (((zzcik)object).zzjem == null) {
                    ((zzcik)object).zzjem = new zzciy((zzcik)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcik)object).zzjem);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcik)object).zzjem);
                ((zzcih)object).zzawn().zzayy().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzawn().zzayu().log("Application context is not an Application");
        }
        this.zzjco.zzg(new zzchk(this));
    }

    final void zzwu() {
        if (!this.zzdqd) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzazk() {
        this.zzwu();
        ((zzcih)this.zzawm()).zzut();
        if (this.zzjdi == null || this.zzjdj == 0L || this.zzjdi != null && !this.zzjdi.booleanValue() && Math.abs(this.zzasd.elapsedRealtime() - this.zzjdj) > 1000L) {
            this.zzjdj = this.zzasd.elapsedRealtime();
            this.zzjdi = this.zzawj().zzdu("android.permission.INTERNET") && this.zzawj().zzdu("android.permission.ACCESS_NETWORK_STATE") && (zzbgc.zzcy((Context)this.mContext).zzamj() || zzcha.zzbi(this.mContext) && zzcjx.zzk(this.mContext, false));
            if (this.zzjdi.booleanValue()) {
                this.zzjdi = this.zzawj().zzkb(this.zzawc().getGmpAppId());
            }
        }
        return this.zzjdi;
    }

    @WorkerThread
    private final void zzazl() {
        String string;
        zzcgl zzcgl2;
        ((zzcih)this.zzawm()).zzut();
        this.zzjct.zzazl();
        this.zzjcm.zzazl();
        this.zzjdc.zzazl();
        this.zzawn().zzayw().zzj("App measurement is starting up, version", 11717L);
        this.zzawn().zzayw().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string2 = this.zzjdc.getAppId();
        if (this.zzawj().zzke(string2)) {
            zzcgl2 = this.zzawn().zzayw();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcgl2 = this.zzawn().zzayw();
            String string3 = String.valueOf(string2);
            string = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcgl2.log(string);
        this.zzawn().zzayx().log("Debug-level message logging enabled");
        if (this.zzjdo != this.zzjdp) {
            this.zzawn().zzays().zze("Not all components initialized", this.zzjdo, this.zzjdp);
        }
        this.zzdqd = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcih)this.zzawm()).zzut();
        this.zzawh().zzaxw();
        if (this.zzawo().zzjag.get() == 0L) {
            this.zzawo().zzjag.set(this.zzasd.currentTimeMillis());
        }
        if (Long.valueOf(this.zzawo().zzjal.get()) == 0L) {
            this.zzawn().zzayy().zzj("Persisting first open", this.zzjdv);
            this.zzawo().zzjal.set(this.zzjdv);
        }
        if (!this.zzazk()) {
            if (this.isEnabled()) {
                if (!this.zzawj().zzdu("android.permission.INTERNET")) {
                    this.zzawn().zzays().log("App is missing INTERNET permission");
                }
                if (!this.zzawj().zzdu("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzawn().zzays().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!zzbgc.zzcy((Context)this.mContext).zzamj()) {
                    if (!zzcha.zzbi(this.mContext)) {
                        this.zzawn().zzays().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcjx.zzk(this.mContext, false)) {
                        this.zzawn().zzays().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzawn().zzays().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzawc().getGmpAppId())) {
                String string = this.zzawo().zzazb();
                if (string == null) {
                    this.zzawo().zzjj(this.zzawc().getGmpAppId());
                } else if (!string.equals(this.zzawc().getGmpAppId())) {
                    this.zzawn().zzayw().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzawo().zzaze();
                    this.zzjcz.disconnect();
                    this.zzjcz.zzxr();
                    this.zzawo().zzjj(this.zzawc().getGmpAppId());
                    this.zzawo().zzjal.set(this.zzjdv);
                    this.zzawo().zzjam.zzjl(null);
                }
            }
            this.zzawb().zzjk(this.zzawo().zzjam.zzazg());
            if (!TextUtils.isEmpty((CharSequence)this.zzawc().getGmpAppId())) {
                zzcik zzcik2 = this.zzawb();
                ((zzcih)zzcik2).zzut();
                zzcik2.zzwu();
                if (zzcik2.zzitu.zzazk()) {
                    ((zzcih)zzcik2).zzawe().zzbag();
                    String string = ((zzcih)zzcik2).zzawo().zzazf();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcih)zzcik2).zzawd().zzwu();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcik2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzawe().zza(new AtomicReference<String>());
            }
        }
        this.zzazy();
    }

    public final zzcfk zzawp() {
        return this.zzjcl;
    }

    public final zzcgu zzawo() {
        zzchj.zza((zzcih)this.zzjcm);
        return this.zzjcm;
    }

    public final zzcgj zzawn() {
        zzchj.zza(this.zzjcn);
        return this.zzjcn;
    }

    public final zzcgj zzazm() {
        if (this.zzjcn != null && this.zzjcn.isInitialized()) {
            return this.zzjcn;
        }
        return null;
    }

    public final zzche zzawm() {
        zzchj.zza(this.zzjco);
        return this.zzjco;
    }

    public final zzckc zzawl() {
        zzchj.zza(this.zzjcp);
        return this.zzjcp;
    }

    public final zzchd zzawk() {
        zzchj.zza(this.zzjcq);
        return this.zzjcq;
    }

    final zzche zzazn() {
        return this.zzjco;
    }

    public final zzcik zzawb() {
        zzchj.zza(this.zzjdb);
        return this.zzjdb;
    }

    public final AppMeasurement zzazo() {
        return this.zzjcr;
    }

    public final FirebaseAnalytics zzazp() {
        return this.zzjcs;
    }

    public final zzckn zzawj() {
        zzchj.zza((zzcih)this.zzjct);
        return this.zzjct;
    }

    public final zzcgh zzawi() {
        zzchj.zza((zzcih)this.zzjcu);
        return this.zzjcu;
    }

    public final zzcfl zzawh() {
        zzchj.zza(this.zzjcv);
        return this.zzjcv;
    }

    public final zzcgf zzawg() {
        zzchj.zza(this.zzjcw);
        return this.zzjcw;
    }

    public final zzcgn zzazq() {
        zzchj.zza(this.zzjcx);
        return this.zzjcx;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzwh() {
        return this.zzasd;
    }

    public final zzciz zzawf() {
        zzchj.zza(this.zzjcy);
        return this.zzjcy;
    }

    public final zzcjd zzawe() {
        zzchj.zza(this.zzjcz);
        return this.zzjcz;
    }

    public final zzcfr zzawd() {
        zzchj.zza(this.zzjda);
        return this.zzjda;
    }

    public final zzcge zzawc() {
        zzchj.zza(this.zzjdc);
        return this.zzjdc;
    }

    private final zzcgs zzazr() {
        if (this.zzjdd == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzjdd;
    }

    private final zzcki zzazs() {
        zzchj.zza(this.zzjde);
        return this.zzjde;
    }

    public final zzcfh zzawa() {
        zzchj.zza(this.zzjdf);
        return this.zzjdf;
    }

    public final zzcfa zzavz() {
        zzchj.zza(this.zzjdg);
        return this.zzjdg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzchj zzdu(Context context) {
        zzbq.checkNotNull((Object)context);
        zzbq.checkNotNull((Object)context.getApplicationContext());
        if (zzjck != null) return zzjck;
        Class<zzchj> clazz = zzchj.class;
        synchronized (zzchj.class) {
            if (zzjck != null) return zzjck;
            zzcij zzcij2 = new zzcij(context);
            zzjck = new zzchj(zzcij2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzjck;
        }
    }

    final void zzd(zzcff zzcff2) {
        this.zzawh().zziw(zzcff2.packageName);
        String string = zzcff2.packageName;
        zzcfl zzcfl2 = this.zzawh();
        zzbq.zzgi((String)string);
        zzcfl2.zzut();
        zzcfl2.zzwu();
        try {
            SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
            String[] stringArray = new String[]{string};
            int n = 0 + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("queue", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
            if (n > 0) {
                zzcfl2.zzawn().zzayy().zze("Reset analytics data. app, records", string, n);
            }
        }
        catch (SQLiteException sQLiteException) {
            zzcfl2.zzawn().zzays().zze("Error resetting analytics data. appId, error", zzcgj.zzjf(string), (Object)sQLiteException);
        }
        zzcff zzcff3 = this.zza(this.mContext, zzcff2.packageName, zzcff2.zzivh, zzcff2.zzivm, zzcff2.zzivt);
        this.zzf(zzcff3);
    }

    private final zzcff zza(Context context, String string, String string2, boolean bl, boolean bl2) {
        String string3 = "Unknown";
        String string4 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string5 = "Unknown";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            this.zzawn().zzays().log("PackageManager is null, can not log app install information");
            return null;
        }
        try {
            string3 = packageManager.getInstallerPackageName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzawn().zzays().zzj("Error retrieving installer package name. appId", zzcgj.zzjf(string));
        }
        if (string3 == null) {
            string3 = "manual_install";
        } else if ("com.android.vending".equals(string3)) {
            string3 = "";
        }
        try {
            PackageInfo packageInfo = zzbgc.zzcy((Context)context).getPackageInfo(string, 0);
            if (packageInfo != null) {
                CharSequence charSequence = zzbgc.zzcy((Context)context).zzgp(string);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string5 = charSequence.toString();
                }
                string4 = packageInfo.versionName;
                n = packageInfo.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzawn().zzays().zze("Error retrieving newly installed package info. appId, appName", zzcgj.zzjf(string), string5);
            return null;
        }
        return new zzcff(string, string2, string4, n, string3, 11717L, this.zzawj().zzaf(context, string), null, bl, false, "", 0L, 0L, 0, bl2);
    }

    private static void zza(zzcii zzcii2) {
        if (zzcii2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcii2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcih zzcih2) {
        if (zzcih2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzazt() {
        ((zzcih)this.zzawm()).zzut();
        String string = "google_app_measurement.db";
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzjdl = new RandomAccessFile(file2, "rw").getChannel();
            this.zzjdk = this.zzjdl.tryLock();
            if (this.zzjdk != null) {
                this.zzawn().zzayy().log("Storage concurrent access okay");
                return true;
            }
            this.zzawn().zzays().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzawn().zzays().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcih)this.zzawm()).zzut();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawn().zzays().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzawn().zzayu().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcih)this.zzawm()).zzut();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzawn().zzays().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzawn().zzays().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (this.zzjcl.zzaxp()) {
            return false;
        }
        Boolean bl = this.zzjcl.zzit("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcc.zzaix();
        return this.zzawo().zzbm(bl2);
    }

    final void zze(zzcff zzcff2) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        zzbq.zzgi((String)zzcff2.packageName);
        this.zzg(zzcff2);
    }

    final long zzazu() {
        Long l = this.zzawo().zzjal.get();
        if (l == 0L) {
            return this.zzjdv;
        }
        return Math.min(this.zzjdv, l);
    }

    private final long zzazv() {
        long l = this.zzasd.currentTimeMillis();
        zzcgu zzcgu2 = this.zzawo();
        zzcgu2.zzwu();
        zzcgu2.zzut();
        long l2 = zzcgu2.zzjak.get();
        if (l2 == 0L) {
            l2 = 1L + (long)zzcgu2.zzawj().zzbao().nextInt(86400000);
            zzcgu2.zzjak.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcff zzjr(String string) {
        zzcfe zzcfe2 = this.zzawh().zziw(string);
        if (zzcfe2 == null || TextUtils.isEmpty((CharSequence)zzcfe2.zzuy())) {
            this.zzawn().zzayx().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbgc.zzcy((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcfe2.zzuy() != null && !zzcfe2.zzuy().equals(string2)) {
                this.zzawn().zzayu().zzj("App version does not match; dropping. appId", zzcgj.zzjf(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcff(string, zzcfe2.getGmpAppId(), zzcfe2.zzuy(), zzcfe2.zzawv(), zzcfe2.zzaww(), zzcfe2.zzawx(), zzcfe2.zzawy(), null, zzcfe2.zzawz(), false, zzcfe2.zzaws(), zzcfe2.zzaxm(), 0L, 0, zzcfe2.zzaxn());
    }

    @WorkerThread
    final void zzb(zzcfx zzcfx2, String string) {
        Object object;
        zzcfe zzcfe2;
        block4: {
            zzcfe2 = this.zzawh().zziw(string);
            if (zzcfe2 == null || TextUtils.isEmpty((CharSequence)zzcfe2.zzuy())) {
                this.zzawn().zzayx().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbgc.zzcy((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcfe2.zzuy() != null && !zzcfe2.zzuy().equals(object)) {
                    this.zzawn().zzayu().zzj("App version does not match; dropping event. appId", zzcgj.zzjf(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcfx2.name)) break block4;
                this.zzawn().zzayu().zzj("Could not find package. appId", zzcgj.zzjf(string));
            }
        }
        object = new zzcff(string, zzcfe2.getGmpAppId(), zzcfe2.zzuy(), zzcfe2.zzawv(), zzcfe2.zzaww(), zzcfe2.zzawx(), zzcfe2.zzawy(), null, zzcfe2.zzawz(), false, zzcfe2.zzaws(), zzcfe2.zzaxm(), 0L, 0, zzcfe2.zzaxn());
        this.zzb(zzcfx2, (zzcff)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcfx zzcfx2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgi((String)zzcff2.packageName);
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        String string = zzcff2.packageName;
        long l = zzcfx2.zzixj;
        this.zzawj();
        if (!zzckn.zzd(zzcfx2, zzcff2)) {
            return;
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawh().beginTransaction();
        try {
            zzbej zzbej2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcfl zzcfl2 = this.zzawh();
            zzbq.zzgi((String)string3);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l2 < 0L) {
                zzcfl2.zzawn().zzayu().zze("Invalid time querying timed out conditional properties", zzcgj.zzjf(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcfl2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzawn().zzayx().zzd("User property timed out", object22.packageName, this.zzawi().zzje(object22.zzivv.name), object22.zzivv.getValue());
                if (object22.zzivz != null) {
                    this.zzc(new zzcfx(object22.zzivz, l), zzcff2);
                }
                this.zzawh().zzai(string, object22.zzivv.name);
            }
            l2 = l;
            string3 = string;
            zzcfl2 = this.zzawh();
            zzbq.zzgi((String)string3);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l2 < 0L) {
                zzcfl2.zzawn().zzayu().zze("Invalid time querying expired conditional properties", zzcgj.zzjf(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcfl2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcfi)((Object)object4.next());
                if (object == null) continue;
                this.zzawn().zzayx().zzd("User property expired", object.packageName, this.zzawi().zzje(object.zzivv.name), object.zzivv.getValue());
                this.zzawh().zzaf(string, object.zzivv.name);
                if (object.zziwd != null) {
                    object22.add(object.zziwd);
                }
                this.zzawh().zzai(string, object.zzivv.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcfx)((Object)e);
                this.zzc(new zzcfx((zzcfx)((Object)object), l), zzcff2);
            }
            long l3 = l;
            String string4 = zzcfx2.name;
            string3 = string;
            zzcfl2 = this.zzawh();
            zzbq.zzgi((String)string3);
            zzbq.zzgi((String)string4);
            zzcfl2.zzut();
            zzcfl2.zzwu();
            if (l3 < 0L) {
                zzcfl2.zzawn().zzayu().zzd("Invalid time querying triggered conditional properties", zzcgj.zzjf(string3), zzcfl2.zzawi().zzjc(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcfl2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbej2 = (zzcfi)((Object)iterator.next());
                if (zzbej2 == null) continue;
                zzckk zzckk2 = zzbej2.zzivv;
                zzckm zzckm2 = new zzckm(zzbej2.packageName, zzbej2.zzivu, zzckk2.name, l, zzckk2.getValue());
                if (this.zzawh().zza(zzckm2)) {
                    this.zzawn().zzayx().zzd("User property triggered", zzbej2.packageName, this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                } else {
                    this.zzawn().zzays().zzd("Too many active user properties, ignoring", zzcgj.zzjf(zzbej2.packageName), this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                }
                if (zzbej2.zziwb != null) {
                    object.add(zzbej2.zziwb);
                }
                zzbej2.zzivv = new zzckk(zzckm2);
                zzbej2.zzivx = true;
                this.zzawh().zza((zzcfi)zzbej2);
            }
            this.zzc(zzcfx2, zzcff2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbej2 = (zzcfx)((Object)e);
                this.zzc(new zzcfx((zzcfx)zzbej2, l), zzcff2);
            }
            this.zzawh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    private final void zzc(zzcfx var1_1, zzcff var2_2) {
        zzbq.checkNotNull((Object)var2_2);
        zzbq.zzgi((String)var2_2.packageName);
        var3_3 = System.nanoTime();
        this.zzawm().zzut();
        this.zzwu();
        var5_4 = var2_2.packageName;
        this.zzawj();
        if (!zzckn.zzd(var1_1, var2_2)) {
            return;
        }
        if (!var2_2.zzivm) {
            this.zzg(var2_2);
            return;
        }
        if (this.zzawk().zzan(var5_4, var1_1.name)) {
            this.zzawn().zzayu().zze("Dropping blacklisted event. appId", zzcgj.zzjf(var5_4), this.zzawi().zzjc(var1_1.name));
            var6_5 = this.zzawj().zzkg(var5_4) != false || this.zzawj().zzkh(var5_4) != false;
            if (!var6_5 && !"_err".equals(var1_1.name)) {
                this.zzawj().zza(var5_4, 11, "_ev", var1_1.name, 0);
            }
            if (var6_5 && (var7_7 = this.zzawh().zziw(var5_4)) != null) {
                var8_9 = Math.max(var7_7.zzaxc(), var7_7.zzaxb());
                if (Math.abs(this.zzasd.currentTimeMillis() - var8_9) > zzcfz.zziyr.get()) {
                    this.zzawn().zzayx().log("Fetching config for blacklisted app");
                    this.zzb(var7_7);
                }
            }
            return;
        }
        if (this.zzawn().zzae(2)) {
            this.zzawn().zzayy().zzj("Logging event", this.zzawi().zzb(var1_1));
        }
        this.zzawh().beginTransaction();
        try {
            block45: {
                block46: {
                    this.zzg(var2_2);
                    if (("_iap".equals(var1_1.name) || "ecommerce_purchase".equals(var1_1.name)) && !this.zza(var5_4, var1_1)) {
                        this.zzawh().setTransactionSuccessful();
                        return;
                    }
                    var6_6 = zzckn.zzju(var1_1.name);
                    var7_8 = "_err".equals(var1_1.name);
                    var8_10 = this.zzawh().zza(this.zzazv(), var5_4, true, var6_6, false, var7_8, false);
                    var9_11 = var8_10.zziwn - (long)zzcfz.zziyc.get().intValue();
                    if (var9_11 > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawn().zzays().zze("Data loss. Too many events logged. appId, count", zzcgj.zzjf(var5_4), var8_10.zziwn);
                        }
                        this.zzawh().setTransactionSuccessful();
                        return;
                    }
                    if (var6_6 && (var9_11 = var8_10.zziwm - (long)zzcfz.zziye.get().intValue()) > 0L) {
                        if (var9_11 % 1000L == 1L) {
                            this.zzawn().zzays().zze("Data loss. Too many public events logged. appId, count", zzcgj.zzjf(var5_4), var8_10.zziwm);
                        }
                        this.zzawj().zza(var5_4, 16, "_ev", var1_1.name, 0);
                        this.zzawh().setTransactionSuccessful();
                        return;
                    }
                    if (var7_8) {
                        var19_12 = var2_2.packageName;
                        var20_13 = this.zzjcl.zzb((String)var19_12, zzcfz.zziyd);
                        var9_11 = var8_10.zziwp - (long)Math.max(0, var20_13 = Math.min(1000000, var20_13));
                        if (var9_11 > 0L) {
                            if (var9_11 == 1L) {
                                this.zzawn().zzays().zze("Too many error events logged. appId, count", zzcgj.zzjf(var5_4), var8_10.zziwp);
                            }
                            this.zzawh().setTransactionSuccessful();
                            return;
                        }
                    }
                    var11_15 = var1_1.zzixi.zzaym();
                    this.zzawj().zza(var11_15, "_o", (Object)var1_1.zzivu);
                    if (this.zzawj().zzke(var5_4)) {
                        this.zzawj().zza(var11_15, "_dbg", 1L);
                        this.zzawj().zza(var11_15, "_r", 1L);
                    }
                    if ((var12_16 = this.zzawh().zzix(var5_4)) > 0L) {
                        this.zzawn().zzayu().zze("Data lost. Too many events stored on disk, deleted. appId", zzcgj.zzjf(var5_4), var12_16);
                    }
                    var14_17 = new zzcfs(this, var1_1.zzivu, var5_4, var1_1.name, var1_1.zzixj, 0L, var11_15);
                    var15_18 = this.zzawh().zzae(var5_4, var14_17.mName);
                    if (var15_18 == null) {
                        if (this.zzawh().zzja(var5_4) >= 500L && var6_6) {
                            this.zzawn().zzays().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcgj.zzjf(var5_4), this.zzawi().zzjc(var14_17.mName), 500);
                            this.zzawj().zza(var5_4, 8, null, null, 0);
                            return;
                        }
                        var16_19 = new zzcft(var5_4, var14_17.mName, 0L, 0L, var14_17.zzfgb, 0L, null, null, null);
                    } else {
                        var14_17 = var14_17.zza(this, var15_18.zzixb);
                        var16_19 = var15_18.zzba(var14_17.zzfgb);
                    }
                    this.zzawh().zza(var16_19);
                    var20_14 = var2_2;
                    var19_12 = var14_17;
                    var18_20 = this;
                    var18_20.zzawm().zzut();
                    var18_20.zzwu();
                    zzbq.checkNotNull((Object)var19_12);
                    zzbq.checkNotNull((Object)var20_14);
                    zzbq.zzgi((String)var19_12.mAppId);
                    zzbq.checkArgument((boolean)var19_12.mAppId.equals(var20_14.packageName));
                    var21_21 = new zzclb();
                    new zzclb().zzjjd = 1;
                    var21_21.zzjjl = "android";
                    var21_21.zzch = var20_14.packageName;
                    var21_21.zzivi = var20_14.zzivi;
                    var21_21.zzida = var20_14.zzida;
                    var21_21.zzjjy = var20_14.zzivo == -2147483648L ? null : Integer.valueOf((int)var20_14.zzivo);
                    var21_21.zzjjp = var20_14.zzivj;
                    var21_21.zzivh = var20_14.zzivh;
                    var21_21.zzjju = var20_14.zzivk == 0L ? null : Long.valueOf(var20_14.zzivk);
                    var22_22 = var18_20.zzawo().zzjh(var20_14.packageName);
                    if (var22_22 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var22_22.first))) {
                        if (var20_14.zzivt) {
                            var21_21.zzjjr = (String)var22_22.first;
                            var21_21.zzjjs = (Boolean)var22_22.second;
                        }
                    } else if (!var18_20.zzawd().zzdt(var18_20.mContext)) {
                        var23_23 = Settings.Secure.getString((ContentResolver)var18_20.mContext.getContentResolver(), (String)"android_id");
                        if (var23_23 == null) {
                            var18_20.zzawn().zzayu().zzj("null secure ID. appId", zzcgj.zzjf(var21_21.zzch));
                            var23_23 = "null";
                        } else if (var23_23.isEmpty()) {
                            var18_20.zzawn().zzayu().zzj("empty secure ID. appId", zzcgj.zzjf(var21_21.zzch));
                        }
                        var21_21.zzjkb = var23_23;
                    }
                    var18_20.zzawd().zzwu();
                    var21_21.zzjjm = Build.MODEL;
                    var18_20.zzawd().zzwu();
                    var21_21.zzcv = Build.VERSION.RELEASE;
                    var21_21.zzjjo = (int)var18_20.zzawd().zzayj();
                    var21_21.zzjjn = var18_20.zzawd().zzayk();
                    var21_21.zzjjq = null;
                    var21_21.zzjjg = null;
                    var21_21.zzjjh = null;
                    var21_21.zzjji = null;
                    var21_21.zzfib = var20_14.zzivq;
                    if (var18_20.isEnabled() && zzcfk.zzaxt()) {
                        var18_20.zzawc();
                        var21_21.zzjkd = null;
                    }
                    if ((var23_23 = var18_20.zzawh().zziw(var20_14.packageName)) == null) {
                        var23_23 = new zzcfe(var18_20, var20_14.packageName);
                        var23_23.zzim(var18_20.zzawc().zzayo());
                        var23_23.zzip(var20_14.zzivp);
                        var23_23.zzin(var20_14.zzivh);
                        var23_23.zzio(var18_20.zzawo().zzji(var20_14.packageName));
                        var23_23.zzap(0L);
                        var23_23.zzak(0L);
                        var23_23.zzal(0L);
                        var23_23.setAppVersion(var20_14.zzida);
                        var23_23.zzam(var20_14.zzivo);
                        var23_23.zziq(var20_14.zzivi);
                        var23_23.zzan(var20_14.zzivj);
                        var23_23.zzao(var20_14.zzivk);
                        var23_23.setMeasurementEnabled(var20_14.zzivm);
                        var23_23.zzay(var20_14.zzivq);
                        var18_20.zzawh().zza((zzcfe)var23_23);
                    }
                    var21_21.zzjjt = var23_23.getAppInstanceId();
                    var21_21.zzivp = var23_23.zzaws();
                    var24_24 = var18_20.zzawh().zziv(var20_14.packageName);
                    var21_21.zzjjf = new zzcld[var24_24.size()];
                    for (var25_25 = 0; var25_25 < var24_24.size(); ++var25_25) {
                        var21_21.zzjjf[var25_25] = var26_27 = new zzcld();
                        var26_27.name = var24_24.get((int)var25_25).mName;
                        var26_27.zzjkh = var24_24.get((int)var25_25).zzjhb;
                        var18_20.zzawj().zza(var26_27, var24_24.get((int)var25_25).mValue);
                    }
                    try {
                        var25_26 = var18_20.zzawh().zza(var21_21);
                    }
                    catch (IOException var27_28) {
                        var18_20.zzawn().zzays().zze("Data loss. Failed to insert raw event metadata. appId", zzcgj.zzjf(var21_21.zzch), var27_28);
                        break block45;
                    }
                    v0 = var18_20.zzawh();
                    var29_29 = var19_12;
                    var28_30 = var18_20;
                    if (var29_29.zziwy == null) ** GOTO lbl-1000
                    for (Object var31_33 : var29_29.zziwy) {
                        if (!"_r".equals(var31_33)) continue;
                        v1 = true;
                        break block46;
                    }
                    var30_32 = var28_30.zzawk().zzao(var29_29.mAppId, var29_29.mName);
                    var31_33 = var28_30.zzawh().zza(var28_30.zzazv(), var29_29.mAppId, false, false, false, false, false);
                    if (var30_32 && var31_33.zziwq < (long)var28_30.zzjcl.zzis(var29_29.mAppId)) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                }
                if (v0.zza((zzcfs)var19_12, var25_26, v1)) {
                    var18_20.zzjdr = 0L;
                }
            }
            this.zzawh().setTransactionSuccessful();
            if (this.zzawn().zzae(2)) {
                this.zzawn().zzayy().zzj("Event recorded", this.zzawi().zza(var14_17));
            }
        }
        finally {
            this.zzawh().endTransaction();
        }
        this.zzazy();
        this.zzawn().zzayy().zzj("Background event processing time, ms", (System.nanoTime() - var3_3 + 500000L) / 1000000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean zza(String string, zzcfx zzcfx2) {
        long l;
        String string2;
        block10: {
            string2 = zzcfx2.zzixi.getString("currency");
            if ("ecommerce_purchase".equals(zzcfx2.name)) {
                double d = zzcfx2.zzixi.getDouble("value") * 1000000.0;
                if (d == 0.0) {
                    d = (double)zzcfx2.zzixi.getLong("value").longValue() * 1000000.0;
                }
                if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                    l = Math.round(d);
                    break block10;
                } else {
                    this.zzawn().zzayu().zze("Data lost. Currency value is too big. appId", zzcgj.zzjf(string), d);
                    return false;
                }
            }
            l = zzcfx2.zzixi.getLong("value");
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
            String string3 = String.valueOf("_ltv_");
            String string4 = String.valueOf(string2);
            String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            zzckm zzckm2 = this.zzawh().zzag(string, string5);
            if (zzckm2 == null || !(zzckm2.mValue instanceof Long)) {
                String string6 = string;
                int n = this.zzjcl.zzb(string6, zzcfz.zziyw) - 1;
                string6 = string;
                zzcfl zzcfl2 = this.zzawh();
                zzbq.zzgi((String)string6);
                zzcfl2.zzut();
                zzcfl2.zzwu();
                try {
                    zzcfl2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string6, string6, String.valueOf(n)});
                }
                catch (SQLiteException sQLiteException) {
                    zzcfl2.zzawn().zzays().zze("Error pruning currencies. appId", zzcgj.zzjf(string6), (Object)sQLiteException);
                }
                zzckm2 = new zzckm(string, zzcfx2.zzivu, string5, this.zzasd.currentTimeMillis(), l);
            } else {
                long l2 = (Long)zzckm2.mValue;
                zzckm2 = new zzckm(string, zzcfx2.zzivu, string5, this.zzasd.currentTimeMillis(), l2 + l);
            }
            if (!this.zzawh().zza(zzckm2)) {
                this.zzawn().zzays().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcgj.zzjf(string), this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                this.zzawj().zza(string, 9, null, null, 0);
            }
        }
        return true;
    }

    @WorkerThread
    final void zzd(zzcfi zzcfi2) {
        zzcff zzcff2 = this.zzjr(zzcfi2.packageName);
        if (zzcff2 != null) {
            this.zzb(zzcfi2, zzcff2);
        }
    }

    @WorkerThread
    final void zzb(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.zzgi((String)zzcfi2.packageName);
        zzbq.checkNotNull((Object)zzcfi2.zzivu);
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivv));
        zzbq.zzgi((String)zzcfi2.zzivv.name);
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            return;
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        zzcfi zzcfi3 = new zzcfi(zzcfi2);
        new zzcfi(zzcfi2).zzivx = false;
        this.zzawh().beginTransaction();
        try {
            boolean bl = false;
            zzcfi zzcfi4 = this.zzawh().zzah(zzcfi3.packageName, zzcfi3.zzivv.name);
            if (zzcfi4 != null && !zzcfi4.zzivu.equals(zzcfi3.zzivu)) {
                this.zzawn().zzayu().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzawi().zzje(zzcfi3.zzivv.name), zzcfi3.zzivu, zzcfi4.zzivu);
            }
            if (zzcfi4 != null && zzcfi4.zzivx) {
                zzcfi3.zzivu = zzcfi4.zzivu;
                zzcfi3.zzivw = zzcfi4.zzivw;
                zzcfi3.zziwa = zzcfi4.zziwa;
                zzcfi3.zzivy = zzcfi4.zzivy;
                zzcfi3.zziwb = zzcfi4.zziwb;
                zzcfi3.zzivx = zzcfi4.zzivx;
                zzcfi3.zzivv = new zzckk(zzcfi3.zzivv.name, zzcfi4.zzivv.zzjgx, zzcfi3.zzivv.getValue(), zzcfi4.zzivv.zzivu);
            } else if (TextUtils.isEmpty((CharSequence)zzcfi3.zzivy)) {
                zzcfi3.zzivv = new zzckk(zzcfi3.zzivv.name, zzcfi3.zzivw, zzcfi3.zzivv.getValue(), zzcfi3.zzivv.zzivu);
                zzcfi3.zzivx = true;
                bl = true;
            }
            if (zzcfi3.zzivx) {
                zzckk zzckk2 = zzcfi3.zzivv;
                zzckm zzckm2 = new zzckm(zzcfi3.packageName, zzcfi3.zzivu, zzckk2.name, zzckk2.zzjgx, zzckk2.getValue());
                if (this.zzawh().zza(zzckm2)) {
                    this.zzawn().zzayx().zzd("User property updated immediately", zzcfi3.packageName, this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                } else {
                    this.zzawn().zzays().zzd("(2)Too many active user properties, ignoring", zzcgj.zzjf(zzcfi3.packageName), this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                }
                if (bl && zzcfi3.zziwb != null) {
                    zzcfx zzcfx2 = new zzcfx(zzcfi3.zziwb, zzcfi3.zzivw);
                    this.zzc(zzcfx2, zzcff2);
                }
            }
            if (this.zzawh().zza(zzcfi3)) {
                this.zzawn().zzayx().zzd("Conditional property added", zzcfi3.packageName, this.zzawi().zzje(zzcfi3.zzivv.name), zzcfi3.zzivv.getValue());
            } else {
                this.zzawn().zzays().zzd("Too many conditional properties, ignoring", zzcgj.zzjf(zzcfi3.packageName), this.zzawi().zzje(zzcfi3.zzivv.name), zzcfi3.zzivv.getValue());
            }
            this.zzawh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcfi zzcfi2) {
        zzcff zzcff2 = this.zzjr(zzcfi2.packageName);
        if (zzcff2 != null) {
            this.zzc(zzcfi2, zzcff2);
        }
    }

    @WorkerThread
    final void zzc(zzcfi zzcfi2, zzcff zzcff2) {
        zzbq.checkNotNull((Object)((Object)zzcfi2));
        zzbq.zzgi((String)zzcfi2.packageName);
        zzbq.checkNotNull((Object)((Object)zzcfi2.zzivv));
        zzbq.zzgi((String)zzcfi2.zzivv.name);
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            return;
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawh().beginTransaction();
        try {
            this.zzg(zzcff2);
            zzcfi zzcfi3 = this.zzawh().zzah(zzcfi2.packageName, zzcfi2.zzivv.name);
            if (zzcfi3 != null) {
                this.zzawn().zzayx().zze("Removing conditional user property", zzcfi2.packageName, this.zzawi().zzje(zzcfi2.zzivv.name));
                this.zzawh().zzai(zzcfi2.packageName, zzcfi2.zzivv.name);
                if (zzcfi3.zzivx) {
                    this.zzawh().zzaf(zzcfi2.packageName, zzcfi2.zzivv.name);
                }
                if (zzcfi2.zziwd != null) {
                    Bundle bundle = null;
                    if (zzcfi2.zziwd.zzixi != null) {
                        bundle = zzcfi2.zziwd.zzixi.zzaym();
                    }
                    zzcfx zzcfx2 = this.zzawj().zza(zzcfi2.zziwd.name, bundle, zzcfi3.zzivu, zzcfi2.zziwd.zzixj, true, false);
                    this.zzc(zzcfx2, zzcff2);
                }
            } else {
                this.zzawn().zzayu().zze("Conditional user property doesn't exist", zzcgj.zzjf(zzcfi2.packageName), this.zzawi().zzje(zzcfi2.zzivv.name));
            }
            this.zzawh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcfx zzcfx2, @Size(min=1L) String string) {
        Object object;
        this.zzwu();
        ((zzcih)this.zzawm()).zzut();
        zzchj.zzavx();
        zzbq.checkNotNull((Object)((Object)zzcfx2));
        zzbq.zzgi((String)string);
        zzcla zzcla2 = new zzcla();
        this.zzawh().beginTransaction();
        try {
            zzcft zzcft2;
            long l;
            Object object2;
            zzcfe zzcfe2 = this.zzawh().zziw(string);
            if (zzcfe2 == null) {
                this.zzawn().zzayx().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcfe2.zzawz()) {
                this.zzawn().zzayx().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (("_iap".equals(zzcfx2.name) || "ecommerce_purchase".equals(zzcfx2.name)) && !this.zza(string, zzcfx2)) {
                this.zzawn().zzayu().zzj("Failed to handle purchase event at single event bundle creation. appId", zzcgj.zzjf(string));
            }
            object = new zzclb();
            zzcla2.zzjjb = new zzclb[]{object};
            object.zzjjd = 1;
            object.zzjjl = "android";
            object.zzch = zzcfe2.getAppId();
            object.zzivi = zzcfe2.zzaww();
            object.zzida = zzcfe2.zzuy();
            long l2 = zzcfe2.zzawv();
            object.zzjjy = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzjjp = zzcfe2.zzawx();
            object.zzivh = zzcfe2.getGmpAppId();
            object.zzjju = zzcfe2.zzawy();
            if (this.isEnabled() && zzcfk.zzaxt() && this.zzjcl.zziu(object.zzch)) {
                this.zzawc();
                object.zzjkd = null;
            }
            Pair<String, Boolean> pair = this.zzawo().zzjh(zzcfe2.getAppId());
            if (zzcfe2.zzaxn() && pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzjjr = (String)pair.first;
                object.zzjjs = (Boolean)pair.second;
            }
            this.zzawd().zzwu();
            object.zzjjm = Build.MODEL;
            this.zzawd().zzwu();
            object.zzcv = Build.VERSION.RELEASE;
            object.zzjjo = (int)this.zzawd().zzayj();
            object.zzjjn = this.zzawd().zzayk();
            object.zzjjt = zzcfe2.getAppInstanceId();
            object.zzivp = zzcfe2.zzaws();
            List<zzckm> list = this.zzawh().zziv(zzcfe2.getAppId());
            object.zzjjf = new zzcld[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcld();
                object.zzjjf[i] = object2;
                ((zzcld)((Object)object2)).name = list.get((int)i).mName;
                ((zzcld)((Object)object2)).zzjkh = list.get((int)i).zzjhb;
                this.zzawj().zza((zzcld)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcfx2.zzixi.zzaym();
            if ("_iap".equals(zzcfx2.name)) {
                bundle.putLong("_c", 1L);
                this.zzawn().zzayx().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcfx2.zzivu);
            if (this.zzawj().zzke(object.zzch)) {
                this.zzawj().zza(bundle, "_dbg", 1L);
                this.zzawj().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzawh().zzae(string, zzcfx2.name)) == null) {
                l = 0L;
                zzcft2 = new zzcft(string, zzcfx2.name, 1L, 0L, zzcfx2.zzixj, 0L, null, null, null);
                this.zzawh().zza(zzcft2);
            } else {
                l = ((zzcft)object2).zzixb;
                zzcft2 = ((zzcft)object2).zzba(zzcfx2.zzixj).zzayl();
                this.zzawh().zza(zzcft2);
            }
            zzcfs zzcfs2 = new zzcfs(this, zzcfx2.zzivu, string, zzcfx2.name, zzcfx2.zzixj, l, bundle);
            zzcky zzcky2 = new zzcky();
            object.zzjje = new zzcky[]{zzcky2};
            zzcky2.zzjix = zzcfs2.zzfgb;
            zzcky2.name = zzcfs2.mName;
            zzcky2.zzjiy = zzcfs2.zziwx;
            zzcky2.zzjiw = new zzckz[zzcfs2.zziwy.size()];
            int n = 0;
            for (String string2 : zzcfs2.zziwy) {
                zzckz zzckz2 = new zzckz();
                zzcky2.zzjiw[n++] = zzckz2;
                zzckz2.name = string2;
                Object object3 = zzcfs2.zziwy.get(string2);
                this.zzawj().zza(zzckz2, object3);
            }
            object.zzjjx = this.zza(zzcfe2.getAppId(), object.zzjjf, object.zzjje);
            object.zzjjh = zzcky2.zzjix;
            object.zzjji = zzcky2.zzjix;
            long l3 = zzcfe2.zzawu();
            object.zzjjk = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcfe2.zzawt();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzjjj = l4 != 0L ? Long.valueOf(l4) : null;
            zzcfe2.zzaxd();
            object.zzjjv = (int)zzcfe2.zzaxa();
            object.zzjjq = 11717L;
            object.zzjjg = this.zzasd.currentTimeMillis();
            object.zzjjw = Boolean.TRUE;
            zzcfe2.zzak(object.zzjjh);
            zzcfe2.zzal(object.zzjji);
            this.zzawh().zza(zzcfe2);
            this.zzawh().setTransactionSuccessful();
        }
        finally {
            this.zzawh().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcla2.zzhl()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzfhk zzfhk2 = zzfhk.zzo((byte[])byArray, (int)0, (int)byArray2.length);
            zzcla2.zza(zzfhk2);
            zzfhk2.zzcut();
            return this.zzawj().zzp((byte[])object);
        }
        catch (IOException iOException) {
            this.zzawn().zzays().zze("Data loss. Failed to bundle and serialize. appId", zzcgj.zzjf(string), iOException);
            return null;
        }
    }

    public final String zzjs(String string) {
        Future<String> future = this.zzawm().zzc(new zzchl(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzawn().zzays().zze("Failed to get app instance id. appId", zzcgj.zzjf(string), exception);
            return null;
        }
    }

    private static boolean zza(zzcky zzcky2, String string, Object object) {
        if (TextUtils.isEmpty((CharSequence)string) || object == null) {
            return false;
        }
        zzckz[] zzckzArray = zzcky2.zzjiw;
        int n = zzcky2.zzjiw.length;
        for (int i = 0; i < n; ++i) {
            zzckz zzckz2 = zzckzArray[i];
            if (!string.equals(zzckz2.name)) continue;
            return object instanceof Long && object.equals(zzckz2.zzjja) || object instanceof String && object.equals(zzckz2.zzfzs) || object instanceof Double && object.equals(zzckz2.zzjha);
        }
        return false;
    }

    static void zzavx() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzckk zzckk2, zzcff zzcff2) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            return;
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        int n = this.zzawj().zzjy(zzckk2.name);
        if (n != 0) {
            this.zzawj();
            String string = zzckn.zza(zzckk2.name, 24, true);
            int n2 = zzckk2.name != null ? zzckk2.name.length() : 0;
            this.zzawj().zza(zzcff2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzawj().zzl(zzckk2.name, zzckk2.getValue());
        if (n != 0) {
            this.zzawj();
            String string = zzckn.zza(zzckk2.name, 24, true);
            Object object = zzckk2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzawj().zza(zzcff2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzawj().zzm(zzckk2.name, zzckk2.getValue());
        if (object == null) {
            return;
        }
        zzckm zzckm2 = new zzckm(zzcff2.packageName, zzckk2.zzivu, zzckk2.name, zzckk2.zzjgx, object);
        this.zzawn().zzayx().zze("Setting user property", this.zzawi().zzje(zzckm2.mName), object);
        this.zzawh().beginTransaction();
        try {
            this.zzg(zzcff2);
            boolean bl = this.zzawh().zza(zzckm2);
            this.zzawh().setTransactionSuccessful();
            if (bl) {
                this.zzawn().zzayx().zze("User property set", this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
            } else {
                this.zzawn().zzays().zze("Too many unique user properties are set. Ignoring user property", this.zzawi().zzje(zzckm2.mName), zzckm2.mValue);
                this.zzawj().zza(zzcff2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzckk zzckk2, zzcff zzcff2) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            return;
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        this.zzawn().zzayx().zzj("Removing user property", this.zzawi().zzje(zzckk2.name));
        this.zzawh().beginTransaction();
        try {
            this.zzg(zzcff2);
            this.zzawh().zzaf(zzcff2.packageName, zzckk2.name);
            this.zzawh().setTransactionSuccessful();
            this.zzawn().zzayx().zzj("User property removed", this.zzawi().zzje(zzckk2.name));
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazw() {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        this.zzjdu = true;
        try {
            String string;
            Boolean bl = this.zzawe().zzbah();
            if (bl == null) {
                this.zzawn().zzayu().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzawn().zzays().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzjdr > 0L) {
                this.zzazy();
                return;
            }
            Object object = this;
            ((zzcih)((zzchj)object).zzawm()).zzut();
            if (((zzchj)object).zzjdm != null) {
                this.zzawn().zzayy().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzazq().zzzh()) {
                this.zzawn().zzayy().log("Network not connected, ignoring upload request");
                this.zzazy();
                return;
            }
            long l = this.zzasd.currentTimeMillis();
            long l2 = l - zzcfk.zzaxr();
            this.zzh(null, l2);
            long l3 = this.zzawo().zzjag.get();
            if (l3 != 0L) {
                this.zzawn().zzayx().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzawh().zzaxu()))) {
                if (this.zzjdq == -1L) {
                    this.zzjdq = this.zzawh().zzayb();
                }
                Object object2 = string;
                int n = this.zzjcl.zzb((String)object2, zzcfz.zzixy);
                object2 = string;
                object = this.zzjcl;
                int n2 = Math.max(0, ((zzcfk)object).zzb((String)object2, zzcfz.zzixz));
                List<Pair<zzclb, Long>> list = this.zzawh().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzclb zzclb2 = (zzclb)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzclb2.zzjjr)) continue;
                        string2 = zzclb2.zzjjr;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzclb)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzclb)((Object)object3)).zzjjr) || ((zzclb)((Object)object3)).zzjjr.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcla();
                    new zzcla().zzjjb = new zzclb[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcfk.zzaxt() && this.zzjcl.zziu(string);
                    for (int i = 0; i < ((zzcla)((Object)object4)).zzjjb.length; ++i) {
                        ((zzcla)((Object)object4)).zzjjb[i] = (zzclb)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcla)((Object)object4)).zzjjb[i].zzjjq = 11717L;
                        ((zzcla)((Object)object4)).zzjjb[i].zzjjg = l;
                        ((zzcla)((Object)object4)).zzjjb[i].zzjjw = false;
                        if (bl2) continue;
                        ((zzcla)((Object)object4)).zzjjb[i].zzjkd = null;
                    }
                    String string3 = null;
                    if (this.zzawn().zzae(2)) {
                        string3 = this.zzawi().zza((zzcla)((Object)object4));
                    }
                    byte[] byArray = this.zzawj().zzb((zzcla)((Object)object4));
                    String string4 = zzcfz.zziyi.get();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbq.checkArgument((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzchj)object).zzjdm != null) {
                            ((zzchj)object).zzawn().zzays().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzchj)object).zzjdm = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzawo().zzjah.set(l);
                        String string5 = "?";
                        if (((zzcla)((Object)object4)).zzjjb.length > 0) {
                            string5 = ((zzcla)((Object)object4)).zzjjb[0].zzch;
                        }
                        this.zzawn().zzayy().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzjdt = true;
                        zzchm zzchm2 = new zzchm(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzazq();
                        ((zzcih)object).zzut();
                        ((zzcii)object).zzwu();
                        zzbq.checkNotNull((Object)uRL2);
                        zzbq.checkNotNull((Object)byArray2);
                        zzbq.checkNotNull((Object)zzchm2);
                        ((zzcih)object).zzawm().zzh(new zzcgr((zzcgn)object, (String)object2, uRL2, byArray2, null, zzchm2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzawn().zzays().zze("Failed to parse upload URL. Not uploading. appId", zzcgj.zzjf(string), string4);
                    }
                }
            } else {
                zzcfe zzcfe2;
                this.zzjdq = -1L;
                String string6 = this.zzawh().zzaz(l - zzcfk.zzaxr());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcfe2 = this.zzawh().zziw(string6)) != null) {
                    this.zzb(zzcfe2);
                }
            }
            return;
        }
        finally {
            this.zzjdu = false;
            this.zzbac();
        }
    }

    @WorkerThread
    private final void zzb(zzcfe zzcfe2) {
        ((zzcih)this.zzawm()).zzut();
        if (TextUtils.isEmpty((CharSequence)zzcfe2.getGmpAppId())) {
            this.zzb(zzcfe2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcfe2.getAppInstanceId();
        String string = zzcfe2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcfz.zzixw.get()).encodedAuthority(zzcfz.zzixx.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11717");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzawn().zzayy().zzj("Fetching remote configuration", zzcfe2.getAppId());
            zzckv zzckv2 = this.zzawk().zzjn(zzcfe2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzawk().zzjo(zzcfe2.getAppId());
            if (zzckv2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzjds = true;
            zzchn zzchn2 = new zzchn(this);
            builder = arrayMap;
            object = uRL;
            string = zzcfe2.getAppId();
            zzcgn zzcgn2 = this.zzazq();
            ((zzcih)zzcgn2).zzut();
            zzcgn2.zzwu();
            zzbq.checkNotNull((Object)object);
            zzbq.checkNotNull((Object)zzchn2);
            ((zzcih)zzcgn2).zzawm().zzh(new zzcgr(zzcgn2, string, (URL)object, null, (Map)builder, zzchn2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzawn().zzays().zze("Failed to parse config URL. Not fetching. appId", zzcgj.zzjf(zzcfe2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzh(String string, long l) {
        this.zzawh().beginTransaction();
        try {
            block85: {
                zzckz[] zzckzArray;
                Object object;
                int zzcky3;
                int n2;
                int n3;
                Object object2;
                String string2;
                zza zza2;
                block84: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzjdq;
                    long l3 = l;
                    string2 = null;
                    object2 = this.zzawh();
                    zzbq.checkNotNull((Object)zza3);
                    ((zzcih)object2).zzut();
                    ((zzcii)object2).zzwu();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcfl)object2).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block84;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcih)object2).zzawn().zzays().zzj("Raw event metadata record is missing. appId", zzcgj.zzjf(string2));
                            break block84;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                        zzclb zzclb2 = new zzclb();
                        try {
                            zzclb2.zza((zzfhj)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcih)object2).zzawn().zzays().zze("Data loss. Failed to merge raw event metadata. appId", zzcgj.zzjf(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block84;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcih)object2).zzawn().zzayu().zzj("Get multiple raw event metadata records, expected one. appId", zzcgj.zzjf(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzclb2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcih)object2).zzawn().zzayu().zzj("Raw event data disappeared while in transaction. appId", zzcgj.zzjf(string2));
                            break block84;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzfhj.zzn((byte[])byArray, (int)0, (int)byArray.length);
                            zzcky zzcky2 = new zzcky();
                            try {
                                zzcky2.zza((zzfhj)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcih)object2).zzawn().zzays().zze("Data loss. Failed to merge raw event. appId", zzcgj.zzjf(string2), iOException);
                                continue;
                            }
                            zzcky2.name = cursor.getString(1);
                            zzcky2.zzjix = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcky2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object2 = zza2;
                if (((zza)object2).zzaof == null || ((zza)object2).zzaof.isEmpty()) break block85;
                boolean bl = false;
                zzclb zzclb3 = zza2.zzjdx;
                zza2.zzjdx.zzjje = new zzcky[zza2.zzaof.size()];
                int n4 = 0;
                for (n3 = 0; n3 < zza2.zzaof.size(); ++n3) {
                    block87: {
                        zzckz[] n8;
                        int n;
                        boolean bl2;
                        block86: {
                            bl2 = bl;
                            if (this.zzawk().zzan(zza2.zzjdx.zzch, zza2.zzaof.get((int)n3).name)) {
                                this.zzawn().zzayu().zze("Dropping blacklisted raw event. appId", zzcgj.zzjf(zza2.zzjdx.zzch), this.zzawi().zzjc(zza2.zzaof.get((int)n3).name));
                                if (this.zzawj().zzkg(zza2.zzjdx.zzch) || this.zzawj().zzkh(zza2.zzjdx.zzch) || "_err".equals(zza2.zzaof.get((int)n3).name)) continue;
                                this.zzawj().zza(zza2.zzjdx.zzch, 11, "_ev", zza2.zzaof.get((int)n3).name, 0);
                                continue;
                            }
                            n2 = this.zzawk().zzao(zza2.zzjdx.zzch, zza2.zzaof.get((int)n3).name);
                            if (n2 != 0) break block86;
                            this.zzawj();
                            if (!zzckn.zzki(zza2.zzaof.get((int)n3).name)) break block87;
                        }
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (zza2.zzaof.get((int)n3).zzjiw == null) {
                            zza2.zzaof.get((int)n3).zzjiw = new zzckz[0];
                        }
                        zzckz[] n7 = zza2.zzaof.get((int)n3).zzjiw;
                        zzcky3 = zza2.zzaof.get((int)n3).zzjiw.length;
                        for (n = 0; n < zzcky3; ++n) {
                            n8 = n7[n];
                            if ("_c".equals(n8.name)) {
                                n8.zzjja = 1L;
                                bl3 = true;
                                continue;
                            }
                            if (!"_r".equals(n8.name)) continue;
                            n8.zzjja = 1L;
                            bl4 = true;
                        }
                        if (!bl3 && n2 != 0) {
                            this.zzawn().zzayy().zzj("Marking event as conversion", this.zzawi().zzjc(zza2.zzaof.get((int)n3).name));
                            zzckz[] zzckzArray2 = Arrays.copyOf(zza2.zzaof.get((int)n3).zzjiw, zza2.zzaof.get((int)n3).zzjiw.length + 1);
                            zzckz zzckz2 = new zzckz();
                            new zzckz().name = "_c";
                            zzckz2.zzjja = 1L;
                            zzckzArray2[zzckzArray2.length - 1] = zzckz2;
                            zza2.zzaof.get((int)n3).zzjiw = zzckzArray2;
                        }
                        if (!bl4) {
                            this.zzawn().zzayy().zzj("Marking event as real-time", this.zzawi().zzjc(zza2.zzaof.get((int)n3).name));
                            zzckz[] zzckzArray3 = Arrays.copyOf(zza2.zzaof.get((int)n3).zzjiw, zza2.zzaof.get((int)n3).zzjiw.length + 1);
                            zzckz zzckz3 = new zzckz();
                            new zzckz().name = "_r";
                            zzckz3.zzjja = 1L;
                            zzckzArray3[zzckzArray3.length - 1] = zzckz3;
                            zza2.zzaof.get((int)n3).zzjiw = zzckzArray3;
                        }
                        bl = true;
                        if (this.zzawh().zza((long)this.zzazv(), (String)zza2.zzjdx.zzch, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zziwq > (long)this.zzjcl.zzis(zza2.zzjdx.zzch)) {
                            zzcky zzcky2 = zza2.zzaof.get(n3);
                            for (n = 0; n < zzcky2.zzjiw.length; ++n) {
                                if (!"_r".equals(zzcky2.zzjiw[n].name)) continue;
                                n8 = new zzckz[zzcky2.zzjiw.length - 1];
                                if (n > 0) {
                                    System.arraycopy(zzcky2.zzjiw, 0, n8, 0, n);
                                }
                                if (n < n8.length) {
                                    System.arraycopy(zzcky2.zzjiw, n + 1, n8, n, n8.length - n);
                                }
                                zzcky2.zzjiw = n8;
                                break;
                            }
                            bl = bl2;
                        }
                        if (zzckn.zzju(zza2.zzaof.get((int)n3).name) && n2 != 0 && this.zzawh().zza((long)this.zzazv(), (String)zza2.zzjdx.zzch, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zziwo > (long)this.zzjcl.zzb(string2 = zza2.zzjdx.zzch, zzcfz.zziyf)) {
                            this.zzawn().zzayu().zzj("Too many conversions. Not logging as conversion. appId", zzcgj.zzjf(zza2.zzjdx.zzch));
                            zzcky zzcky4 = zza2.zzaof.get(n3);
                            boolean bl5 = false;
                            object = null;
                            zzckzArray = zzcky4.zzjiw;
                            int n5 = zzcky4.zzjiw.length;
                            for (int i = 0; i < n5; ++i) {
                                zzckz zzckz4 = zzckzArray[i];
                                if ("_c".equals(zzckz4.name)) {
                                    object = zzckz4;
                                    continue;
                                }
                                if (!"_err".equals(zzckz4.name)) continue;
                                bl5 = true;
                            }
                            if (bl5 && object != null) {
                                zzcky4.zzjiw = (zzckz[])com.google.android.gms.common.util.zza.zza((Object[])zzcky4.zzjiw, (Object[])new zzckz[]{object});
                            } else if (object != null) {
                                ((zzckz)((Object)object)).name = "_err";
                                ((zzckz)((Object)object)).zzjja = 10L;
                            } else {
                                this.zzawn().zzays().zzj("Did not find conversion parameter. appId", zzcgj.zzjf(zza2.zzjdx.zzch));
                            }
                        }
                    }
                    zzclb3.zzjje[n4++] = zza2.zzaof.get(n3);
                }
                if (n4 < zza2.zzaof.size()) {
                    zzclb3.zzjje = Arrays.copyOf(zzclb3.zzjje, n4);
                }
                zzclb3.zzjjx = this.zza(zza2.zzjdx.zzch, zza2.zzjdx.zzjjf, zzclb3.zzjje);
                if (zzcfz.zzixr.get().booleanValue()) {
                    string2 = zza2.zzjdx.zzch;
                    object2 = this.zzjcl;
                    if ("1".equals(((zzcih)object2).zzawk().zzam(string2, "measurement.event_sampling_enabled"))) {
                        HashMap<String, zzcft> hashMap = new HashMap<String, zzcft>();
                        zzcky[] zzckyArray = new zzcky[zzclb3.zzjje.length];
                        n2 = 0;
                        SecureRandom secureRandom = this.zzawj().zzbao();
                        zzcky[] zzckyArray2 = zzclb3.zzjje;
                        int n = zzclb3.zzjje.length;
                        for (zzcky3 = 0; zzcky3 < n; ++zzcky3) {
                            zzcky zzcky5 = zzckyArray2[zzcky3];
                            if (zzcky5.name.equals("_ep")) {
                                this.zzawj();
                                String string3 = (String)zzckn.zza(zzcky5, "_en");
                                object = (zzcft)hashMap.get(string3);
                                if (object == null) {
                                    object = this.zzawh().zzae(zza2.zzjdx.zzch, string3);
                                    hashMap.put(string3, (zzcft)object);
                                }
                                if (object.zzixd != null) continue;
                                if (object.zzixe > 1L) {
                                    this.zzawj();
                                    zzcky5.zzjiw = zzckn.zza(zzcky5.zzjiw, "_sr", object.zzixe);
                                }
                                if (object.zzixf != null && object.zzixf.booleanValue()) {
                                    this.zzawj();
                                    zzcky5.zzjiw = zzckn.zza(zzcky5.zzjiw, "_efs", 1L);
                                }
                                zzckyArray[n2++] = zzcky5;
                                continue;
                            }
                            int n6 = 1;
                            if (!zzchj.zza(zzcky5, "_dbg", 1L)) {
                                n6 = this.zzawk().zzap(zza2.zzjdx.zzch, zzcky5.name);
                            }
                            if (n6 <= 0) {
                                this.zzawn().zzayu().zze("Sample rate must be positive. event, rate", zzcky5.name, n6);
                                zzckyArray[n2++] = zzcky5;
                                continue;
                            }
                            object = (zzcft)hashMap.get(zzcky5.name);
                            if (object == null && (object = this.zzawh().zzae(zza2.zzjdx.zzch, zzcky5.name)) == null) {
                                this.zzawn().zzayu().zze("Event being bundled has no eventAggregate. appId, eventName", zza2.zzjdx.zzch, zzcky5.name);
                                object = new zzcft(zza2.zzjdx.zzch, zzcky5.name, 1L, 1L, zzcky5.zzjix, 0L, null, null, null);
                            }
                            this.zzawj();
                            zzckzArray = (zzckz[])zzckn.zza(zzcky5, "_eid");
                            Boolean bl6 = zzckzArray != null;
                            if (n6 == 1) {
                                zzckyArray[n2++] = zzcky5;
                                if (!bl6.booleanValue() || object.zzixd == null && object.zzixe == null && object.zzixf == null) continue;
                                object = object.zza(null, null, null);
                                hashMap.put(zzcky5.name, (zzcft)object);
                                continue;
                            }
                            if (secureRandom.nextInt(n6) == 0) {
                                this.zzawj();
                                zzcky5.zzjiw = zzckn.zza(zzcky5.zzjiw, "_sr", n6);
                                zzckyArray[n2++] = zzcky5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), null);
                                }
                                hashMap.put(zzcky5.name, object.zzbb(zzcky5.zzjix));
                                continue;
                            }
                            long l2 = object.zzixc;
                            if (Math.abs(zzcky5.zzjix - l2) >= 86400000L) {
                                this.zzawj();
                                zzcky5.zzjiw = zzckn.zza(zzcky5.zzjiw, "_efs", 1L);
                                this.zzawj();
                                zzcky5.zzjiw = zzckn.zza(zzcky5.zzjiw, "_sr", n6);
                                zzckyArray[n2++] = zzcky5;
                                if (bl6.booleanValue()) {
                                    object = object.zza(null, Long.valueOf(n6), true);
                                }
                                hashMap.put(zzcky5.name, object.zzbb(zzcky5.zzjix));
                                continue;
                            }
                            if (!bl6.booleanValue()) continue;
                            hashMap.put(zzcky5.name, object.zza((Long)zzckzArray, null, null));
                        }
                        if (n2 < zzclb3.zzjje.length) {
                            zzclb3.zzjje = Arrays.copyOf(zzckyArray, n2);
                        }
                        for (Map.Entry entry : hashMap.entrySet()) {
                            this.zzawh().zza((zzcft)entry.getValue());
                        }
                    }
                }
                zzclb3.zzjjh = Long.MAX_VALUE;
                zzclb3.zzjji = Long.MIN_VALUE;
                for (n3 = 0; n3 < zzclb3.zzjje.length; ++n3) {
                    zzcky zzcky6 = zzclb3.zzjje[n3];
                    if (zzcky6.zzjix < zzclb3.zzjjh) {
                        zzclb3.zzjjh = zzcky6.zzjix;
                    }
                    if (zzcky6.zzjix <= zzclb3.zzjji) continue;
                    zzclb3.zzjji = zzcky6.zzjix;
                }
                String string7 = zza2.zzjdx.zzch;
                zzcfe zzcfe2 = this.zzawh().zziw(string7);
                if (zzcfe2 == null) {
                    this.zzawn().zzays().zzj("Bundling raw events w/o app info. appId", zzcgj.zzjf(zza2.zzjdx.zzch));
                } else if (zzclb3.zzjje.length > 0) {
                    long l6 = zzcfe2.zzawu();
                    zzclb3.zzjjk = l6 != 0L ? Long.valueOf(l6) : null;
                    long l7 = zzcfe2.zzawt();
                    if (l7 == 0L) {
                        l7 = l6;
                    }
                    zzclb3.zzjjj = l7 != 0L ? Long.valueOf(l7) : null;
                    zzcfe2.zzaxd();
                    zzclb3.zzjjv = (int)zzcfe2.zzaxa();
                    zzcfe2.zzak(zzclb3.zzjjh);
                    zzcfe2.zzal(zzclb3.zzjji);
                    zzclb3.zzivl = zzcfe2.zzaxl();
                    this.zzawh().zza(zzcfe2);
                }
                if (zzclb3.zzjje.length > 0) {
                    zzckv zzckv2 = this.zzawk().zzjn(zza2.zzjdx.zzch);
                    if (zzckv2 == null || zzckv2.zzjil == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzjdx.zzivh)) {
                            zzclb3.zzjkc = -1L;
                        } else {
                            this.zzawn().zzayu().zzj("Did not find measurement config or missing version info. appId", zzcgj.zzjf(zza2.zzjdx.zzch));
                        }
                    } else {
                        zzclb3.zzjkc = zzckv2.zzjil;
                    }
                    this.zzawh().zza(zzclb3, bl);
                }
                this.zzawh().zzag(zza2.zzjdy);
                string2 = string7;
                object2 = this.zzawh();
                SQLiteDatabase sQLiteDatabase = ((zzcfl)object2).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcih)object2).zzawn().zzays().zze("Failed to remove unused event metadata. appId", zzcgj.zzjf(string2), (Object)sQLiteException);
                }
                this.zzawh().setTransactionSuccessful();
                return true;
            }
            this.zzawh().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    private final zzckx[] zza(String string, zzcld[] zzcldArray, zzcky[] zzckyArray) {
        zzbq.zzgi((String)string);
        return this.zzawa().zza(string, zzckyArray, zzcldArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        zzbq.zzgi((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzawn().zzayy().zzj("onConfigFetched. Response size", byArray.length);
            this.zzawh().beginTransaction();
            try {
                boolean bl;
                zzcfe zzcfe2 = this.zzawh().zziw(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcfe2 == null) {
                    this.zzawn().zzayu().zzj("App does not exist in onConfigFetched. appId", zzcgj.zzjf(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzawk().zzjn(string) == null && !this.zzawk().zzb(string, null, null) : !this.zzawk().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcfe2.zzaq(this.zzasd.currentTimeMillis());
                    this.zzawh().zza(zzcfe2);
                    if (n == 404) {
                        this.zzawn().zzayv().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzawn().zzayy().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzazq().zzzh() && this.zzazx()) {
                        this.zzazw();
                    } else {
                        this.zzazy();
                    }
                } else {
                    zzcfe2.zzar(this.zzasd.currentTimeMillis());
                    this.zzawh().zza(zzcfe2);
                    this.zzawn().zzayy().zze("Fetching config failed. code, error", n, throwable);
                    this.zzawk().zzjp(string);
                    this.zzawo().zzjah.set(this.zzasd.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzawo().zzjai.set(this.zzasd.currentTimeMillis());
                    }
                    this.zzazy();
                }
                this.zzawh().setTransactionSuccessful();
            }
            finally {
                this.zzawh().endTransaction();
            }
            return;
        }
        finally {
            this.zzjds = false;
            this.zzbac();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzjdm;
            this.zzjdm = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzawo().zzjag.set(this.zzasd.currentTimeMillis());
                    this.zzawo().zzjah.set(0L);
                    this.zzazy();
                    this.zzawn().zzayy().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzawh().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcfl zzcfl2 = this.zzawh();
                            zzcfl2.zzut();
                            zzcfl2.zzwu();
                            SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcfl2.zzawn().zzays().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzawh().setTransactionSuccessful();
                    }
                    finally {
                        this.zzawh().endTransaction();
                    }
                    if (this.zzazq().zzzh() && this.zzazx()) {
                        this.zzazw();
                    } else {
                        this.zzjdq = -1L;
                        this.zzazy();
                    }
                    this.zzjdr = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzawn().zzays().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzjdr = this.zzasd.elapsedRealtime();
                    this.zzawn().zzayy().zzj("Disable upload, time", this.zzjdr);
                }
            } else {
                this.zzawn().zzayy().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzawo().zzjah.set(this.zzasd.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzawo().zzjai.set(this.zzasd.currentTimeMillis());
                }
                this.zzazy();
            }
            return;
        }
        finally {
            this.zzjdt = false;
            this.zzbac();
        }
    }

    private final boolean zzazx() {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        return this.zzawh().zzaxz() || !TextUtils.isEmpty((CharSequence)this.zzawh().zzaxu());
    }

    @WorkerThread
    private final void zzazy() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcih)this.zzawm()).zzut();
            this.zzwu();
            if (!this.zzbab()) {
                return;
            }
            if (this.zzjdr > 0L) {
                l3 = this.zzasd.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzjdr);
                if (l2 > 0L) {
                    this.zzawn().zzayy().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzazr().unregister();
                    this.zzazs().cancel();
                    return;
                }
                this.zzjdr = 0L;
            }
            if (!this.zzazk() || !this.zzazx()) {
                this.zzawn().zzayy().log("Nothing to upload or uploading impossible");
                this.zzazr().unregister();
                this.zzazs().cancel();
                return;
            }
            zzchj zzchj2 = this;
            long l4 = zzchj2.zzasd.currentTimeMillis();
            long l5 = Math.max(0L, zzcfz.zziys.get());
            boolean bl = zzchj2.zzawh().zzaya() || zzchj2.zzawh().zzaxv();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzchj2.zzjcl.zzaxs())) && !".none.".equals(string) ? Math.max(0L, zzcfz.zziyn.get()) : Math.max(0L, zzcfz.zziym.get())) : Math.max(0L, zzcfz.zziyl.get());
            long l7 = zzchj2.zzawo().zzjag.get();
            long l8 = zzchj2.zzawo().zzjah.get();
            long l9 = zzchj2.zzawh().zzaxx();
            long l10 = zzchj2.zzawh().zzaxy();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzchj2.zzawj().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < Math.min(20, Math.max(0, zzcfz.zziyu.get())); ++i) {
                        long l15 = 1L << i;
                        if ((l14 += Math.max(0L, zzcfz.zziyt.get()) * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzawn().zzayy().log("Next upload time is 0");
            this.zzazr().unregister();
            this.zzazs().cancel();
            return;
        }
        if (!this.zzazq().zzzh()) {
            this.zzawn().zzayy().log("No network");
            this.zzazr().zzze();
            this.zzazs().cancel();
            return;
        }
        l2 = this.zzawo().zzjai.get();
        long l16 = Math.max(0L, zzcfz.zziyj.get());
        if (!this.zzawj().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzazr().unregister();
        long l17 = l3 - this.zzasd.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = Math.max(0L, zzcfz.zziyo.get());
            this.zzawo().zzjag.set(this.zzasd.currentTimeMillis());
        }
        this.zzawn().zzayy().zzj("Upload scheduled in approximately ms", l17);
        this.zzazs().zzr(l17);
    }

    public final void zzbn(boolean bl) {
        this.zzazy();
    }

    final void zzb(zzcii zzcii2) {
        ++this.zzjdo;
    }

    final void zzazz() {
        ++this.zzjdp;
    }

    @WorkerThread
    public final void zzf(zzcff zzcff2) {
        int n;
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgi((String)zzcff2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            return;
        }
        zzcfe zzcfe2 = this.zzawh().zziw(zzcff2.packageName);
        if (zzcfe2 != null && TextUtils.isEmpty((CharSequence)zzcfe2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcff2.zzivh)) {
            zzcfe2.zzaq(0L);
            this.zzawh().zza(zzcfe2);
            this.zzawk().zzjq(zzcff2.packageName);
        }
        if (!zzcff2.zzivm) {
            this.zzg(zzcff2);
            return;
        }
        long l = zzcff2.zzivr;
        if (l == 0L) {
            l = this.zzasd.currentTimeMillis();
        }
        if ((n = zzcff2.zzivs) != 0 && n != 1) {
            this.zzawn().zzayu().zze("Incorrect app type, assuming installed app. appId, appType", zzcgj.zzjf(zzcff2.packageName), n);
            n = 0;
        }
        this.zzawh().beginTransaction();
        try {
            zzcfx zzcfx2;
            Object object;
            long l2 = l;
            zzcff zzcff3 = zzcff2;
            zzchj zzchj2 = this;
            zzcfe zzcfe3 = zzchj2.zzawh().zziw(zzcff3.packageName);
            if (zzcfe3 != null && zzcfe3.getGmpAppId() != null && !zzcfe3.getGmpAppId().equals(zzcff3.zzivh)) {
                zzchj2.zzawn().zzayu().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcgj.zzjf(zzcfe3.getAppId()));
                String string = zzcfe3.getAppId();
                zzcfl zzcfl2 = zzchj2.zzawh();
                zzcfl2.zzwu();
                zzcfl2.zzut();
                zzbq.zzgi((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcfl2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcfl2.zzawn().zzayy().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcfl2.zzawn().zzays().zze("Error deleting application data. appId, error", zzcgj.zzjf(string), (Object)sQLiteException);
                }
                zzcfe3 = null;
            }
            if (zzcfe3 != null && zzcfe3.zzuy() != null && !zzcfe3.zzuy().equals(zzcff3.zzida)) {
                object = new Bundle();
                object.putString("_pv", zzcfe3.zzuy());
                zzcfx2 = new zzcfx("_au", new zzcfu((Bundle)object), "auto", l2);
                zzchj2.zzb(zzcfx2, zzcff3);
            }
            this.zzg(zzcff2);
            zzcft zzcft2 = null;
            if (n == 0) {
                zzcft2 = this.zzawh().zzae(zzcff2.packageName, "_f");
            } else if (n == 1) {
                zzcft2 = this.zzawh().zzae(zzcff2.packageName, "_v");
            }
            if (zzcft2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbej zzbej2;
                    zzckk zzckk2 = new zzckk("_fot", l, l3, "auto");
                    this.zzb(zzckk2, zzcff2);
                    l2 = l;
                    zzcff3 = zzcff2;
                    zzchj2 = this;
                    ((zzcih)zzchj2.zzawm()).zzut();
                    zzchj2.zzwu();
                    zzcfe3 = new Bundle();
                    zzcfe3.putLong("_c", 1L);
                    zzcfe3.putLong("_r", 1L);
                    zzcfe3.putLong("_uwa", 0L);
                    zzcfe3.putLong("_pfo", 0L);
                    zzcfe3.putLong("_sys", 0L);
                    zzcfe3.putLong("_sysu", 0L);
                    if (zzchj2.mContext.getPackageManager() == null) {
                        zzchj2.zzawn().zzays().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcgj.zzjf(zzcff3.packageName));
                    } else {
                        zzcfx2 = null;
                        try {
                            zzcfx2 = zzbgc.zzcy((Context)zzchj2.mContext).getPackageInfo(zzcff3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchj2.zzawn().zzays().zze("Package info is null, first open report might be inaccurate. appId", zzcgj.zzjf(zzcff3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcfx2 != null && ((PackageInfo)zzcfx2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcfx2).firstInstallTime != ((PackageInfo)zzcfx2).lastUpdateTime) {
                                zzcfe3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbej2 = new zzckk("_fi", l2, bl ? 1L : 0L, "auto");
                            zzchj2.zzb((zzckk)zzbej2, zzcff3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbgc.zzcy((Context)zzchj2.mContext).getApplicationInfo(zzcff3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzchj2.zzawn().zzays().zze("Application info is null, first open report might be inaccurate. appId", zzcgj.zzjf(zzcff3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcfe3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcfe3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcff3.packageName;
                    zzcfl zzcfl3 = zzchj2.zzawh();
                    zzbq.zzgi((String)string);
                    zzcfl3.zzut();
                    zzcfl3.zzwu();
                    long l4 = zzcfl3.zzal(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcfe3.putLong("_pfo", l4);
                    }
                    zzbej2 = new zzcfx("_f", new zzcfu((Bundle)zzcfe3), "auto", l2);
                    zzchj2.zzb((zzcfx)zzbej2, zzcff3);
                } else if (n == 1) {
                    zzckk zzckk3 = new zzckk("_fvt", l, l3, "auto");
                    this.zzb(zzckk3, zzcff2);
                    l2 = l;
                    zzcff3 = zzcff2;
                    zzchj2 = this;
                    ((zzcih)zzchj2.zzawm()).zzut();
                    zzchj2.zzwu();
                    zzcfe3 = new Bundle();
                    zzcfe3.putLong("_c", 1L);
                    zzcfe3.putLong("_r", 1L);
                    object = new zzcfx("_v", new zzcfu((Bundle)zzcfe3), "auto", l2);
                    zzchj2.zzb((zzcfx)((Object)object), zzcff3);
                }
                l2 = l;
                zzcff3 = zzcff2;
                zzchj2 = this;
                zzcfe3 = new Bundle();
                zzcfe3.putLong("_et", 1L);
                object = new zzcfx("_e", new zzcfu((Bundle)zzcfe3), "auto", l2);
                zzchj2.zzb((zzcfx)((Object)object), zzcff3);
            } else if (zzcff2.zzivn) {
                l2 = l;
                zzcff3 = zzcff2;
                zzchj2 = this;
                zzcfe3 = new Bundle();
                object = new zzcfx("_cd", new zzcfu((Bundle)zzcfe3), "auto", l2);
                zzchj2.zzb((zzcfx)((Object)object), zzcff3);
            }
            this.zzawh().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzawh().endTransaction();
        }
    }

    @WorkerThread
    private final void zzg(zzcff zzcff2) {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)((Object)zzcff2));
        zzbq.zzgi((String)zzcff2.packageName);
        zzcfe zzcfe2 = this.zzawh().zziw(zzcff2.packageName);
        String string = this.zzawo().zzji(zzcff2.packageName);
        boolean bl = false;
        if (zzcfe2 == null) {
            zzcfe2 = new zzcfe(this, zzcff2.packageName);
            zzcfe2.zzim(this.zzawc().zzayo());
            zzcfe2.zzio(string);
            bl = true;
        } else if (!string.equals(zzcfe2.zzawr())) {
            zzcfe2.zzio(string);
            zzcfe2.zzim(this.zzawc().zzayo());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzivh) && !zzcff2.zzivh.equals(zzcfe2.getGmpAppId())) {
            zzcfe2.zzin(zzcff2.zzivh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzivp) && !zzcff2.zzivp.equals(zzcfe2.zzaws())) {
            zzcfe2.zzip(zzcff2.zzivp);
            bl = true;
        }
        if (zzcff2.zzivj != 0L && zzcff2.zzivj != zzcfe2.zzawx()) {
            zzcfe2.zzan(zzcff2.zzivj);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzida) && !zzcff2.zzida.equals(zzcfe2.zzuy())) {
            zzcfe2.setAppVersion(zzcff2.zzida);
            bl = true;
        }
        if (zzcff2.zzivo != zzcfe2.zzawv()) {
            zzcfe2.zzam(zzcff2.zzivo);
            bl = true;
        }
        if (zzcff2.zzivi != null && !zzcff2.zzivi.equals(zzcfe2.zzaww())) {
            zzcfe2.zziq(zzcff2.zzivi);
            bl = true;
        }
        if (zzcff2.zzivk != zzcfe2.zzawy()) {
            zzcfe2.zzao(zzcff2.zzivk);
            bl = true;
        }
        if (zzcff2.zzivm != zzcfe2.zzawz()) {
            zzcfe2.setMeasurementEnabled(zzcff2.zzivm);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcff2.zzivl) && !zzcff2.zzivl.equals(zzcfe2.zzaxk())) {
            zzcfe2.zzir(zzcff2.zzivl);
            bl = true;
        }
        if (zzcff2.zzivq != zzcfe2.zzaxm()) {
            zzcfe2.zzay(zzcff2.zzivq);
            bl = true;
        }
        if (zzcff2.zzivt != zzcfe2.zzaxn()) {
            zzcfe2.zzbk(zzcff2.zzivt);
            bl = true;
        }
        if (bl) {
            this.zzawh().zza(zzcfe2);
        }
    }

    @WorkerThread
    final void zzbaa() {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        if (!this.zzjdh) {
            this.zzawn().zzayw().log("This instance being marked as an uploader");
            zzchj zzchj2 = this;
            ((zzcih)zzchj2.zzawm()).zzut();
            zzchj2.zzwu();
            if (zzchj2.zzbab() && zzchj2.zzazt()) {
                int n;
                int n2 = zzchj2.zza(zzchj2.zzjdl);
                int n3 = n = zzchj2.zzawc().zzayp();
                int n4 = n2;
                zzchj zzchj3 = zzchj2;
                ((zzcih)zzchj3.zzawm()).zzut();
                if (n4 > n3) {
                    zzchj3.zzawn().zzays().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzchj3.zza(n3, zzchj3.zzjdl)) {
                        zzchj3.zzawn().zzayy().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzchj3.zzawn().zzays().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzjdh = true;
            this.zzazy();
        }
    }

    @WorkerThread
    private final boolean zzbab() {
        ((zzcih)this.zzawm()).zzut();
        this.zzwu();
        return this.zzjdh;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcih)this.zzawm()).zzut();
        if (this.zzjdn == null) {
            this.zzjdn = new ArrayList<Runnable>();
        }
        this.zzjdn.add(runnable);
    }

    @WorkerThread
    private final void zzbac() {
        ((zzcih)this.zzawm()).zzut();
        if (this.zzjds || this.zzjdt || this.zzjdu) {
            this.zzawn().zzayy().zzd("Not stopping services. fetch, network, upload", this.zzjds, this.zzjdt, this.zzjdu);
            return;
        }
        this.zzawn().zzayy().log("Stopping uploading service(s)");
        if (this.zzjdn == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzjdn.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzjdn.clear();
    }

    static /* synthetic */ void zza(zzchj zzchj2) {
        zzchj2.zzazl();
    }

    final class zza
    implements zzcfn {
        zzclb zzjdx;
        List<Long> zzjdy;
        List<zzcky> zzaof;
        private long zzjdz;
        private /* synthetic */ zzchj zzjdw;

        private zza(zzchj zzchj2) {
            this.zzjdw = zzchj2;
        }

        @Override
        public final void zzb(zzclb zzclb2) {
            zzbq.checkNotNull((Object)((Object)zzclb2));
            this.zzjdx = zzclb2;
        }

        @Override
        public final boolean zza(long l, zzcky zzcky2) {
            zzbq.checkNotNull((Object)((Object)zzcky2));
            if (this.zzaof == null) {
                this.zzaof = new ArrayList<zzcky>();
            }
            if (this.zzjdy == null) {
                this.zzjdy = new ArrayList<Long>();
            }
            if (this.zzaof.size() > 0 && zza.zza(this.zzaof.get(0)) != zza.zza(zzcky2)) {
                return false;
            }
            long l2 = this.zzjdz + (long)zzcky2.zzhl();
            if (l2 >= (long)Math.max(0, zzcfz.zziya.get())) {
                return false;
            }
            this.zzjdz = l2;
            this.zzaof.add(zzcky2);
            this.zzjdy.add(l);
            return this.zzaof.size() < Math.max(1, zzcfz.zziyb.get());
        }

        private static long zza(zzcky zzcky2) {
            return zzcky2.zzjix / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzchj zzchj2, zzchk zzchk2) {
            this(zzchj2);
        }
    }
}

