/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzciq;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzciv;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciy;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjc;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcik
extends zzcii {
    protected zzciy zzjem;
    private AppMeasurement.EventInterceptor zzjen;
    private final Set<AppMeasurement.OnEventListener> zzjeo = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzjep;
    private final AtomicReference<String> zzjeq = new AtomicReference();

    protected zzcik(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxo() {
        return false;
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzwu();
        ((zzcih)this).zzawm().zzg(new zzcil(this, bl));
    }

    @WorkerThread
    private final void zzbo(boolean bl) {
        ((zzcih)this).zzut();
        this.zzwu();
        ((zzcih)this).zzawn().zzayx().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcih)this).zzawo().setMeasurementEnabled(bl);
        ((zzcih)this).zzawe().zzbaf();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcih)this).zzawm().zzg(new zzciq(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcih)this).zzawm().zzg(new zzcir(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzjen == null || zzckn.zzkd(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        boolean bl = this.zzjen == null || zzckn.zzkd(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcih)this).zzwh().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcih)this).zzawm().zzg(new zzcis(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcjc zzcjc2;
        Bundle bundle2;
        Object object;
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        zzbq.checkNotNull((Object)bundle);
        ((zzcih)this).zzut();
        this.zzwu();
        if (!this.zzitu.isEnabled()) {
            ((zzcih)this).zzawn().zzayx().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzjep) {
            this.zzjep = true;
            zzcik zzcik2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcik zzcik3 = zzcik2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcih)zzcik3).getContext());
                }
                catch (Exception exception) {
                    ((zzcih)zzcik3).zzawn().zzayu().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcih)zzcik2).zzawn().zzayw().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzckn.zzkd(string2);
        if (bl && this.zzjen != null && !bl5 && !bl4) {
            ((zzcih)this).zzawn().zzayx().zze("Passing event to registered event handler (FE)", ((zzcih)this).zzawi().zzjc(string2), ((zzcih)this).zzawi().zzx(bundle));
            this.zzjen.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzitu.zzazk()) {
            return;
        }
        int n = ((zzcih)this).zzawj().zzjw(string2);
        if (n != 0) {
            ((zzcih)this).zzawj();
            String string4 = zzckn.zza(string2, 40, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzitu.zzawj().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcih)this).zzawj().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcih)this).zzawj().zzbao().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcih)this).zzawj();
            bundle2 = zzckn.zzae(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcih)this).zzawj().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        if ((zzcjc2 = ((zzcih)this).zzawf().zzbad()) != null && !bundle3.containsKey("_sc")) {
            zzcjc2.zzjfq = true;
        }
        object2 = zzcjc2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzciz.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcih)this).zzawj().zzy(bundle5) : bundle5;
            ((zzcih)this).zzawn().zzayx().zze("Logging event (FE)", ((zzcih)this).zzawi().zzjc(string2), ((zzcih)this).zzawi().zzx(bundle2));
            zzcfx zzcfx2 = new zzcfx((String)object, new zzcfu(bundle2), string, l);
            ((zzcih)this).zzawe().zzc(zzcfx2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzjeo) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        if (((zzcih)this).zzawf().zzbad() != null && "_ae".equals(string2)) {
            ((zzcih)this).zzawl().zzbr(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbq.zzgi((String)string);
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        int n = ((zzcih)this).zzawj().zzjy(string2);
        if (n != 0) {
            ((zzcih)this).zzawj();
            String string3 = zzckn.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzitu.zzawj().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcih)this).zzawj().zzl(string2, object);
            if (n != 0) {
                ((zzcih)this).zzawj();
                String string4 = zzckn.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zzitu.zzawj().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcih)this).zzawj().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcih)this).zzawm().zzg(new zzcit(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbq.zzgi((String)string);
        zzbq.zzgi((String)string2);
        ((zzcih)this).zzut();
        this.zzwu();
        if (!this.zzitu.isEnabled()) {
            ((zzcih)this).zzawn().zzayx().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzitu.zzazk()) {
            return;
        }
        ((zzcih)this).zzawn().zzayx().zze("Setting user property (FE)", ((zzcih)this).zzawi().zzjc(string2), object);
        zzckk zzckk2 = new zzckk(string2, l, object, string);
        ((zzcih)this).zzawe().zzb(zzckk2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzckk> zzbp(boolean bl) {
        this.zzwu();
        ((zzcih)this).zzawn().zzayx().log("Fetching user attributes (FE)");
        if (((zzcih)this).zzawm().zzazh()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcih)this).zzawm();
        if (zzche.zzas()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitu.zzawm().zzg(new zzciu(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawn().zzayu().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawn().zzayu().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcih)this).zzawo().zzazc();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcih)this).zzawm().zzazi(), (Callable)new zzciv(this));
        }
        catch (Exception exception) {
            ((zzcih)this).zzawn().zzayu().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzazc() {
        return this.zzjeq.get();
    }

    final void zzjk(@Nullable String string) {
        this.zzjeq.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbc(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcih)this).zzawm().zzg(new zzciw(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawn().zzayu().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        ((zzcih)this).zzawm().zzg(new zzcix(this));
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcih)this).zzut();
        this.zzwu();
        if (eventInterceptor != null && eventInterceptor != this.zzjen) {
            zzbq.zza((this.zzjen == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzjen = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzwu();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjeo.add(onEventListener)) {
            ((zzcih)this).zzawn().zzayu().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzwu();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjeo.remove(onEventListener)) {
            ((zzcih)this).zzawn().zzayu().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcih)this).zzawn().zzayu().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgi((String)conditionalUserProperty.mAppId);
        ((zzcih)this).zzavx();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgi((String)conditionalUserProperty.mName);
        zzbq.zzgi((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcih)this).zzawj().zzjy(string) != 0) {
            ((zzcih)this).zzawn().zzays().zzj("Invalid conditional user property name", ((zzcih)this).zzawi().zzje(string));
            return;
        }
        if (((zzcih)this).zzawj().zzl(string, object) != 0) {
            ((zzcih)this).zzawn().zzays().zze("Invalid conditional user property value", ((zzcih)this).zzawi().zzje(string), object);
            return;
        }
        Object object2 = ((zzcih)this).zzawj().zzm(string, object);
        if (object2 == null) {
            ((zzcih)this).zzawn().zzays().zze("Unable to normalize conditional user property value", ((zzcih)this).zzawi().zzje(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzcih)this).zzawn().zzays().zze("Invalid conditional user property timeout", ((zzcih)this).zzawi().zzje(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzcih)this).zzawn().zzays().zze("Invalid conditional user property time to live", ((zzcih)this).zzawi().zzje(string), l3);
            return;
        }
        ((zzcih)this).zzawm().zzg(new zzcim(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbq.zzgi((String)string);
        ((zzcih)this).zzavx();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcih)this).zzwh().currentTimeMillis();
        zzbq.zzgi((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcih)this).zzawm().zzg(new zzcin(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcfx zzcfx2;
        zzcfx zzcfx3;
        zzcfx zzcfx4;
        ((zzcih)this).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgi((String)conditionalUserProperty.mName);
        zzbq.zzgi((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zzitu.isEnabled()) {
            ((zzcih)this).zzawn().zzayx().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzckk zzckk2 = new zzckk(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcfx4 = ((zzcih)this).zzawj().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcfx3 = ((zzcih)this).zzawj().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcfx2 = ((zzcih)this).zzawj().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfi zzcfi2 = new zzcfi(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzckk2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcfx3, conditionalUserProperty.mTriggerTimeout, zzcfx4, conditionalUserProperty.mTimeToLive, zzcfx2);
        ((zzcih)this).zzawe().zzf(zzcfi2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcfx zzcfx2;
        ((zzcih)this).zzut();
        this.zzwu();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgi((String)conditionalUserProperty.mName);
        if (!this.zzitu.isEnabled()) {
            ((zzcih)this).zzawn().zzayx().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzckk zzckk2 = new zzckk(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcfx2 = ((zzcih)this).zzawj().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcfi zzcfi2 = new zzcfi(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzckk2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcfx2);
        ((zzcih)this).zzawe().zzf(zzcfi2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbq.zzgi((String)string);
        ((zzcih)this).zzavx();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcih)this).zzawm().zzazh()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcih)this).zzawm();
        if (zzche.zzas()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitu.zzawm().zzg(new zzcio(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawn().zzayu().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawn().zzayu().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcfi zzcfi2 = (zzcfi)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcfi2.zzivw;
                conditionalUserProperty.mName = zzcfi2.zzivv.name;
                conditionalUserProperty.mValue = zzcfi2.zzivv.getValue();
                conditionalUserProperty.mActive = zzcfi2.zzivx;
                conditionalUserProperty.mTriggerEventName = zzcfi2.zzivy;
                if (zzcfi2.zzivz != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcfi2.zzivz.name;
                    if (zzcfi2.zzivz.zzixi != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcfi2.zzivz.zzixi.zzaym();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcfi2.zziwa;
                if (zzcfi2.zziwb != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcfi2.zziwb.name;
                    if (zzcfi2.zziwb.zzixi != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcfi2.zziwb.zzixi.zzaym();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcfi2.zzivv.zzjgx;
                conditionalUserProperty.mTimeToLive = zzcfi2.zziwc;
                if (zzcfi2.zziwd != null) {
                    conditionalUserProperty.mExpiredEventName = zzcfi2.zziwd.name;
                    if (zzcfi2.zziwd.zzixi != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcfi2.zziwd.zzixi.zzaym();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbq.zzgi((String)string);
        ((zzcih)this).zzavx();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcih)this).zzawm().zzazh()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcih)this).zzawm();
        if (zzche.zzas()) {
            ((zzcih)this).zzawn().zzays().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zzitu.zzawm().zzg(new zzcip(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcih)this).zzawn().zzayu().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcih)this).zzawn().zzayu().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzckk zzckk2 = (zzckk)((Object)iterator.next());
                arrayMap.put(zzckk2.name, zzckk2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcik zzcik2, boolean bl) {
        zzcik2.zzbo(bl);
    }

    static /* synthetic */ void zza(zzcik zzcik2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcik2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcik zzcik2, String string, String string2, Object object, long l) {
        zzcik2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcik zzcik2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcik2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcik zzcik2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcik2.zzc(conditionalUserProperty);
    }
}

