/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcho;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.internal.zzckn;

public final class zzcjx<T extends Context> {
    private final T zzdvw;

    public zzcjx(T t) {
        zzbq.checkNotNull(t);
        this.zzdvw = t;
    }

    public static boolean zzk(Context context, boolean bl) {
        zzbq.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzckn.zzt(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzckn.zzt(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public final void onCreate() {
        zzchj.zzdu(this.zzdvw).zzawm().zzayx().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public final void onDestroy() {
        zzchj.zzdu(this.zzdvw).zzawm().zzayx().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public final int onStartCommand(Intent intent, int n, int n2) {
        zzcgj zzcgj2 = zzchj.zzdu(this.zzdvw).zzawm();
        if (intent == null) {
            zzcgj2.zzayt().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzcgj2.zzayx().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzk(new zzcjy(this, n2, zzcgj2, intent));
        }
        return 2;
    }

    private final void zzk(Runnable runnable) {
        zzchj zzchj2 = zzchj.zzdu(this.zzdvw);
        zzchj2.zzawm();
        zzchj2.zzawl().zzg(new zzcka(this, zzchj2, runnable));
    }

    @MainThread
    public final IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzawm().zzayr().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzcho(zzchj.zzdu(this.zzdvw));
        }
        this.zzawm().zzayt().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public final boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzawm().zzayr().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzawm().zzayx().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    @TargetApi(value=24)
    public final boolean onStartJob(JobParameters jobParameters) {
        zzcgj zzcgj2 = zzchj.zzdu(this.zzdvw).zzawm();
        String string = jobParameters.getExtras().getString("action");
        zzcgj2.zzayx().zzj("Local AppMeasurementJobService called. action", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            this.zzk(new zzcjz(this, zzcgj2, jobParameters));
        }
        return true;
    }

    @MainThread
    public final void onRebind(Intent intent) {
        if (intent == null) {
            this.zzawm().zzayr().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzawm().zzayx().zzj("onRebind called. action", string);
    }

    private final zzcgj zzawm() {
        return zzchj.zzdu(this.zzdvw).zzawm();
    }

    final /* synthetic */ void zza(zzcgj zzcgj2, JobParameters jobParameters) {
        zzcgj2.zzayx().log("AppMeasurementJobService processed last upload request.");
        ((zzckb)this.zzdvw).zza(jobParameters, false);
    }

    final /* synthetic */ void zza(int n, zzcgj zzcgj2, Intent intent) {
        if (((zzckb)this.zzdvw).callServiceStopSelfResult(n)) {
            zzcgj2.zzayx().zzj("Local AppMeasurementService processed last upload request. StartId", n);
            this.zzawm().zzayx().log("Completed wakeful intent.");
            ((zzckb)this.zzdvw).zzm(intent);
        }
    }
}

