/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzckf;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public final class zzcgd
extends zzcjk {
    private final Map<String, Long> zziwr;
    private final Map<String, Integer> zziws = new ArrayMap();
    private long zziwt;

    public zzcgd(zzcim zzcim2) {
        super(zzcim2);
        this.zziwr = new ArrayMap();
    }

    public final void beginAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcjk)this).zzawy().zzazd().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcjk)this).zzws().elapsedRealtime();
        ((zzcjk)this).zzawx().zzg(new zzcge(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        Integer n;
        ((zzcjk)this).zzve();
        zzbq.zzgm((String)string);
        if (this.zziws.isEmpty()) {
            this.zziwt = l;
        }
        if ((n = this.zziws.get(string)) != null) {
            this.zziws.put(string, n + 1);
            return;
        }
        if (this.zziws.size() >= 100) {
            ((zzcjk)this).zzawy().zzazf().log("Too many ads visible");
            return;
        }
        this.zziws.put(string, 1);
        this.zziwr.put(string, l);
    }

    public final void endAdUnitExposure(String string) {
        if (string == null || string.length() == 0) {
            ((zzcjk)this).zzawy().zzazd().log("Ad unit id must be a non-empty string");
            return;
        }
        long l = ((zzcjk)this).zzws().elapsedRealtime();
        ((zzcjk)this).zzawx().zzg(new zzcgf(this, string, l));
    }

    @WorkerThread
    private final void zze(String string, long l) {
        ((zzcjk)this).zzve();
        zzbq.zzgm((String)string);
        Integer n = this.zziws.get(string);
        if (n != null) {
            zzckf zzckf2 = ((zzcjk)this).zzawq().zzbao();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zziws.remove(string);
                Long l2 = this.zziwr.get(string);
                if (l2 == null) {
                    ((zzcjk)this).zzawy().zzazd().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zziwr.remove(string);
                    this.zza(string, l3, zzckf2);
                }
                if (this.zziws.isEmpty()) {
                    if (this.zziwt == 0L) {
                        ((zzcjk)this).zzawy().zzazd().log("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zziwt, zzckf2);
                    this.zziwt = 0L;
                }
                return;
            }
            this.zziws.put(string, n2);
            return;
        }
        ((zzcjk)this).zzawy().zzazd().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcjk)this).zzawy().zzazj().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcjk)this).zzawy().zzazj().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzckc.zza(zzb2, bundle);
        ((zzcjk)this).zzawm().zzc("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, AppMeasurement.zzb zzb2) {
        if (zzb2 == null) {
            ((zzcjk)this).zzawy().zzazj().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzcjk)this).zzawy().zzazj().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzckc.zza(zzb2, bundle);
        ((zzcjk)this).zzawm().zzc("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzaj(long l) {
        zzckf zzckf2 = ((zzcjk)this).zzawq().zzbao();
        for (String string : this.zziwr.keySet()) {
            long l2 = this.zziwr.get(string);
            this.zza(string, l - l2, zzckf2);
        }
        if (!this.zziwr.isEmpty()) {
            this.zza(l - this.zziwt, zzckf2);
        }
        this.zzak(l);
    }

    @WorkerThread
    private final void zzak(long l) {
        for (String string : this.zziwr.keySet()) {
            this.zziwr.put(string, l);
        }
        if (!this.zziwr.isEmpty()) {
            this.zziwt = l;
        }
    }

    static /* synthetic */ void zza(zzcgd zzcgd2, String string, long l) {
        zzcgd2.zzd(string, l);
    }

    static /* synthetic */ void zzb(zzcgd zzcgd2, String string, long l) {
        zzcgd2.zze(string, l);
    }

    static /* synthetic */ void zza(zzcgd zzcgd2, long l) {
        zzcgd2.zzak(l);
    }
}

