/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfo;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclq;
import java.util.ArrayList;
import java.util.List;

public final class zzchi
extends zzcjl {
    private final zzchj zzjbn = new zzchj(this, ((zzcjk)this).getContext(), "google_app_measurement_local.db");
    private boolean zzjbo;

    zzchi(zzcim zzcim2) {
        super(zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    @WorkerThread
    public final void resetAnalyticsData() {
        ((zzcjk)this).zzve();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzcjk)this).zzawy().zzazj().zzj("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzcjk)this).zzawy().zzazd().zzj("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    @WorkerThread
    private final boolean zzb(int n, byte[] byArray) {
        ((zzcjk)this).zzve();
        if (this.zzjbo) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzcjk)this).zzawy().zzazf().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzcjk)this).zzawy().zzazd().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzcjk)this).zzawy().zzazd().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzjbo = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcjk)this).zzawy().zzazd().zzj("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zzjbo = true;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block20;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcjk)this).zzawy().zzazd().zzj("Error writing entry to local database", (Object)sQLiteException);
                        this.zzjbo = true;
                    }
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcha zzcha2) {
        Parcel parcel = Parcel.obtain();
        zzcha2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcjk)this).zzawy().zzazf().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zzb(0, byArray);
    }

    public final boolean zza(zzcln zzcln2) {
        Parcel parcel = Parcel.obtain();
        zzcln2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcjk)this).zzawy().zzazf().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(1, byArray);
    }

    public final boolean zzc(zzcgl zzcgl2) {
        ((zzcjk)this).zzawu();
        byte[] byArray = zzclq.zza((Parcelable)zzcgl2);
        if (byArray.length > 131072) {
            ((zzcjk)this).zzawy().zzazf().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public final List<zzbfm> zzeb(int n) {
        ((zzcjk)this).zzve();
        if (this.zzjbo) {
            return null;
        }
        ArrayList<zzbfm> arrayList = new ArrayList<zzbfm>();
        if (!((zzcjk)this).getContext().getDatabasePath("google_app_measurement_local.db").exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzcjk)this).zzawy().zzazf().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zzbfm zzbfm2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbfm2 = (zzcha)((Object)zzcha.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbfo zzbfo2) {
                                    ((zzcjk)this).zzawy().zzazd().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zzbfm2 == null) continue;
                                arrayList.add(zzbfm2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zzbfm2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbfm2 = (zzcln)((Object)zzcln.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbfo zzbfo3) {
                                    ((zzcjk)this).zzawy().zzazd().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbfm2 == null) continue;
                                arrayList.add(zzbfm2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zzbfm2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbfm2 = (zzcgl)((Object)zzcgl.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbfo zzbfo4) {
                                    ((zzcjk)this).zzawy().zzazd().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbfm2 == null) continue;
                                arrayList.add(zzbfm2);
                                continue;
                            }
                            ((zzcjk)this).zzawy().zzazd().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzcjk)this).zzawy().zzazd().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzjbo = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcjk)this).zzawy().zzazd().zzj("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzjbo = true;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block41;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcjk)this).zzawy().zzazd().zzj("Error reading entries from local database", (Object)sQLiteException);
                        this.zzjbo = true;
                    }
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() {
        if (this.zzjbo) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzjbn.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzjbo = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

