/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcia;
import com.google.android.gms.internal.zzcib;
import com.google.android.gms.internal.zzcic;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzclq;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzchx
extends zzcjl {
    static final Pair<String, Long> zzjcp = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdyn;
    public final zzcib zzjcq = new zzcib(this, "health_monitor", Math.max(0L, zzchc.zzjaf.get()), null);
    public final zzcia zzjcr = new zzcia(this, "last_upload", 0L);
    public final zzcia zzjcs = new zzcia(this, "last_upload_attempt", 0L);
    public final zzcia zzjct = new zzcia(this, "backoff", 0L);
    public final zzcia zzjcu = new zzcia(this, "last_delete_stale", 0L);
    public final zzcia zzjcv;
    public final zzcia zzjcw;
    public final zzcic zzjcx;
    private String zzjcy;
    private boolean zzjcz;
    private long zzjda;
    private String zzjdb;
    private long zzjdc;
    private final Object zzjdd;
    public final zzcia zzjde = new zzcia(this, "time_before_start", 10000L);
    public final zzcia zzjdf = new zzcia(this, "session_timeout", 1800000L);
    public final zzchz zzjdg = new zzchz(this, "start_new_session", true);
    public final zzcia zzjdh = new zzcia(this, "last_pause_time", 0L);
    public final zzcia zzjdi = new zzcia(this, "time_active", 0L);
    public boolean zzjdj;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjm(String string) {
        this.zzve();
        long l = this.zzws().elapsedRealtime();
        if (this.zzjcy != null && l < this.zzjda) {
            return new Pair((Object)this.zzjcy, (Object)this.zzjcz);
        }
        String string2 = string;
        this.zzjda = l + this.zzaxa().zza(string2, zzchc.zzjae);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzjcy = info.getId();
                this.zzjcz = info.isLimitAdTrackingEnabled();
            }
            if (this.zzjcy == null) {
                this.zzjcy = "";
            }
        }
        catch (Throwable throwable) {
            this.zzawy().zzazi().zzj("Unable to get advertising id", throwable);
            this.zzjcy = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzjcy, (Object)this.zzjcz);
    }

    @WorkerThread
    final String zzjn(String string) {
        this.zzve();
        String string2 = (String)this.zzjm((String)string).first;
        MessageDigest messageDigest = zzclq.zzek("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzchx(zzcim zzcim2) {
        super(zzcim2);
        this.zzjcv = new zzcia(this, "midnight_offset", 0L);
        this.zzjcw = new zzcia(this, "first_open_time", 0L);
        this.zzjcx = new zzcic(this, "app_instance_id", null);
        this.zzjdd = new Object();
    }

    @Override
    protected final boolean zzaxz() {
        return true;
    }

    @Override
    protected final void zzayy() {
        this.zzdyn = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzjdj = this.zzdyn.getBoolean("has_been_opened", false);
        if (!this.zzjdj) {
            SharedPreferences.Editor editor = this.zzdyn.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzazl() {
        this.zzve();
        this.zzxf();
        return this.zzdyn;
    }

    @WorkerThread
    final void zzjo(String string) {
        this.zzve();
        SharedPreferences.Editor editor = this.zzazl().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzazm() {
        this.zzve();
        return this.zzazl().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjp(String string) {
        Object object = this.zzjdd;
        synchronized (object) {
            this.zzjdb = string;
            this.zzjdc = this.zzws().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzazn() {
        Object object = this.zzjdd;
        synchronized (object) {
            if (Math.abs(this.zzws().elapsedRealtime() - this.zzjdc) < 1000L) {
                return this.zzjdb;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzazo() {
        this.zzve();
        if (!this.zzazl().contains("use_service")) {
            return null;
        }
        return this.zzazl().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbm(boolean bl) {
        this.zzve();
        this.zzawy().zzazj().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzazl().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzazp() {
        this.zzve();
        this.zzawy().zzazj().log("Clearing collection preferences.");
        boolean bl = this.zzazl().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbn(true);
        }
        SharedPreferences.Editor editor = this.zzazl().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzve();
        this.zzawy().zzazj().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzazl().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbn(boolean bl) {
        this.zzve();
        return this.zzazl().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzazq() {
        this.zzve();
        String string = this.zzazl().getString("previous_os_version", null);
        this.zzawo().zzxf();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzazl().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzchx zzchx2) {
        return zzchx2.zzazl();
    }
}

