/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjo;
import com.google.android.gms.internal.zzcjp;
import com.google.android.gms.internal.zzcjq;
import com.google.android.gms.internal.zzcjr;
import com.google.android.gms.internal.zzcjs;
import com.google.android.gms.internal.zzcjt;
import com.google.android.gms.internal.zzcju;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.internal.zzckc;
import com.google.android.gms.internal.zzckf;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcjn
extends zzcjl {
    protected zzckb zzjgx;
    private AppMeasurement.EventInterceptor zzjgy;
    private final Set<AppMeasurement.OnEventListener> zzjgz = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zzjha;
    private final AtomicReference<String> zzjhb = new AtomicReference();

    protected zzcjn(zzcim zzcim2) {
        super(zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzxf();
        ((zzcjk)this).zzawx().zzg(new zzcjo(this, bl));
    }

    @WorkerThread
    private final void zzbp(boolean bl) {
        ((zzcjk)this).zzve();
        this.zzxf();
        ((zzcjk)this).zzawy().zzazi().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcjk)this).zzawz().setMeasurementEnabled(bl);
        ((zzcjk)this).zzawp().zzbaq();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcjk)this).zzawx().zzg(new zzcjt(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcjk)this).zzawx().zzg(new zzcju(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        boolean bl2 = this.zzjgy == null || zzclq.zzki(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        boolean bl = this.zzjgy == null || zzclq.zzki(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcjk)this).zzws().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcjk)this).zzawx().zzg(new zzcjv(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzckf zzckf2;
        Bundle bundle2;
        Object object;
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        zzbq.checkNotNull((Object)bundle);
        ((zzcjk)this).zzve();
        this.zzxf();
        if (!this.zziwf.isEnabled()) {
            ((zzcjk)this).zzawy().zzazi().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzjha) {
            this.zzjha = true;
            zzcjn zzcjn2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcjn zzcjn3 = zzcjn2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcjk)zzcjn3).getContext());
                }
                catch (Exception exception) {
                    ((zzcjk)zzcjn3).zzawy().zzazf().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcjk)zzcjn2).zzawy().zzazh().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzclq.zzki(string2);
        if (bl && this.zzjgy != null && !bl5 && !bl4) {
            ((zzcjk)this).zzawy().zzazi().zze("Passing event to registered event handler (FE)", ((zzcjk)this).zzawt().zzjh(string2), ((zzcjk)this).zzawt().zzx(bundle));
            this.zzjgy.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zziwf.zzazv()) {
            return;
        }
        int n = ((zzcjk)this).zzawu().zzkb(string2);
        if (n != 0) {
            ((zzcjk)this).zzawu();
            String string4 = zzclq.zza(string2, 40, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zziwf.zzawu().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcjk)this).zzawu().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcjk)this).zzawu().zzbaz().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcjk)this).zzawu();
            bundle2 = zzclq.zzaf(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcjk)this).zzawu().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        if ((zzckf2 = ((zzcjk)this).zzawq().zzbao()) != null && !bundle3.containsKey("_sc")) {
            zzckf2.zzjib = true;
        }
        object2 = zzckf2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzckc.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcjk)this).zzawu().zzy(bundle5) : bundle5;
            ((zzcjk)this).zzawy().zzazi().zze("Logging event (FE)", ((zzcjk)this).zzawt().zzjh(string2), ((zzcjk)this).zzawt().zzx(bundle2));
            zzcha zzcha2 = new zzcha((String)object, new zzcgx(bundle2), string, l);
            ((zzcjk)this).zzawp().zzc(zzcha2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zzjgz) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        if (((zzcjk)this).zzawq().zzbao() != null && "_ae".equals(string2)) {
            ((zzcjk)this).zzaww().zzbs(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbq.zzgm((String)string);
        long l = ((zzcjk)this).zzws().currentTimeMillis();
        int n = ((zzcjk)this).zzawu().zzkd(string2);
        if (n != 0) {
            ((zzcjk)this).zzawu();
            String string3 = zzclq.zza(string2, 24, true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zziwf.zzawu().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcjk)this).zzawu().zzl(string2, object);
            if (n != 0) {
                ((zzcjk)this).zzawu();
                String string4 = zzclq.zza(string2, 24, true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zziwf.zzawu().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcjk)this).zzawu().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcjk)this).zzawx().zzg(new zzcjw(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbq.zzgm((String)string);
        zzbq.zzgm((String)string2);
        ((zzcjk)this).zzve();
        this.zzxf();
        if (!this.zziwf.isEnabled()) {
            ((zzcjk)this).zzawy().zzazi().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zziwf.zzazv()) {
            return;
        }
        ((zzcjk)this).zzawy().zzazi().zze("Setting user property (FE)", ((zzcjk)this).zzawt().zzjh(string2), object);
        zzcln zzcln2 = new zzcln(string2, l, object, string);
        ((zzcjk)this).zzawp().zzb(zzcln2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcln> zzbq(boolean bl) {
        this.zzxf();
        ((zzcjk)this).zzawy().zzazi().log("Fetching user attributes (FE)");
        if (((zzcjk)this).zzawx().zzazs()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcjk)this).zzawx();
        if (zzcih.zzau()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziwf.zzawx().zzg(new zzcjx(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcjk)this).zzawy().zzazf().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcjk)this).zzawy().zzazf().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcjk)this).zzawz().zzazn();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcjk)this).zzawx().zzazt(), (Callable)new zzcjy(this));
        }
        catch (Exception exception) {
            ((zzcjk)this).zzawy().zzazf().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzazn() {
        return this.zzjhb.get();
    }

    final void zzjp(@Nullable String string) {
        this.zzjhb.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbd(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcjk)this).zzawx().zzg(new zzcjz(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcjk)this).zzawy().zzazf().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void resetAnalyticsData() {
        ((zzcjk)this).zzawx().zzg(new zzcka(this));
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcjk)this).zzve();
        this.zzxf();
        if (eventInterceptor != null && eventInterceptor != this.zzjgy) {
            zzbq.zza((this.zzjgy == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzjgy = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzxf();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjgz.add(onEventListener)) {
            ((zzcjk)this).zzawy().zzazf().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        this.zzxf();
        zzbq.checkNotNull((Object)onEventListener);
        if (!this.zzjgz.remove(onEventListener)) {
            ((zzcjk)this).zzawy().zzazf().log("OnEventListener had not been registered");
        }
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcjk)this).zzawy().zzazf().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgm((String)conditionalUserProperty.mAppId);
        ((zzcjk)this).zzawi();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcjk)this).zzws().currentTimeMillis();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgm((String)conditionalUserProperty.mName);
        zzbq.zzgm((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcjk)this).zzawu().zzkd(string) != 0) {
            ((zzcjk)this).zzawy().zzazd().zzj("Invalid conditional user property name", ((zzcjk)this).zzawt().zzjj(string));
            return;
        }
        if (((zzcjk)this).zzawu().zzl(string, object) != 0) {
            ((zzcjk)this).zzawy().zzazd().zze("Invalid conditional user property value", ((zzcjk)this).zzawt().zzjj(string), object);
            return;
        }
        Object object2 = ((zzcjk)this).zzawu().zzm(string, object);
        if (object2 == null) {
            ((zzcjk)this).zzawy().zzazd().zze("Unable to normalize conditional user property value", ((zzcjk)this).zzawt().zzjj(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzcjk)this).zzawy().zzazd().zze("Invalid conditional user property timeout", ((zzcjk)this).zzawt().zzjj(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzcjk)this).zzawy().zzazd().zze("Invalid conditional user property time to live", ((zzcjk)this).zzawt().zzjj(string), l3);
            return;
        }
        ((zzcjk)this).zzawx().zzg(new zzcjp(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbq.zzgm((String)string);
        ((zzcjk)this).zzawi();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcjk)this).zzws().currentTimeMillis();
        zzbq.zzgm((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcjk)this).zzawx().zzg(new zzcjq(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcha zzcha2;
        zzcha zzcha3;
        zzcha zzcha4;
        ((zzcjk)this).zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgm((String)conditionalUserProperty.mName);
        zzbq.zzgm((String)conditionalUserProperty.mOrigin);
        zzbq.checkNotNull((Object)conditionalUserProperty.mValue);
        if (!this.zziwf.isEnabled()) {
            ((zzcjk)this).zzawy().zzazi().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcln zzcln2 = new zzcln(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcha4 = ((zzcjk)this).zzawu().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcha3 = ((zzcjk)this).zzawu().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcha2 = ((zzcjk)this).zzawu().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcgl zzcgl2 = new zzcgl(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcln2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcha3, conditionalUserProperty.mTriggerTimeout, zzcha4, conditionalUserProperty.mTimeToLive, zzcha2);
        ((zzcjk)this).zzawp().zzf(zzcgl2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcha zzcha2;
        ((zzcjk)this).zzve();
        this.zzxf();
        zzbq.checkNotNull((Object)conditionalUserProperty);
        zzbq.zzgm((String)conditionalUserProperty.mName);
        if (!this.zziwf.isEnabled()) {
            ((zzcjk)this).zzawy().zzazi().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcln zzcln2 = new zzcln(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcha2 = ((zzcjk)this).zzawu().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcgl zzcgl2 = new zzcgl(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcln2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcha2);
        ((zzcjk)this).zzawp().zzf(zzcgl2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbq.zzgm((String)string);
        ((zzcjk)this).zzawi();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcjk)this).zzawx().zzazs()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcjk)this).zzawx();
        if (zzcih.zzau()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziwf.zzawx().zzg(new zzcjr(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcjk)this).zzawy().zzazf().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcjk)this).zzawy().zzazf().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcgl zzcgl2 = (zzcgl)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcgl2.zziyh;
                conditionalUserProperty.mName = zzcgl2.zziyg.name;
                conditionalUserProperty.mValue = zzcgl2.zziyg.getValue();
                conditionalUserProperty.mActive = zzcgl2.zziyi;
                conditionalUserProperty.mTriggerEventName = zzcgl2.zziyj;
                if (zzcgl2.zziyk != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcgl2.zziyk.name;
                    if (zzcgl2.zziyk.zzizt != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcgl2.zziyk.zzizt.zzayx();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcgl2.zziyl;
                if (zzcgl2.zziym != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcgl2.zziym.name;
                    if (zzcgl2.zziym.zzizt != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcgl2.zziym.zzizt.zzayx();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcgl2.zziyg.zzjji;
                conditionalUserProperty.mTimeToLive = zzcgl2.zziyn;
                if (zzcgl2.zziyo != null) {
                    conditionalUserProperty.mExpiredEventName = zzcgl2.zziyo.name;
                    if (zzcgl2.zziyo.zzizt != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcgl2.zziyo.zzizt.zzayx();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbq.zzgm((String)string);
        ((zzcjk)this).zzawi();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcjk)this).zzawx().zzazs()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcjk)this).zzawx();
        if (zzcih.zzau()) {
            ((zzcjk)this).zzawy().zzazd().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziwf.zzawx().zzg(new zzcjs(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcjk)this).zzawy().zzazf().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcjk)this).zzawy().zzazf().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcln zzcln2 = (zzcln)((Object)iterator.next());
                arrayMap.put(zzcln2.name, zzcln2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcjn zzcjn2, boolean bl) {
        zzcjn2.zzbp(bl);
    }

    static /* synthetic */ void zza(zzcjn zzcjn2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcjn2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcjn zzcjn2, String string, String string2, Object object, long l) {
        zzcjn2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcjn zzcjn2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcjn2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcjn zzcjn2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcjn2.zzc(conditionalUserProperty);
    }
}

