/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzckh;
import com.google.android.gms.internal.zzcki;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckl;
import com.google.android.gms.internal.zzckm;
import com.google.android.gms.internal.zzckn;
import com.google.android.gms.internal.zzcko;
import com.google.android.gms.internal.zzckp;
import com.google.android.gms.internal.zzckq;
import com.google.android.gms.internal.zzckr;
import com.google.android.gms.internal.zzcks;
import com.google.android.gms.internal.zzckt;
import com.google.android.gms.internal.zzcku;
import com.google.android.gms.internal.zzclk;
import com.google.android.gms.internal.zzcln;
import com.google.android.gms.internal.zzclq;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzckg
extends zzcjl {
    private final zzcku zzjic;
    private zzche zzjid;
    private volatile Boolean zzjie;
    private final zzcgs zzjif;
    private final zzclk zzjig;
    private final List<Runnable> zzjih = new ArrayList<Runnable>();
    private final zzcgs zzjii;

    protected zzckg(zzcim zzcim2) {
        super(zzcim2);
        this.zzjig = new zzclk(zzcim2.zzws());
        this.zzjic = new zzcku(this);
        this.zzjif = new zzckh(this, zzcim2);
        this.zzjii = new zzckm(this, zzcim2);
    }

    @Override
    protected final boolean zzaxz() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcjk)this).zzve();
        this.zzxf();
        return this.zzjid != null;
    }

    @WorkerThread
    protected final void zzbaq() {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(true);
        this.zzj(new zzckn(this, zzcgi2));
    }

    @WorkerThread
    final void zza(zzche zzche2, zzbfm zzbfm2, zzcgi zzcgi2) {
        ((zzcjk)this).zzve();
        this.zzxf();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<zzbfm> arrayList = new ArrayList<zzbfm>();
            n = 0;
            List<zzbfm> list = ((zzcjk)this).zzawr().zzeb(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbfm2 != null && n < 100) {
                arrayList.add(zzbfm2);
            }
            ArrayList<zzbfm> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbfm zzbfm3 = (zzbfm)e;
                if (zzbfm3 instanceof zzcha) {
                    try {
                        zzche2.zza((zzcha)zzbfm3, zzcgi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcjk)this).zzawy().zzazd().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbfm3 instanceof zzcln) {
                    try {
                        zzche2.zza((zzcln)zzbfm3, zzcgi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcjk)this).zzawy().zzazd().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbfm3 instanceof zzcgl) {
                    try {
                        zzche2.zza((zzcgl)zzbfm3, zzcgi2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcjk)this).zzawy().zzazd().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcjk)this).zzawy().zzazd().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcha zzcha2, String string) {
        zzbq.checkNotNull((Object)((Object)zzcha2));
        ((zzcjk)this).zzve();
        this.zzxf();
        boolean bl = ((zzcjk)this).zzawr().zza(zzcha2);
        zzcgi zzcgi2 = this.zzbr(true);
        this.zzj(new zzcko(this, true, bl, zzcha2, zzcgi2, string));
    }

    @WorkerThread
    protected final void zzf(zzcgl zzcgl2) {
        zzbq.checkNotNull((Object)((Object)zzcgl2));
        ((zzcjk)this).zzve();
        this.zzxf();
        boolean bl = ((zzcjk)this).zzawr().zzc(zzcgl2);
        zzcgl zzcgl3 = new zzcgl(zzcgl2);
        zzcgi zzcgi2 = this.zzbr(true);
        this.zzj(new zzckp(this, true, bl, zzcgl3, zzcgi2, zzcgl2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcgl>> atomicReference, String string, String string2, String string3) {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(false);
        this.zzj(new zzckq(this, atomicReference, string, string2, string3, zzcgi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcln>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(false);
        this.zzj(new zzckr(this, atomicReference, string, string2, string3, bl, zzcgi2));
    }

    @WorkerThread
    protected final void zzb(zzcln zzcln2) {
        ((zzcjk)this).zzve();
        this.zzxf();
        boolean bl = ((zzcjk)this).zzawr().zza(zzcln2);
        zzcgi zzcgi2 = this.zzbr(true);
        this.zzj(new zzcks(this, bl, zzcln2, zzcgi2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcln>> atomicReference, boolean bl) {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(false);
        this.zzj(new zzckt(this, atomicReference, zzcgi2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(false);
        ((zzcjk)this).zzawr().resetAnalyticsData();
        this.zzj(new zzcki(this, zzcgi2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(false);
        this.zzj(new zzckj(this, atomicReference, zzcgi2));
    }

    @WorkerThread
    protected final void zzbar() {
        ((zzcjk)this).zzve();
        this.zzxf();
        zzcgi zzcgi2 = this.zzbr(true);
        this.zzj(new zzckk(this, zzcgi2));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcjk)this).zzve();
        this.zzxf();
        this.zzj(new zzckl(this, zzb2));
    }

    @WorkerThread
    private final void zzxr() {
        ((zzcjk)this).zzve();
        this.zzjig.start();
        this.zzjif.zzs(zzchc.zzjbj.get());
    }

    @WorkerThread
    final void zzyc() {
        Intent intent;
        Object object;
        zzckg zzckg2;
        ((zzcjk)this).zzve();
        this.zzxf();
        if (this.isConnected()) {
            return;
        }
        if (this.zzjie == null) {
            boolean bl;
            zzckg2 = this;
            ((zzcjk)zzckg2).zzve();
            zzckg2.zzxf();
            object = ((zzcjk)zzckg2).zzawz().zzazo();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzcjk)zzckg2).zzawn().zzazb() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzcjk)zzckg2).zzawy().zzazj().log("Checking service availability");
                    zzclq zzclq2 = ((zzcjk)zzckg2).zzawu();
                    int n = zzf.zzafy().isGooglePlayServicesAvailable(((zzcjk)zzclq2).getContext());
                    switch (n) {
                        case 0: {
                            ((zzcjk)zzckg2).zzawy().zzazj().log("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzcjk)zzckg2).zzawy().zzazj().log("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzcjk)zzckg2).zzawy().zzazf().log("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzcjk)zzckg2).zzawy().zzazi().log("Service container out of date");
                            zzclq2 = ((zzcjk)zzckg2).zzawu();
                            zzf.zzafy();
                            if (zzf.zzcf((Context)((zzcjk)zzclq2).getContext()) < 11400) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzcjk)zzckg2).zzawz().zzazo();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzcjk)zzckg2).zzawy().zzazf().log("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzcjk)zzckg2).zzawy().zzazf().log("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzcjk)zzckg2).zzawy().zzazf().zzj("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzcjk)zzckg2).zzawz().zzbm(bl3);
                }
                bl = bl3;
            }
            this.zzjie = bl;
        }
        if (this.zzjie.booleanValue()) {
            this.zzjic.zzbau();
            return;
        }
        zzckg2 = this;
        object = ((zzcjk)zzckg2).getContext().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzcjk)zzckg2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzcjk)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzjic.zzn(intent2);
            return;
        }
        ((zzcjk)this).zzawy().zzazd().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzbas() {
        return this.zzjie;
    }

    @WorkerThread
    protected final void zza(zzche zzche2) {
        ((zzcjk)this).zzve();
        zzbq.checkNotNull((Object)zzche2);
        this.zzjid = zzche2;
        this.zzxr();
        this.zzbat();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcjk)this).zzve();
        this.zzxf();
        try {
            zza.zzamc();
            zzcku zzcku2 = this.zzjic;
            Context context = ((zzcjk)this).getContext();
            context.unbindService((ServiceConnection)zzcku2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzjid = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcjk)this).zzve();
        if (this.zzjid != null) {
            this.zzjid = null;
            ((zzcjk)this).zzawy().zzazj().zzj("Disconnected from device MeasurementService", componentName);
            zzckg zzckg2 = this;
            ((zzcjk)zzckg2).zzve();
            zzckg2.zzyc();
        }
    }

    @WorkerThread
    private final void zzxs() {
        ((zzcjk)this).zzve();
        if (!this.isConnected()) {
            return;
        }
        ((zzcjk)this).zzawy().zzazj().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcjk)this).zzve();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzjih.size() >= 1000L) {
            ((zzcjk)this).zzawy().zzazd().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzjih.add(runnable);
        this.zzjii.zzs(60000L);
        this.zzyc();
    }

    @WorkerThread
    private final void zzbat() {
        ((zzcjk)this).zzve();
        ((zzcjk)this).zzawy().zzazj().zzj("Processing queued up service tasks", this.zzjih.size());
        for (Runnable runnable : this.zzjih) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcjk)this).zzawy().zzazd().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzjih.clear();
        this.zzjii.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzcgi zzbr(boolean bl) {
        return ((zzcjk)this).zzawn().zzjg(bl ? ((zzcjk)this).zzawy().zzazk() : null);
    }

    static /* synthetic */ zzcku zza(zzckg zzckg2) {
        return zzckg2.zzjic;
    }

    static /* synthetic */ void zza(zzckg zzckg2, ComponentName componentName) {
        zzckg2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzche zza(zzckg zzckg2, zzche zzche2) {
        zzckg2.zzjid = null;
        return null;
    }

    static /* synthetic */ void zzb(zzckg zzckg2) {
        zzckg2.zzbat();
    }

    static /* synthetic */ void zzc(zzckg zzckg2) {
        zzckg2.zzxs();
    }

    static /* synthetic */ zzche zzd(zzckg zzckg2) {
        return zzckg2.zzjid;
    }

    static /* synthetic */ void zze(zzckg zzckg2) {
        zzckg2.zzxr();
    }
}

