/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchm;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzckg;
import com.google.android.gms.internal.zzckv;
import com.google.android.gms.internal.zzckw;
import com.google.android.gms.internal.zzckx;
import com.google.android.gms.internal.zzcky;
import com.google.android.gms.internal.zzckz;

public final class zzcku
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzjiq;
    private volatile zzchl zzjir;
    final /* synthetic */ zzckg zzjij;

    protected zzcku(zzckg zzckg2) {
        this.zzjij = zzckg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzn(Intent intent) {
        ((zzcjk)this.zzjij).zzve();
        Context context = ((zzcjk)this.zzjij).getContext();
        zza zza2 = zza.zzamc();
        zzcku zzcku2 = this;
        synchronized (zzcku2) {
            if (this.zzjiq) {
                ((zzcjk)this.zzjij).zzawy().zzazj().log("Connection attempt already in progress");
                return;
            }
            ((zzcjk)this.zzjij).zzawy().zzazj().log("Using local app measurement service");
            this.zzjiq = true;
            zza2.zza(context, intent, (ServiceConnection)zzckg.zza(this.zzjij), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbq.zzge((String)"MeasurementServiceConnection.onServiceConnected");
        zzcku zzcku2 = this;
        synchronized (zzcku2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzjiq = false;
                ((zzcjk)this.zzjij).zzawy().zzazd().log("Service connected with null binder");
                return;
            }
            zzche zzche2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzche2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzche ? (zzche)iInterface : new zzchg(iBinder2));
                    ((zzcjk)this.zzjij).zzawy().zzazj().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcjk)this.zzjij).zzawy().zzazd().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcjk)this.zzjij).zzawy().zzazd().log("Service connect failed to get IMeasurementService");
            }
            if (zzche2 == null) {
                this.zzjiq = false;
                try {
                    zza.zzamc();
                    zzcku zzcku3 = zzckg.zza(this.zzjij);
                    iInterface = ((zzcjk)this.zzjij).getContext();
                    iInterface.unbindService((ServiceConnection)zzcku3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzche2;
                ((zzcjk)this.zzjij).zzawx().zzg(new zzckv(this, (zzche)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbq.zzge((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcjk)this.zzjij).zzawy().zzazi().log("Service disconnected");
        ((zzcjk)this.zzjij).zzawx().zzg(new zzckw(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzbau() {
        ((zzcjk)this.zzjij).zzve();
        Context context = ((zzcjk)this.zzjij).getContext();
        zzcku zzcku2 = this;
        synchronized (zzcku2) {
            if (this.zzjiq) {
                ((zzcjk)this.zzjij).zzawy().zzazj().log("Connection attempt already in progress");
                return;
            }
            if (this.zzjir != null) {
                ((zzcjk)this.zzjij).zzawy().zzazj().log("Already awaiting connection attempt");
                return;
            }
            this.zzjir = new zzchl(context, Looper.getMainLooper(), this, this);
            ((zzcjk)this.zzjij).zzawy().zzazj().log("Connecting to remote service");
            this.zzjiq = true;
            this.zzjir.zzakj();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbq.zzge((String)"MeasurementServiceConnection.onConnected");
        zzcku zzcku2 = this;
        synchronized (zzcku2) {
            try {
                zzche zzche2 = (zzche)this.zzjir.zzakn();
                this.zzjir = null;
                ((zzcjk)this.zzjij).zzawx().zzg(new zzckx(this, zzche2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzjir = null;
                this.zzjiq = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbq.zzge((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcjk)this.zzjij).zzawy().zzazi().log("Service connection suspended");
        ((zzcjk)this.zzjij).zzawx().zzg(new zzcky(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zzge((String)"MeasurementServiceConnection.onConnectionFailed");
        zzchm zzchm2 = this.zzjij.zziwf.zzazx();
        if (zzchm2 != null) {
            zzchm2.zzazf().zzj("Service connection failed", connectionResult);
        }
        zzcku zzcku2 = this;
        synchronized (zzcku2) {
            this.zzjiq = false;
            this.zzjir = null;
        }
        ((zzcjk)this.zzjij).zzawx().zzg(new zzckz(this));
    }

    static /* synthetic */ boolean zza(zzcku zzcku2, boolean bl) {
        zzcku2.zzjiq = false;
        return false;
    }
}

